ORCA/M Asm65816 2.1.0

0001 D000              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0002 D000              ;	by EdAsmCvtIIGS version 1.2d2 on 5/4/91 at 6:36:21 PM
0003 D000
0004 D000                       MACHINE M65816                 	
0005 D000                       MSB   OFF
0006 D000                       LONGA OFF
0007 D000                       LONGI OFF
0008 D000                       PRINT NOGEN,DATA
0009 D000                       PRINT PUSH
0010 D000                       PRINT OFF
0011 D000                       INCLUDE '::Firmware.macros.aii'
0012 D000
0013 D000                       PRINT POP
0014 D000
0015 D000              PLIST    EQU   0
0016 D000              A2E      EQU   0                        ;1= Do Apple //e enhanced fixes
0017 D000              LOLLY    EQU   1                        ;1= Do //c fixes
0018 D000              CORTLAND EQU   1                        ;1= Do Cortland fixes
0019 D000                       TITLE 'Cortland AppleSoft BASIC'
0020 D000
0021 D000              *******************************
0022 D000              *   REAL APPLESOFT II SOURCE 
0023 D000              *    CONVERTED TO EDASM II 
0024 D000              *      ON JUNE 26, 1981
0025 D000              *   RESURECTED  BY  J ARKLEY
0026 D000              *      ON  MAY 1, 1980
0027 D000              *  MODIFICATIONS FOR LOLLY BY
0028 D000              *   J.R HUSTON, AUGUST 1983
0029 D000              *
0030 D000              * Modifications for Cortland by
0031 D000              * R. Williams / F. Bachman 1986
0032 D000              *
0033 D000              *******************************
0034 D000              *****************************
0035 D000              *                           *
0036 D000              *       APPLESOFT:          *
0037 D000              * FLOATING POINT BASIC FOR  *
0038 D000              *      THE APPLE-][         *
0039 D000              *                           *
0040 D000              *  COPYRIGHT 1978, 1983 by  *
0041 D000              *  APPLE COMPUTER INC.      *
0042 D000              *   ALL RIGHTS RESERVED     *
0043 D000              *                           *
0044 D000              *  WRITTEN BY MICROSOFT     *
0045 D000              *                           *
0046 D000              * EXTENDED BY R. WIGGINTON  *
0047 D000              *                           *
0048 D000              *****************************
0049 D000                       EJECT 
0050 D000                       TITLE 'PRELIMINARY EQUATES'
0051 D000              CLMWID   EQU   14
0052 D000              STKEND   EQU   507
0053 D000              BUFPAG   EQU   2
0054 D000              TRMPOS:  EQU   $24
0055 D000              FIRST    EQU   $F0
0056 D000              H2       EQU   $2C
0057 D000              V2       EQU   $2D
0058 D000              ROMLOC   EQU   $D000
0059 D000              RAMLOC   EQU   $800
0060 D000              C_INLN   EQU   $FD6A
0061 D000              C_PRMP   EQU   $33
0062 D000              C_INCH   EQU   $FD0C
0063 D000              C_COUT   EQU   $FECD
0064 D000              C_CSIN   EQU   $FEFD
0065 D000              BUF      EQU   $0200
0066 D000              OUTCH    EQU   $FDED
0067 D000              C_GETL   EQU   $FD0C
0068 D000              SPDBYT   EQU   $F1
0069 D000              WAITNOW  EQU   $FCA8
0070 D000              CLRSCR   EQU   $FC58
0071 D000              TRFLAG   EQU   $F2                      ;TRACE ON/OFF
0072 D000              ORMASK   EQU   $F3                      ;FOR FLASH, NORMAL, INVERSE
0073 D000              INVFLG   EQU   $32                      ;DISPLAY MODES.
0074 D000              ERRTO    EQU   $F4
0075 D000              ERRFLG   EQU   $D8
0076 D000              ERRLIN   EQU   $DA
0077 D000              ERRPOS   EQU   $DC
0078 D000              ERRNUM   EQU   $DE                      ;PLACE FOR ERROR .
0079 D000              ERRSTK   EQU   $DF                      ;SAVE STACK POINTER DURING ERROR.
0080 D000              REMSTK   EQU   $F8                      ;FOR EVERY TIME.
0081 D000              RNONLY   EQU   $D6                      ;RUN-ONLY PROGRAM?
0082 D000                       EJECT 
0083 D000                       TITLE 'INTR AND COMP PARAMETERS.'
0084 D000              ; --------- ---- -- ---------
0085 D000              ; COPYRIGHT 1976 BY MICROSOFT
0086 D000              ; --------- ---- -- ---------
0087 D000              ; *
0088 D000              NUMLEV   EQU   19                       ;NUMBER OF STACK LEVELS RESERVED
0089 D000                                                      ;BY AN EXPLICIT CALL TO 'GETSTK'.
0090 D000              LINLEN   EQU   40
0091 D000              BUFLEN   EQU   240                      ;INPUT BUFFER SIZE.
0092 D000                                                      ;FOR COMMODORE.
0093 D000              STRSIZ   EQU   3                        ;# OF LOCS PER STRING DESCRIPTOR.
0094 D000              NUMTMP   EQU   3                        ;NUMBER OF STRING TEMPORARIES.
0095 D000              CONTW    EQU   15                       ;CHARACTER TO SUPPRESS OUTPUT.
0096 D000                                                      ; DSECT
0097 D000              ZPage    RECORD 0
0098 D000              START:   DS.b 3                         ;JMP INIT	;INITIALIZE - SETUP CERTAIN LOCATIONS
0099 D000              ;AND DELETE FUNCTIONS IF NOT NEEDED,
0100 D000              ;AND CHANGE THIS TO 'JMP READY'
0101 D000              ;IN CASE USER RESTARTS AT LOC ZERO.
0102 D000              RDYJSR:  DS.b 3                         ;JMP INIT	;CHANGED TO 'JMP STROUT' BY 'INIT'
0103 D000              ;TO HANDLE ERRORS.
0104 D000              ADRAYI:  DS.W 1                         ;was DW AYINT ;STORE HERE THE ADDR OF THE
0105 D000              ;ROUTINE TO TURN THE FAC INTO A 
0106 D000              ;TWO BYTE SIGNED INTEGER IN Y,A
0107 D000              ADRGAY:  DS.W 1                         ;was DW GIVAYF ;STORE HERE THE ADDR OF THE
0108 D000              ;ROUTINE TO CONVERT Y,A TO A FLOATING
0109 D000              ;POINT NUMBER IN THE FAC.
0110 D000              USRPOK:  DS.b 3                         ;JMP FCERR ;SET UP ORIG BY INIT.
0111 D000              ; THIS IS THE 'VOLATILE' STORAGE AREA AND NONE OF IT
0112 D000              ; CAN BE KEPT IN ROM. ANY CONSTANTS IN THIS AREA CANNOT
0113 D000              ; BE KEPT IN A ROM, BUT MUST BE LOADED IN BY THE 
0114 D000              ; PROGRAM INSTRUCTIONS IN ROM.
0115 D000              ; --- GENERAL RAM ---:
0116 D000              CHARAC:  DS.B 1                         ;A DELIMITING CHARACTER.
0117 D000              INTEGR   EQU   CHARAC                   ;A ONE-BYTE INTEGER FROM 'QINT'.
0118 D000              ENDCHR:  DS.B 1                         ;THE OTHER DELIMITING CHARACTER.
0119 D000              COUNT:   DS.B 1                         ;A GENERAL COUNTER.
0120 D000              ; --- FLAGS ---:
0121 D000              DIMFLG:  DS.B 1                         ;IN GETTING A PNTER TO A VARIABLE
0122 D000              ;IT IS IMPORTANT TO REMEMBER WHETHER IT
0123 D000              ;IS BEING DONE FOR 'DIM' OR NOT.
0124 D000              ;DIMFLG AND VALTYP MUST BE
0125 D000              ;CONSECUTIVE LOCATIONS.
0126 D000              KIMY     EQU   DIMFLG                   ;PLACE TO PRESERVE Y DURING OUT.
0127 D000              VALTYP:  DS.B 1                         ;THE TYPE INDICATOR.
0128 D000              ;0=NUMERIC 1=STRING.
0129 D000              INTFLG:  DS.B 1                         ;TELLS IF INTEGER.
0130 D000              DORES:   DS.B 1                         ;WHETHER CAN OR CAN'T CRUNCH RES'D WORDS.
0131 D000              ;TURNED ON WHEN 'DATA'
0132 D000              ;BEING SCANNED BY CRUNCH SO UNQUOTED
0133 D000              ;STRINGS WON'T BE CRUNCHED.
0134 D000              GARBFL   EQU   DORES                    ;WHETHER TO DO GARBAGE COLLECTN.
0135 D000              SUBFLG:  DS.B 1                         ;FLAG WHETHER SUB'D VARIABLE ALLOWED.
0136 D000              ;'FOR' AND USER-DEFINED FUNCTION
0137 D000              ;POINTER FETCHING TURN
0138 D000              ;THIS ON BEFORE CALLING 'PTRGET'
0139 D000              ;SO ARRAYS WON'T BE DETECTED.
0140 D000              ;'STKINI' AND 'PTRGET' CLEAR IT.
0141 D000              ;ALSO DISALLOWS INTEGERS THERE.
0142 D000              INPFLG:  DS.B 1                         ;FLAGS WHETHER WE ARE DOING 'INPUT'
0143 D000              ;OR 'READ'.
0144 D000              TANSGN:  DS.B 1                         ;USED IN DETERMINING SIGN OF TANGENT.
0145 D000              ;****** DSECT
0146 D000                       ORG   $50                      ;ROOM FOR APPLE PAGE 0 STUFF.
0147 D000              ; --- RAM DEALING WITH TERMINAL HANDLING ---:
0148 D000              ;NUMBER OF NULLS TO PRINT.
0149 D000              LINNUM:  DS.B 01                        ;LOCATION TO STORE LINE NUMBER BEFORE BUF
0150 D000              ;SO THAT 'BLTUC' CAN STORE IT ALL AWAY AT ONCE.
0151 D000                       DS.B 1                         ;A COMMA (PROAD OR FROM ROM)
0152 D000              ;USED BY INPUT STATEMENT SINCE THE
0153 D000              ;DATA POINTER ALWAYS STARTS ON A
0154 D000              ;COMMA OR TERMINATOR.
0155 D000              ;TYPE IN STORED HERE.
0156 D000              ;DIRECT STATEMENTS EXECUTE OUT OF
0157 D000              ;HERE. REMEMBER 'INPUT' SMASHES BUF.
0158 D000              ;MUST BE ON PAGE ZERO
0159 D000              ;OR ASSIGNMENT OF STRING
0160 D000              ;VALUES IN DIRECT STATEMENTS WON'T COPY
0161 D000              ;INTO STRING SPACE -- WHICH IT MUST.
0162 D000              ;N.B. TWO NONZERO BYTES MUST PRECEDE 'BUFLNM'.
0163 D000              ; --- STORAGE FOR TEMPORARY THINGS ---:
0164 D000              TEMPPT:  DS.B 1                         ;POINTER AT FIRST FREE TEMP DESCRIPTOR.
0165 D000              ;INITIALIZ TO POINT TO TEMPST.
0166 D000              LASTPT:  DS.B 2                         ;POINTER TO LAST-USED STRING TEMPORARY.
0167 D000              TEMPST:  DS.B STRSIZ*NUMTMP             ;STORAGE FOR NUMTMP TEMP DESCRPT
0168 D000              INDEX1:  DS.B 2                         ;INDEXES.
0169 D000              INDEX    EQU   INDEX1
0170 D000              INDEX2:  DS.B 2
0171 D000              RESHO:   DS.B 1                         ;RESULT OF MULTIPLIER AND DIVIDER.
0172 D000              RESMOH:  DS.B 1                         ;ONE MORE BYTE.
0173 D000              RESMO:   DS.B 1
0174 D000              RESLO:   DS.B 1
0175 D000              ADDEND   EQU   RESMO                    ;TEMPORARY USED BY 'UMULT'.
0176 D000                       DS.B 1                         ;OVERFLOW FOR RES.
0177 D000              ; --- POINTERS INTO DYNAMIC DATA STRUCTURES ---;
0178 D000              TXTTAB:  DS.B 2                         ;POINTER TO BEGINNING OF TEXT.
0179 D000              ;DOE'T CHANGE AFTER BEING
0180 D000              ;SETUP BY 'INIT'.
0181 D000              VARTAB:  DS.B 2                         ;POINTER TO START OF SIMPLE
0182 D000              ;VARIABLE SPACE.
0183 D000              ;UPDATED WHENEVER THE SIZE OF THE
0184 D000              ;PROGRAM CHANGES, SET TO TXTTAB
0185 D000              ;BY 'SCRATCH' ('NEW').
0186 D000              ARYTAB:  DS.B 2                         ;POINTER TO BEGINNING OF ARRAY
0187 D000              ;TABLE.
0188 D000              ;INCREMENTED BY 6 WHENEVER
0189 D000              ;A NEW SIMPLE VARIABLE IS FOUND, AND
0190 D000              ;SET TO VARTAB BY 'CLEARC'.
0191 D000              STREND:  DS.B 2                         ;END OF STORAGE IN USE.
0192 D000              ;INCREASED WHENEVER A NEW ARRAY
0193 D000              ;OR SIMPLE VARIABLE IS ENCOUNTERED.
0194 D000              ;SET TO VARTAB BY 'CLEARC'.
0195 D000              FRETOP:  DS.B 2                         ;TOP OF STRING FREE SPACE.
0196 D000              FRESPC:  DS.B 2                         ;POINTER TO NEW STRING.
0197 D000              MEMSIZ:  DS.B 2                         ;HIGHEST LOCATION IN MEMORY.
0198 D000              ; --- LINE NUMBERS AND TEXTUAL POINTERS ---:
0199 D000              CURLIN:  DS.B 2                         ;CURRENT LINE .
0200 D000              ;SET TO 0,255 FOR DIRECT STATEMENTS.
0201 D000              OLDLIN:  DS.B 2                         ;OLD LINE NUMBER (SETUP BY C,'STOP'
0202 D000              ;OR 'END' IN A PROGRAM).
0203 D000              POKER    EQU   LINNUM                   ;SET UP LOCATION USED BY POKE.
0204 D000              ;TEMPORARY FOR INPUT AND READ CODE
0205 D000              OLDTXT:  DS.B 2                         ;OLD TEXT POINTER.
0206 D000              ;POINTS AT STATEMENT TO BE EXEC'D NEXT.
0207 D000              DATLIN:  DS.B 2                         ;DATA LINE  -- REMEMBER FOR ERRORS.
0208 D000              DATPTR:  DS.B 2                         ;POINTER TO DATA. INITIALIZED TO POINT
0209 D000              ;AT THE ZERO IN FRONT OF TXTTAB
0210 D000              ;BY 'RESTORE' WHICH IS CALLED BY 'CLEARC'.
0211 D000              ;UPDATED BY EXECUTION OF A 'READ'.
0212 D000              INPPTR:  DS.B 2                         ;THIS REMEMBERS WHERE INPUT IS COMING FROM.
0213 D000              ; --- STUFF USED IN EVALUATIONS ---:
0214 D000              VARNAM:  DS.B 2                         ;VARIABLE'S NAME IS STORED HERE.
0215 D000              VARPNT:  DS.B 2                         ;POINTER TO VARIABLE IN MEMORY.
0216 D000              FDECPT   EQU   VARPNT                   ;POINTER INTO POWERF TENS OF 'FOUT'.
0217 D000              FORPNT:  DS.B 2                         ;A VARIABLE'S POINTER FOR 'FOR' LOOPS
0218 D000              ;AND 'LET' STATEMENTS.
0219 D000              LSTPNT   EQU   FORPNT                   ;PNTR TO LIST STRING.
0220 D000              ANDMSK   EQU   FORPNT                   ;THE MASK USED BY WAIT FOR ANDING.
0221 D000              EORMSK   EQU   FORPNT+1                 ;THE MASK FOR EORING IN WAIT.
0222 D000              OPPTR:   DS.B 2                         ;POINTER TO CURRENT OP'S ENTRY IN 'OPTAB'.
0223 D000              VARTXT   EQU   OPPTR                    ;POINTER INTO LIST OF VARIABLES
0224 D000              OPMASK:  DS.B 1                         ;MASK CREATED BY CURRENT OPERATOR.
0225 D000              DOMASK   EQU   TANSGN                   ;MASK IN USE BY RELATION OPERATIONS.
0226 D000              DEFPNT:  DS.B 2                         ;POINTER USED IN FUNCTION DEFINITION.
0227 D000              GRBPNT   EQU   DEFPNT                   ;ANOTHER US IN GARBAGE COLLECTION.
0228 D000              DSCPNT:  DS.B 2                         ;POINTER TO A STRING DESCRIPTOR.
0229 D000                       DS.B 1                         ;FOR TEMPF3.
0230 D000              FOUR6:   DS.B 1                         ;VARIABLE CONSTANT USED BY GARB COLECT
0231 D000              ; --- ET CETERA ---:
0232 D000              JMPER:   DS.b 3                         ;was JMP 60000
0233 D000              SIZE     EQU   JMPER+1
0234 D000              OLDOV    EQU   JMPER+2                  ;THE OLD OVERFLOW.
0235 D000              TEMPF3   EQU   DEFPNT                   ;A THIRD FAC TEMPORARY (4 BYTES).
0236 D000              TEMPF1:  DS.B 1                         ;FOR TEMPF1S EXTRA BYTE.
0237 D000              HIGHDS:  DS.B 2                         ;DESINATION OF HIGHEST ELEMENT IN BLT.
0238 D000              HIGHTR:  DS.B 2                         ;SOURCE OF HIGHEST ELEMENT TO MOVE.
0239 D000              TEMPF2:  DS.B 1                         ;FOREMPF2S EXTRA BYTE.
0240 D000              LOWDS:   DS.B 2                         ;LOCATION OF LAST BYTE TRANSFERRED INTO.
0241 D000              LOWTR:   DS.B 2                         ;LAST THING TO MOVE IN BLT.
0242 D000              ARYPNT   EQU   HIGHDS                   ;A POINTER USED IN ARRAY BUILDING.
0243 D000              GRBTOP   EQU   LOWTR                    ;A POINTER USED IN GARBAGE COLLECTION.
0244 D000              DECCNT   EQU   LOWDS                    ;NUMBER OF PLACES BEFORE DECIMAL POINT.
0245 D000              TENEXP   EQU   LOWDS+1                  ;HAS A DPT BEEN INPUT?
0246 D000              DPTFLG   EQU   LOWTR                    ;BASE TEN EXPONENT.
0247 D000              EXPSGN   EQU   LOWTR+1                  ;SIGN OF BASE TEN EXPONENT.
0248 D000              ; --- THE FLOATING ACCUMULATOR ---:
0249 D000              FAC:     EQU   *
0250 D000              FACEXP:  DS.B 01
0251 D000              FACHO:   DS.B 01                        ;MOST SIGNIFICANT BYTE OF MANTISSA.
0252 D000              FACMOH:  DS.B 01                        ;ONE MORE.
0253 D000              FACMO:   DS.B 01                        ;MIDDLE ORDER OF MANTISSA.
0254 D000              FACLO:   DS.B 01                        ;LEAST SIG BYTE OF MANTISSA.
0255 D000              FACSGN:  DS.B 01                        ;SIGN OF FAC (0 OR -1) WHEN UNPACKED.
0256 D000              SGNFLG:  DS.B 01                        ;SIGN OF FAC IS PRESERVED BERE BY 'FIN'.
0257 D000              DEGREE   EQU   SGNFLG                   ;A COUNT USED BY POLYNOMIALS.
0258 D000              DSCTMP   EQU   FAC                      ;THIS IS WHERE TEMP DESCS ARE BUILT.
0259 D000              INDICE   EQU   FACMO                    ;INDICE IS SET UP HERE BY 'QINT'.
0260 D000              BITS:    DS.B 01                        ;SOMETHING FOR 'SHIFTR' TO USE.
0261 D000              ; --- THE FLOING ARGUMENT (UNPACKED) ---:
0262 D000              ARGEXP:  DS.B 01
0263 D000              ARGHO:   DS.B 01
0264 D000              ARGMOH:  DS.B 01
0265 D000              ARGMO:   DS.B 01
0266 D000              ARGLO:   DS.B 01
0267 D000              ARGSGN:  DS.B 01
0268 D000              ARISGN:  DS.B 01                        ;A SIGN REFLECTING THE RESULT.
0269 D000              FACOV:   DS.B 01                        ;OVERFLOW BYTE OF THE FAC.
0270 D000              STRNG1   EQU   ARISGN                   ;POINTER TO A STRING OR DESCRIPTOR.
0271 D000              FBUFPT:  DS.B 2                         ;POINTER INTO FBUFFR USED BY FOUT.
0272 D000              BUFPTR   EQU   FBUFPT                   ;POINTER TO BUF USED BY 'CRUNCH'.
0273 D000              STRNG2   EQU   FBUFPT                   ;POINTER TO STRING OR DESC.
0274 D000              POLYPT   EQU   FBUFPT                   ;POINTER INTO POLYNOMIAL COEFFICIENTS.
0275 D000              CURTOL   EQU   FBUFPT                   ;ABSOLUTE LINEAR INDEX IS FORMED HERE.
0276 D000              PRGEND:  DS.B 2
0277 D000                       EJECT 
0278 D000                       TITLE 'RAM CODE.'
0279 D000              ; THIS CODE GETS CHANGED THROUGHOUT EXECUTION.
0280 D000              ; IT IS MADE TO BE FAST THIS WAY.
0281 D000              ; ALSO, X AND Y ARE NOT DISTURBED
0282 D000              ; 'CHRGET' USING TXTPTR AS THE CURRENT TEXT PNTR
0283 D000              ; FETCHES NEW CHARACTER INTO ACCA AFTER INCREMENTING TXTPT
0284 D000              ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
0285 D000              ; NOT C= NUMERIC   ('0' THRU '9')
0286 D000              ; Z= ':' OR END-OF-LINE (A NULL)
0287 D000              ; ACCA = NEW CHAR.
0288 D000              ; TXTPTR=TXTPTR+1
0289 D000              ; THE FOLLOWING EXISTS IN ROM IF ROM EXISTS AND IS LOADED
0290 D000              ; DOWN HERE BY INIT. OTHERWISE IT IS JUST LOADED INTO THIS
0291 D000              ; RAM LIKE ALL THE REST OF RAM IS LOADED.
0292 D000              CHRGET:  DS.b 2                         ;INC CHRGET+7 ;INCREMENT THE WHOLE TXTPTR.
0293 D000                       DS.b 2                         ;BNE CHRGOT
0294 D000                       DS.b 2                         ;INC CHRGET+8
0295 D000              CHRGOT:  DS.b 3                         ;LDA 60000 ;A LOAD WITH AN EXT ADDR.
0296 D000              TXTPTR   EQU   CHRGOT+1
0297 D000                       DS.b 2                         ;CMP $20 ;SKIP SPACES.
0298 D000                       DS.b 2                         ;BEQ CHRGET
0299 D000              QNUM:    DS.b 2                         ;CMP ':' ;IS IT A ':'?
0300 D000                       DS.b 2                         ;BCS CHRRTS ;IT IS .GE. ':'
0301 D000                       DS.b 1                         ;SEC
0302 D000                       DS.b 2                         ;SBC '0' ;ALL CHARS .GT. '9' HAVE RET'D SO
0303 D000                       DS.b 1                         ;SEC
0304 D000                       DS.b 2                         ;SBC $100-'0' ;SEE INUMERIC.
0305 D000              ;TURN CARRY ON IF NUMERIC.
0306 D000              ;ALSO, SETZ IF NULL.
0307 D000              CHRRTS:  DS.b 1                         ;RTS ;RETURN TO CALLER.
0308 D000               RNDX:   DS.b 1                         ;was DB 128 ;LOADED OR FROM ROM.
0309 D000                       DS.b 1                         ;was DB 79 ;THE INITIAL RANDOM NUMBER.
0310 D000                       DS.b 1                         ;was DB 199
0311 D000                       DS.b 1                         ;was DB 82
0312 D000                       DS.b 1                         ;was DB 89 ;ONE MORE BYTE.
0313 D000                       ORG   255                      ;PAGE 1 STUFF COMING UP.
0314 D000              LOFBUF:  DS.B 1                         ;THE LOW FAC BUFFER. COPYABLE.
0315 D000              ;---  PAGE ZERO/ONE BOUNDARY ---.
0316 D000              ;MUST HAVE 13 CONTIGUOUS BYTES.
0317 D000              FBUFFR:  DS.B 3*1+13                    ;BUFFER FOR 'FOUT'.
0318 D000              ;ON PAGE 1 SO THAT STRING IS NOT COPIED.
0319 D000              ;STACK IS LOCATED HERE. IE FROTHE END OF FBUFFR TO STKEND.
0320 D000                       ENDR 
0321 D000                       EJECT 
0322 D000                       TITLE 'DISPATCH TABLES, RESERVED WORDS, AND ERROR TEXTS.'
0323 D000              ROMASOFT PROC ORG ROMLOC
0324 D000                       WITH ZPage
0325 D000              APPLESOFT:  
0326 D000 6F D8        STMDSP:  DC W:END-1
0327 D002 65 D7                 DC W:FOR-1
0328 D004 F8 DC                 DC W:NEXT-1
0329 D006 94 D9                 DC W:DATA-1
0330 D008 B1 DB                 DC W:INPUT-1
0331 D00A 30 F3                 DC W:DELETE-1
0332 D00C D8 DF                 DC W:DIM-1
0333 D00E E1 DB                 DC W:READ-1
0334 D010 8F F3                 DC W:MSETGR-1
0335 D012 98 F3                 DC W:MSETTXT-1
0336 D014 E4 F1                 DC W:PRNUMB-1
0337 D016 DD F1                 DC W:INNUMB-1
0338 D018 D4 F1                 DC W:CALL-1
0339 D01A 24 F2                 DC W:PLOT-1
0340 D01C 31 F2                 DC W:HLIN-1
0341 D01E 40 F2                 DC W:VLIN-1
0342 D020 D7 F3                 DC W:SETHRH-1
0343 D022 E1 F3                 DC W:SETHRL-1
0344 D024 E8 F6                 DC W:SETHCOL-1
0345 D026 FD F6                 DC W:LINE-1
0346 D028 68 F7                 DC W:DODRAW-1
0347 D02A 6E F7                 DC W:DOXDRAW-1
0348 D02C E6 F7                 DC W:HTAB-1
0349 D02E 57 FC                 DC W:CLRSCR-1
0350 D030 20 F7                 DC W:SETROT-1
0351 D032 26 F7                 DC W:SETSCALE-1
0352 D034 F4 03                 DC W:$3F4                      ;UNSUPPORTED IN LOLLY, GO & HOOK
0353 D036 6C F2                 DC W:SETTRACE-1
0354 D038 6E F2                 DC W:TRACEOFF-1
0355 D03A 72 F2                 DC W:SETNORM-1
0356 D03C 76 F2                 DC W:INVERSE-1
0357 D03E 7F F2                 DC W:FLASH-1
0358 D040 4E F2                 DC W:COLORE-1
0359 D042 6A D9                 DC W:RETURN-1
0360 D044 55 F2                 DC W:VTAB-1
0361 D046 85 F2                 DC W:HIMEMSET-1
0362 D048 A5 F2                 DC W:LOMEMSET-1
0363 D04A CA F2                 DC W:ONERR-1
0364 D04C 17 F3                 DC W:RESUME-1
0365 D04E F4 03                 DC W:$3F4                      ;UNSUPPORTED IN LOLLY, DO & HOOK
0366 D050 F4 03                 DC W:$3F4
0367 D052 61 F2                 DC W:SETSPD-1
0368 D054 45 DA                 DC W:LET-1
0369 D056 3D D9                 DC W:GOTO-1
0370 D058 11 D9                 DC W:RUN-1
0371 D05A C8 D9                 DC W:IF-1
0372 D05C 48 D8                 DC W:RESTOR-1
0373 D05E F4 03                 DC W:$3F4                      ;WHY THE HELL NOT
0374 D060 20 D9                 DC W:GOSUB-1
0375 D062 6A D9                 DC W:RETURN-1
0376 D064 DB D9                 DC W:REM-1
0377 D066 6D D8                 DC W:STOP-1
0378 D068 EB D9                 DC W:ONGOTO-1
0379 D06A 83 E7                 DC W:FNWAIT-1
0380 D06C F4 03                 DC W:$3F4                      ;UNSUPPORTED IN LOLLY, DO & HOOK
0381 D06E F4 03                 DC W:$3F4
0382 D070 12 E3                 DC W:DEF-1
0383 D072 7A E7                 DC W:POKE-1
0384 D074 D4 DA                 DC W:PRINT-1
0385 D076 95 D8                 DC W:CONT-1
0386 D078 A4 D6                 DC W:LIST-1
0387 D07A 69 D6                 DC W:CLEAR-1
0388 D07C 9F DB                 DC W:GET-1                     ;FILL W/ GET ADDR.
0389 D07E 48 D6                 DC W:SCRATH-1
0390 D080 90 EB        FUNDSP:  DC W:SGN
0391 D082 23 EC                 DC W:INT
0392 D084 AF EB                 DC W:ABS
0393 D086 0A 00        USRLOC:  DC W:USRPOK
0394 D088 DE E2                 DC W:FRE
0395 D08A 12 D4                 DC W:ERROR                     ;DUMMY FILL FOR SCRN().
0396 D08C CD DF                 DC W:PDLHNDL
0397 D08E FF E2                 DC W:POS
0398 D090 8D EE                 DC W:SQR
0399 D092 AE EF                 DC W:RND
0400 D094 41 E9                 DC W:LOG
0401 D096 09 EF                 DC W:EXP
0402 D098 EA EF        COSFIX:  DC W:COS
0403 D09A F1 EF        SINFIX:  DC W:SIN
0404 D09C 3A F0        TANFIX:  DC W:TAN
0405 D09E 9E F0        ATNFIX:  DC W:ATN
0406 D0A0 64 E7                 DC W:PEEK
0407 D0A2 D6 E6                 DC W:LEN
0408 D0A4 C5 E3                 DC W:STRS
0409 D0A6 07 E7                 DC W:VAL
0410 D0A8 E5 E6                 DC W:ASC
0411 D0AA 46 E6                 DC W:CHRS
0412 D0AC 5A E6                 DC W:LEFTS
0413 D0AE 86 E6                 DC W:RIGHTS
0414 D0B0 91 E6                 DC W:MIDS
0415 D0B2 79           OPTAB:   DC B:121
0416 D0B3 C0 E7                 DC W:FADDT-1
0417 D0B5 79                    DC B:121
0418 D0B6 A9 E7                 DC W:FSUBT-1
0419 D0B8 7B                    DC B:123
0420 D0B9 81 E9                 DC W:FMULTT-1
0421 D0BB 7B                    DC B:123
0422 D0BC 68 EA                 DC W:FDIVT-1
0423 D0BE 7D                    DC B:125
0424 D0BF 96 EE                 DC W:FPWRT-1
0425 D0C1 50                    DC B:80
0426 D0C2 54 DF                 DC W:ANDOP-1
0427 D0C4 46                    DC B:70
0428 D0C5 4E DF                 DC W:OROP-1
0429 D0C7 7F           NEGTAB:  DC B:127
0430 D0C8 CF EE                 DC W:NEGOP-1
0431 D0CA 7F           NOTTAB:  DC B:127
0432 D0CB 97 DE                 DC W:NOTOP-1
0433 D0CD 64           PTDORL:  DC B:100                       ;PRECEDENCE.
0434 D0CE 64 DF                 DC W:DOREL-1                   ;OPERATOR ADDRESS.
0435 D0D0              ; TOKENS FOR RESERVED WORDS ALWAYS HAVE THE MOST
0436 D0D0              ; SIGNIFICANT BIT ON.
0437 D0D0              ; THE LIST OF RESERVED WORDS:
0438 D0D0              ;Q EQU 128-1
0439 D0D0              ; DCI MACRO A
0440 D0D0              ;Q EQU Q+1
0441 D0D0              ; DC A
0442 D0D0              ; ENDM
0443 D0D0 45 4E C4     RESLST:  DC I:'END'
0444 D0D3              ENDTK    EQU   $80
0445 D0D3 46 4F D2              DC I:'FOR'
0446 D0D6              FORTK    EQU   ENDTK+1
0447 D0D6 4E 45 58 D4           DC I:'NEXT'
0448 D0DA 44 41 54 C1           DC I:'DATA'
0449 D0DE              DATATK   EQU   FORTK+2
0450 D0DE 49 4E 50 55           DC I:'INPUT'
0451 D0E3 44 45 CC              DC I:'DEL'
0452 D0E6 44 49 CD              DC I:'DIM'
0453 D0E9 52 45 41 C4           DC I:'READ'
0454 D0ED 47 D2                 DC I:'GR'
0455 D0EF 54 45 58 D4           DC I:'TEXT'
0456 D0F3 50 52 A3              DC I:'PR#'
0457 D0F6 49 4E A3              DC I:'IN#'
0458 D0F9 43 41 4C CC           DC I:'CALL'
0459 D0FD 50 4C 4F D4           DC I:'PLOT'
0460 D101 48 4C 49 CE           DC I:'HLIN'
0461 D105 56 4C 49 CE           DC I:'VLIN'
0462 D109 48 47 52 B2           DC I:'HGR2'
0463 D10D 48 47 D2              DC I:'HGR'
0464 D110 48 43 4F 4C           DC I:'HCOLOR='
0465 D117 48 50 4C 4F           DC I:'HPLOT'
0466 D11C 44 52 41 D7           DC I:'DRAW'
0467 D120 58 44 52 41           DC I:'XDRAW'
0468 D125 48 54 41 C2           DC I:'HTAB'
0469 D129 48 4F 4D C5           DC I:'HOME'
0470 D12D 52 4F 54 BD           DC I:'ROT='
0471 D131 53 43 41 4C           DC I:'SCALE='
0472 D137 53 48 4C 4F           DC I:'SHLOAD'
0473 D13D 54 52 41 43           DC I:'TRACE'
0474 D142 4E 4F 54 52           DC I:'NOTRACE'
0475 D149 4E 4F 52 4D           DC I:'NORMAL'
0476 D14F 49 4E 56 45           DC I:'INVERSE'
0477 D156 46 4C 41 53           DC I:'FLASH'
0478 D15B 43 4F 4C 4F           DC I:'COLOR='
0479 D161 50 4F D0              DC I:'POP'
0480 D164              POPTKN   EQU   DATATK+30
0481 D164 56 54 41 C2           DC I:'VTAB'
0482 D168 48 49 4D 45           DC I:'HIMEM:'
0483 D16E 4C 4F 4D 45           DC I:'LOMEM:'
0484 D174 4F 4E 45 52           DC I:'ONERR'
0485 D179 52 45 53 55           DC I:'RESUME'
0486 D17F 52 45 43 41           DC I:'RECALL'
0487 D185 53 54 4F 52           DC I:'STORE'
0488 D18A 53 50 45 45           DC I:'SPEED='
0489 D190 4C 45 D4              DC I:'LET'
0490 D193 47 4F 54 CF           DC I:'GOTO'
0491 D197              GOTOTK   EQU   POPTKN+10
0492 D197 52 55 CE              DC I:'RUN'
0493 D19A 49 C6                 DC I:'IF'
0494 D19C 52 45 53 54           DC I:'RESTORE'
0495 D1A3 A6                    DC B:$26+$80                   ;'&' FOR DISK HOOKS.
0496 D1A4 47 4F 53 55           DC I:'GOSUB'
0497 D1A9              GOSUTK   EQU   GOTOTK+5
0498 D1A9 52 45 54 55           DC I:'RETURN'
0499 D1AF 52 45 CD              DC I:'REM'
0500 D1B2              REMTK    EQU   GOSUTK+2
0501 D1B2 53 54 4F D0           DC I:'STOP'
0502 D1B6 4F CE                 DC I:'ON'
0503 D1B8 57 41 49 D4           DC I:'WAIT'
0504 D1BC 4C 4F 41 C4           DC I:'LOAD'
0505 D1C0 53 41 56 C5           DC I:'SAVE'
0506 D1C4 44 45 C6              DC I:'DEF'
0507 D1C7 50 4F 4B C5           DC I:'POKE'
0508 D1CB 50 52 49 4E           DC I:'PRINT'
0509 D1D0              PRINTK   EQU   REMTK+8
0510 D1D0 43 4F 4E D4           DC I:'CONT'
0511 D1D4 4C 49 53 D4           DC I:'LIST'
0512 D1D8 43 4C 45 41           DC I:'CLEAR'
0513 D1DD 47 45 D4              DC I:'GET'
0514 D1E0 4E 45 D7              DC I:'NEW'
0515 D1E3              SCRATK   EQU   PRINTK+5
0516 D1E3              ; END OF COMMAND LIST.
0517 D1E3 54 41 42 A8           DC I:'TAB('
0518 D1E7              TABTK    EQU   SCRATK+1
0519 D1E7 54 CF                 DC I:'TO'
0520 D1E9              TOTK     EQU   TABTK+1
0521 D1E9 46 CE                 DC I:'FN'
0522 D1EB              FNTK     EQU   TOTK+1
0523 D1EB 53 50 43 A8           DC I:'SPC('
0524 D1EF              SPCTK    EQU   FNTK+1
0525 D1EF 54 48 45 CE           DC I:'THEN'
0526 D1F3              THENTK   EQU   SPCTK+1
0527 D1F3 41 D4                 DC I:'AT'
0528 D1F5              ATTKN    EQU   THENTK+1
0529 D1F5 4E 4F D4              DC I:'NOT'
0530 D1F8              NOTTK    EQU   ATTKN+1
0531 D1F8 53 54 45 D0           DC I:'STEP'
0532 D1FC              STEPTK   EQU   NOTTK+1
0533 D1FC AB                    DC I:'+'
0534 D1FD              PLUSTK   EQU   STEPTK+1
0535 D1FD AD                    DC I:'-'
0536 D1FE              MINUTK   EQU   PLUSTK+1
0537 D1FE AA                    DC I:'*'
0538 D1FF AF                    DC I:'/'
0539 D200 DE                    DC B:$DE                       ;THE EXPONENTIATION SIGN
0540 D201 41 4E C4              DC I:'AND'
0541 D204 4F D2                 DC I:'OR'
0542 D206 BE                    DC I:'>'
0543 D207              GREATK   EQU   MINUTK+6
0544 D207 BD                    DC I:'='
0545 D208              EQULTK   EQU   GREATK+1
0546 D208 BC                    DC I:'<'
0547 D209              LESSTK   EQU   EQULTK+1
0548 D209              ; ANOTHER EXAMPLE: IF T OR Q THEN ... 'TO' IS CNCHED
0549 D209 53 47 CE              DC I:'SGN'
0550 D20C              ONEFUN   EQU   LESSTK+1
0551 D20C 49 4E D4              DC I:'INT'
0552 D20F 41 42 D3              DC I:'ABS'
0553 D212 55 53 D2              DC I:'USR'
0554 D215 46 52 C5              DC I:'FRE'
0555 D218 53 43 52 4E           DC I:'SCRN('
0556 D21D              SCRNFN   EQU   ONEFUN+5
0557 D21D 50 44 CC              DC I:'PDL'
0558 D220 50 4F D3              DC I:'POS'
0559 D223 53 51 D2              DC I:'SQR'
0560 D226 52 4E C4              DC I:'RND'
0561 D229 4C 4F C7              DC I:'LOG'
0562 D22C 45 58 D0              DC I:'EXP'
0563 D22F 43 4F D3              DC I:'COS'
0564 D232 53 49 CE              DC I:'SIN'
0565 D235 54 41 CE              DC I:'TAN'
0566 D238 41 54 CE              DC I:'ATN'
0567 D23B 50 45 45 CB           DC I:'PEEK'
0568 D23F 4C 45 CE              DC I:'LEN'
0569 D242 53 54 52 A4           DC I:'STR$'
0570 D246 56 41 CC              DC I:'VAL'
0571 D249 41 53 C3              DC I:'ASC'
0572 D24C 43 48 52 A4           DC I:'CHR$'
0573 D250              LASNUM   EQU   SCRNFN+16                ;NUMBER OF LAST FUNCTION
0574 D250              ;THAT TAKES ONE ARG
0575 D250 4C 45 46 54           DC I:'LEFT$'
0576 D255 52 49 47 48           DC I:'RIGHT$'
0577 D25B 4D 49 44 A4           DC I:'MID$'
0578 D25F 00                    DC B:0                         ;MARKS END OF RESERVED WORD LIST
0579 D260              ; NOTE: THIS ERROR COUNT TECHNIQUE WILL NOT WORK IF THERE
0580 D260              ; ARE THAN 256 CHARACTERS OF ERROR MESSAGES
0581 D260 4E 45 58 54  ERRTAB:  DC I:'NEXT WITHOUT FOR'
0582 D270              ERRNF    EQU   0
0583 D270 53 59 4E 54           DC I:'SYNTAX'
0584 D276              ERRSN    EQU   ERRNF+16
0585 D276 52 45 54 55           DC I:'RETURN WITHOUT GOSUB'
0586 D28A              ERRRG    EQU   ERRSN+6
0587 D28A 4F 55 54 20           DC I:'OUT OF DATA'
0588 D295              ERROD    EQU   ERRRG+20
0589 D295 49 4C 4C 45           DC I:'ILLEGAL QUANTITY'
0590 D2A5              ERRFC    EQU   ERROD+11
0591 D2A5 4F 56 45 52           DC I:'OVERFLOW'
0592 D2AD              ERROV    EQU   ERRFC+16
0593 D2AD 4F 55 54 20           DC I:'OUT OF MEMORY'
0594 D2BA              ERROM    EQU   ERROV+8
0595 D2BA 55 4E 44 45           DC I:'UNDEF''D STATEMENT'
0596 D2CB              ERRUS    EQU   ERROM+13
0597 D2CB 42 41 44 20           DC I:'BAD SUBSCRIPT'
0598 D2D8              ERRBS    EQU   ERRUS+17
0599 D2D8 52 45 44 49           DC I:'REDIM''D ARRAY'
0600 D2E5              ERRDD    EQU   ERRBS+13
0601 D2E5 44 49 56 49           DC I:'DIVISION BY ZERO'
0602 D2F5              ERRDV0   EQU   ERRDD+13
0603 D2F5 49 4C 4C 45           DC I:'ILLEGAL DIRECT'
0604 D303              ERRID    EQU   ERRDV0+16
0605 D303 54 59 50 45           DC I:'TYPE MISMATCH'
0606 D310              ERRTM    EQU   ERRID+14
0607 D310 53 54 52 49           DC I:'STRING TOO LONG'
0608 D31F              ERRLS    EQU   ERRTM+13
0609 D31F 46 4F 52 4D           DC I:'FORMULA TOO COMPLEX'
0610 D332              ERRST    EQU   ERRLS+15
0611 D332 43 41 4E 27           DC I:'CAN''T CONTINUE'
0612 D340              ERRCN    EQU   ERRST+19
0613 D340 55 4E 44 45           DC I:'UNDEF''D FUNCTION'
0614 D350              ERRUF    EQU   ERRCN+14
0615 D350              ; NEEDED FOR MESSAGES IN ALL VERSIONS.
0616 D350 20 45 52 52  ERR:     DC B:' ERROR'
0617 D356 07 00                 DC B:7,0
0618 D358 20 49 4E 20  INTXT:   DC B:' IN '
0619 D35C 00                    DC B:0
0620 D35D 0D           BRKTXT:  DC B:13
0621 D35E 42 52 45 41           DC B:'BREAK'
0622 D363 07 00                 DC B:7,0
0623 D365                       EJECT 
0624 D365                       TITLE 'GENERAL STORAGE ROUTINES.'
0625 D365              ; FIND A 'FOR' ENTRY ON THE STACK VIA 'VARPNT'.
0626 D365              FORSIZ   EQU   $12
0627 D365 BA           FNDFOR:  TSX                            ;LOAD XREG WITH STK PNTR.
0628 D366 E8                    INX   
0629 D367 E8                    INX   
0630 D368 E8                    INX   
0631 D369 E8                    INX                            ;IGNORE ADR(NEWSTT) AND RTS ADDR.
0632 D36A BD 01 01     FFLOOP:  LDA   257,X                    ;GET STACK ENTRY.
0633 D36D C9 81                 CMP   #FORTK                   ;IS IT A 'FOR' TOKEN?
0634 D36F D0 21                 BNE   FFRTS                    ;NO, NO 'FOR' LOOPS TH THIS PNTR.
0635 D371 A5 86                 LDA   FORPNT+1                 ;GET HIGH.
0636 D373 D0 0A                 BNE   CMPFOR
0637 D375 BD 02 01              LDA   258,X                    ;PNTR IS ZERO, SO ASSUME THIS ONE.
0638 D378 85 85                 STA   FORPNT
0639 D37A BD 03 01              LDA   259,X
0640 D37D 85 86                 STA   FORPNT+1
0641 D37F DD 03 01     CMPFOR:  CMP   259,X
0642 D382 D0 07                 BNE   ADDFRS                   ;NOT THIS ONE.
0643 D384 A5 85                 LDA   FORPNT                   ;GET DOWN.
0644 D386 DD 02 01              CMP   258,X
0645 D389 F0 07                 BEQ   FFRTS                    ;WE GOT IT! WE GOT IT!
0646 D38B 8A           ADDFRS:  TXA   
0647 D38C 18                    CLC                            ;ADD 16 TO X.
0648 D38D 69 12                 ADC   #FORSIZ
0649 D38F AA                    TAX                            ;RESULT BACK INTO X.
0650 D390 D0 D8                 BNE   FFLOOP
0651 D392 60           FFRTS:   RTS                            ;RETURN TO CALLER.
0652 D393              ; THIS IS THE BLOCK TRANSFER ROUTINE.
0653 D393              ; IT MAKES SPACE BY SHOVING EVERYTHING FORWARD.
0654 D393              ; ON ENTRY:
0655 D393              ; Y,A=HIGHDS    (FOR REASON).
0656 D393              ; HIGHDS= DESTINATION OF HIGH ADDRESS.
0657 D393              ; LOWTR= LOWEST ADDR TO BE TRANSFERRED.
0658 D393              ; HIGHTR= HIGHEST ADDR TO BE TRANSFERRED.
0659 D393              ; A CHECK IS MADE TO ASCERTAIN THAT A REASONABLE
0660 D393              ; AMOUNT OF SPACE REMAINS BETWEEN THE BOTTOM
0661 D393              ; OF THE STRINGS AND THE HIGHEST LOCATION TRANSFERRED INTO
0662 D393              ; ON EXIT:
0663 D393              ; LOWTR ARE UNCHANGED.
0664 D393              ; HIGHTR=LOWTR-200 OCTAL.
0665 D393              ; HIGHDS=LOWEST ADDR TRANSFERRED INTO MINUS 200 OCTAL.
0666 D393 20 E3 D3     BLTU:    JSR   REASON                   ;CERTAIN THAT STRING SPACE WON'T
0667 D396              ;BE OVERRUN.
0668 D396 85 6D                 STA   STREND
0669 D398 84 6E                 STY   STREND+1
0670 D39A 38           BLTUC:   SEC                            ;PREPARE TO SUBTRACT.
0671 D39B A5 96                 LDA   HIGHTR
0672 D39D E5 9B                 SBC   LOWTR                    ;COMPUTE NUMBER OF THINGS TO MOVE.
0673 D39F 85 5E                 STA   INDEX                    ;SAVE FOR LATER.
0674 D3A1 A8                    TAY   
0675 D3A2 A5 97                 LDA   HIGHTR+1
0676 D3A4 E5 9C                 SBC   LOWTR+1
0677 D3A6 AA                    TAX                            ;PUT IT IN A COUNTER REGISTER.
0678 D3A7 E8                    INX                            ;SO THAT COUNTER ALGORITHM WORKS.
0679 D3A8 98                    TYA                            ;SEE IF LOW PART OF COUNT IS ZERO.
0680 D3A9 F0 23                 BEQ   DECBLT                   ;YES, GO START MOVING BLOCKS.
0681 D3AB A5 96                 LDA   HIGHTR                   ;NO, MUST MODIFY BASE ADDR.
0682 D3AD 38                    SEC   
0683 D3AE E5 5E                 SBC   INDEX                    ;BORROW IS OFF SCE HIGHTR.GT.LOWTR.
0684 D3B0 85 96                 STA   HIGHTR                   ;SAVE MODIFIED BASE ADDR.
0685 D3B2 B0 03                 BCS   BLT1                     ;IF NO BORROW, GO SHOVE IT.
0686 D3B4 C6 97                 DEC   HIGHTR+1                 ;BORROW IMPLIES SUB 1 FROM HIGH ORDER.
0687 D3B6 38                    SEC   
0688 D3B7 A5 94        BLT1:    LDA   HIGHDS                   ;MOD BASE OF DEST ADDR.
0689 D3B9 E5 5E                 SBC   INDEX
0690 D3BB 85 94                 STA   HIGHDS
0691 D3BD B0 08                 BCS   MOREN1                   ;NO BORROW.
0692 D3BF C6 95                 DEC   HIGHDS+1                 ;DECREMENT HIGH ORDER BYTE.
0693 D3C1 90 04                 BCC   MOREN1                   ;ALWAYS SKIP.
0694 D3C3 B1 96        BLTLP:   LDA   (HIGHTR),Y               ;FETCH BYTE TO MOVE
0695 D3C5 91 94                 STA   (HIGHDS),Y               ;MOVE IT IN, MOVE IT OUT.
0696 D3C7 88           MOREN1:  DEY   
0697 D3C8 D0 F9                 BNE   BLTLP
0698 D3CA B1 96                 LDA   (HIGHTR),Y               ;MOVE LAST OF THE BLOCK.
0699 D3CC 91 94                 STA   (HIGHDS),Y
0700 D3CE C6 97        DECBLT:  DEC   HIGHTR+1
0701 D3D0 C6 95                 DEC   HIGHDS+1                 ;START ON NEW BLOCKS.
0702 D3D2 CA                    DEX   
0703 D3D3 D0 F2                 BNE   MOREN1
0704 D3D5 60                    RTS                            ;RETURN TO CALLER.
0705 D3D6              ; THIS ROUTINE IS USED TO ASCERTAIN THAT A GIVEN
0706 D3D6              ; NUMBER OF LOCS REMAIN AVAILABLE FOR THE STACK.
0707 D3D6              ;    THE CALL IS:
0708 D3D6              ; LDAI NUMBER OF 2-BYTE ENTRIES NEEDED.
0709 D3D6              ; JSR GETSTK
0710 D3D6              ; THIS ROUTINE MUST BE CALLED BY ANY ROUTINE WHICH PUTS
0711 D3D6              ; AN ARBITRARY AMOUNT OF STUFF ON THE STACK,
0712 D3D6              ; I.E., ANY RECURSIVE ROUTINE LIKE 'FRMEVL'.
0713 D3D6              ; IT IS ALSO CALLED BY ROUTINES SUCH A'GOSUB' AND 'FOR'
0714 D3D6              ; WHICH MAKE PERMANENT ENTRIES ON THE STACK.
0715 D3D6              ; ROUTINES WHICH MERELY USE AND FREE UP THE GUARANTEED
0716 D3D6              ; NUMLEV LOCATIONS NEED NOT CALL THIS.
0717 D3D6              ; ON EXIT:
0718 D3D6              ;    A AND X HAVE BEEN MODIFIED.
0719 D3D6 0A           GETSTK:  ASL   A                        ;MULT A BY 2. NB, CLEARS C BIT.
0720 D3D7 69 36                 ADC   #2*NUMLEV+3+13           ;MAKE SURE 2*NUMLEV+13 LOCS
0721 D3D9              ;(13 BECAUSE OF FBUFFR)
0722 D3D9 B0 35                 BCS   OMERR                    ;WILL REMAIN IN STACK.
0723 D3DB 85 5E                 STA   INDEX
0724 D3DD BA                    TSX                            ;GET STACKED.
0725 D3DE E4 5E                 CPX   INDEX                    ;COMPARE.
0726 D3E0 90 2E                 BCC   OMERR                    ;IF STACK.LE.INDEX1, OM.
0727 D3E2 60                    RTS   
0728 D3E3              ; Y,A IS A CERTAIN ADDRESS. 'REASON' MAKES SURE
0729 D3E3              ; IT IS LESS THAN FRETOP.
0730 D3E3 C4 70        REASON:  CPY   FRETOP+1
0731 D3E5 90 28                 BCC   REARTS
0732 D3E7 D0 04                 BNE   TRYMOR                   ;GO GARB COLLECT.
0733 D3E9 C5 6F                 CMP   FRETOP
0734 D3EB 90 22                 BCC   REARTS
0735 D3ED 48           TRYMOR:  PHA   
0736 D3EE A2 09                 LDX   #8+1                     ;IF TEMPF2 HAS ZERO IN BETWEEN.
0737 D3F0 98                    TYA   
0738 D3F1 48           REASAV:  PHA   
0739 D3F2 B5 93                 LDA   HIGHDS-1,X               ;SAVE HIGHDS ON STACK.
0740 D3F4 CA                    DEX   
0741 D3F5 10 FA                 BPL   REASAV                   ;PUT 8 OF THEM ON STK.
0742 D3F7 20 84 E4              JSR   GARBA2                   ;GO GARB COLLECT.
0743 D3FA A2 F7                 LDX   #$F7
0744 D3FC 68           REASTO:  PLA   
0745 D3FD 95 9D                 STA   HIGHDS+8+1,X             ;RESTORE AFTER GARB COLLECT.
0746 D3FF E8                    INX   
0747 D400 30 FA                 BMI   REASTO
0748 D402 68                    PLA   
0749 D403 A8                    TAY   
0750 D404 68                    PLA                            ;RESTORE A AND Y.
0751 D405 C4 70                 CPY   FRETOP+1                 ;COMPARE HIGHS
0752 D407 90 06                 BCC   REARTS
0753 D409 D0 05                 BNE   OMERR                    ;HIGHER IS BAD.
0754 D40B C5 6F                 CMP   FRETOP                   ;AND THE LOWS.
0755 D40D B0 01                 BCS   OMERR
0756 D40F 60           REARTS:  RTS   
0757 D410                       EJECT 
0758 D410                       TITLE 'ERR HAND, READY, TERM INPUT'
0759 D410 A2 4D        OMERR:   LDX   #ERROM
0760 D412              ERROR:   EQU   *
0761 D412 24 D8        ERRCRD:  BIT   ERRFLG
0762 D414 10 03                 BPL   *+5
0763 D416 4C E9 F2              JMP   HNDLERR
0764 D419 20 FB DA              JSR   CRDO                     ;OUTPUT CRLF.
0765 D41C 20 5A DB              JSR   OUTQST                   ;PRINT A QUESTI MARK
0766 D41F              ;OUTPUT IT.
0767 D41F BD 60 D2     GETERR:  LDA   ERRTAB,X
0768 D422 48                    PHA   
0769 D423 20 5C DB              JSR   OUTDO                    ;OUTPUT IT.
0770 D426 E8                    INX   
0771 D427 68                    PLA                            ;LAST CHAR OF MESSAGE?
0772 D428 10 F5                 BPL   GETERR                   ;NO. GO GET NEXT AND OUTPUT IT.
0773 D42A 20 83 D6     TYPERR:  JSR   STKINI                   ;RESET THE STACK AND FLAGS.
0774 D42D A9 50                 LDA   #ERR
0775 D42F A0 D3                 LDY   #>ERR                    ;GET PNTR TO ' ERROR'.
0776 D431 20 3A DB     ERRFIN:  JSR   STROUT                   ;OUTPUT IT.
0777 D434 A4 76                 LDY   CURLIN+1
0778 D436 C8                    INY                            ;WAS NUMBER 64000?
0779 D437 F0 03                 BEQ   READY                    ;YES, DON'T TYPE LINE NUMBER.
0780 D439 20 19 ED              JSR   INPRT
0781 D43C              READY    EQU   *
0782 D43C              ;NO INIT ERRORS POSSIBLE.
0783 D43C 20 FB DA     MAIN:    JSR   CRDO                     ;NEXT LINE
0784 D43F A2 DD                 LDX   #$DD                     ;BACK BRACKET FOR PROMPT
0785 D441 20 2E D5              JSR   INLIN+2
0786 D444 86 B8                 STX   TXTPTR
0787 D446 84 B9                 STY   TXTPTR+1
0788 D448 46 D8                 LSR   ERRFLG                   ;CLEAR 'ONERR' FLAG.
0789 D44A 20 B1 00              JSR   CHRGET
0790 D44D AA                    TAX                            ;SET ZERO FLAG BASED ON A
0791 D44E              ;THIS DISTINGUISHES ':' AND 0
0792 D44E F0 EC                 BEQ   MAIN                     ;IF BLANK LINE, GET ANOTHER.
0793 D450 A2 FF                 LDX   #255                     ;SET DIRECT LINE NUMBER.
0794 D452 86 76                 STX   CURLIN+1
0795 D454 90 06                 BCC   MAIN1                    ;IS A LINE NUMBER. NOT DIRECT.
0796 D456 20 59 D5              JSR   CRUNCH                   ;COMPACTIFY.
0797 D459 4C 05 D8              JMP   GONE                     ;EXECUTE IT.
0798 D45C A6 AF        MAIN1:   LDX   PRGEND
0799 D45E 86 69                 STX   VARTAB
0800 D460 A6 B0                 LDX   PRGEND+1
0801 D462 86 6A                 STX   VARTAB+1
0802 D464 20 0C DA              JSR   LINGET                   ;READ LINE NUMBER INTO 'LINNUM'
0803 D467 20 59 D5              JSR   CRUNCH
0804 D46A 84 0F                 STY   COUNT                    ;RETAIN CHARACTER COUNT.
0805 D46C 20 1A D6              JSR   FNDLIN
0806 D46F 90 44                 BCC   NODEL                    ;NO MATCH, SO DON'T DELETE.
0807 D471 A0 01                 LDY   #1
0808 D473 B1 9B                 LDA   (LOWTR),Y
0809 D475 85 5F                 STA   INDEX1+1
0810 D477 A5 69                 LDA   VARTAB
0811 D479 85 5E                 STA   INDEX1
0812 D47B A5 9C                 LDA   LOWTR+1                  ;SET TRANSFER TO.
0813 D47D 85 61                 STA   INDEX2+1
0814 D47F A5 9B                 LDA   LOWTR
0815 D481 88                    DEY   
0816 D482 F1 9B                 SBC   (LOWTR),Y                ;COMPUTE NEGATIVE LENGTH.
0817 D484 18                    CLC   
0818 D485 65 69                 ADC   VARTAB                   ;COMPUTE NEW VARTAB.
0819 D487 85 69                 STA   VARTAB
0820 D489 85 60                 STA   INDEX2                   ;SET LOW OF TRANS TO.
0821 D48B A5 6A                 LDA   VARTAB+1
0822 D48D 69 FF                 ADC   #255
0823 D48F 85 6A                 STA   VARTAB+1                 ;COMPUTE HIGH OF VARTAB.
0824 D491 E5 9C                 SBC   LOWTR+1                  ;COUTE NUMBER OF BLOCKS TO MOVE.
0825 D493 AA                    TAX   
0826 D494 38                    SEC   
0827 D495 A5 9B                 LDA   LOWTR
0828 D497 E5 69                 SBC   VARTAB                   ;COMPUTE OFFSET.
0829 D499 A8                    TAY   
0830 D49A B0 03                 BCS   QDECT1                   ;IF VARTAB.LE.LOWTR,
0831 D49C E8                    INX                            ;DECR DUE TO CARRY, AND
0832 D49D C6 61                 DEC   INDEX2+1                 ;DECREMENT STORE SO CARRY WORKS.
0833 D49F 18           QDECT1:  CLC   
0834 D4A0 65 5E                 ADC   INDEX1
0835 D4A2 90 03                 BCC   MLOOP
0836 D4A4 C6 5F                 DEC   INDEX1+1
0837 D4A6 18                    CLC                            ;FOR LATER ADC.
0838 D4A7 B1 5E        MLOOP:   LDA   (INDEX1),Y
0839 D4A9 91 60                 STA   (INDEX2),Y
0840 D4AB C8                    INY   
0841 D4AC D0 F9                 BNE   MLOOP                    ;BLOCK DONE?
0842 D4AE E6 5F                 INC   INDEX1+1
0843 D4B0 E6 61                 INC   INDEX2+1
0844 D4B2 CA                    DEX   
0845 D4B3 D0 F2                 BNE   MLOOP                    ;DO ANOTHER BLOCK. ALWAYS.
0846 D4B5 AD 00 02     NODEL:   LDA   BUF                      ;SEE IF LINE HAD ANY CONTES.
0847 D4B8 F0 38                 BEQ   FINI                     ;IF NOT, DON'T INSERT.
0848 D4BA A5 73                 LDA   MEMSIZ
0849 D4BC A4 74                 LDY   MEMSIZ+1
0850 D4BE 85 6F                 STA   FRETOP
0851 D4C0 84 70                 STY   FRETOP+1
0852 D4C2 A5 69                 LDA   VARTAB
0853 D4C4 85 96                 STA   HIGHTR                   ;SETUP HIGHTR.
0854 D4C6 65 0F                 ADC   COUNT                    ;ADD LENGTH OF LINE TO INSERT.
0855 D4C8 85 94                 STA   HIGHDS                   ;THIS GIVES DEST ADDR.
0856 D4CA A4 6A                 LDY   VARTAB+1
0857 D4CC 84 97                 STY   HIGHTR+1                 ;SAME FOR HIGH ORDERS.
0858 D4CE 90 01                 BCC   NODELC
0859 D4D0 C8                    INY   
0860 D4D1 84 95        NODELC:  STY   HIGHDS+1
0861 D4D3 20 93 D3              JSR   BLTU
0862 D4D6 A5 50                 LDA   LINNUM
0863 D4D8 A4 51                 LDY   LINNUM+1                 ;POSITION THE BINARY LINE NUMBER
0864 D4DA 8D FE 01              STA   BUF-2
0865 D4DD 8C FF 01              STY   BUF-2+1                  ;IN FRONT OF BUF
0866 D4E0 A5 6D                 LDA   STREND
0867 D4E2 A4 6E                 LDY   STREND+1
0868 D4E4 85 69                 STA   VARTAB
0869 D4E6 84 6A                 STY   VARTAB+1
0870 D4E8 A4 0F                 LDY   COUNT
0871 D4EA B9 FB 01     STOLOP:  LDA   BUF-5,Y
0872 D4ED 88                    DEY   
0873 D4EE 91 9B                 STA   (LOWTR),Y
0874 D4F0 D0 F8                 BNE   STOLOP
0875 D4F2 20 65 D6     FINI:    JSR   RUNC                     ;DO CLEAR & SET UP STACK.
0876 D4F5              ;AND SET TXTPTR TO TXTTAB-1.
0877 D4F5 A5 67                 LDA   TXTTAB
0878 D4F7 A4 68                 LDY   TXTTAB+1                 ;SET INDEX TO TXTTAB.
0879 D4F9 85 5E                 STA   INDEX
0880 D4FB 84 5F                 STY   INDEX+1
0881 D4FD 18                    CLC   
0882 D4FE              ; CHEAD GOES THROUGH PROGRAM STORAGE AND FIXES
0883 D4FE              ; UP ALL THE LINKS. THE END OF EACH LINE IS FOUND
0884 D4FE              ; BY SEARCHING FOR THE ZERO AT THE END.
0885 D4FE              ; THE DOUBLE ZERO LINK IS USED TO DETECT THE END OF PROG
0886 D4FE A0 01        CHEAD:   LDY   #1
0887 D500 B1 5E                 LDA   (INDEX),Y                ;ARRIVED AT DOUBLE ZEROES?
0888 D502 D0 0B                 BNE   CCHEAD
0889 D504 A5 69        SAVMEM:  LDA   VARTAB
0890 D506 85 AF                 STA   PRGEND
0891 D508 A5 6A                 LDA   VARTAB+1
0892 D50A 85 B0                 STA   PRGEND+1
0893 D50C 4C 3C D4              JMP   MAIN                     ;YES, CHEAD HAS FINISHED.
0894 D50F A0 04        CCHEAD:  LDY   #4
0895 D511 C8           CZLOOP:  INY                            ;THERE IS AT LEAST ONE BYTE.
0896 D512 B1 5E                 LDA   (INDEX),Y
0897 D514 D0 FB                 BNE   CZLOOP                   ;NO, CONTINUE SEARCHING.
0898 D516 C8                    INY                            ;GO ONE BEYOND.
0899 D517 98                    TYA   
0900 D518 65 5E                 ADC   INDEX
0901 D51A AA                    TAX   
0902 D51B A0 00                 LDY   #0
0903 D51D 91 5E                 STA   (INDEX),Y
0904 D51F A5 5F                 LDA   INDEX+1
0905 D521 69 00                 ADC   #0
0906 D523 C8                    INY   
0907 D524 91 5E                 STA   (INDEX),Y
0908 D526 86 5E                 STX   INDEX
0909 D528 85 5F                 STA   INDEX+1
0910 D52A 90 D2                 BCC   CHEAD                    ;ALWAYS BRANCHES.
0911 D52C A2 80        INLIN:   LDX   #$80                     ;NO PROMPT CHARACTER
0912 D52E 86 33                 STX   C_PRMP
0913 D530 20 6A FD              JSR   C_INLN                   ;GET A LINE ONTO PAGE 2
0914 D533 E0 EF                 CPX   #BUFLEN-1
0915 D535 90 02                 BCC   GDBUFS                   ;NOT TOO MANY CHARACTERS
0916 D537 A2 EF                 LDX   #BUFLEN-1
0917 D539 A9 00        GDBUFS:  LDA   #0                       ;PUT A ZERO AT THE END
0918 D53B 9D 00 02              STA   BUF,X
0919 D53E 8A                    TXA   
0920 D53F F0 0B                 BEQ   NOCHR
0921 D541 BD FF 01     LOPBHT:  LDA   BUF-1,X
0922 D544 29 7F                 AND   #127
0923 D546 9D FF 01              STA   BUF-1,X
0924 D549 CA                    DEX   
0925 D54A D0 F5                 BNE   LOPBHT
0926 D54C A9 00        NOCHR:   LDA   #0
0927 D54E A2 FF                 LDX   #<BUF-1
0928 D550 A0 01                 LDY   #>BUF-1                  ;POINT AT THE BEGINNING
0929 D552 60                    RTS   
0930 D553              ;GO TO FININL FAR, FAR AWAY.
0931 D553 20 0C FD     INCHR:   JSR   C_INCH
0932 D556 29 7F                 AND   #127
0933 D558 60           INCRTS:  RTS                            ;END OF INCHR.
0934 D559              ;OF THE TEXT POINTER TO GET TO BUF
0935 D559              ;AFTER TXTPTR HAS BEEN SETUP TO POINT INTO BUF
0936 D559              BUFOFS   EQU   BUF/256*256
0937 D559 A6 B8        CRUNCH:  LDX   TXTPTR                   ;SETOURCE POINTER.
0938 D55B CA                    DEX   
0939 D55C A0 04                 LDY   #4                       ;SET DESTINATION OFFSET.
0940 D55E 84 13                 STY   DORES                    ;ALLOW CRUNCHING.
0941 D560 24 D6                 BIT   RNONLY                   ;RUN ONLY?
0942 D562 10 08                 BPL   SLOOP
0943 D564 68                    PLA                            ;NO SUBROUTINES IN
0944 D565 68                    PLA   
0945 D566 20 65 D6              JSR   RUNC                     ;GO TO IT!
0946 D569 4C D2 D7              JMP   NEWSTT                   ;AND RUN!!
0947 D56C E8           SLOOP:   INX   
0948 D56D              KLOOP    EQU   *
0949 D56D 20 B5 D8              JSR   UPSHFT2                  ;UPSHIFT CHARACTERS FOR TOKEN SEARCH
0950 D570 24 13                 BIT   DORES
0951 D572 70 04                 BVS   NOSPCS
0952 D574 C9 20        CMPSPC:  CMP   #$20                     ;IS IT A SPACE TO SAVE?
0953 D576 F0 F4                 BEQ   SLOOP                    ;YES,IGNORE IT.
0954 D578 85 0E        NOSPCS:  STA   ENDCHR                   ;IF IT'S A QUOTE, THIS WILL
0955 D57A              ;STOP LOOP WHEN OTHER QUOTE APPEARS.
0956 D57A C9 22                 CMP   #34                      ;QUOTE SIGN?
0957 D57C F0 74                 BEQ   STRNG                    ;YES, DO SPECIAL STRING HANDLING.
0958 D57E 70 4D                 BVS   STUFFH                   ;NO CRUNCH, JUST STORE.
0959 D580 C9 3F                 CMP   #'?'                     ;A QMARK?
0960 D582 D0 04                 BNE   KLOOP1
0961 D584 A9 BA                 LDA   #PRINTK                  ;YES, STUFF A 'PRINT' TOKE
0962 D586 D0 45                 BNE   STUFFH                   ;ALWAYS GO TO STUFFH.
0963 D588 C9 30        KLOOP1:  CMP   #'0'                     ;SKIP NUMERICS.
0964 D58A 90 04                 BCC   MUSTCR
0965 D58C C9 3C                 CMP   #60                      ;':' AND ';' ARE ENTERED STRAIGHTAWAY.
0966 D58E 90 3D                 BCC   STUFFH
0967 D590 84 AD        MUSTCR:  STY   BUFPTR                   ;SAVE BUFFER POINTER.
0968 D592 A9 D0                 LDA   #RESLST                  ;FOR INDIRECT.
0969 D594 85 9D                 STA   FAC
0970 D596 A9 CF                 LDA   #>RESLST-$100            ;HI BYTE
0971 D598 85 9E                 STA   FAC+1
0972 D59A A0 00                 LDY   #0                       ;LOAD RESLST POINTER.
0973 D59C 84 0F                 STY   COUNT                    ;ALSO CLEAR COUNT.
0974 D59E 88                    DEY   
0975 D59F 86 B8                 STX   TXTPTR                   ;SAVE TEXT POINTER FOR LATER USE.
0976 D5A1 CA                    DEX   
0977 D5A2 C8           RESER:   INY   
0978 D5A3 D0 02                 BNE   RESPUL
0979 D5A5 E6 9E                 INC   FAC+1
0980 D5A7 E8           RESPUL:  INX   
0981 D5A8              RESCON:  EQU   *
0982 D5A8 20 B5 D8              JSR   UPSHFT2
0983 D5AB C9 20                 CMP   #$20                     ;IS IT A SPACE TO CRUNCH?
0984 D5AD F0 F8                 BEQ   RESPUL                   ;SKIP IT.
0985 D5AF 38                    SEC                            ;PREPARE TO SUBSTARCT.
0986 D5B0 F1 9D                 SBC   (FAC),Y                  ;CHARACTERS EQUAL?
0987 D5B2 F0 EE                 BEQ   RESER                    ;YES, CONTINUE SEARCH.
0988 D5B4 C9 80                 CMP   #128                     ;NO BUT MAYBE THE END IS HERE.
0989 D5B6 D0 41                 BNE   NTHIS                    ;NO, TRULY UNEQUAL.
0990 D5B8 05 0F                 ORA   COUNT
0991 D5BA C9 C5                 CMP   #ATTKN                   ;AT PROBLEM?
0992 D5BC D0 0D                 BNE   GETBPT                   ;NAW, FANCY FREE...
0993 D5BE 20 B0 D8              JSR   UPSHFT1
0994 D5C1 C9 4E                 CMP   #'N'                     ;IS IT A 'N' (ATN)
0995 D5C3 F0 34                 BEQ   NTHIS                    ;IF SO, NO 'AT' FUNCTION
0996 D5C5 C9 4F                 CMP   #'O'                     ;IS IT A 'O'   (A TO...)
0997 D5C7 F0 30                 BEQ   NTHIS
0998 D5C9 A9 C5                 LDA   #ATTKN                   ;NOTHING SPECIAL, GIVE HIM 'AT'
0999 D5CB A4 AD        GETBPT:  LDY   BUFPTR                   ;GET BUFFER PNTR.
1000 D5CD E8           STUFFH:  INX   
1001 D5CE C8                    INY   
1002 D5CF 99 FB 01              STA   BUF-5,Y
1003 D5D2 B9 FB 01              LDA   BUF-5,Y
1004 D5D5 F0 39                 BEQ   CRDONE                   ;NULL IMPLIES END OF LINE.
1005 D5D7 38                    SEC                            ;PREPARE TO SUBSTARCT.
1006 D5D8 E9 3A                 SBC   #':'                     ;IS IT A ':'?
1007 D5DA F0 04                 BEQ   COLIS                    ;YES, ALLOW CRUNCHING AGAIN.
1008 D5DC C9 49                 CMP   #DATATK-':'              ;IS IT A DATATK?
1009 D5DE D0 02                 BNE   NODATT                   ;NO, SEE IF IT IS REM TOKEN.
1010 D5E0 85 13        COLIS:   STA   DORES                    ;SETUP FLAG.
1011 D5E2 38           NODATT:  SEC                            ;PREP TO SBC.
1012 D5E3 E9 78                 SBC   #REMTK-':'               ;REM ONLY STOPS ON NULL.
1013 D5E5 D0 86                 BNE   KLOOP                    ;NO, CONTINUE CRUNCHING.
1014 D5E7 85 0E                 STA   ENDCHR                   ;REM STOPS ONLY ON NULL, NOT : OR '.
1015 D5E9              STR1:    EQU   *
1016 D5E9 20 B5 D8              JSR   UPSHFT2
1017 D5EC F0 DF                 BEQ   STUFFH                   ;YES, END OF LINE, SO DONE.
1018 D5EE C5 0E                 CMP   ENDCHR                   ;END OF GOBBLE?
1019 D5F0 F0 DB                 BEQ   STUFFH                   ;YES, DONE WITH STRING.
1020 D5F2 C8           STRNG:   INY                            ;INCREMENT BUFFER POINTER.
1021 D5F3 99 FB 01              STA   BUF-5,Y
1022 D5F6 E8                    INX   
1023 D5F7 D0 F0                 BNE   STR1                     ;PROCESS NEXT CHARACTER.
1024 D5F9 A6 B8        NTHIS:   LDX   TXTPTR                   ;RESTORE TEXT POINTER.
1025 D5FB E6 0F                 INC   COUNT                    ;INCREMENT RES WORD COUNT.
1026 D5FD B1 9D        NTHIS1:  LDA   (FAC),Y                  ;NEXT WORD TIME...
1027 D5FF C8                    INY   
1028 D600 D0 02                 BNE   *+4
1029 D602 E6 9E                 INC   FAC+1
1030 D604 0A                    ASL   A
1031 D605 90 F6                 BCC   NTHIS1
1032 D607 B1 9D                 LDA   (FAC),Y                  ;END OF TABLE?
1033 D609 D0 9D                 BNE   RESCON
1034 D60B 20 C3 D8              JSR   UPSHFT3
1035 D60E 10 BB                 BPL   GETBPT                   ;STORE IT AWAY (ALWAYS BRANCHES).
1036 D610 99 FD 01     CRDONE:  STA   BUF-3,Y                  ;SO THAT IF THIS IS A DIR STATEMENT
1037 D613              ;ITS END WILL LOOK LIKE END OF PROGRAM.
1038 D613 C6 B9                 DEC   TXTPTR+1
1039 D615 A9 FF                 LDA   #<BUF-1                  ;MAKE TXTPTR POINT TO
1040 D617 85 B8                 STA   TXTPTR                   ;CRUNCHED LINE.
1041 D619 60           LISTRT:  RTS                            ;RETURN TOALLER.
1042 D61A              ; FNDLIN SEARCHES THE PROGRAM TEXT FOR THE LINE
1043 D61A              ; WHOSE NUMBER IS PASSED IN 'LINNUM'.
1044 D61A              ; THERE ARE TWO POSSIBLE RETURNS:
1045 D61A              ; 1) CARRY SET.
1046 D61A              ;    LOWTR POINTS TO THE LINK FIELD IN THE LINE
1047 D61A              ;    WHICH IS THE ONE SEARCHED FOR.
1048 D61A              ; 2) CARRY NOT SET.
1049 D61A              ;    LINE NOT FOUND. LOWTR POINTS TO THE LINE IN THE
1050 D61A              ;    PROGRAM GREATER THAN THE ONE SOUGHT AFTER.
1051 D61A A5 67        FNDLIN:  LDA   TXTTAB
1052 D61C A6 68                 LDX   TXTTAB+1                 ;LOAD X,A WITH TXTTAB
1053 D61E A0 01        FNDLNC:  LDY   #1
1054 D620 85 9B                 STA   LOWTR
1055 D622 86 9C                 STX   LOWTR+1                  ;STORE X,ANTO LOWTR
1056 D624 B1 9B                 LDA   (LOWTR),Y                ;SEE IF LINK IS 0
1057 D626 F0 1F                 BEQ   FLINRT
1058 D628 C8                    INY   
1059 D629 C8                    INY   
1060 D62A A5 51                 LDA   LINNUM+1                 ;COMP HIGH ORDERS OF LINE NUMBERS.
1061 D62C D1 9B                 CMP   (LOWTR),Y
1062 D62E 90 18                 BCC   FLNRTS                   ;NO SUCH LINE NUMBER.
1063 D630 F0 03                 BEQ   FNDLO1
1064 D632 88                    DEY   
1065 D633 D0 09                 BNE   AFFRTS                   ;ALWAYS BRANCH.
1066 D635 A5 50        FNDLO1:  LDA   LINNUM
1067 D637 88                    DEY   
1068 D638 D1 9B                 CMP   (LOWTR),Y                ;COMPARE LOW ORDERS.
1069 D63A 90 0C                 BCC   FLNRTS                   ;NO SUCH NUMBER.
1070 D63C F0 0A                 BEQ   FLNRTS                   ;GO TIT.
1071 D63E 88           AFFRTS:  DEY   
1072 D63F B1 9B                 LDA   (LOWTR),Y                ;FETCH LINK.
1073 D641 AA                    TAX   
1074 D642 88                    DEY   
1075 D643 B1 9B                 LDA   (LOWTR),Y
1076 D645 B0 D7                 BCS   FNDLNC                   ;ALWAYS BRANCHES.
1077 D647 18           FLINRT:  CLC                            ;C MAY BE HIGH.
1078 D648 60           FLNRTS:  RTS                            ;RETURN TO CALLER.
1079 D649              ; THE 'NEW' COMMAND CLEARS THE PROGRAM TEXT AS WELL
1080 D649              ; AS VARIABLE SPACE.
1081 D649 D0 FD        SCRATH:  BNE   FLNRTS                   ;MAKE SURE THERE IS A TERMINATOR.
1082 D64B A9 00        SCRTCH:  LDA   #0                       ;GET A CLEARER.
1083 D64D 85 D6                 STA   RNONLY                   ;OUT OF RRUN-ONLY MODE.
1084 D64F A8                    TAY                            ;SET UP INDEX.
1085 D650 91 67                 STA   (TXTTAB),Y               ;CLEAR FIRST LINK.
1086 D652 C8                    INY   
1087 D653 91 67                 STA   (TXTTAB),Y
1088 D655 A5 67                 LDA   TXTTAB
1089 D657 69 02                 ADC   #2
1090 D659 85 69                 STA   VARTAB                   ;SETUP VARTAB.
1091 D65B 85 AF                 STA   PRGEND
1092 D65D A5 68                 LDA   TXTTAB+1
1093 D65F 69 00                 ADC   #0
1094 D661 85 6A                 STA   VARTAB+1
1095 D663 85 B0                 STA   PRGEND+1
1096 D665 20 97 D6     RUNC:    JSR   STXTPT
1097 D668 A9 00                 LDA   #0                       ;SET ZERO FLAG
1098 D66A              ; THIS CODE IS FOR THE CLEAR COMMAND.
1099 D66A D0 2A        CLEAR:   BNE   STKRTS                   ;SYNTAX ERROR IF NO TERMINATOR.
1100 D66C              ; CLEARC IS SUBROUTINE WHICH INITIALIZES THE VARIABLE AND
1101 D66C              ; ARRAY SPACE BY RESETING ARYTAB (END OF SIMPLE VARIABLE)
1102 D66C              ; AND STREND (END OF ARRAY STORAGE). IT FALLS INTO
1103 D66C              ; 'STKINI' WHICH RESETS THE STACK. 
1104 D66C A5 73        CLEARC:  LDA   MEMSIZ
1105 D66E A4 74                 LDY   MEMSIZ+1                 ;FREE UP STRING SPACE.
1106 D670 85 6F                 STA   FRETOP
1107 D672 84 70                 STY   FRETOP+1
1108 D674 A5 69                 LDA   VARTAB
1109 D676 A4 6A                 LDY   VARTAB+1                 ;LIBERATE THE
1110 D678 85 6B                 STA   ARYTAB
1111 D67A 84 6C                 STY   ARYTAB+1                 ;VARIABLESND
1112 D67C 85 6D                 STA   STREND
1113 D67E 84 6E                 STY   STREND+1                 ;ARRAYS.
1114 D680 20 49 D8     FLOAD:   JSR   RESTOR                   ;RESTORE DATA.
1115 D683              ; STKINI RESETS THE STACK POINTER ELIMINATING
1116 D683              ; GOSUB AND FOR CONTEXT. STRING TEMPORARIES ARE FREED
1117 D683              ; UP, SUBFLG IS RESET. CONTINUING IS PROHIBITED.
1118 D683              ; AND A DUMMY ENTRY IS LEFT AT THE BOTTOM OF THE STACK
1119 D683              ; FIND A NON-'FOR' ENTRY AT THE BOTTOM OF THE STACK.
1120 D683 A2 55        STKINI:  LDX   #TEMPST                  ;INITIALIZE STRING TEMPORARIES.
1121 D685 86 52                 STX   TEMPPT
1122 D687 68                    PLA                            ;SETUP RETURN ADDRESS.
1123 D688 A8                    TAY   
1124 D689 68                    PLA   
1125 D68A A2 F8                 LDX   #STKEND-259              ;HAVE STACK POINT TO RETURN ADDRESS.
1126 D68C 9A                    TXS   
1127 D68D 48                    PHA   
1128 D68E 98                    TYA   
1129 D68F 48                    PHA   
1130 D690 A9 00                 LDA   #0
1131 D692 85 7A                 STA   OLDTXT+1                 ;DISALLOWING CONTINUING
1132 D694 85 14                 STA   SUBFLG                   ;ALLOW SUBSCRIPTS.
1133 D696 60           STKRTS:  RTS   
1134 D697 18           STXTPT:  CLC   
1135 D698 A5 67                 LDA   TXTTAB
1136 D69A 69 FF                 ADC   #255
1137 D69C 85 B8                 STA   TXTPTR
1138 D69E A5 68                 LDA   TXTTAB+1
1139 D6A0 69 FF                 ADC   #255
1140 D6A2 85 B9                 STA   TXTPTR+1                 ;SETUP TEXT POINTER.
1141 D6A4 60                    RTS   
1142 D6A5                       EJECT 
1143 D6A5                       TITLE 'THE LIST COMMAND.'
1144 D6A5 90 0A        LIST:    BCC   GOLST                    ;IT IS A DIGIT.
1145 D6A7 F0 08                 BEQ   GOLST                    ;IT IS A TERMINATOR.
1146 D6A9 C9 C9                 CMP   #MINUTK                  ;DASH PRECEDING?
1147 D6AB F0 04                 BEQ   GOLST
1148 D6AD C9 2C                 CMP   #$2C
1149 D6AF D0 E5                 BNE   STKRTS
1150 D6B1 20 0C DA     GOLST:   JSR   LINGET                   ;GET LINE NUMBER INTO NUMLIN.
1151 D6B4 20 1A D6              JSR   FNDLIN                   ;FIND LINE .GE. NUMLIN.
1152 D6B7 20 B7 00              JSR   CHRGOT                   ;GET LAST CHARACTER.
1153 D6BA F0 10                 BEQ   LSTEND                   ;IF END OF LINE, # IS THE END.
1154 D6BC C9 C9                 CMP   #MINUTK                  ;DASH?
1155 D6BE F0 04                 BEQ   *+6
1156 D6C0 C9 2C                 CMP   #$2C
1157 D6C2 D0 84                 BNE   FLNRTS                   ;IF NOT, SYNTAX ERROR.
1158 D6C4 20 B1 00              JSR   CHRGET                   ;GET NEXT CHAR.
1159 D6C7 20 0C DA              JSR   LINGET                   ;GET END #.
1160 D6CA D0 CA                 BNE   STKRTS                   ;IF NOT TERMINATOR, ERROR.
1161 D6CC 68           LSTEND:  PLA   
1162 D6CD 68                    PLA                            ;GET RID OF 'NEWSTT' RTS ADDR.
1163 D6CE A5 50                 LDA   LINNUM                   ;SEE IF IT WAS EXISTENT.
1164 D6D0 05 51                 ORA   LINNUM+1
1165 D6D2 D0 06                 BNE   LIST4                    ;IT WAS TYPED.
1166 D6D4 A9 FF                 LDA   #255
1167 D6D6 85 50                 STA   LINNUM
1168 D6D8 85 51                 STA   LINNUM+1                 ;MAKE IT HUGE.
1169 D6DA A0 01        LIST4:   LDY   #1
1170 D6DC B1 9B                 LDA   (LOWTR),Y                ;IS LINK ZERO?
1171 D6DE F0 44                 BEQ   GRODY                    ;YES, GO TO READY.
1172 D6E0 20 58 D8              JSR   ISCNTC                   ;LISTEN FOR CONT-C.
1173 D6E3 20 FB DA              JSR   CRDO                     ;PRINT CRLF TO START WITH.
1174 D6E6 C8                    INY   
1175 D6E7 B1 9B                 LDA   (LOWTR),Y
1176 D6E9 AA                    TAX   
1177 D6EA C8                    INY   
1178 D6EB B1 9B                 LDA   (LOWTR),Y                ;GET LINE NUMBER.
1179 D6ED C5 51                 CMP   LINNUM+1                 ;SEE IF BEYOND LAST.
1180 D6EF D0 04                 BNE   TSTDUN                   ;GO DETERMINE RELATION.
1181 D6F1 E4 50                 CPX   LINNUM                   ;WAS EQUAL SO TEST LOW ORDER.
1182 D6F3 F0 02                 BEQ   TYPLIN                   ;EQUAL, SO LIST IT.
1183 D6F5 B0 2D        TSTDUN:  BCS   GRODY                    ;IF LINE IS GR THAN LAST, THEN DUNE.
1184 D6F7 84 85        TYPLIN:  STY   LSTPNT
1185 D6F9 20 D3 D8              JSR   LDSPCE                   ;OUTPUT SPACE BEFORE LINE NUMBER
1186 D6FC A9 20                 LDA   #$20                     ;ALWAYS PRINT SPACE AFTER NUMBER.
1187 D6FE A4 85        PRIT4:   LDY   LSTPNT                   ;GET POINTER TO LINE BACK.
1188 D700 29 7F                 AND   #127
1189 D702 20 5C DB     PLOOP:   JSR   OUTDO                    ;PRINT CHAR.
1190 D705 20 DD D8              JSR   LSTFMAT
1191 D708 EA                    NOP   
1192 D709 90 07                 BCC   PLOOP1
1193 D70B 20 FB DA              JSR   CRDO                     ;GO TO NEXT LINE,
1194 D70E A9 05                 LDA   #$05                     ;AND FAKE A TAB.
1195 D710 85 24                 STA   $24
1196 D712 C8           PLOOP1:  INY   
1197 D713              ;THE PROGRAM MUST BE MISFORMATED IN
1198 D713              ;MEMORY DUE TO A BAD LOAD OR BAD
1199 D713              ;HARDWARE. LET THE GUY RECOVER
1200 D713 B1 9B                 LDA   (LOWTR),Y                ;GET NEXT CHAR. IS IT ZERO?
1201 D715 D0 1D                 BNE   QPLOP                    ;YES. END OF LINE.
1202 D717 A8                    TAY   
1203 D718 B1 9B                 LDA   (LOWTR),Y
1204 D71A AA                    TAX   
1205 D71B C8                    INY   
1206 D71C B1 9B                 LDA   (LOWTR),Y
1207 D71E 86 9B                 STX   LOWTR
1208 D720 85 9C                 STA   LOWTR+1
1209 D722 D0 B6                 BNE   LIST4                    ;BRANCH IF SOMETHING TO LIST.
1210 D724 A9 0D        GRODY:   LDA   #$0D                     ;PRINT EXTRA CRLF
1211 D726 20 5C DB              JSR   OUTDO
1212 D729 4C D2 D7              JMP   NEWSTT                   ;THEN GO BACK TONEWSTT FOR NXTLIN.
1213 D72C C8           GETNXTW: INY                            ;NEXT CHAR IN
1214 D72D D0 02                 BNE   *+4                      ;RESLST
1215 D72F E6 9E                 INC   FAC+1
1216 D731 B1 9D                 LDA   (FAC),Y
1217 D733 60                    RTS   
1218 D734              ;IS IT A TOKEN?
1219 D734 10 CC        QPLOP:   BPL   PLOOP                    ;NO, HEAD FOR PRINTER.
1220 D736              ;YES, JUST TYPE THE CHARACTER.
1221 D736 38                    SEC   
1222 D737 E9 7F                 SBC   #127                     ;GET RID OF SIGN BIT AND ADD 1.
1223 D739 AA                    TAX                            ;MAKE IT A COUNTER.
1224 D73A 84 85                 STY   LSTPNT                   ;SAVE POINTER TO LINE.
1225 D73C A0 D0                 LDY   #RESLST
1226 D73E 84 9D                 STY   FAC
1227 D740 A0 CF                 LDY   #>RESLST-$100
1228 D742 84 9E                 STY   FAC+1
1229 D744 A0 FF                 LDY   #255                     ;LOOK AT RES'D WORD LIST.
1230 D746 CA           RESRCH:  DEX                            ;IS THIS THE RES'D WORD?
1231 D747 F0 07                 BEQ   PRIT25                   ;YES, GO TOSS IT UP
1232 D749 20 2C D7     RESCR1:  JSR   GETNXTW
1233 D74C 10 FB                 BPL   RESCR1                   ;NO, CONTINUE PASSING.
1234 D74E 30 F6                 BMI   RESRCH
1235 D750 A9 20        PRIT25:  LDA   #$20                     ;SPACE AROUND RESERVED WORDS.
1236 D752 20 5C DB              JSR   OUTDO
1237 D755 20 2C D7     PRIT3:   JSR   GETNXTW
1238 D758 30 05                 BMI   PRFINIS                  ;END OF RESERVED WORD.
1239 D75A 20 5C DB              JSR   OUTDO                    ;PRINT IT.
1240 D75D D0 F6                 BNE   PRIT3                    ;END OF ENTRY? NO, TYPE REST.
1241 D75F 20 5C DB     PRFINIS: JSR   OUTDO
1242 D762 A9 20                 LDA   #$20
1243 D764 D0 98                 BNE   PRIT4
1244 D766                       EJECT 
1245 D766                       TITLE 'THE FOR STATEMENT.'
1246 D766              ; A 'FOR' ENTRY ON THE STACK HAS THE FOLLOWING FORMAT:
1247 D766              ; LOW ADDRESS
1248 D766              ; TOKEN (FORTK) 1 BYTE
1249 D766              ; A POINTER TO THE LOOP VARIABLE 2 BYTES
1250 D766              ; THE STEP 4+ADDPRC BYTES
1251 D766              ; A BYTE REFLECTING THE SIGN OF THE INCREMENT 1 BYTE
1252 D766              ; THE UPPER VALUE 4+ADDPRC BYTE ; LINE NUMBER OF THE 'FOR'
1253 D766              ; A TEXT POINTER INTO THE 'FOR' STATEMENT 2 BYTES
1254 D766              ; HIGH ADDRESS
1255 D766              ; TOTAL 16+2*ADDPRC BYTES.
1256 D766 A9 80        FOR:     LDA   #128                     ;DON'T RECOGNIZE
1257 D768 85 14                 STA   SUBFLG                   ;SUBSCRIPTED VARIABLES.
1258 D76A 20 46 DA              JSR   LET                      ;READ THE VARIABLE AND ASSIGN IT
1259 D76D              ;THE CORRECT INITIAL VALUE AND STORE
1260 D76D              ;A POINTER TO THE VARIABLE IN VARPNT.
1261 D76D 20 65 D3              JSR   FNDFOR                   ;PNTR IS IN VARPNT, AND FORPNT.
1262 D770 D0 05                 BNE   NOTOL                    ;IF NO MATCH, DON'T ELIMINATE ANYTHING.
1263 D772 8A                    TXA                            ;MAKE IT ARITHMETICAL.
1264 D773 69 0F                 ADC   #FORSIZ-3                ;ELIMINATE ALMOST ALL.
1265 D775 AA                    TAX                            ;NOTE C=1, THEN PLA, PLA.
1266 D776 9A                    TXS                            ;MANIFEST.
1267 D777 68           NOTOL:   PLA                            ;GET RID OF NEWSTT RETURN ADDRESS
1268 D778 68                    PLA                            ;IN CASE THIS IS A TOTALLY NEW ENTRY.
1269 D779 A9 09                 LDA   #9
1270 D77B 20 D6 D3              JSR   GETSTK                   ;MAKE SURE 16 BYTES ARE AVAILABLE.
1271 D77E 20 A3 D9              JSR   DATAN                    ;GET A COUNT IN Y OF THE NUMBER OF
1272 D781              ;CHACRACTERS LEFT IN THE 'FOR' STATEMENT
1273 D781              ;TXTPTR IS UNAFFECTED.
1274 D781 18                    CLC                            ;PREP TO ADD.
1275 D782 98                    TYA                            ;SAVE IT FOR PUSHING.
1276 D783 65 B8                 ADC   TXTPTR
1277 D785 48                    PHA   
1278 D786 A5 B9                 LDA   TXTPTR+1
1279 D788 69 00                 ADC   #0
1280 D78A 48                    PHA   
1281 D78B A5 76                 LDA   CURLIN+1
1282 D78D 48                    PHA   
1283 D78E A5 75                 LDA   CURLIN
1284 D790 48                    PHA                            ;PUT LINE NUMBER ON STACK.
1285 D791 A9 C1                 LDA   #TOTK
1286 D793 20 C0 DE              JSR   SYNCHR                   ;'TO' IS NECESSARY.
1287 D796 20 6A DD              JSR   CHKNUM                   ;VALUE MUST BE A NUMBER.
1288 D799 20 67 DD              JSR   FRMNUM                   ;GET UPPER VALUE INTO FAC.
1289 D79C A5 A2                 LDA   FACSGN                   ;PACK FAC.
1290 D79E 09 7F                 ORA   #127
1291 D7A0 25 9E                 AND   FACHO
1292 D7A2 85 9E                 STA   FACHO                    ;SET PACKED SIGN BIT.
1293 D7A4 A9 AF                 LDA   #LDFONE
1294 D7A6 A0 D7                 LDY   #>LDFONE
1295 D7A8 85 5E                 STA   INDEX1
1296 D7AA 84 5F                 STY   INDEX1+1
1297 D7AC 4C 20 DE              JMP   FORPSH                   ;PUT FAC ONTO STACK, PACKED.
1298 D7AF A9 13        LDFONE:  LDA   #FONE
1299 D7B1 A0 E9                 LDY   #>FONE                   ;PUT 1.0 INTO FAC.
1300 D7B3 20 F9 EA              JSR   MOVFM
1301 D7B6 20 B7 00              JSR   CHRGOT
1302 D7B9 C9 C7                 CMP   #STEPTK                  ;A STEP IS GIVEN?
1303 D7BB D0 06                 BNE   ONEON                    ;NO. AUME 1.0.
1304 D7BD 20 B1 00              JSR   CHRGET                   ;YES. ADVANCE POINTER.
1305 D7C0 20 67 DD              JSR   FRMNUM                   ;READ THE STEP.
1306 D7C3 20 82 EB     ONEON:   JSR   SIGN                     ;GET SIGN IN ACCA.
1307 D7C6 20 15 DE              JSR   PUSHF                    ;PUSH FAC ONTO STACK (THRU A).
1308 D7C9 A5 86                 LDA   FORPNT+1
1309 D7CB 48                    PHA   
1310 D7CC A5 85                 LDA   FORPNT
1311 D7CE 48                    PHA                            ;PUT PNTR TO VARIABLE ON STACK.
1312 D7CF A9 81        NXTCON:  LDA   #FORTK                   ;PUT A FORTK ONTO STACK.
1313 D7D1 48                    PHA   
1314 D7D2              ; BNEA NEWSTT   ;SIMULATE BNE TO NEWSTT. JUST FALL IN.
1315 D7D2                       EJECT 
1316 D7D2                       TITLE 'NEW STATEMENT FETCHER.'
1317 D7D2              ; BACK HERE FOR NEW STATEMENT. CHAR POINTED TO BY TXTPT
1318 D7D2              ; IS ':' OR END-OF-LINE. THE ADDRESS OF TS LOC IS LEFT
1319 D7D2              ; ON THE STACK WHEN A STATEMENT IS EXECUTED SO THAT
1320 D7D2              ; IT CAN MERELY DO A RTS WHEN IT IS DONE.
1321 D7D2              NEWSTT:  EQU   *
1322 D7D2 BA                    TSX                            ;IN CASE OF ERROR.
1323 D7D3 86 F8                 STX   REMSTK
1324 D7D5 20 58 D8              JSR   ISCNTC                   ;LISTEN FOR CONTROL-C.
1325 D7D8 A5 B8                 LDA   TXTPTR
1326 D7DA A4 B9                 LDY   TXTPTR+1                 ;LOOK AT CURRENT CHARACTER.
1327 D7DC A6 76                 LDX   CURLIN+1
1328 D7DE E8                    INX   
1329 D7DF F0 04                 BEQ   DIRCON
1330 D7E1 85 79                 STA   OLDTXT
1331 D7E3 84 7A                 STY   OLDTXT+1                 ;SAVE IN CASE OF RESTART BY INPUT.
1332 D7E5 A0 00        DIRCON:  LDY   #0
1333 D7E7 B1 B8                 LDA   (TXTPTR),Y
1334 D7E9 D0 57                 BNE   MORSTS                   ;NOT NULL -- CHECK WHAT IT IS
1335 D7EB A0 02                 LDY   #2                       ;LOOK AT LINK.
1336 D7ED B1 B8                 LDA   (TXTPTR),Y               ;IS LINK 0?
1337 D7EF 18                    CLC   
1338 D7F0 F0 34                 BEQ   INTERM                   ;YES - RAN OFF THE END.
1339 D7F2 C8                    INY                            ;PUT LINE NUMB IN CURLIN.
1340 D7F3 B1 B8                 LDA   (TXTPTR),Y
1341 D7F5 85 75                 STA   CURLIN
1342 D7F7 C8                    INY   
1343 D7F8 B1 B8                 LDA   (TXTPTR),Y
1344 D7FA 85 76                 STA   CURLIN+1
1345 D7FC 98                    TYA   
1346 D7FD 65 B8                 ADC   TXTPTR
1347 D7FF 85 B8                 STA   TXTPTR
1348 D801 90 02                 BCC   GONE
1349 D803 E6 B9                 INC   TXTPTR+1
1350 D805 24 F2        GONE:    BIT   TRFLAG                   ;IN TRACE MODE?
1351 D807 10 14                 BPL   GOFORIT                  ;IF NOT, DO LINE
1352 D809 A6 76                 LDX   CURLIN+1                 ;IN DIRECT MODE?
1353 D80B E8                    INX   
1354 D80C F0 0F                 BEQ   GOFORIT                  ;IF SO, DON'T TRACE
1355 D80E A9 23                 LDA   #'#'
1356 D810 20 5C DB              JSR   OUTDO                    ;FOR TRACE FORMAT
1357 D813 A6 75                 LDX   CURLIN
1358 D815 A5 76                 LDA   CURLIN+1
1359 D817 20 24 ED              JSR   LINPRT
1360 D81A 20 57 DB              JSR   OUTSPC                   ;TRAILING BLANK.
1361 D81D 20 B1 00     GOFORIT: JSR   CHRGET
1362 D820 20 28 D8              JSR   GONE3
1363 D823 4C D2 D7              JMP   NEWSTT
1364 D826 F0 62        INTERM:  BEQ   ENDCON                   ;GO ALL THE WAY
1365 D828 F0 2D        GONE3:   BEQ   ISCRTS                   ;IF TERMINATOR, TRY AGAIN.
1366 D82A              ;NO NEED TO SET UP CARRY SINCE IT WILL
1367 D82A              ;BE ON IF NON-NUMERIC AND NUMERICS
1368 D82A              ;WILL CAUSE A SYNTAX ERROR LIKE THEY SHOULD
1369 D82A E9 80        GONE2:   SBC   #ENDTK                   ;' ON ... GOTO AND GOSUB' COME HERE.
1370 D82C 90 11                 BCC   GLET
1371 D82E C9 40                 CMP   #SCRATK-ENDTK+1
1372 D830 B0 14                 BCS   SNERR1                   ;SOMRES'D WORD BUT NOT
1373 D832              ;A STATEMENT RES'D WORD.
1374 D832 0A                    ASL   A                        ;MULTIPLY BY TWO.
1375 D833 A8                    TAY                            ;MAKE AN INDEX.
1376 D834 B9 01 D0              LDA   STMDSP+1,Y
1377 D837 48                    PHA   
1378 D838 B9 00 D0              LDA   STMDSP,Y
1379 D83B 48                    PHA                            ;PUT DISP ADDR ONTO STACK.
1380 D83C 4C B1 00              JMP   CHRGET
1381 D83F 4C 46 DA     GLET:    JMP   LET                      ;MUST BE A LET
1382 D842 C9 3A        MORSTS:  CMP   #':'
1383 D844 F0 BF                 BEQ   GONE                     ;IF A ':' CONTINUE STATEMENT
1384 D846 4C C9 DE     SNERR1:  JMP   SNERR                    ;NEITHER 0 OR ':' SO SYNTAX ERROR
1385 D849                       EJECT 
1386 D849                       TITLE 'REST,STOP,END,CONT,NULL,CLEAR.'
1387 D849 38           RESTOR:  SEC   
1388 D84A A5 67                 LDA   TXTTAB
1389 D84C E9 01                 SBC   #1
1390 D84E A4 68                 LDY   TXTTAB+1
1391 D850 B0 01                 BCS   RESFIN
1392 D852 88                    DEY   
1393 D853 85 7D        RESFIN:  STA   DATPTR
1394 D855 84 7E                 STY   DATPTR+1                 ;READ FINISHES COME TO 'RESFIN'.
1395 D857 60           ISCRTS:  RTS   
1396 D858              ;WAS IT A CONTROL-C??
1397 D858 AD 00 C0     ISCNTC:  LDA   $C000                    ;CHECK THE CHARACTER
1398 D85B C9 83                 CMP   #$83
1399 D85D F0 01                 BEQ   ISCCAP
1400 D85F 60                    RTS   
1401 D860 20 53 D5     ISCCAP:  JSR   INCHR
1402 D863 A2 FF                 LDX   #$FF                     ;FOR BREAK ERROR NUMBER.
1403 D865 24 D8                 BIT   ERRFLG                   ;IN ONERR MODE?
1404 D867 10 03                 BPL   *+5                      ;IF SO, JUMP TO 'HNDLERR'
1405 D869 4C E9 F2              JMP   HNDLERR
1406 D86C C9 03                 CMP   #$03
1407 D86E B0 01        STOP:    BCS   STOPC                    ;MAKE C NONZERO AS A FLAG.
1408 D870 18           END:     CLC   
1409 D871 D0 3C        STOPC:   BNE   CONTRT                   ;RETURN IF NOT CONT-C OR
1410 D873              ;IF NO TERMINATOR FOR STOP OR END.
1411 D873              ;C=0 SO WILL NOT PRINT 'BREAK'.
1412 D873 A5 B8                 LDA   TXTPTR
1413 D875 A4 B9                 LDY   TXTPTR+1
1414 D877 A6 76                 LDX   CURLIN+1
1415 D879 E8                    INX   
1416 D87A F0 0C                 BEQ   DIRIS
1417 D87C 85 79                 STA   OLDTXT
1418 D87E 84 7A                 STY   OLDTXT+1
1419 D880 A5 75        STPEND:  LDA   CURLIN
1420 D882 A4 76                 LDY   CURLIN+1
1421 D884 85 77                 STA   OLDLIN
1422 D886 84 78                 STY   OLDLIN+1
1423 D888 68           DIRIS:   PLA                            ;POP OFF NEWSTT ADDR.
1424 D889 68                    PLA   
1425 D88A A9 5D        ENDCON:  LDA   #BRKTXT
1426 D88C A0 D3                 LDY   #>BRKTXT
1427 D88E 90 03                 BCC   GORDY                    ;CARRY CLEAR SO DON'T PRINT 'BREAK'.
1428 D890 4C 31 D4              JMP   ERRFIN
1429 D893 4C 3C D4     GORDY:   JMP   READY                    ;TYPE 'READY'.
1430 D896 D0 17        CONT:    BNE   CONTRT                   ;MAKE SURE THERE IS A TERMINATOR.
1431 D898 A2 D2                 LDX   #ERRCN                   ;CONTINUE ERROR.
1432 D89A A4 7A                 LDY   OLDTXT+1                 ;A STORED TXTPTR OF ZERO IS SETUP
1433 D89C              ;BY STKINI AND INDICATES THERE IS
1434 D89C              ;NOTHING TO CTINUE.
1435 D89C D0 03                 BNE   *+5
1436 D89E 4C 12 D4              JMP   ERROR                    ;'STOP', 'END', TYPING CRLF TO 
1437 D8A1              ;'INPUT' AND  C SETUP OLDTXT.
1438 D8A1 A5 79                 LDA   OLDTXT
1439 D8A3 85 B8                 STA   TXTPTR
1440 D8A5 84 B9                 STY   TXTPTR+1
1441 D8A7 A5 77                 LDA   OLDLIN
1442 D8A9 A4 78                 LDY   OLDLIN+1
1443 D8AB 85 75                 STA   CURLIN
1444 D8AD 84 76                 STY   CURLIN+1
1445 D8AF 60           CONTRT:  RTS                            ;RETURN TO CALLER.
1446 D8B0                       EJECT 
1447 D8B0                       TITLE 'LOAD AND SAVE SUBROUTINES.'
1448 D8B0              ;FOR APPLE COMPUTERS.
1449 D8B0 BD 01 02     UPSHFT1  LDA   BUFOFS+1,X
1450 D8B3 10 11                 BPL   UPSHFT4                  ;BRANCH ALWAYS
1451 D8B5 A5 0E        UPSHFT2  LDA   ENDCHR                   ;TESTS FOR NO UPSHIFT DESIRED
1452 D8B7 F0 16                 BEQ   NOSHFT
1453 D8B9 C9 22                 CMP   #$22                     ;INSIDE A QUOTED STRING?
1454 D8BB F0 12                 BEQ   NOSHFT
1455 D8BD A5 13                 LDA   DORES                    ;TEST FOR DATA STATEMENT
1456 D8BF C9 49                 CMP   #$49
1457 D8C1 F0 0C                 BEQ   NOSHFT                   ;BRANCH IF DATA
1458 D8C3 BD 00 02     UPSHFT3  LDA   BUFOFS,X                 ;GET CHARACTER FROM INPUT BUFFER
1459 D8C6 08           UPSHFT4  PHP                            ;SAVE STATUS
1460 D8C7 C9 61                 CMP   #$61                     ;IS IT LOWER CASE?
1461 D8C9 90 02                 BCC   UPSHFT5
1462 D8CB 29 5F                 AND   #$5F                     ;MAKE IT UPPER CASE!
1463 D8CD 28           UPSHFT5  PLP                            ;RESTORE STATUS
1464 D8CE 60                    RTS   
1465 D8CF BD 00 02     NOSHFT   LDA   BUFOFS,X                 ;RETURN ORIGINAL STUFF
1466 D8D2 60                    RTS   
1467 D8D3 48           LDSPCE   PHA                            ;SAVE ACC 
1468 D8D4 A9 20                 LDA   #$20                     ;OUTPUT A SPACE CHARACTER IN FRONT OF LINE NUMBER
1469 D8D6 20 5C DB              JSR   OUTDO
1470 D8D9 68                    PLA   
1471 D8DA 4C 24 ED              JMP   LINPRT                   ;NOW OUTPUT LINE # 
1472 D8DD A5 24        LSTFMAT  LDA   $24
1473 D8DF C9 21                 CMP   #33                      ;REGULAR WIDTH
1474 D8E1 2C 1F C0              BIT   $C01F
1475 D8E4 10 05                 BPL   FMAT40
1476 D8E6 AD 7B 05              LDA   $57B                     ;IF 80-COL ENABLED, COMPARE WITH 73
1477 D8E9 C9 49                 CMP   #73
1478 D8EB 60           FMAT40   RTS   
1479 D8EC              ROMPLOT  EQU   $F80E
1480 D8EC              COLOR    EQU   $30
1481 D8EC              GBASL    EQU   $26
1482 D8EC              GBASCALC EQU   $F847
1483 D8EC              MASK     EQU   $2E
1484 D8EC              SETWND   EQU   $FB4B
1485 D8EC              SETGR    EQU   *
1486 D8EC AD 50 C0              LDA   TXTCLR
1487 D8EF 20 F7 D8              JSR   CLRTOP
1488 D8F2 A9 14                 LDA   #$14                     ;SET WINDOW TOP TO LINE 20
1489 D8F4 4C 4B FB              JMP   SETWND                   ; IN MONITOR 
1490 D8F7              *
1491 D8F7 A0 27        CLRTOP   LDY   #$27                     ;GET GRAPHICS VERTICAL IN Y REGISTER
1492 D8F9 84 2D                 STY   V2
1493 D8FB 20 CB F3              JSR   VIDSTATE                 ;GET VIDEO STATE (DOUBLE GR?)
1494 D8FE A9 27                 LDA   #$27
1495 D900 90 01                 BCC   GRIS40                   ;BRANCH IF 40 BY 48 (NORMAL)
1496 D902 2A                    ROL   A
1497 D903 A8           GRIS40   TAY                            ;WIDTH IN A... PUT IN Y.
1498 D904 A9 00        CLRSC3   LDA   #0
1499 D906 85 30                 STA   COLOR
1500 D908 20 8B F7              JSR   VLINE
1501 D90B 88                    DEY   
1502 D90C 10 F6                 BPL   CLRSC3
1503 D90E 60                    RTS   
1504 D90F              *
1505 D90F              FILL_SIZE01 EQU   APPLESOFT+$912-*
1506 D90F 00 00 00              DC B:FILL_SIZE01,0             ;FILL REMAINDER WITH BREAKS FOR LOLLY
1507 D912
1508 D912                       TITLE 'RUN,GOTO,GOSUB,RETURN.'
1509 D912 08           RUN:     PHP   
1510 D913 C6 76                 DEC   CURLIN+1                 ;RUN NOT DIRECT!
1511 D915 28                    PLP   
1512 D916 D0 03                 BNE   *+5
1513 D918 4C 65 D6              JMP   RUNC                     ;IF NO LINE # ARGUMENT.
1514 D91B 20 6C D6              JSR   CLEARC                   ;CLEAN UP -- RESET THE STACK.
1515 D91E 4C 35 D9              JMP   RUNC2                    ;MUST REPLACE RTS ADDR.
1516 D921              ; A GOSUB ENTRY ON THE STACK HAS THE FOLLOWING FORMAT:
1517 D921              ; LOW ADDRESS:
1518 D921              ; THE GOSUTK ONE BYTE
1519 D921              ; THE LINE NUMBER OF THE GOSUB STATEMENT TWO BYTES
1520 D921              ; A POINTER INTO THE TEXT OF THE GOSUB TWO BYS
1521 D921              ; HIGH ADDRESS.
1522 D921              ; TOTAL FIVE BYTES.
1523 D921 A9 03        GOSUB:   LDA   #3
1524 D923 20 D6 D3              JSR   GETSTK                   ;MAKE SURE THERE IS ROOM.
1525 D926 A5 B9                 LDA   TXTPTR+1
1526 D928 48                    PHA   
1527 D929 A5 B8                 LDA   TXTPTR
1528 D92B 48                    PHA                            ;PUSH ON THE TEXT POINTER.
1529 D92C A5 76                 LDA   CURLIN+1
1530 D92E 48                    PHA   
1531 D92F A5 75                 LDA   CURLIN
1532 D931 48                    PHA                            ;PUSH ON THE CURRENT LINE NUMBER.
1533 D932 A9 B0                 LDA   #GOSUTK
1534 D934 48                    PHA                            ;PUSH ON A GOSUB TOKEN.
1535 D935 20 B7 00     RUNC2:   JSR   CHRGOT                   ;GET CHARACTER & SET CODES FOR LINGET.
1536 D938 20 3E D9              JSR   GOTO                     ;USE RTS SCHEME TO 'NEWSTT'.
1537 D93B 4C D2 D7              JMP   NEWSTT
1538 D93E 20 0C DA     GOTO:    JSR   LINGET                   ;PICK UP THE LINE NUMBER IN 'LINNUM'.
1539 D941 20 A6 D9              JSR   REMN                     ;SKIP TO END OF LINE.
1540 D944 A5 76                 LDA   CURLIN+1
1541 D946 C5 51                 CMP   LINNUM+1
1542 D948 B0 0B                 BCS   LUK4IT
1543 D94A 98                    TYA   
1544 D94B 38                    SEC   
1545 D94C 65 B8                 ADC   TXTPTR
1546 D94E A6 B9                 LDX   TXTPTR+1
1547 D950 90 07                 BCC   LUKALL
1548 D952 E8                    INX   
1549 D953 B0 04                 BCS   LUKALL                   ;ALWAYS GOES.
1550 D955 A5 67        LUK4IT:  LDA   TXTTAB
1551 D957 A6 68                 LDX   TXTTAB+1
1552 D959 20 1E D6     LUKALL:  JSR   FNDLNC                   ;X,A ARE ALL SET UP.
1553 D95C 90 1E        QFOUND:  BCC   USERR                    ;GOTO LINE IS NONEXISTANT.
1554 D95E A5 9B                 LDA   LOWTR
1555 D960 E9 01                 SBC   #1
1556 D962 85 B8                 STA   TXTPTR
1557 D964 A5 9C                 LDA   LOWTR+1
1558 D966 E9 00                 SBC   #0
1559 D968 85 B9                 STA   TXTPTR+1
1560 D96A 60           GORTS:   RTS                            ;PROCESS THE STATEMENT.
1561 D96B              ; 'RETURN' RESTORES LINE NUMBER AND TEXT PNTR FROM STACK
1562 D96B              ; AND ELIMINATES ALL E 'FOR' ENTRIES IN FRONT OF 'GOSUB'
1563 D96B D0 FD        RETURN:  BNE   GORTS                    ;NO TERMINATOR=BLOW HIM UP.
1564 D96D A9 FF                 LDA   #255
1565 D96F 85 85                 STA   FORPNT                   ;MAKE SURE THE VARIABLE'S PNTR
1566 D971              ;NEVER GETS MATCHED.
1567 D971 20 65 D3              JSR   FNDFOR                   ;GO PAST ALL THE 'FOR' ENTRIES.
1568 D974 9A                    TXS   
1569 D975 C9 B0                 CMP   #GOSUTK                  ;RETURN WITHOUT GOSUB?
1570 D977 F0 0B                 BEQ   RETU1
1571 D979 A2 16                 LDX   #ERRRG
1572 D97B 2C                    DC B:44
1573 D97C A2 5A        USERR:   LDX   #ERRUS                   ;NO MATCH SO 'US' ERROR.
1574 D97E 4C 12 D4              JMP   ERROR                    ;YES.
1575 D981 4C C9 DE     SNERR2:  JMP   SNERR
1576 D984 68           RETU1:   PLA                            ;REMOVE GOSUTK.
1577 D985 68                    PLA   
1578 D986 C0 42                 CPY   #<POPTKN*2               ;POP STATEMENT
1579 D988 F0 3B                 BEQ   DOPOP
1580 D98A 85 75                 STA   CURLIN
1581 D98C 68                    PLA   
1582 D98D 85 76                 STA   CURLIN+1                 ;GET LINE NUMBER 'GOSUB' WAS OM.
1583 D98F 68                    PLA   
1584 D990 85 B8                 STA   TXTPTR
1585 D992 68                    PLA   
1586 D993 85 B9                 STA   TXTPTR+1                 ;GET TEXT PNTR FROM 'GOSUB'.
1587 D995 20 A3 D9     DATA:    JSR   DATAN                    ;SKIP TO END OF STATEMENT, 
1588 D998              ;SINCE WHEN 'GOSUB' STUCK THE TEXT  PNTR
1589 D998              ;ONTO THE STACK, THE LINE NUMBER ARG
1590 D998              ;HADN'T BEEN READ YET.
1591 D998 98           ADDON:   TYA   
1592 D999 18                    CLC   
1593 D99A 65 B8                 ADC   TXTPTR
1594 D99C 85 B8                 STA   TXTPTR
1595 D99E 90 02                 BCC   REMRTS
1596 D9A0 E6 B9                 INC   TXTPTR+1
1597 D9A2 60           REMRTS:  RTS                            ;'NEWSTT' RTS ADDR IS STILL THERE.
1598 D9A3 A2 3A        DATAN:   LDX   #':'                     ;'DATA' TERMINATES ON ':' AND NULL.
1599 D9A5 2C                    DC B:44
1600 D9A6 A2 00        REMN:    LDX   #0                       ;THE ONLY TERMINATOR IS NULL.
1601 D9A8 86 0D                 STX   CHARAC                   ;PRESERVE IT.
1602 D9AA A0 00                 LDY   #0                       ;THIS MAKES CHARAC=0 AFTER SWAP.
1603 D9AC 84 0E                 STY   ENDCHR
1604 D9AE A5 0E        EXCHQT:  LDA   ENDCHR
1605 D9B0 A6 0D                 LDX   CHARAC
1606 D9B2 85 0D                 STA   CHARAC
1607 D9B4 86 0E                 STX   ENDCHR
1608 D9B6 B1 B8        REMER:   LDA   (TXTPTR),Y
1609 D9B8 F0 E8                 BEQ   REMRTS                   ;NULL ALWAYS TERMINATES.
1610 D9BA C5 0E                 CMP   ENDCHR                   ;IS IT THE OTHER TERMINATOR?
1611 D9BC F0 E4                 BEQ   REMRTS                   ;YES, IT'S FINISHED.
1612 D9BE C8                    INY                            ;PROGRESS TO NEXT CHARACTER.
1613 D9BF C9 22                 CMP   #34                      ;IS IT A QUOTE?
1614 D9C1 D0 F3                 BNE   REMER                    ;NO, JUST CONTINUE.
1615 D9C3 F0 E9                 BEQ   EXCHQT                   ;YES, TIME TO TRADE.
1616 D9C5 68           DOPOP:   PLA                            ;GET OTHER STUFF OFF STACK
1617 D9C6 68                    PLA   
1618 D9C7 68                    PLA                            ;NEWSTT ADDR STILL THERE
1619 D9C8 60                    RTS                            ;SO GO BACK.....
1620 D9C9                       EJECT 
1621 D9C9                       TITLE 'IF ... THEN CODE.'
1622 D9C9 20 7B DD     IF:      JSR   FRMEVL                   ;EVALUATE A FORMULA.
1623 D9CC 20 B7 00              JSR   CHRGOT                   ;GET CURNT CHARACTER.
1624 D9CF C9 AB                 CMP   #GOTOTK                  ;IS TERMINATING CHARACTER A GOTOTK?
1625 D9D1 F0 05                 BEQ   OKGOTO                   ;YES.
1626 D9D3 A9 C4                 LDA   #THENTK
1627 D9D5 20 C0 DE              JSR   SYNCHR                   ;NO, IT MUST BE 'THEN'.
1628 D9D8 A5 9D        OKGOTO:  LDA   FACEXP                   ;0=FALSE. ALL OTHERS TRUE.
1629 D9DA D0 05                 BNE   DOCOND                   ;TRUE !
1630 D9DC 20 A6 D9     REM:     JSR   REMN                     ;SKIP REST OF STATEMENT.
1631 D9DF F0 B7                 BEQ   ADDON                    ;WILL ALWAYS BRANCH.
1632 D9E1 20 B7 00     DOCOND:  JSR   CHRGOT                   ;TEST CURRENT CHARACTER.
1633 D9E4 B0 03                 BCS   DOCO                     ;IF A NUMBER, GOTO IT.
1634 D9E6 4C 3E D9              JMP   GOTO
1635 D9E9 4C 28 D8     DOCO:    JMP   GONE3                    ;INTERPRET NEW STATEMENT.
1636 D9EC                       EJECT 
1637 D9EC                       TITLE 'ON ... GO TO ... CODE.'
1638 D9EC 20 F8 E6     ONGOTO:  JSR   GETBYT                   ;GEVALUE IN FACLO.
1639 D9EF 48                    PHA                            ;SAVE FOR LATER.
1640 D9F0 C9 B0                 CMP   #GOSUTK                  ;AN 'ON ... GOSUB' PERHAPS?
1641 D9F2 F0 04                 BEQ   ONGLOP                   ;YES.
1642 D9F4 C9 AB        SNERR3:  CMP   #GOTOTK                  ;MUST BE 'GOTOTK'.
1643 D9F6 D0 89                 BNE   SNERR2
1644 D9F8 C6 A1        ONGLOP:  DEC   FACLO
1645 D9FA D0 04                 BNE   ONGLP1                   ;SKIP ANOTHER LINE NUMBER.
1646 D9FC 68                    PLA                            ;GET DISPATCH CHARACTER.
1647 D9FD 4C 2A D8              JMP   GONE2
1648 DA00 20 B1 00     ONGLP1:  JSR   CHRGET                   ;ADVANCE AND SET CODES.
1649 DA03 20 0C DA              JSR   LINGET
1650 DA06 C9 2C                 CMP   #44                      ;IS IT A COMMA?
1651 DA08 F0 EE                 BEQ   ONGLOP
1652 DA0A 68                    PLA                            ;REMOVE STACK ENTRY (TOKEN).
1653 DA0B 60           ONGRTS:  RTS                            ;EITHER END-OF-LINE OR SYNTAX ERROR.
1654 DA0C                       EJECT 
1655 DA0C                       TITLE 'LINGET -- READ A LINE NUMBER'
1656 DA0C              ; 'LINGET' READS A LINE NUMBER FROM CURRENT TEXT POSITION
1657 DA0C              ; LINE NUMBERS RANGE FROM 0 TO 64000-1.
1658 DA0C              ; THE ANSWER IS RETURNED IN 'LINNUM'.
1659 DA0C              ; 'TXTPTR' IS UPDATED TO POINT TO THE TERMINATING CHARCTER
1660 DA0C              ; AND A = THE TERMINATING CHARACTER WITH CONDITION
1661 DA0C              ; CODES SET UP TO REFLECT ITS VALUE.
1662 DA0C A2 00        LINGET:  LDX   #0
1663 DA0E 86 50                 STX   LINNUM                   ;INITIALIZE LINE NUMBER TO ZERO.
1664 DA10 86 51                 STX   LINNUM+1
1665 DA12 B0 F7        MORLIN:  BCS   ONGRTS                   ;IT IS NOT A DIGIT.
1666 DA14 E9 2F                 SBC   #'0'-1                   ;-1 SINCE C=0.
1667 DA16 85 0D                 STA   CHARAC                   ;SAVE CHARACTER.
1668 DA18 A5 51                 LDA   LINNUM+1
1669 DA1A 85 5E                 STA   INDEX
1670 DA1C C9 19                 CMP   #25                      ;LINE NUMBER WILL BE .LT. 64000?
1671 DA1E B0 D4                 BCS   SNERR3
1672 DA20 A5 50                 LDA   LINNUM
1673 DA22 0A                    ASL   A                        ;MULTIPLY BY 10.
1674 DA23 26 5E                 ROL   INDEX
1675 DA25 0A                    ASL   A
1676 DA26 26 5E                 ROL   INDEX
1677 DA28 65 50                 ADC   LINNUM
1678 DA2A 85 50                 STA   LINNUM
1679 DA2C A5 5E                 LDA   INDEX
1680 DA2E 65 51                 ADC   LINNUM+1
1681 DA30 85 51                 STA   LINNUM+1
1682 DA32 06 50                 ASL   LINNUM
1683 DA34 26 51                 ROL   LINNUM+1
1684 DA36 A5 50                 LDA   LINNUM
1685 DA38 65 0D                 ADC   CHARAC                   ;ADD IN DIGIT.
1686 DA3A 85 50                 STA   LINNUM
1687 DA3C 90 02                 BCC   NXTLGC
1688 DA3E E6 51                 INC   LINNUM+1
1689 DA40 20 B1 00     NXTLGC:  JSR   CHRGET
1690 DA43 4C 12 DA              JMP   MORLIN
1691 DA46                       EJECT 
1692 DA46                       TITLE 'LET CODE.'
1693 DA46 20 E3 DF     LET:     JSR   PTRGET                   ;GET PNTR TO VARIABLE INTO 'VARPNT'.
1694 DA49 85 85                 STA   FORPNT
1695 DA4B 84 86                 STY   FORPNT+1                 ;PRESERVE POINTER.
1696 DA4D A9 D0                 LDA   #EQULTK
1697 DA4F 20 C0 DE              JSR   SYNCHR                   ;'=' IS NECESSARY.
1698 DA52 A5 12                 LDA   INTFLG                   ;SAVE FOR LATER.
1699 DA54 48                    PHA   
1700 DA55 A5 11                 LDA   VALTYP                   ;RETAIN THE VARIABLE'S VALUE TYPE.
1701 DA57 48                    PHA   
1702 DA58 20 7B DD              JSR   FRMEVL                   ;GET VALUE OF FORMULA INTO 'FAC'.
1703 DA5B 68                    PLA   
1704 DA5C 2A                    ROL   A                        ;CARRY SET FOR STRING, OFF FOR
1705 DA5D              ;NUMERIC.
1706 DA5D 20 6D DD              JSR   CHKVAL                   ;MAKE SURE 'VALTYP' MATCHES CARRY.
1707 DA60              ;AND SET ZERO FLAG FOR NUMERIC.
1708 DA60 D0 18                 BNE   COPSTR                   ;IF NUMERIC, COPY IT.
1709 DA62 68           COPNUM:  PLA                            ;GET NUMBER TYPE.
1710 DA63 10 12        QINTGR:  BPL   COPFLT                   ;STORE A FLTING NUMR.
1711 DA65 20 72 EB              JSR   ROUND                    ;ROUND INTEGER.
1712 DA68 20 0C E1              JSR   AYINT                    ;MAKE 2-BYTE NUMBER.
1713 DA6B A0 00                 LDY   #0
1714 DA6D A5 A0                 LDA   FACMO                    ;GET HIGH.
1715 DA6F 91 85                 STA   (FORPNT),Y               ;STORE IT.
1716 DA71 C8                    INY   
1717 DA72 A5 A1                 LDA   FACLO                    ;GET LOW.
1718 DA74 91 85                 STA   (FORPNT),Y
1719 DA76 60                    RTS   
1720 DA77 4C 27 EB     COPFLT:  JMP   MOVVF                    ;PUT NUMBER @FORPNT.
1721 DA7A              COPSTR:  EQU   *
1722 DA7A 68                    PLA                            ;IF STRING, NO INTFLG.
1723 DA7B              INPCOM:  EQU   *
1724 DA7B              ;ADD IN DIGIT TO FAC.
1725 DA7B A0 02        GETSPT:  LDY   #2                       ;GET PNTR TO DESCRIPTOR.
1726 DA7D B1 A0                 LDA   (FACMO),Y
1727 DA7F C5 70                 CMP   FRETOP+1                 ;SEE IF IT POINTS INTO STRING SPACE.
1728 DA81 90 17                 BCC   DNTCPY                   ;IF FRETOP,GT.2&3,FACMO, DON'T COPY.
1729 DA83 D0 07                 BNE   QVARIA                   ;IT IS LESS.
1730 DA85 88                    DEY   
1731 DA86 B1 A0                 LDA   (FACMO),Y
1732 DA88 C5 6F                 CMP   FRETOP                   ;COMPARE LOW ORDERS.
1733 DA8A 90 0E                 BCC   DNTCPY
1734 DA8C A4 A1        QVARIA:  LDY   FACLO
1735 DA8E C4 6A                 CPY   VARTAB+1                 ;IF VARTAB.GT.FACMO, DON'T COPY.
1736 DA90 90 08                 BCC   DNTCPY
1737 DA92 D0 0D                 BNE   COPY                     ;IT IS LESS.
1738 DA94 A5 A0                 LDA   FACMO
1739 DA96 C5 69                 CMP   VARTAB                   ;COMPARE LOW ORDERS.
1740 DA98 B0 07                 BCS   COPY
1741 DA9A A5 A0        DNTCPY:  LDA   FACMO
1742 DA9C A4 A1                 LDY   FACMO+1
1743 DA9E 4C B7 DA              JMP   COPY_C
1744 DAA1 A0 00        COPY:    LDY   #0
1745 DAA3 B1 A0                 LDA   (FACMO),Y
1746 DAA5 20 D5 E3              JSR   STRINI                   ;GET ROOM TO COPY STRING INTO.
1747 DAA8 A5 8C                 LDA   DSCPNT
1748 DAAA A4 8D                 LDY   DSCPNT+1                 ;GET POINTER TO OLD DESCRIPTOR, SO 
1749 DAAC 85 AB                 STA   STRNG1
1750 DAAE 84 AC                 STY   STRNG1+1                 ;MOVINS CAN FINSTRING.
1751 DAB0 20 D4 E5              JSR   MOVINS                   ;COPY IT.
1752 DAB3 A9 9D                 LDA   #DSCTMP
1753 DAB5 A0 00                 LDY   #>DSCTMP                 ;GET POINTER TO OLD DESCRIPTOR.
1754 DAB7 85 8C        COPY_C:  STA   DSCPNT
1755 DAB9 84 8D                 STY   DSCPNT+1                 ;REMEMBER POINTER TO DESCRIPTOR.
1756 DABB 20 35 E6              JSR   FRETMS                   ;FREE UP THE TEMPORARY WITHOUT
1757 DABE              ;FREEING UP ANY STRING SPACE.
1758 DABE A0 00                 LDY   #0
1759 DAC0 B1 8C                 LDA   (DSCPNT),Y
1760 DAC2 91 85                 STA   (FORPNT),Y
1761 DAC4 C8                    INY                            ;POINT TO STRING PNTR.
1762 DAC5 B1 8C                 LDA   (DSCPNT),Y
1763 DAC7 91 85                 STA   (FORPNT),Y
1764 DAC9 C8                    INY   
1765 DACA B1 8C                 LDA   (DSCPNT),Y
1766 DACC 91 85                 STA   (FORPNT),Y
1767 DACE 60                    RTS   
1768 DACF                       EJECT 
1769 DACF                       TITLE 'PRINT CODE.'
1770 DACF 20 3D DB     STRDON:  JSR   STRPRT
1771 DAD2 20 B7 00     NEWCHR:  JSR   CHRGOT                   ;REGET LAST CHARACTER.
1772 DAD5 F0 24        PRINT:   BEQ   CRDO                     ;TERMINATOR SO TYPE CRLF.
1773 DAD7 F0 29        PRINTC:  BEQ   PRTRTS                   ;HERE AFTER SEEING TAB(X) OR , OR ;
1774 DAD9              ;IN WHICH CASE A TERMINATOR DOES NOT
1775 DAD9              ;MEAN TYPE A CRLF BUT JUST RTS.
1776 DAD9 C9 C0                 CMP   #TABTK                   ;TAB FUNCTION?
1777 DADB F0 3C                 BEQ   TABER                    ;YES.
1778 DADD C9 C3                 CMP   #SPCTK                   ;SPACE FUNCTION?
1779 DADF 18                    CLC                            ;REMEMBER IF IT IS.
1780 DAE0 F0 37                 BEQ   TABER
1781 DAE2 C9 2C                 CMP   #44                      ;A COMMA?
1782 DAE4 18                    CLC   
1783 DAE5 F0 1C                 BEQ   COMPRT                   ;YES.
1784 DAE7 C9 3B                 CMP   #59                      ;A SEMICOLON?
1785 DAE9 F0 44                 BEQ   NOTABR                   ;YES.
1786 DAEB 20 7B DD              JSR   FRMEVL                   ;EVALUATE THE FORMULA.
1787 DAEE 24 11                 BIT   VALTYP                   ;A STRING?
1788 DAF0 30 DD                 BMI   STRDON                   ;YES.
1789 DAF2 20 34 ED              JSR   FOUT
1790 DAF5 20 E7 E3              JSR   STRLIT
1791 DAF8 4C CF DA              JMP   STRDON
1792 DAFB              CRDO:    EQU   *
1793 DAFB A9 0D                 LDA   #13                      ;MAKE TRMPOS LESS THAN LINE LENGTH.
1794 DAFD 20 5C DB              JSR   OUTDO
1795 DB00              CRFIN:   EQU   *
1796 DB00 49 FF                 EOR   #255
1797 DB02 60           PRTRTS:  RTS   
1798 DB03 20 DD D8     COMPRT   JSR   LSTFMAT
1799 DB06 30 09                 BMI   MORCOM                   ;PAST LAST COMMA POSITION
1800 DB08 C9 18                 CMP   #$18
1801 DB0A 90 05                 BCC   MORCOM
1802 DB0C 20 FB DA              JSR   CRDO
1803 DB0F D0 1E                 BNE   NOTABR                   ;FINISH UP
1804 DB11 69 10        MORCOM:  ADC   #$10                     ;DO COMMA FOR PRINTER CARD
1805 DB13 29 F0                 AND   #$F0                     ;THE RIGHT WAY SO IT WILL WORK!
1806 DB15 AA                    TAX   
1807 DB16 38                    SEC   
1808 DB17 B0 0C                 BCS   TABR1A                   ;FINISH UP BY PRINTING SPACES TO NEXT TAB. 
1809 DB19 08           TABER:   PHP                            ;REMEMBER IF SPC OR TAB FUNCTION.
1810 DB1A 20 F5 E6              JSR   GTBYTC                   ;GET VALUE INTO ACCX.
1811 DB1D C9 29                 CMP   #41
1812 DB1F D0 62                 BNE   SNERR4
1813 DB21              * 
1814 DB21 28                    PLP   
1815 DB22 90 07                 BCC   XSPAC                    ;PRINT X SPACES.
1816 DB24 CA           TABER1   DEX                            ;COLUMN 1 ISFIRST
1817 DB25 20 CB F7     TABR1A   JSR   TABER2
1818 DB28 90 05                 BCC   NOTABR                   ;NEGATIVE, DON'T PRINT ANY.
1819 DB2A AA           ASPAC:   TAX   
1820 DB2B E8           XSPAC:   INX   
1821 DB2C CA           XSPAC2:  DEX                            ;DECREMENT THE COUNT.
1822 DB2D D0 06                 BNE   XSPAC1
1823 DB2F 20 B1 00     NOTABR:  JSR   CHRGET                   ;REGET LAST CHARACTER.
1824 DB32 4C D7 DA              JMP   PRINTC                   ;DON'T CALL CRDO.
1825 DB35 20 57 DB     XSPAC1:  JSR   OUTSPC
1826 DB38 D0 F2                 BNE   XSPAC2
1827 DB3A              ; PRINT STRING POINTED TO BY Y,A WHICH ENDS WITH A ZERO.
1828 DB3A              ; IF STRING IS BELOW DSCTMP IT WILL BE COPIED INTO STRING
1829 DB3A 20 E7 E3     STROUT:  JSR   STRLIT                   ;GET A STRING LITERAL.
1830 DB3D              ; PRINT THE STRING WHOSE DESCRIPTOR IS POINTED TO BY FACMO
1831 DB3D 20 00 E6     STRPRT:  JSR   FREFAC                   ;RETURN TEMP POINTER.
1832 DB40 AA                    TAX                            ;PUT COUNT INTO COUNTER.
1833 DB41 A0 00                 LDY   #0
1834 DB43 E8                    INX                            ;MOVE ONE AHEAD.
1835 DB44 CA           STRPR2:  DEX   
1836 DB45 F0 BB                 BEQ   PRTRTS                   ;ALL DONE.
1837 DB47 B1 5E                 LDA   (INDEX),Y                ;PNTR TO ACT STRNG SET BY FREFAC.
1838 DB49 20 5C DB              JSR   OUTDO
1839 DB4C C8                    INY   
1840 DB4D C9 0D                 CMP   #13
1841 DB4F D0 F3                 BNE   STRPR2
1842 DB51 20 00 DB              JSR   CRFIN                    ;TYPE REST OF CARRIAGE RETURN.
1843 DB54 4C 44 DB              JMP   STRPR2                   ;AND ON AND ON.
1844 DB57              ; OUTDO OUTPUTS THE CHARACTER IN ACCA, USING CNTWFL
1845 DB57              ; (SUPPSS OR NOT), TRMPOS (PRINT HEAD POSITION),
1846 DB57              ; TIMING, ETC.. NO REGISTERS ARE CHANGED.
1847 DB57              OUTSPC:  EQU   *
1848 DB57 A9 20                 LDA   #$20
1849 DB59 2C                    DC B:44
1850 DB5A A9 3F        OUTQST:  LDA   #'?'
1851 DB5C              OUTDO:   EQU   *
1852 DB5C 09 80                 ORA   #$80                     ;TURN ON B7 FOR APPLE.
1853 DB5E C9 A0                 CMP   #$A0                     ;CONTROL CHARACTER?
1854 DB60 90 02                 BCC   OUTLOC
1855 DB62 05 F3                 ORA   ORMASK
1856 DB64 20 ED FD     OUTLOC:  JSR   OUTCH                    ;OUTPUT THE CHARACTER.
1857 DB67 29 7F                 AND   #$7F                     ;GET A BACK FROM APPLE.
1858 DB69 48                    PHA                            ;NOW DELAY FOR SPEED=
1859 DB6A A5 F1                 LDA   SPDBYT
1860 DB6C 20 A8 FC              JSR   WAITNOW
1861 DB6F 68                    PLA   
1862 DB70 60           GETRTS:  RTS   
1863 DB71                       EJECT 
1864 DB71                       TITLE 'INPUT AND READ CODE'
1865 DB71              ; HERE WHEN DATA THAT WAS TYPED IN OR IN 'DATA' STATEMENT
1866 DB71              ; IS IMPROPERLY FORMATTED. FOR 'INPUT' WE START AGAIN.
1867 DB71              ; FOR 'READ' WE GIVE A SYNTAX ERROR AT THE DATA LINE.
1868 DB71 A5 15        TRMNOK:  LDA   INPFLG
1869 DB73 F0 12                 BEQ   TRMNO1                   ;IFNPUT TRY AGAIN.
1870 DB75 30 04                 BMI   GETDTL
1871 DB77 A0 FF                 LDY   #255                     ;MAKE IT LOOK DIRECT.
1872 DB79 D0 04                 BNE   STCURL                   ;ALWAYS GOES.
1873 DB7B              GETDTL:  EQU   *
1874 DB7B A5 7B                 LDA   DATLIN
1875 DB7D A4 7C                 LDY   DATLIN+1                 ;GET DATA LINE NUMBER.
1876 DB7F 85 75        STCURL:  STA   CURLIN
1877 DB81 84 76                 STY   CURLIN+1                 ;MAKE IT CURRENT LINE.
1878 DB83 4C C9 DE     SNERR4:  JMP   SNERR
1879 DB86 68                    PLA   
1880 DB87              TRMNO1:  EQU   *
1881 DB87 24 D8                 BIT   ERRFLG                   ;ON ERR IN EFFECT?
1882 DB89 10 05                 BPL   DOAGIN                   ;NO.
1883 DB8B A2 FE                 LDX   #254                     ;ERROR CODE IS 254 FOR BAD INPUT.
1884 DB8D 4C E9 F2              JMP   HNDLERR
1885 DB90 A9 EF        DOAGIN:  LDA   #TRYAGN
1886 DB92 A0 DC                 LDY   #>TRYAGN
1887 DB94 20 3A DB              JSR   STROUT                   ;PRINT '?REDO FROM START'.
1888 DB97 A5 79                 LDA   OLDTXT
1889 DB99 A4 7A                 LDY   OLDTXT+1                 ;POINT AT START
1890 DB9B 85 B8                 STA   TXTPTR
1891 DB9D 84 B9                 STY   TXTPTR+1                 ;OF THIS CURRENT LINE.
1892 DB9F 60                    RTS                            ;GO TO 'NEWSTT'.
1893 DBA0 20 06 E3     GET:     JSR   ERRDIR                   ;DIRECT IS NOT OK.
1894 DBA3 A2 01        GETTTY:  LDX   #<BUF+1
1895 DBA5 A0 02                 LDY   #>BUF+1                  ;POINT TO 0.
1896 DBA7 A9 00                 LDA   #0                       ;TO STUFF AND TO POINT.
1897 DBA9 8D 01 02              STA   BUF+1
1898 DBAC A9 40                 LDA   #64                      ;TURN ON V-BIT.
1899 DBAE 20 EB DB              JSR   INPCO1                   ;DO THE GET.
1900 DBB1 60                    RTS   
1901 DBB2              INPUT:   EQU   *
1902 DBB2 C9 22                 CMP   #34                      ;A QUOTE?
1903 DBB4 D0 0E                 BNE   NOTQTI                   ;NO MESSA.
1904 DBB6 20 81 DE              JSR   STRTXT                   ;LITERALIZE THE STRING IN TEXT
1905 DBB9 A9 3B                 LDA   #59
1906 DBBB 20 C0 DE              JSR   SYNCHR                   ;MUST END WITH SEMICOLON.
1907 DBBE 20 3D DB              JSR   STRPRT                   ;PRINT IT OUT.
1908 DBC1 4C C7 DB              JMP   NOTQTII                  ;DON'T PRIN OUT QUESTION MARK
1909 DBC4 20 5A DB     NOTQTI:  JSR   OUTQST                   ;PRINT A ? FOR INPUT
1910 DBC7 20 06 E3     NOTQTII: JSR   ERRDIR                   ;USE COMMON ROUTINE SINCE DEF DIRECT
1911 DBCA A9 2C                 LDA   #44                      ;GET COMMA.
1912 DBCC 8D FF 01              STA   BUF-1
1913 DBCF              ;IS ALSO ILLEGAL.
1914 DBCF 20 2C D5     GETAGN:  JSR   INLIN                    ;INPUT A LINE OF TEXT.
1915 DBD2 AD 00 02              LDA   BUF                      ;ANYTHING INPUT?
1916 DBD5 C9 03                 CMP   #$03                     ;CONTROL-C AT FRONT OF LINE?
1917 DBD7 D0 10                 BNE   INPCON                   ;YES, CONTINUE
1918 DBD9 4C 63 D8              JMP   ISCCAP+3                 ;NO, STOP.
1919 DBDC              QINLIN:  EQU   *
1920 DBDC 20 5A DB              JSR   OUTQST
1921 DBDF 4C 2C D5     GINLIN:  JMP   INLIN
1922 DBE2 A6 7D        READ:    LDX   DATPTR
1923 DBE4 A4 7E                 LDY   DATPTR+1                 ;GET LAST DATA LOCATION.
1924 DBE6 A9 98                 LDA   #$98                     ;FOR STUFF..
1925 DBE8 2C                    DC B:44                        ;SKIP OVER LDA #0 OPERATION.
1926 DBE9 A9 00        INPCON:  LDA   #0
1927 DBEB 85 15        INPCO1:  STA   INPFLG                   ;STORE THE FLAG.
1928 DBED              ; IN THE PROCESSING OF DATA AND READ STATEMENTS:
1929 DBED              ; ONE POINTER POINTS TO DATA (THE NUMBERS BEING FETCHED)
1930 DBED              ; AND ANOTHER POINTS TO THE LIST OF VARIABLES.
1931 DBED              ; THE POINTER INTO THE DATA ALWAYS STARTS POINTING TO A
1932 DBED              ; TERMINATOR -- A , : OR END-OF-LINE.
1933 DBED              ; AT THIS POINT TXTPTR POINTS TO LIST OF VARIABLES AND
1934 DBED              ; Y,X POINTS TO DATA OR INPUT LINE.
1935 DBED 86 7F                 STX   INPPTR
1936 DBEF 84 80                 STY   INPPTR+1
1937 DBF1 20 E3 DF     INLOOP:  JSR   PTRGET                   ;READ VARIABLE LIST.
1938 DBF4 85 85                 STA   FORPNT
1939 DBF6 84 86                 STY   FORPNT+1                 ;SAVE POINTER FOR 'LET' STRING UFFING.
1940 DBF8              ;RETURNS PNTR TOP VAR IN VARPNT.
1941 DBF8 A5 B8                 LDA   TXTPTR
1942 DBFA A4 B9                 LDY   TXTPTR+1                 ;SAVE TEXT PNTR.
1943 DBFC 85 87                 STA   VARTXT
1944 DBFE 84 88                 STY   VARTXT+1
1945 DC00 A6 7F                 LDX   INPPTR
1946 DC02 A4 80                 LDY   INPPTR+1
1947 DC04 86 B8                 STX   TXTPTR
1948 DC06 84 B9                 STY   TXTPTR+1
1949 DC08 20 B7 00              JSR   CHRGOT                   ;GET IT AND SET Z IF TERM.
1950 DC0B D0 1E                 BNE   DATBK1
1951 DC0D 24 15                 BIT   INPFLG
1952 DC0F 50 0E                 BVC   QDATA
1953 DC11 20 0C FD              JSR   C_GETL                   ;DON'T WANT INCHR. JUST ONE.
1954 DC14 29 7F                 AND   #127
1955 DC16 8D 00 02              STA   BUF                      ;MAKE IT FIRST CHARACTER.
1956 DC19 A2 FF                 LDX   #<BUF-1
1957 DC1B A0 01                 LDY   #>BUF-1                  ;POINT JUST BEFORE IT.
1958 DC1D D0 08                 BNE   DATBK                    ;GO PROCESS.
1959 DC1F 30 7F        QDATA:   BMI   DATLOP                   ;SEARCH FOR ANOTHER DATA STATEMENT.
1960 DC21 20 5A DB              JSR   OUTQST
1961 DC24 20 DC DB     GETNTH:  JSR   QINLIN                   ;GET ANOTHER LINE.
1962 DC27 86 B8        DATBK:   STX   TXTPTR
1963 DC29 84 B9                 STY   TXTPTR+1                 ;SET FOR 'CHRGET'.
1964 DC2B 20 B1 00     DATBK1:  JSR   CHRGET
1965 DC2E 24 11                 BIT   VALTYP                   ;GET VALUE TYPE.
1966 DC30 10 31                 BPL   NUMINS                   ;INPUT A NUMBER IF NUMERIC.
1967 DC32 24 15                 BIT   INPFLG                   ;GET?
1968 DC34 50 09                 BVC   SETQUT                   ;NO, GO SET QUOTE.
1969 DC36 E8                    INX   
1970 DC37 86 B8                 STX   TXTPTR
1971 DC39 A9 00                 LDA   #0                       ;ZERO TERMINATORS.
1972 DC3B 85 0D                 STA   CHARAC
1973 DC3D F0 0C                 BEQ   RESETC
1974 DC3F 85 0D        SETQUT:  STA   CHARAC                   ;ASSUME QUOTED STRING.
1975 DC41 C9 22                 CMP   #34                      ;TERMINATORS OK?
1976 DC43 F0 07                 BEQ   NOWGET                   ;YES.
1977 DC45 A9 3A                 LDA   #':'                     ;SET TERMINATORS TO ':' AND
1978 DC47 85 0D                 STA   CHARAC
1979 DC49 A9 2C                 LDA   #44                      ;COMMA.
1980 DC4B 18           RESETC:  CLC   
1981 DC4C 85 0E        NOWGET:  STA   ENDCHR
1982 DC4E A5 B8                 LDA   TXTPTR
1983 DC50 A4 B9                 LDY   TXTPTR+1
1984 DC52 69 00                 ADC   #0                       ;C IS SET PROPERLY ABOVE.
1985 DC54 90 01                 BCC   NOWGE1
1986 DC56 C8                    INY   
1987 DC57 20 ED E3     NOWGE1:  JSR   STRLT2                   ;MAKE A STRING DESCRIPTOR FOR VALUE
1988 DC5A              ;AND COPY IF NECESSARY.
1989 DC5A 20 3D E7              JSR   ST2TXT                   ;SET TEXT POINTER.
1990 DC5D 20 7B DA              JSR   INPCOM                   ;DO ASSIGNMENT.
1991 DC60 4C 72 DC              JMP   STRDN2
1992 DC63 48           NUMINS:  PHA   
1993 DC64 AD 00 02              LDA   BUF                      ;BLANK INPUT?
1994 DC67 F0 30                 BEQ   MAYBAD
1995 DC69 68           NUMINS2: PLA   
1996 DC6A 20 4A EC              JSR   FIN                      ;GET VALUE.
1997 DC6D A5 12                 LDA   INTFLG                   ;SET CODES ON FLAG.
1998 DC6F 20 63 DA              JSR   QINTGR                   ;GO DECIDE ON FLOAT.
1999 DC72 20 B7 00     STRDN2:  JSR   CHRGOT                   ;READ LAST CHARACTER.
2000 DC75 F0 07                 BEQ   TRMOK                    ;':' OR EOL IS OK.
2001 DC77 C9 2C                 CMP   #44                      ;A COMMA?
2002 DC79 F0 03                 BEQ   *+5
2003 DC7B 4C 71 DB              JMP   TRMNOK
2004 DC7E A5 B8        TRMOK:   LDA   TXTPTR
2005 DC80 A4 B9                 LDY   TXTPTR+1
2006 DC82 85 7F                 STA   INPPTR
2007 DC84 84 80                 STY   INPPTR+1                 ;SAVE FOR MORE READS.
2008 DC86 A5 87                 LDA   VARTXT
2009 DC88 A4 88                 LDY   VARTXT+1
2010 DC8A 85 B8                 STA   TXTPTR
2011 DC8C 84 B9                 STY   TXTPTR+1                 ;POINT TO VARIABLE LIST.
2012 DC8E 20 B7 00              JSR   CHRGOT                   ;LOOK AT LAST VARIABLE LIST CHARACTER.
2013 DC91 F0 33                 BEQ   VAREND                   ;THAT'S THE END OF THE LIST.
2014 DC93 20 BE DE              JSR   CHKCOM                   ;NOT END. CHECK FOR COMMA.
2015 DC96 4C F1 DB              JMP   INLOOP
2016 DC99 A5 15        MAYBAD:  LDA   INPFLG
2017 DC9B D0 CC                 BNE   NUMINS2
2018 DC9D 4C 86 DB              JMP   TRMNO1-1
2019 DCA0              ; SUBROUTINE TO FIND DATA
2020 DCA0              ; SEARCH IS MADE BY USING THE EXECUTION CODE FOR DATA TO
2021 DCA0              ; SKIP OR STATEMENTS. THE START WORD OF EACH STATEMENT
2022 DCA0              ; IS COMPARED WITH 'DATATK'. EACH NEW LINE NUMBER
2023 DCA0              ; IS STORED IN 'DATLIN' SO THAT IF AN ERROR OCCURS
2024 DCA0              ; WHILE READING DATA THE ERROR MESSAGE CAN GIVE THE LINE
2025 DCA0              ; NUMBER OF THE ILL-FORMATTED DATA.
2026 DCA0 20 A3 D9     DATLOP:  JSR   DATAN                    ;SKIP SOME TEXT.
2027 DCA3 C8                    INY   
2028 DCA4 AA                    TAX                            ;END OF LINE?
2029 DCA5 D0 12                 BNE   NOWLIN                   ;SHO AIN'T.
2030 DCA7 A2 2A                 LDX   #ERROD                   ;YES = 'NO DATA' ERROR.
2031 DCA9 C8                    INY   
2032 DCAA B1 B8                 LDA   (TXTPTR),Y
2033 DCAC F0 5F                 BEQ   ERRGO5
2034 DCAE C8                    INY   
2035 DCAF B1 B8                 LDA   (TXTPTR),Y               ;GET HIGH BYTE OF LINE NUMBER.
2036 DCB1 85 7B                 STA   DATLIN
2037 DCB3 C8                    INY   
2038 DCB4 B1 B8                 LDA   (TXTPTR),Y               ;GET LOW BYTE.
2039 DCB6 C8                    INY   
2040 DCB7 85 7C                 STA   DATLIN+1
2041 DCB9 B1 B8        NOWLIN:  LDA   (TXTPTR),Y               ;HOW IS IT?
2042 DCBB AA                    TAX   
2043 DCBC 20 98 D9              JSR   ADDON                    ;ADD Y TO TXTPTR.
2044 DCBF E0 83                 CPX   #DATATK                  ;IS IT A 'DATA' STATEMENT.
2045 DCC1 D0 DD                 BNE   DATLOP                   ;NOT QUITE RIGHT. KEEP LOOKING.
2046 DCC3 4C 2B DC              JMP   DATBK1                   ;THIS IS THE ONE !
2047 DCC6 A5 7F        VAREND:  LDA   INPPTR
2048 DCC8 A4 80                 LDY   INPPTR+1                 ;PUT AWAY A NEW DATA PNTR MAYBE.
2049 DCCA A6 15                 LDX   INPFLG
2050 DCCC 10 03                 BPL   VARY0
2051 DCCE 4C 53 D8              JMP   RESFIN
2052 DCD1 A0 00        VARY0:   LDY   #0
2053 DCD3 B1 7F                 LDA   (INPPTR),Y               ;LAST DATA CHR COULD HAVE BEEN
2054 DCD5              ;COMMA OR COLON BUT SHOULD BE NULL.
2055 DCD5 F0 07                 BEQ   INPRTS                   ;IT IS NUL
2056 DCD7 A9 DF                 LDA   #EXIGNT
2057 DCD9 A0 DC                 LDY   #>EXIGNT
2058 DCDB 4C 3A DB              JMP   STROUT                   ;TYPE '?EXTRA IGNORED'
2059 DCDE 60           INPRTS:  RTS                            ;DO NEXT STATEMENT.
2060 DCDF 3F 45 58 54  EXIGNT:  DC B:'?EXTRA IGNORED'
2061 DCED 0D                    DC B:13
2062 DCEE 00                    DC B:0
2063 DCEF 3F 52 45 45  TRYAGN:  DC B:'?REENTER'
2064 DCF7 0D                    DC B:13
2065 DCF8 00                    DC B:0
2066 DCF9                       EJECT 
2067 DCF9                       TITLE 'THE NEXT CODE IS THE NEXT CODE'
2068 DCF9              ; A 'FOR' ENTRY ON THE STACK HAS THE FOLLOWING FORMAT:
2069 DCF9              ; LOW ADDRESS
2070 DCF9              ; TOKEN (FORTK) 1 BYTE
2071 DCF9              ; A POINTER TO THE LOOP VARIABLE 2 BYTES
2072 DCF9              ; T STEP 4+ADDPRC BYTES
2073 DCF9              ; A BYTE REFLECTING THE SIGN OF THE INCREMENT 1 BYTE
2074 DCF9              ; THE UPPER VALUE (PACKED) 4+ADDPRC BYTES
2075 DCF9              ; THE LINE NUMBER OF THE 'FOR' STATEMENT 2 BYTES
2076 DCF9              ; A TEXT POINTER INTO THE 'FOR' STATEMENT 2 BYTES
2077 DCF9              ; HIGH ADDRESS
2078 DCF9              ; TOTAL 16+2*ADDPRC BYTES.
2079 DCF9 D0 04        NEXT:    BNE   GETFOR
2080 DCFB A0 00                 LDY   #0                       ;WITHOUT ARG CALL 'FNDFOR' WITH
2081 DCFD F0 03                 BEQ   STXFOR                   ;FORPNT=0.
2082 DCFF 20 E3 DF     GETFOR:  JSR   PTRGET                   ;GET A POINTER TO LOOP VARIABLE
2083 DD02 85 85        STXFOR:  STA   FORPNT
2084 DD04 84 86                 STY   FORPNT+1                 ;INTO 'FORPNT'.
2085 DD06 20 65 D3              JSR   FNDFOR                   ;FIND THE MATCHI ENTRY IF ANY.
2086 DD09 F0 04                 BEQ   HAVFOR
2087 DD0B A2 00                 LDX   #ERRNF                   ;'NEXT WITHOUT FOR'.
2088 DD0D F0 69        ERRGO5:  BEQ   ERRGO4
2089 DD0F 9A           HAVFOR:  TXS                            ;SETUP STACK. CHOP FIRST.
2090 DD10 E8                    INX   
2091 DD11 E8                    INX   
2092 DD12 E8                    INX   
2093 DD13 E8                    INX                            ;POINT TO INCREMENT.
2094 DD14 8A                    TXA                            ;SET LO ADDR OF THING TO MOVE.
2095 DD15 E8                    INX   
2096 DD16 E8                    INX   
2097 DD17 E8                    INX   
2098 DD18 E8                    INX   
2099 DD19 E8                    INX   
2100 DD1A E8                    INX                            ;POINT TO UPPER LIMIT.
2101 DD1B 86 60                 STX   INDEX2
2102 DD1D A0 01                 LDY   #1                       ;SET HI ADDR OF THING TO MOVE.
2103 DD1F 20 F9 EA              JSR   MOVFM                    ;GET QUANTITY INTO THE FAC.
2104 DD22 BA                    TSX   
2105 DD23 BD 09 01              LDA   257+7+1,X                ;SET SIGN CORRECTLY.
2106 DD26 85 A2                 STA   FACSGN
2107 DD28 A5 85                 LDA   FORPNT
2108 DD2A A4 86                 LDY   FORPNT+1
2109 DD2C 20 BE E7              JSR   FADD                     ;ADD INC TO LO VARIABLE.
2110 DD2F 20 27 EB              JSR   MOVVF                    ;PACK THE FAC INTO MEMORY.
2111 DD32 A0 01                 LDY   #1
2112 DD34 20 B4 EB              JSR   FCOMPN                   ;COMPARE FAC WITH UPPER VALUE.
2113 DD37 BA                    TSX   
2114 DD38 38                    SEC   
2115 DD39 FD 09 01              SBC   257+7+1,X                ;SUBTRACT SIGN OF INC FROM SIGN OF
2116 DD3C              ;OF (CURRENT VALUE-FINAL VALUE).
2117 DD3C F0 17                 BEQ   LOOPDN                   ;IF SIGN (FINAL-CURRENT)-SIGN STEP=0
2118 DD3E              ;THEN LOOP IS DONE.
2119 DD3E BD 0F 01              LDA   257+12+2,X
2120 DD41 85 75                 STA   CURLIN                   ;STORE LINE NUMBER OF 'FOR' STATEMENT.
2121 DD43 BD 10 01              LDA   257+13+2,X
2122 DD46 85 76                 STA   CURLIN+1
2123 DD48 BD 12 01              LDA   257+15+2,X
2124 DD4B 85 B8                 STA   TXTPTR                   ;STORE TEXT PNTR INTO 'FOR' STATEMENT.
2125 DD4D BD 11 01              LDA   257+14+2,X
2126 DD50 85 B9                 STA   TXTPTR+1
2127 DD52 4C D2 D7     NEWSGO:  JMP   NEWSTT                   ;PROCESS NEXT STATEMENT.
2128 DD55 8A           LOOPDN:  TXA   
2129 DD56 69 11                 ADC   #15+2                    ;ADDS 16 WITH CARRY.
2130 DD58 AA                    TAX   
2131 DD59 9A                    TXS                            ;NEW STACK PNTR.
2132 DD5A 20 B7 00              JSR   CHRGOT
2133 DD5D C9 2C                 CMP   #44                      ;COMMA AT END?
2134 DD5F D0 F1                 BNE   NEWSGO
2135 DD61 20 B1 00              JSR   CHRGET
2136 DD64 20 FF DC              JSR   GETFOR                   ;DO NEXT BUT DON'T ALLOW BLANK VARIABLE
2137 DD67              ;PNTR. VARPNT IS THE STK PNTR WHICH
2138 DD67              ;NEVER MATCHES ANY POINTER.
2139 DD67              ;JSR TO PUT ON DUMMY NEWSTT ADDR.
2140 DD67                       EJECT 
2141 DD67                       TITLE 'FORMULA EVALUATION CODE.'
2142 DD67              ; THESE ROUTINES CHECK FOR CERTAIN 'VALTYP'.
2143 DD67              ; C IS NOT PRESERVED.
2144 DD67 20 7B DD     FRMNUM:  JSR   FRMEVL
2145 DD6A 18           CHKNUM:  CLC   
2146 DD6B 24                    DC B:36
2147 DD6C 38           CHKSTR:  SEC                            ;SET CARRY.
2148 DD6D 24 11        CHKVAL:  BIT   VALTYP                   ;WILL NOT F UP 'VALTYP'.
2149 DD6F 30 03                 BMI   DOCSTR
2150 DD71 B0 03                 BCS   CHKERR
2151 DD73 60           CHKOK:   RTS   
2152 DD74 B0 FD        DOCSTR:  BCS   CHKOK
2153 DD76 A2 A3        CHKERR:  LDX   #ERRTM
2154 DD78 4C 12 D4     ERRGO4:  JMP   ERROR
2155 DD7B              ; THE FORMULA EVALUATOR STARTS WITH
2156 DD7B              ; TXTPTR POINTING TO THE FIRST CHARACTER OF THE FORMULA.
2157 DD7B              ; AT THE END TXTPTR POINTS TO THE TERMINATOR.
2158 DD7B              ; THE RESULT IS LEFT IN THE FAC.
2159 DD7B              ; ON RETURN A DOES NOT REFLECT THE TERMINATOR.
2160 DD7B              ; THE FORMULA EVALUATOR USES THE OPERATOR LIST (OPTAB)
2161 DD7B              ; TO DETERMINE PCEDENCE AND DISPATCH ADDRESSES FOR 
2162 DD7B              ; EACH OPERATOR.
2163 DD7B              ; A TEMPORARY RESULT ON THE STACK HAS THE FOLLOWING FORMAT
2164 DD7B              ; THE ADDRESS OF THE OPERATOR ROUTINE.
2165 DD7B              ; THE FLOATING POINT TEMPORARY RESULT.
2166 DD7B              ; THE PRECEDENCE OF THE OPERATOR.
2167 DD7B A6 B8        FRMEVL:  LDX   TXTPTR
2168 DD7D D0 02                 BNE   FRMEV1
2169 DD7F C6 B9                 DEC   TXTPTR+1
2170 DD81 C6 B8        FRMEV1:  DEC   TXTPTR
2171 DD83 A2 00                 LDX   #0                       ;INITIAL DUMMY PRECEDENCE IS 0.
2172 DD85 24                    DC B:36
2173 DD86 48           LPOPER:  PHA                            ;SAVE LOW PRECEDENCE. (MASK.)
2174 DD87 8A                    TXA   
2175 DD88 48                    PHA                            ;SAVE HIGH PRECEDENCE.
2176 DD89 A9 01                 LDA   #1
2177 DD8B 20 D6 D3              JSR   GETSTK                   ;MAKE SURE THERE IS ROOM FOR
2178 DD8E              ;RECURSIVE CALLS.
2179 DD8E 20 60 DE              JSR   EVAL                     ;EVALUATE SOMETHING.
2180 DD91 A9 00                 LDA   #$00
2181 DD93 85 89                 STA   OPMASK                   ;PREPARE TO BUILD MASK MAYBE.
2182 DD95 20 B7 00     TSTOP:   JSR   CHRGOT                   ;REGET LAST CHARACTER.
2183 DD98 38           LOPREL:  SEC                            ;PREP TO SUBTRACT.
2184 DD99 E9 CF                 SBC   #GREATK                  ;IS CURRENT CHARACTER A RELATION?
2185 DD9B 90 17                 BCC   ENDREL                   ;NO. RELATIONS ALL THROUGH.
2186 DD9D C9 03                 CMP   #LESSTK-GREATK+1         ;REALLY RELATIONAL?
2187 DD9F B0 13                 BCS   ENDREL                   ;NO -- JUST BIG.
2188 DDA1 C9 01                 CMP   #1                       ;RESET CARRY FOR ZERO ONLY.
2189 DDA3 2A                    ROL   A                        ;0 TO 1, 1 TO 2, 2 TO 4.
2190 DDA4 49 01                 EOR   #1
2191 DDA6 45 89                 EOR   OPMASK                   ;BRING IN THE OLD BITS.
2192 DDA8 C5 89                 CMP   OPMASK                   ;MAKE SUREHE NEW MASK IS BIGGER.
2193 DDAA 90 61                 BCC   SNERR5                   ;SYNTAX ERROR. BECAUSE TWO OF THE SAME.
2194 DDAC 85 89                 STA   OPMASK                   ;SAVE MASK.
2195 DDAE 20 B1 00              JSR   CHRGET
2196 DDB1 4C 98 DD              JMP   LOPREL                   ;GET THE NEXT CANDIDATE.
2197 DDB4 A6 89        ENDREL:  LDX   OPMASK                   ;WERE THERE ANY?
2198 DDB6 D0 2C                 BNE   FINREL                   ;YES, HANDLE AS SPECIAL OP.
2199 DDB8 B0 7B                 BCS   QOP                      ;NOT AN OPERATOR.
2200 DDBA 69 07                 ADC   #GREATK-PLUSTK
2201 DDBC 90 77                 BCC   QOP                      ;NOT AN OPERATOR.
2202 DDBE 65 11                 ADC   VALTYP                   ;C=1.
2203 DDC0 D0 03                 BNE   *+5
2204 DDC2 4C 97 E5              JMP   CAT                      ;ONLY IF A=0 AND VALTYP=-1 (A STR).
2205 DDC5 69 FF                 ADC   #$100-1                  ;GET BACK ORIGINAL A.
2206 DDC7 85 5E                 STA   INDEX1
2207 DDC9 0A                    ASL   A                        ;MULTIPLY BY 2.
2208 DDCA 65 5E                 ADC   INDEX1                   ;BY THREE.
2209 DDCC A8                    TAY                            ;SET UP FOR LATER.
2210 DDCD 68           QPREC:   PLA                            ;GET PREVIOUS PRECEDENCE.
2211 DDCE D9 B2 D0              CMP   OPTAB,Y                  ;IS OLD PRECEDENCE GREATER OR EQUAL?
2212 DDD1 B0 67                 BCS   QCHNUM                   ;YES, GO OPERATE.
2213 DDD3 20 6A DD              JSR   CHKNUM                   ;CAN'T BE STRING HERE.
2214 DDD6 48           DOPREC:  PHA                            ;SAVE OLD PRECEDENCE.
2215 DDD7 20 FD DD     NEGPRC:  JSR   DOPRE1                   ;SET A RETURN ADDRESS FOR OP.
2216 DDDA 68                    PLA                            ;PULL OFF PREVIOUS PRECEDENCE.
2217 DDDB A4 87                 LDY   OPPTR                    ;GET POINTER TO OP.
2218 DDDD 10 17                 BPL   QPREC1                   ;THAT'S A REAL OPERATOR.
2219 DDDF AA                    TAX                            ;DONE ?
2220 DDE0 F0 56                 BEQ   QOPGO                    ;DONE !
2221 DDE2 D0 5F                 BNE   PULSTK
2222 DDE4 46 11        FINREL:  LSR   VALTYP                   ;GET VALUE TYPINTO 'C'.
2223 DDE6 8A                    TXA   
2224 DDE7 2A                    ROL   A                        ;PUT VALTYP INTO LOW ORDER BIT OF MASK.
2225 DDE8 A6 B8                 LDX   TXTPTR                   ;DECREMENT TEXT POINTER.
2226 DDEA D0 02                 BNE   FINRE2
2227 DDEC C6 B9                 DEC   TXTPTR+1
2228 DDEE C6 B8        FINRE2:  DEC   TXTPTR
2229 DDF0 A0 1B                 LDY   #PTDORL-OPTAB            ;MAKE YREG POINT AT OPERATOR ENTRY.
2230 DDF2 85 89                 STA   OPMASK                   ;SAVE THE OPERATION MASK.
2231 DDF4 D0 D7                 BNE   QPREC                    ;SAVE IT ALL. BR ALWAYS.
2232 DDF6              ;NOTE B7(VALTYP)=0 SO CHKNUM CALL IS OK.
2233 DDF6 D9 B2 D0     QPREC1:  CMP   OPTAB,Y                  ;LAST PRECEDENCE IS GREATER?
2234 DDF9 B0 48                 BCS   PULSTK                   ;YES, GO OPERATE.
2235 DDFB 90 D9                 BCC   DOPREC                   ;NO SAVE ARGUMENT AND GET OTHER OPERAND.
2236 DDFD B9 B4 D0     DOPRE1:  LDA   OPTAB+2,Y
2237 DE00 48                    PHA                            ;DISP ADDR GOES ONTO STACK.
2238 DE01 B9 B3 D0              LDA   OPTAB+1,Y
2239 DE04 48                    PHA   
2240 DE05 20 10 DE              JSR   PUSHF1                   ;SAVE FAC ON STACK UNPACKED.
2241 DE08 A5 89                 LDA   OPMASK                   ;ACCA MAY BE MASK FOR REL.
2242 DE0A 4C 86 DD              JMP   LPOPER
2243 DE0D 4C C9 DE     SNERR5:  JMP   SNERR                    ;GO TO AN ERROR.
2244 DE10 A5 A2        PUSHF1:  LDA   FACSGN
2245 DE12 BE B2 D0              LDX   OPTAB,Y                  ;GET HIGH PRECEDENCE.
2246 DE15 A8           PUSHF:   TAY                            ;GET POINTER INTO STACK.
2247 DE16 68                    PLA   
2248 DE17 85 5E                 STA   INDEX1
2249 DE19 E6 5E                 INC   INDEX1
2250 DE1B 68                    PLA   
2251 DE1C 85 5F                 STA   INDEX1+1
2252 DE1E 98                    TYA   
2253 DE1F              ;STORE FAC ON STACK UNPACKED.
2254 DE1F 48                    PHA                            ;START WITH SIGN SET UP.
2255 DE20 20 72 EB     FORPSH:  JSR   ROUND                    ;PUT ROUNDED FAC ON STACK.
2256 DE23 A5 A1                 LDA   FACLO                    ;ENY POINT TO SKIP STORING SIGN.
2257 DE25 48                    PHA   
2258 DE26 A5 A0                 LDA   FACMO
2259 DE28 48                    PHA   
2260 DE29 A5 9F                 LDA   FACMOH
2261 DE2B 48                    PHA   
2262 DE2C A5 9E                 LDA   FACHO
2263 DE2E 48                    PHA   
2264 DE2F A5 9D                 LDA   FACEXP
2265 DE31 48                    PHA   
2266 DE32 6C                    DC B:$6C                       ;JMP (INDIRECT)
2267 DE33 5E 00                 DC W:INDEX1
2268 DE35 A0 FF        QOP:     LDY   #255
2269 DE37 68                    PLA                            ;GET HIGH PRECEDENCE OF LAST OP.
2270 DE38 F0 23        QOPGO:   BEQ   QOPRTS                   ;DONE !
2271 DE3A C9 64        QCHNUM:  CMP   #100                     ;RELATIONAL OPERATOR?
2272 DE3C F0 03                 BEQ   UNPSTK                   ;YES, DON'T CHECK OPERAND.
2273 DE3E 20 6A DD              JSR   CHKNUM                   ;MUST BE NUMBER.
2274 DE41 84 87        UNPSTK:  STY   OPPTR                    ;SAVE OPERATOR'S POINTER FOR NEXT TIME
2275 DE43 68           PULSTK:  PLA                            ;GET MASK FOR REL OP IF IT IS ONE.
2276 DE44 4A                    LSR   A                        ;SETUP C FOR DOREL 'CHKVAL'.
2277 DE45 85 16                 STA   DOMASK                   ;SAVE FOR 'DOCMP'.
2278 DE47 68                    PLA                            ;UNPACK STACK INTO ARG.
2279 DE48 85 A5                 STA   ARGEXP
2280 DE4A 68                    PLA   
2281 DE4B 85 A6                 STA   ARGHO
2282 DE4D 68                    PLA   
2283 DE4E 85 A7                 STA   ARGMOH
2284 DE50 68                    PLA   
2285 DE51 85 A8                 STA   ARGMO
2286 DE53 68                    PLA   
2287 DE54 85 A9                 STA   ARGLO
2288 DE56 68                    PLA   
2289 DE57 85 AA                 STA   ARGSGN
2290 DE59 45 A2                 EOR   FACSGN                   ;GET PROBABLE RESULT SIGN.
2291 DE5B 85 AB                 STA   ARISGN                   ;ARITHMETIC SIGN. USED BY
2292 DE5D              ;ADD, SUB, MULT, DIV.
2293 DE5D A5 9D        QOPRTS:  LDA   FACEXP                   ;GET IT AND SET CODES.
2294 DE5F 60           UNPRTS:  RTS                            ;RETURN.
2295 DE60 A9 00        EVAL:    LDA   #$00
2296 DE62 85 11                 STA   VALTYP                   ;ASSUME VALUE WILL BE NUMERIC.
2297 DE64 20 B1 00     EVAL0:   JSR   CHRGET                   ;GET A CHARACTER.
2298 DE67 B0 03                 BCS   EVAL2
2299 DE69 4C 4A EC     EVAL1:   JMP   FIN                      ;IT IS A NUMBER.
2300 DE6C 20 7D E0     EVAL2:   JSR   ISLETC                   ;VARIABLE NAME?
2301 DE6F B0 64                 BCS   ISVAR                    ;YES.
2302 DE71 C9 2E        QDOT:    CMP   #'.'                     ;LEADING CHARACTER OF CONSTANT?
2303 DE73 F0 F4                 BEQ   EVAL1
2304 DE75 C9 C9                 CMP   #MINUTK                  ;NEGATION?
2305 DE77 F0 55                 BEQ   DOMIN                    ;SHO IS.
2306 DE79 C9 C8                 CMP   #PLUSTK
2307 DE7B F0 E7                 BEQ   EVAL0
2308 DE7D C9 22                 CMP   #34                      ;A QUOTE? A STRING?
2309 DE7F D0 0F                 BNE   EVAL3
2310 DE81 A5 B8        STRTXT:  LDA   TXTPTR
2311 DE83 A4 B9                 LDY   TXTPTR+1
2312 DE85 69 00                 ADC   #0                       ;TO INC, ADD C=1.
2313 DE87 90 01                 BCC   STRTX2
2314 DE89 C8                    INY   
2315 DE8A 20 E7 E3     STRTX2:  JSR   STRLIT                   ;YES. GO PROCESS IT.
2316 DE8D 4C 3D E7              JMP   ST2TXT
2317 DE90 C9 C6        EVAL3:   CMP   #NOTTK                   ;CHECK FOR 'NOT' OPERATOR.
2318 DE92 D0 10                 BNE   EVAL4
2319 DE94 A0 18                 LDY   #NOTTAB-OPTAB            ;NOT' HAS PRECEDENCE 90.
2320 DE96 D0 38                 BNE   GONPRC                   ;GO DO ITS EVALUATION.
2321 DE98 A5 9D        NOTOP:   LDA   FACEXP
2322 DE9A D0 03                 BNE   TOZER
2323 DE9C A0 01                 LDY   #1
2324 DE9E 2C                    DC B:44                        ;SKIP 2 INSTRUCTION
2325 DE9F A0 00        TOZER:   LDY   #0
2326 DEA1 4C 01 E3              JMP   SNGFLT
2327 DEA4 C9 C2        EVAL4:   CMP   #FNTK                    ;USER-DEFINED FUNCTION?
2328 DEA6 D0 03                 BNE   *+5
2329 DEA8 4C 54 E3              JMP   FNDOER
2330 DEAB C9 D2                 CMP   #ONEFUN                  ;A FUNCTION NAME?
2331 DEAD 90 03                 BCC   PARCHK                   ;FUNCTIONS ARE THE HIGHEST NUMBERED
2332 DEAF 4C 0C DF              JMP   ISFUN                    ;CHARACTERS SO NO NEED TO CHECK
2333 DEB2              ;AN UPPER-BOUND.
2334 DEB2 20 BB DE     PARCHK:  JSR   CHKOPN                   ;ONLY POSSIBILITY LEFT IS
2335 DEB5 20 7B DD              JSR   FRMEVL                   ;A FORMULA IN PARENTHESIS.
2336 DEB8              ;RECURSIVELY EVALUATE THE FORMULA.
2337 DEB8 A9 29        CHKCLS:  LDA   #41                      ;CHECK FOR A RIGHT PARENTHESE
2338 DEBA 2C                    DC B:44
2339 DEBB A9 28        CHKOPN:  LDA   #40
2340 DEBD 2C                    DC B:44
2341 DEBE A9 2C        CHKCOM:  LDA   #44
2342 DEC0              ; 'SYNCHK' LOOKS AT THE CURRENT CHARACTER TO MAKE SURE IT
2343 DEC0              ; IS THE SPECIFIC THING LOADED INTO ACCA JUST BEFORE CALL
2344 DEC0              ; 'SYNCHK'. IF NOT, IT CALLS THE 'SYNTAX ERROR' ROUTINE.
2345 DEC0              ; OTHERWISE IT GOBBLES THE NEXT CHAR AND RETURNS,
2346 DEC0              ; A=NEW CHAR AND TXTPTR IS ADVANCED BY 'CHRGET'.
2347 DEC0 A0 00        SYNCHR:  LDY   #0
2348 DEC2 D1 B8                 CMP   (TXTPTR),Y               ;CHARACTERS EQUAL?
2349 DEC4 D0 03                 BNE   SNERR
2350 DEC6 4C B1 00     CHRGO5:  JMP   CHRGET
2351 DEC9 A2 10        SNERR:   LDX   #ERRSN                   ;'SYNTAX ERROR'
2352 DECB 4C 12 D4              JMP   ERROR
2353 DECE A0 15        DOMIN:   LDY   #NEGTAB-OPTAB            ;A PRECEDENCE BELOW ''.
2354 DED0 68           GONPRC:  PLA                            ;GET RID OF RTS ADDR.
2355 DED1 68                    PLA   
2356 DED2 4C D7 DD              JMP   NEGPRC                   ;EVALUTE FOR NEGATION.
2357 DED5 20 E3 DF     ISVAR:   JSR   PTRGET                   ;GET A PNTR TO VARIABLE.
2358 DED8 85 A0        ISVRET:  STA   FACMO
2359 DEDA 84 A1                 STY   FACMO+1
2360 DEDC A6 11                 LDX   VALTYP
2361 DEDE F0 05                 BEQ   GOOO                     ;THE STRING IS SET UP.
2362 DEE0 A2 00                 LDX   #0
2363 DEE2 86 AC                 STX   FACOV
2364 DEE4 60           STRRTS:  RTS   
2365 DEE5              GOOO:    EQU   *
2366 DEE5 A6 12                 LDX   INTFLG
2367 DEE7 10 0D                 BPL   GOOOOO
2368 DEE9 A0 00                 LDY   #0
2369 DEEB B1 A0                 LDA   (FACMO),Y                ;FETCH HIGH.
2370 DEED AA                    TAX   
2371 DEEE C8                    INY   
2372 DEEF B1 A0                 LDA   (FACMO),Y
2373 DEF1 A8                    TAY                            ;PUT LOW IN Y.
2374 DEF2 8A                    TXA                            ;GET HIGH IN A.
2375 DEF3 4C F2 E2              JMP   GIVAYF                   ;FLOAT AND RETURN.
2376 DEF6              GOOOOO:  EQU   *
2377 DEF6              QSTATV:  EQU   *
2378 DEF6 4C F9 EA              JMP   MOVFM                    ;MOVE ACTUAL VALUE IN.
2379 DEF9 20 B1 00     DOSCRN:  JSR   CHRGET                   ;WITH TWO ARGS.
2380 DEFC 20 EC F1              JSR   PLOTFNS                  ;CALC X & Y
2381 DEFF 8A                    TXA   
2382 DF00 A4 F0                 LDY   FIRST
2383 DF02 20 A6 F7              JSR   RDSCRN
2384 DF05 A8                    TAY   
2385 DF06 20 01 E3              JSR   SNGFLT
2386 DF09 4C B8 DE              JMP   CHKCLS
2387 DF0C C9 D7        ISFUN:   CMP   #SCRNFN                  ;MULTIPLY BY TWO.
2388 DF0E F0 E9                 BEQ   DOSCRN
2389 DF10 0A                    ASL   A
2390 DF11 48                    PHA   
2391 DF12 AA                    TAX   
2392 DF13 20 B1 00              JSR   CHRGET                   ;SET UP FORYNCHK.
2393 DF16 E0 CF                 CPX   #2*LASNUM-256+1          ;IS IT PAST 'LASNUM'?
2394 DF18 90 20                 BCC   OKNORM                   ;NO, MUST BE NORMAL FUNCTION.
2395 DF1A              ; MOST FUNCTIONS TAKE A SINGLE ARGUMENT.
2396 DF1A              ; THE RETURN ADDRESS OF THESE FUNCTIONS IS 'CHKNUM'
2397 DF1A              ; WHICH ASCERTAINS THAT VALTYP=0  (NUMERIC).
2398 DF1A              ; NORMAL FUNCTIONS THAT RETURN STRING RESULTS
2399 DF1A              ; (E.G., CHR$) MUST POP OFF THAT RETURN ADDR AND
2400 DF1A              ; RETURN DIRECTLY TO 'FRMEVL'.
2401 DF1A              ; SO-CALLED 'FUNNY' FUNCTIONS CAN TAKE MORE THAN ONE ARG
2402 DF1A              ; THE FIRST OF WHICH MUST BE STRING AND THE SECOND OF ICH
2403 DF1A              ; MUST BE A NUMBER BETWEEN 0 AND 255.
2404 DF1A              ; CLOSED PARENTHESIS MUST BE CHECKED AND RETURN IS DIRECT
2405 DF1A              ; TO 'FRMEVL' WITH THE TEXT PNTR POINTING BEYOND THE ')'.
2406 DF1A              ; THE POINTER TO THE DESCRIPTOR OF THE STRING ARGUMENT
2407 DF1A              ; IS STORED ON THE STACK UNDERNEATH THE VALUE OF THE
2408 DF1A              ; INTEGER ARGUMENT.
2409 DF1A 20 BB DE              JSR   CHKOPN                   ;CHECK FOR AN OPEN PARENTHESE
2410 DF1D 20 7B DD              JSR   FRMEVL                   ;EAT OPEN PAREN AND FIRST ARG.
2411 DF20 20 BE DE              JSR   CHKCOM                   ;TWO ARGS SO COMMA MUST DELIMIT.
2412 DF23 20 6C DD              JSR   CHKSTR                   ;MAKE SURE FIRST WAS STRING.
2413 DF26 68                    PLA                            ;GET NCTION NUMBER.
2414 DF27 AA                    TAX   
2415 DF28 A5 A1                 LDA   FACMO+1
2416 DF2A 48                    PHA   
2417 DF2B A5 A0                 LDA   FACMO
2418 DF2D 48                    PHA                            ;SAVE POINTER AT STRING DESCRIPTOR
2419 DF2E 8A                    TXA   
2420 DF2F 48                    PHA                            ;RESAVE FUNCTION NUMBER.
2421 DF30              ;THIS MUST BE ON STACK SINCE RECURSIVE.
2422 DF30 20 F8 E6              JSR   GETBYT                   ;X=VALUE OF FORMULA.
2423 DF33 68                    PLA                            ;GET FUNCTION NUMBER.
2424 DF34 A8                    TAY   
2425 DF35 8A                    TXA   
2426 DF36 48                    PHA   
2427 DF37 4C 3F DF              JMP   FINGO                    ;DISPATCH TO FUNCTION.
2428 DF3A 20 B2 DE     OKNORM:  JSR   PARCHK                   ;READ A FORMULA SURROUNDED BY PARENS.
2429 DF3D 68                    PLA                            ;GET DISPATCH FUNCTION.
2430 DF3E A8                    TAY   
2431 DF3F B9 DC CF     FINGO:   LDA   FUNDSP-ONEFUN-ONEFUN+256,Y ;MODIFY DISPATCH ADR
2432 DF42 85 91                 STA   JMPER+1
2433 DF44 B9 DD CF              LDA   FUNDSP-ONEFUN-ONEFUN+257,Y
2434 DF47 85 92                 STA   JMPER+2
2435 DF49 20 90 00              JSR   JMPER                    ;DISPATCH!
2436 DF4C              ;STRING FUNCTIONS REMOVE THIS RET ADDR.
2437 DF4C 4C 6A DD              JMP   CHKNUM                   ;CHECK IT FOR NUMERICNESS AND RETURN.
2438 DF4F A5 A5        OROP:    LDA   ARGEXP
2439 DF51 05 9D                 ORA   FACEXP
2440 DF53 D0 0B                 BNE   GIVE1
2441 DF55 A5 A5        ANDOP:   LDA   ARGEXP
2442 DF57 F0 04                 BEQ   GIVE0
2443 DF59 A5 9D                 LDA   FACEXP
2444 DF5B D0 03                 BNE   GIVE1
2445 DF5D A0 00        GIVE0:   LDY   #0
2446 DF5F 2C                    DC B:44
2447 DF60 A0 01        GIVE1:   LDY   #1
2448 DF62 4C 01 E3              JMP   SNGFLT
2449 DF65              ; TIME TO PERFORM A RELATIONAL OPERATOR.
2450 DF65              ; DOMASK CONTAINS THE BITS AS TO WHICH RELATIONAL
2451 DF65              ; OPERATOR IT WAS. CARRY BIT ON=STRING COMPARE.
2452 DF65 20 6D DD     DOREL:   JSR   CHKVAL                   ;CHECK FOR MATCH.
2453 DF68 B0 13                 BCS   STRCMP                   ;IT IS A STRING.
2454 DF6A A5 AA                 LDA   ARGSGN                   ;PACK ARG FOR FCOMP.
2455 DF6C 09 7F                 ORA   #127
2456 DF6E 25 A6                 AND   ARGHO
2457 DF70 85 A6                 STA   ARGHO
2458 DF72 A9 A5                 LDA   #ARGEXP
2459 DF74 A0 00                 LDY   #>ARGEXP
2460 DF76 20 B2 EB              JSR   FCOMP
2461 DF79 AA                    TAX   
2462 DF7A 4C B0 DF              JMP   QCOMP
2463 DF7D A9 00        STRCMP:  LDA   #$00
2464 DF7F 85 11                 STA   VALTYP                   ;RESULT WILL BE NUMERIC.
2465 DF81 C6 89                 DEC   OPMASK                   ;TURN OFF VALTYP WHICH WAS STRING.
2466 DF83 20 00 E6              JSR   FREFAC                   ;FREE THE FACLO STRING.
2467 DF86 85 9D                 STA   DSCTMP                   ;SAVE FOR LATER.
2468 DF88 86 9E                 STX   DSCTMP+1
2469 DF8A 84 9F                 STY   DSCTMP+1+1
2470 DF8C A5 A8                 LDA   ARGMO
2471 DF8E A4 A9                 LDY   ARGMO+1                  ;GET POINTER TO OTHER STRING.
2472 DF90 20 04 E6              JSR   FRETMP                   ;FREES FIRST DESC POINTER.
2473 DF93 86 A8                 STX   ARGMO
2474 DF95 84 A9                 STY   ARGMO+1
2475 DF97 AA                    TAX                            ;COPY COUNT INTO X.
2476 DF98 38                    SEC   
2477 DF99 E5 9D                 SBC   DSCTMP                   ;WHICH IS GREATER. IF 0, ALL SET UP.
2478 DF9B F0 08                 BEQ   STASGN                   ;JUST PUT SIGN OF DIFFEREE AWAY.
2479 DF9D A9 01                 LDA   #1
2480 DF9F 90 04                 BCC   STASGN                   ;SIGN IS POSITIVE.
2481 DFA1 A6 9D                 LDX   DSCTMP                   ;LENGTH OF FAC IS SHORTER.
2482 DFA3 A9 FF                 LDA   #$100-1                  ;GET A MINUS 1 FOR NEGATIVES.
2483 DFA5 85 A2        STASGN:  STA   FACSGN                   ;KEEP FOR LATER.
2484 DFA7 A0 FF                 LDY   #255                     ;SET POINTER TO FIRST STRING. (ARG.)
2485 DFA9 E8                    INX                            ;TO LOOP PROPERLY.
2486 DFAA C8           NXTCMP:  INY   
2487 DFAB CA                    DEX                            ;ANY CHARACTERS LEFT TO COMPARE?
2488 DFAC D0 07                 BNE   GETCMP                   ;NOT DONE YET.
2489 DFAE A6 A2                 LDX   FACSGN                   ;USE SIGN OF LENGTH DIFFERENCE
2490 DFB0              ;SINCE ALL CHARACTERS ARE THE SAME.
2491 DFB0 30 0F        QCOMP:   BMI   DOCMP                    ;C IS ALWAYS SET THEN.
2492 DFB2 18                    CLC   
2493 DFB3 90 0C                 BCC   DOCMP                    ;ALWAYS BRCH.
2494 DFB5 B1 A8        GETCMP:  LDA   (ARGMO),Y                ;GET NEXT CHAR TO COMPARE.
2495 DFB7 D1 9E                 CMP   (DSCTMP+1),Y             ;SAME?
2496 DFB9 F0 EF                 BEQ   NXTCMP                   ;YEP. TRY FURTHER.
2497 DFBB A2 FF                 LDX   #$100-1                  ;SET A POSITIVE DIFFERENCE.
2498 DFBD B0 02                 BCS   DOCMP                    ;PUT STACK BACK TOGETHER.
2499 DFBF A2 01                 LDX   #1                       ;SET A NEGATIVE DIFFERENCE.
2500 DFC1 E8           DOCMP:   INX                            ;-1 TO 1, 0 TO 2, 1 TO 4.
2501 DFC2 8A                    TXA   
2502 DFC3 2A                    ROL   A
2503 DFC4 25 16                 AND   DOMASK
2504 DFC6 F0 02                 BEQ   GOFLOT
2505 DFC8 A9 01                 LDA   #1                       ;MAP 0 TO 0. ALL OTHERS TO 1.
2506 DFCA 4C 93 EB     GOFLOT:  JMP   FLOAT                    ;FLOAT THE ONE-BYTE RESULT INTO FAC.
2507 DFCD 20 FB E6     PDLHNDL: JSR   CONINT                   ;GET X= PDL#
2508 DFD0 20 1E FB              JSR   PREAD
2509 DFD3 4C 01 E3              JMP   SNGFLT
2510 DFD6              PREAD:   EQU   $FB1E
2511 DFD6                       EJECT 
2512 DFD6                       TITLE 'DIMENSION AND VARIABLE SEARCHING.'
2513 DFD6              ; THE 'DIM' CODE TS DIMFLG & THEN FALLS INTO THE VARIABLE
2514 DFD6              ; ROUTINE, WHICH LOOKS AT DIMFLG AT THREE DIFFERENT POINTS
2515 DFD6              ; 1) IF AN ENTRY IS FOUND, 'DIMFLG' BEING ON INDICATES
2516 DFD6              ;  A 'DOUBLY' DIMENSIONED VARIABLE.
2517 DFD6              ; 2) WHEN A NEW ENTRY IS BEING BUILT 'DIMFLG' BEING ON
2518 DFD6              ;  INDICTAES THE INDICES SHOULD BE USED FOR THE
2519 DFD6              ;  SIZE OF EACH INDEX. OTHERWISE THE DEFAULT OF TEN
2520 DFD6              ;  IS USED.
2521 DFD6              ; 3) WHEN BUILD ENTRY CODE FINISHES, ONLY IF 'DIMFLG' IS
2522 DFD6              ;  WILL INDEXING BE DONE.
2523 DFD6 20 BE DE     DIM3:    JSR   CHKCOM                   ;MUST  A COMMA
2524 DFD9 AA           DIM:     TAX                            ;SET ACCX NONZERO.
2525 DFDA              ;ACCA MUST BE NONZERO TO WORK RIGHT.
2526 DFDA 20 E8 DF     DIM1:    JSR   PTRGT1
2527 DFDD 20 B7 00     DIMCON:  JSR   CHRGOT                   ;GET LAST CHARACTER.
2528 DFE0 D0 F4                 BNE   DIM3
2529 DFE2 60                    RTS   
2530 DFE3              ; ROUTINE TO READ VARIABLE NAME AT CURRENT TEXT POSISION
2531 DFE3              ; AND  PUT A POINTER TO ITS VALUE IN VARPNT. TXTPTR
2532 DFE3              ; POINTS TO THE TERMINATING CHARCTER. NOT THAT EVALUATING
2533 DFE3              ; IN A VARIABLE NAME CAN CAUSE RECURSIVE CALLS TO 'PTRGET'
2534 DFE3              ; THAT POINT ALL VALUES MUST BE STORED ON THE STACK.
2535 DFE3 A2 00        PTRGET:  LDX   #0                       ;MAKE ACCX=0.
2536 DFE5 20 B7 00              JSR   CHRGOT                   ;RETRIEVE LAST CHARACTER.
2537 DFE8 86 10        PTRGT1:  STX   DIMFLG                   ;STORE FLAG AWAY.
2538 DFEA 85 81        PTRGT2:  STA   VARNAM
2539 DFEC 20 B7 00              JSR   CHRGOT                   ;GET CURRENT CHARACTER
2540 DFEF              ;MAYBE WITH FUNCTION BIT OFF.
2541 DFEF 20 7D E0              JSR   ISLETC                   ;CHECK FOR LETTER.
2542 DFF2 B0 03                 BCS   PTRGT3                   ;MUST HAVE A LETTER.
2543 DFF4 4C C9 DE     INTERR:  JMP   SNERR
2544 DFF7 A2 00        PTRGT3:  LDX   #0                       ;ASSUME NO SECOND CHARACTER.
2545 DFF9 86 11                 STX   VALTYP                   ;DEFAULT IS NUMERIC.
2546 DFFB 86 12                 STX   INTFLG                   ;ASSUME FLOATING.
2547 DFFD 4C 07 E0              JMP   ARNDME                   ;FOR CONTROL-B & CONTROL-C
2548 E000 4C 28 F1              JMP   INIT
2549 E003 4C 3C D4              JMP   READY
2550 E006 00                    DC B:$00                       ;FILL SPACE SAME AS ROM CHIPS
2551 E007 20 B1 00     ARNDME:  JSR   CHRGET                   ;GET FOLLOWING CHARACTER.
2552 E00A 90 05                 BCC   ISSEC                    ;CARRY RESET BY CHRGET IF NUMERIC.
2553 E00C 20 7D E0              JSR   ISLETC                   ;SET CARRY IF NOT ALPHABETIC.
2554 E00F 90 0B                 BCC   NOSEC                    ;ALLOW ALPHABETICS.
2555 E011 AA           ISSEC:   TAX                            ;IT IS A NUMBER -- SAVE IN ACCX.
2556 E012 20 B1 00     EATEM:   JSR   CHRGET                   ;LOOK AT NEXT CHARACTER.
2557 E015 90 FB                 BCC   EATEM                    ;SKIP NUMERICS.
2558 E017 20 7D E0              JSR   ISLETC
2559 E01A B0 F6                 BCS   EATEM                    ;SKIP ALPHABETICS.
2560 E01C C9 24        NOSEC:   CMP   #'$'                     ;IS IT A STRING?
2561 E01E D0 06                 BNE   NOTSTR                   ;IF NOT, VALTYP=0.
2562 E020 A9 FF                 LDA   #$100-1                  ;SET VALTYP=255 (STRING !).
2563 E022 85 11                 STA   VALTYP
2564 E024 D0 10                 BNE   TURNON                   ;ALWAYS GOES.
2565 E026 C9 25        NOTSTR:  CMP   #'%'                     ;INTEGER VARIABLE?
2566 E028 D0 13                 BNE   STRNAM                   ;NO.
2567 E02A A5 14                 LDA   SUBFLG
2568 E02C 30 C6                 BMI   INTERR
2569 E02E A9 80                 LDA   #128
2570 E030 85 12                 STA   INTFLG                   ;SET FLAG.
2571 E032 05 81                 ORA   VARNAM                   ;TURN ON BOTH HIGH BITS.
2572 E034 85 81                 STA   VARNAM
2573 E036 8A           TURNON:  TXA   
2574 E037 09 80                 ORA   #128                     ;TURN ON MSB OF SECOND CHARACTER.
2575 E039 AA                    TAX   
2576 E03A 20 B1 00              JSR   CHRGET                   ;GET CHARACTER AFTER $.
2577 E03D 86 82        STRNAM:  STX   VARNAM+1                 ;STORE AWAY SECOND CHARACTER.
2578 E03F 38                    SEC   
2579 E040 05 14                 ORA   SUBFLG                   ;ADD FLAG WHETHER TO ALLOW ARRAYS.
2580 E042 E9 28                 SBC   #40                      ;(CHECK FOR '(') WON'T MATCH IF SUBFLG SET. 
2581 E044 D0 03                 BNE   *+5
2582 E046 4C 1E E1     GARRAY:  JMP   ISARY                    ;IT IS!
2583 E049 24 14                 BIT   SUBFLG                   ;IN STORE OR RECALL?
2584 E04B 30 02                 BMI   *+4                      ;IN CASE OF USER FUNCTIONS
2585 E04D 70 F7                 BVS   GARRAY
2586 E04F A9 00                 LDA   #0
2587 E051 85 14                 STA   SUBFLG                   ;ALLOW SUBSCRIPTS AGAIN.
2588 E053 A5 69                 LDA   VARTAB                   ;PLACE TO START SEARCH.
2589 E055 A6 6A                 LDX   VARTAB+1
2590 E057 A0 00                 LDY   #0
2591 E059 86 9C        STXFND:  STX   LOWTR+1
2592 E05B 85 9B        LOPFND:  STA   LOWTR
2593 E05D E4 6C                 CPX   ARYTAB+1                 ;AT END OF TABLE YET?
2594 E05F D0 04                 BNE   LOPFN
2595 E061 C5 6B                 CMP   ARYTAB
2596 E063 F0 22                 BEQ   NOTFNS                   ;YES. WE COULDN'T FIND IT.
2597 E065 A5 81        LOPFN:   LDA   VARNAM
2598 E067 D1 9B                 CMP   (LOWTR),Y                ;COMPARE HIGH ORDERS.
2599 E069 D0 08                 BNE   NOTIT                    ;NO COMPARISON.
2600 E06B A5 82                 LDA   VARNAM+1
2601 E06D C8                    INY   
2602 E06E D1 9B                 CMP   (LOWTR),Y                ;AND THE LOW PART?
2603 E070 F0 6C                 BEQ   FINPTR                   ;THAT'S IT ! THAT'S IT !
2604 E072 88                    DEY   
2605 E073 18           NOTIT:   CLC   
2606 E074 A5 9B                 LDA   LOWTR
2607 E076 69 07                 ADC   #6+1                     ;MAKES NO DIF AMONG TYPES.
2608 E078 90 E1                 BCC   LOPFND
2609 E07A E8                    INX   
2610 E07B D0 DC                 BNE   STXFND                   ;ALWAYS BRANCHES.
2611 E07D              ; TEST FOR A LETTER. / CARRY OFF= NOT A LETTER.
2612 E07D              ;     CARRY ON= A LETTER.
2613 E07D C9 41        ISLETC:  CMP   #'A'
2614 E07F 90 05                 BCC   ISLRTS                   ;IF LESS THAN 'A', RET.
2615 E081 E9 5B                 SBC   #'Z'+1
2616 E083 38                    SEC   
2617 E084 E9 A5                 SBC   #$100-'Z'-1              ;RESET CARRY IF A .GT. 'Z'.
2618 E086 60           ISLRTS:  RTS                            ;RETURN TO CALLER.
2619 E087 68           NOTFNS:  PLA                            ;CHECK WHO'S CALLING.
2620 E088 48                    PHA                            ;RESTORE MT.
2621 E089 C9 D7                 CMP   #ISVRET-1                ;IS EVAL CALLING?
2622 E08B D0 0F                 BNE   NOTEVL                   ;NO, CARRY ON.
2623 E08D BA                    TSX   
2624 E08E BD 02 01              LDA   258,X
2625 E091 C9 DE                 CMP   #>ISVRET
2626 E093 D0 07                 BNE   NOTEVL
2627 E095 A9 9A        LDZR:    LDA   #ZERO
2628 E097 A0 E0                 LDY   #>ZERO                   ;SET UT PNTR TO SIMULATED ERO.
2629 E099 60                    RTS                            ;R STRINGS OR NUMERIC.
2630 E09A 00           ZERO:    DC B:0                         ;AND FOR INTEGERS TOO.
2631 E09B 00                    DC B:0
2632 E09C              NOTEVL:  EQU   *
2633 E09C              QSTAVR:  EQU   *
2634 E09C A5 6B        VAROK:   LDA   ARYTAB
2635 E09E A4 6C                 LDY   ARYTAB+1
2636 E0A0 85 9B                 STA   LOWTR
2637 E0A2 84 9C                 STY   LOWTR+1                  ;LOWEST THING TO MOVE.
2638 E0A4 A5 6D                 LDA   STREND
2639 E0A6 A4 6E                 LDY   STREND+1                 ;GET HIGHEST ADDR TO MOVE.
2640 E0A8 85 96                 STA   HIGHTR
2641 E0AA 84 97                 STY   HIGHTR+1
2642 E0AC 18                    CLC   
2643 E0AD 69 07                 ADC   #6+1
2644 E0AF 90 01                 BCC   NOTEVE
2645 E0B1 C8                    INY   
2646 E0B2 85 94        NOTEVE:  STA   HIGHDS
2647 E0B4 84 95                 STY   HIGHDS+1                 ;PLACE TO STUFF IT.
2648 E0B6 20 93 D3              JSR   BLTU                     ;MOVE IT ALL.
2649 E0B9              ;NOTE Y,A HAS HIGHDS FOR REASON.
2650 E0B9 A5 94                 LDA   HIGHDS
2651 E0BB A4 95                 LDY   HIGHDS+1                 ;AND SET UP
2652 E0BD C8                    INY   
2653 E0BE 85 6B                 STA   ARYTAB
2654 E0C0 84 6C                 STY   ARYTAB+1                 ;NEW START OF ARRAY TABLE.
2655 E0C2 A0 00                 LDY   #0                       ;GET ADDR OF VARIABLE ENTR.
2656 E0C4 A5 81                 LDA   VARNAM
2657 E0C6 91 9B                 STA   (LOWTR),Y
2658 E0C8 C8                    INY   
2659 E0C9 A5 82                 LDA   VARNAM+1
2660 E0CB 91 9B                 STA   (LOWTR),Y                ;STORE NAME OF VARIABLE.
2661 E0CD A9 00                 LDA   #0
2662 E0CF C8                    INY   
2663 E0D0 91 9B                 STA   (LOWTR),Y
2664 E0D2 C8                    INY   
2665 E0D3 91 9B                 STA   (LOWTR),Y
2666 E0D5 C8                    INY   
2667 E0D6 91 9B                 STA   (LOWTR),Y
2668 E0D8 C8                    INY   
2669 E0D9 91 9B                 STA   (LOWTR),Y                ;FOURTH ERO FOR DEF FUNG.
2670 E0DB C8                    INY   
2671 E0DC 91 9B                 STA   (LOWTR),Y
2672 E0DE A5 9B        FINPTR:  LDA   LOWTR
2673 E0E0 18                    CLC   
2674 E0E1 69 02                 ADC   #2
2675 E0E3 A4 9C                 LDY   LOWTR+1
2676 E0E5 90 01                 BCC   FINNOW
2677 E0E7 C8                    INY   
2678 E0E8 85 83        FINNOW:  STA   VARPNT
2679 E0EA 84 84                 STY   VARPNT+1                 ;TLIS IS IT.
2680 E0EC 60                    RTS   
2681 E0ED                       EJECT 
2682 E0ED                       TITLE 'MULTIPLE DIMENSION CODE.'
2683 E0ED A5 0F        FMAPTR:  LDA   COUNT
2684 E0EF 0A                    ASL   A
2685 E0F0 69 05                 ADC   #5                       ;POINT TO ENTRMES. G CLR'D BY ASL.
2686 E0F2 65 9B                 ADC   LOWTR
2687 E0F4 A4 9C                 LDY   LOWTR+1
2688 E0F6 90 01                 BCC   JSRGM
2689 E0F8 C8                    INY   
2690 E0F9 85 94        JSRGM:   STA   ARYPNT
2691 E0FB 84 95                 STY   ARYPNT+1
2692 E0FD 60                    RTS   
2693 E0FE 90 80 00 00  N32768:  DC B:144,128,0,0               ;-32768.
2694 E102              ; INTIDX READS A FORMULA FROM THE CURRENT POSITION AND
2695 E102              ; TURNS IT INTO A POSITIVE INTEGER
2696 E102              ; LEAVING THE RESULIN FACMO&LO. NEGATIVE ARGUMENTS
2697 E102              ; ARE NOT ALLOWED.
2698 E102 20 B1 00     INTIDX:  JSR   CHRGET
2699 E105 20 67 DD              JSR   FRMNUM                   ;GET A NUMBER
2700 E108 A5 A2        POSINT:  LDA   FACSGN
2701 E10A 30 0D                 BMI   NONONO                   ;IF NEGATIVE, BLOW HIM OUT.
2702 E10C A5 9D        AYINT:   LDA   FACEXP
2703 E10E C9 90                 CMP   #144                     ;FAC .GT. 32767?
2704 E110 90 09                 BCC   QINTGO
2705 E112 A9 FE                 LDA   #N32768
2706 E114 A0 E0                 LDY   #>N32768                 ;GET ADDR OF -32768.
2707 E116 20 B2 EB              JSR   FCOMP                    ;SEE IF FAC=Y,A.
2708 E119 D0 7E        NONONO:  BNE   FCERR                    ;NO, FAC IS TOO BIG.
2709 E11B 4C F2 EB     QINTGO:  JMP   QINT                     ;GO TO QINT AND SHOVE IT.
2710 E11E              ; FORMAT OF ARRAYS IN CORE.
2711 E11E              ; DESCRIPTOR:
2712 E11E              ; LOWBYTE = FIRST CHARACTER.
2713 E11E              ; HHBYTE = SECOND CHARACTER (200 BIT IS STRING FLAG).
2714 E11E              ; LENGTH OF ARRAY IN CORE IN BYTES (INCLUDES EVERYTHING).
2715 E11E              ; NUMBER OF DIMENSIONS.
2716 E11E              ; FOR EACH DIMENSION STARTING WITH THE FIRST A LIST
2717 E11E              ; (2 BYTES EACH) OF THE MAX INDICE+1
2718 E11E              ; THE VALUES
2719 E11E A5 14        ISARY:   LDA   SUBFLG
2720 E120 D0 47                 BNE   STRTSRCH                 ;IF FOR STORE ORRECALL
2721 E122 A5 10                 LDA   DIMFLG
2722 E124 05 12                 ORA   INTFLG
2723 E126 48                    PHA                            ;SAVE DIMFLG FOR RECURSION.
2724 E127 A5 11                 LDA   VALTYP
2725 E129 48                    PHA                            ;SAVE VALTYP FOR RECURSION.
2726 E12A A0 00                 LDY   #0                       ;SET NUMBER OF DIMENSIONS TO ZERO.
2727 E12C 98           INDLOP:  TYA                            ;SAVE NUMBER OF DIMS.
2728 E12D 48                    PHA   
2729 E12E A5 82                 LDA   VARNAM+1
2730 E130 48                    PHA   
2731 E131 A5 81                 LDA   VARNAM
2732 E133 48                    PHA                            ;SAVE LOOKS.
2733 E134 20 02 E1              JSR   INTIDX                   ;EVALUATE INDICE INTO FACMO&LO.
2734 E137 68                    PLA   
2735 E138 85 81                 STA   VARNAM
2736 E13A 68                    PLA   
2737 E13B 85 82                 STA   VARNAM+1                 ;GET BACK ALL... WE'RE HOME.
2738 E13D 68                    PLA                            ;(# OF DIMS).
2739 E13E A8                    TAY   
2740 E13F BA                    TSX   
2741 E140 BD 02 01              LDA   258,X
2742 E143 48                    PHA                            ;PUSH DIMFLG AND VALTYP FURTHER.
2743 E144 BD 01 01              LDA   257,X
2744 E147 48                    PHA   
2745 E148 A5 A0                 LDA   INDICE                   ;PUT INDICE ONTO STACK.
2746 E14A 9D 02 01              STA   258,X                    ;UNDER DIMFLG AND VALTYP.
2747 E14D A5 A1                 LDA   INDICE+1
2748 E14F 9D 01 01              STA   257,X
2749 E152 C8                    INY                            ;INCREMENT # OF DIMS.
2750 E153 20 B7 00              JSR   CHRGOT                   ;GET TERMINATING CHARACTER.
2751 E156 C9 2C                 CMP   #44                      ;A COMMA?
2752 E158 F0 D2                 BEQ   INDLOP                   ;YES.
2753 E15A 84 0F                 STY   COUNT                    ;AVE COUNT OF DIMS.
2754 E15C 20 B8 DE              JSR   CHKCLS                   ;MUST BE CLOSED PAREN.
2755 E15F 68                    PLA   
2756 E160 85 11                 STA   VALTYP                   ;GET VALTYP AND
2757 E162 68                    PLA   
2758 E163 85 12                 STA   INTFLG
2759 E165 29 7F                 AND   #127
2760 E167 85 10                 STA   DIMFLG                   ;DIMFLG OFF STACK.
2761 E169 A6 6B        STRTSRCH: LDX   ARYTAB                  ;PLACE TO START SEARCH.
2762 E16B A5 6C                 LDA   ARYTAB+1
2763 E16D 86 9B        LOPFDA:  STX   LOWTR
2764 E16F 85 9C                 STA   LOWTR+1
2765 E171 C5 6E                 CMP   STREND+1                 ;END OF ARRAYS?
2766 E173 D0 04                 BNE   LOPFDV
2767 E175 E4 6D                 CPX   STREND
2768 E177 F0 3F                 BEQ   NOTFDD                   ;A FINE THING! NO ARRAY!.
2769 E179 A0 00        LOPFDV:  LDY   #0
2770 E17B B1 9B                 LDA   (LOWTR),Y
2771 E17D C8                    INY   
2772 E17E C5 81                 CMP   VARNAM                   ;COMPARE HIGH ORDERS.
2773 E180 D0 06                 BNE   NMARY1                   ;NO WAY IS IT THIS. GET OUT OF HERE.
2774 E182 A5 82                 LDA   VARNAM+1
2775 E184 D1 9B                 CMP   (LOWTR),Y                ;LOW ORDERS?
2776 E186 F0 16                 BEQ   GOTARY                   ;WELL, HERE IT IS !!
2777 E188 C8           NMARY1:  INY   
2778 E189 B1 9B                 LDA   (LOWTR),Y                ;GET LENGTH.
2779 E18B 18                    CLC   
2780 E18C 65 9B                 ADC   LOWTR
2781 E18E AA                    TAX   
2782 E18F C8                    INY   
2783 E190 B1 9B                 LDA   (LOWTR),Y
2784 E192 65 9C                 ADC   LOWTR+1
2785 E194 90 D7                 BCC   LOPFDA                   ;ALWAYS BRANCHES.
2786 E196 A2 6B        BSERR:   LDX   #ERRBS                   ;GET BAD SUB ERROR NUMBER.
2787 E198 2C                    DC B:44
2788 E199 A2 35        FCERR:   LDX   #ERRFC                   ;TOO BIG. 'FUNCTION CALL' ERROR.
2789 E19B 4C 12 D4     ERRGO3:  JMP   ERROR
2790 E19E A2 78        GOTARY:  LDX   #ERRDD                   ;PERHAPS A 'RE-DIMENSION' ERROR
2791 E1A0 A5 10                 LDA   DIMFLG                   ;TEST THE DIMFLG
2792 E1A2 D0 F7                 BNE   ERRGO3
2793 E1A4 A5 14                 LDA   SUBFLG
2794 E1A6 F0 02                 BEQ   *+4                      ;RETURN TO DATA SAVE ROUTINES.
2795 E1A8 38                    SEC   
2796 E1A9 60                    RTS   
2797 E1AA 20 ED E0              JSR   FMAPTR
2798 E1AD A5 0F                 LDA   COUNT                    ;GET NUMBER OF DIMS INPU
2799 E1AF A0 04                 LDY   #4
2800 E1B1 D1 9B                 CMP   (LOWTR),Y                ;# OF DIMS THE SAME?
2801 E1B3 D0 E1                 BNE   BSERR                    ;SAME SO GO GET DEFINITION.
2802 E1B5 4C 4B E2              JMP   GETDEF
2803 E1B8              ; HERE WHEN VARIABLE IS NOT FOUND IN THE ARRAY TABLE.
2804 E1B8              ; BUILDING AN ENTRY.
2805 E1B8              ; PUT DOWN THE DESCRIPTOR.
2806 E1B8              ; SETUP NUMBER OF DIMENSIONS.
2807 E1B8              ; MAKE SURE THERE IS ROOM FOR THE NEW ENTRY.
2808 E1B8              ; REMEMBER 'VARPNT'.
2809 E1B8              ; TALLY=4.
2810 E1B8              ; SKIP 2 LOCS FOR LATER FILL IN OF SIZE.
2811 E1B8              ; LOOP: GET AN INDICE
2812 E1B8              ; PUT DOWN NUMBER+1 AND INCREMENT VARPTR.
2813 E1B8              ; TALLY=TALLY*NUMBER+1.
2814 E1B8              ; DECREMENT NUMBER-DIMS.
2815 E1B8              ; BNE LOOP
2816 E1B8              ; CALL 'REASON' WITH Y,A REFLECTING LAST LOC OF VARIABLE.
2817 E1B8              ; UPDATE STREND.
2818 E1B8              ; ZERO ALL.
2819 E1B8              ; MAKE TALLY INCLUDE MAXDIMS AND DESCRIPTOR.
2820 E1B8              ; PUT DOWN TALLY.
2821 E1B8              ; IF CALLED BY DIMENSION, RETURN.
2822 E1B8              ; OTHERWISE INDEX INTO THE VARIABLE AS IF IT
2823 E1B8              ;  WERE FOUND ON THE INITIAL SEARCH.
2824 E1B8 A5 14        NOTFDD:  LDA   SUBFLG                   ;DON'T FORM ARRAY FOR STORE
2825 E1BA F0 05                 BEQ   *+7
2826 E1BC A2 2A                 LDX   #ERROD
2827 E1BE 4C 12 D4              JMP   ERROR
2828 E1C1 20 ED E0              JSR   FMAPTR                   ;FORM ARYPNT.
2829 E1C4 20 E3 D3              JSR   REASON
2830 E1C7 A9 00                 LDA   #0
2831 E1C9 A8                    TAY   
2832 E1CA 85 AE                 STA   CURTOL+1
2833 E1CC A2 05                 LDX   #5
2834 E1CE A5 81                 LDA   VARNAM                   ;THIS CODE ONLY WORKS FOR INTPRC=1
2835 E1D0 91 9B                 STA   (LOWTR),Y                ;IF ADDPRC=1.
2836 E1D2 10 01                 BPL   NOTFLT
2837 E1D4 CA                    DEX   
2838 E1D5 C8           NOTFLT:  INY   
2839 E1D6 A5 82                 LDA   VARNAM+1
2840 E1D8 91 9B                 STA   (LOWTR),Y
2841 E1DA 10 02                 BPL   STOMLT
2842 E1DC CA                    DEX   
2843 E1DD CA                    DEX   
2844 E1DE 86 AD        STOMLT:  STX   CURTOL
2845 E1E0 A5 0F                 LDA   COUNT
2846 E1E2 C8                    INY   
2847 E1E3 C8                    INY   
2848 E1E4 C8                    INY   
2849 E1E5 91 9B                 STA   (LOWTR),Y                ;SAVE NUMBER OF DIMENSIONS.
2850 E1E7 A2 0B        LOPPTA:  LDX   #11                      ;DEFAULT SIZE.
2851 E1E9 A9 00                 LDA   #0
2852 E1EB 24 10                 BIT   DIMFLG
2853 E1ED 50 08                 BVC   NOTDIM                   ;NOT IN A DIM STATEMENT.
2854 E1EF 68                    PLA                            ;GET LOW ORDER OF INDICE.
2855 E1F0 18                    CLC   
2856 E1F1 69 01                 ADC   #1
2857 E1F3 AA                    TAX   
2858 E1F4 68                    PLA                            ;GET HIGH PART OF INDICE.
2859 E1F5 69 00                 ADC   #0
2860 E1F7 C8           NOTDIM:  INY   
2861 E1F8 91 9B                 STA   (LOWTR),Y                ;STORE HIGH PART OF INDICE.
2862 E1FA C8                    INY   
2863 E1FB 8A                    TXA   
2864 E1FC 91 9B                 STA   (LOWTR),Y                ;STORE LOW ORDER OF INDICE.
2865 E1FE 20 AD E2              JSR   UMULT                    ;X,A=CURTOL*LOWTR,Y
2866 E201 86 AD                 STX   CURTOL                   ;SAVE NEW TALLY.
2867 E203 85 AE                 STA   CURTOL+1
2868 E205 A4 5E                 LDY   INDEX
2869 E207 C6 0F                 DEC   COUNT                    ;ANY MORE INDICES LEFT?
2870 E209 D0 DC                 BNE   LOPPTA                   ;YES.
2871 E20B 65 95                 ADC   ARYPNT+1
2872 E20D B0 5D                 BCS   OMERR1                   ;OVERFLOW.
2873 E20F 85 95                 STA   ARYPNT+1                 ;COMPUTE WHERE TO ZERO.
2874 E211 A8                    TAY   
2875 E212 8A                    TXA   
2876 E213 65 94                 ADC   ARYPNT
2877 E215              *********
2878 E215 90 03                 BCC   GREASE
2879 E217 C8                    INY   
2880 E218 F0 52                 BEQ   OMERR1
2881 E21A 20 E3 D3     GREASE:  JSR   REASON                   ;GET ROOM.
2882 E21D 85 6D                 STA   STREND
2883 E21F 84 6E                 STY   STREND+1                 ;NEW END OF STORAGE.
2884 E221 A9 00                 LDA   #0                       ;STORING ACCA IS FASTER THAN CLEAR.
2885 E223 E6 AE                 INC   CURTOL+1
2886 E225 A4 AD                 LDY   CURTOL
2887 E227 F0 05                 BEQ   DECCUR
2888 E229 88           ZERITA:  DEY   
2889 E22A 91 94                 STA   (ARYPNT),Y
2890 E22C D0 FB                 BNE   ZERITA                   ;NO. CONTINUE.
2891 E22E C6 95        DECCUR:  DEC   ARYPNT+1
2892 E230 C6 AE                 DEC   CURTOL+1
2893 E232 D0 F5                 BNE   ZERITA                   ;DO ANOTHER BLOCK.
2894 E234 E6 95                 INC   ARYPNT+1                 ;BUMP BACK UP. WILL USE LATER.
2895 E236 38                    SEC   
2896 E237 A5 6D                 LDA   STREND                   ;RESTORE ACCA.
2897 E239 E5 9B                 SBC   LOWTR                    ;DETERMINE LENGTH.
2898 E23B A0 02                 LDY   #2
2899 E23D 91 9B                 STA   (LOWTR),Y                ;LOW.
2900 E23F A5 6E                 LDA   STREND+1
2901 E241 C8                    INY   
2902 E242 E5 9C                 SBC   LOWTR+1
2903 E244 91 9B                 STA   (LOWTR),Y                ;HIGH.
2904 E246 A5 10                 LDA   DIMFLG
2905 E248 D0 62                 BNE   DIMRTS                   ;BYE.
2906 E24A C8                    INY   
2907 E24B              ; AT THIS POINT LOWTR,Y POINTS BEYOND THE SIZE TO NUMBER
2908 E24B              ; DIMENSIONS. STRATEGY:
2909 E24B              ; NUMDIM=NUMBER OF DIMENSIONS.
2910 E24B              ; CURTOL.
2911 E24B              ; INLPNM:GET A NEW INDICE.
2912 E24B              ; MAKE SURE INDICE IS NOT TOO BIG.
2913 E24B              ; MULTIPLY CURTOL BY CURMAX.
2914 E24B              ; ADD INDICE TO CURTOL.
2915 E24B              ; NUMDIM=NUMDIM-1.
2916 E24B              ; BNE INLPNM.
2917 E24B              ; USE CURTOL*4 AS OFFSET.
2918 E24B B1 9B        GETDEF:  LDA   (LOWTR),Y
2919 E24D 85 0F                 STA   COUNT                    ;SAVE A COUNTER.
2920 E24F A9 00                 LDA   #0                       ;ZERO CURTOL.
2921 E251 85 AD                 STA   CURTOL
2922 E253 85 AE        INLPNM:  STA   CURTOL+1
2923 E255 C8                    INY   
2924 E256 68                    PLA                            ;GET LOW INDICE.
2925 E257 AA                    TAX   
2926 E258 85 A0                 STA   INDICE
2927 E25A 68                    PLA                            ;AND THE HIGH PART
2928 E25B 85 A1                 STA   INDICE+1
2929 E25D D1 9B                 CMP   (LOWTR),Y                ;COMPARE WITH MAX INDICE.
2930 E25F 90 0E                 BCC   INLPN2
2931 E261 D0 06                 BNE   BSERR7                   ;IF GREATER, 'BADUBSCRIPT' ERROR.
2932 E263 C8                    INY   
2933 E264 8A                    TXA   
2934 E265 D1 9B                 CMP   (LOWTR),Y
2935 E267 90 07                 BCC   INLPN1
2936 E269 4C 96 E1     BSERR7:  JMP   BSERR
2937 E26C 4C 10 D4     OMERR1:  JMP   OMERR
2938 E26F C8           INLPN2:  INY   
2939 E270 A5 AE        INLPN1:  LDA   CURTOL+1                 ;DON'T MULTIPLY IF CURTOL=0.
2940 E272 05 AD                 ORA   CURTOL
2941 E274 18                    CLC                            ;PREPARE TO GET INDICE BACK.
2942 E275 F0 0A                 BEQ   ADDIND                   ;GET HIGH PART OF INDICE BACK.
2943 E277 20 AD E2              JSR   UMULT                    ;MULTIPLY CURTOL BY LOWTR,Y,Y+1.
2944 E27A 8A                    TXA   
2945 E27B 65 A0                 ADC   INDICE                   ;ADD IN INDICE.
2946 E27D AA                    TAX   
2947 E27E 98                    TYA   
2948 E27F A4 5E                 LDY   INDEX1
2949 E281 65 A1        ADDIND:  ADC   INDICE+1
2950 E283 86 AD                 STX   CURTOL
2951 E285 C6 0F                 DEC   COUNT                    ;ANY MORE?
2952 E287 D0 CA                 BNE   INLPNM                   ;YES.
2953 E289 85 AE                 STA   CURTOL+1                 ;SET UP HIGH-ORDER OFFSET
2954 E28B A2 05                 LDX   #5                       ;THIS CO ONLY WORKS FOR INTPRC=1
2955 E28D A5 81                 LDA   VARNAM                   ;IF ADDPRC=1.
2956 E28F 10 01                 BPL   NOTFL1
2957 E291 CA                    DEX   
2958 E292 A5 82        NOTFL1:  LDA   VARNAM+1
2959 E294 10 02                 BPL   STOML1
2960 E296 CA                    DEX   
2961 E297 CA                    DEX   
2962 E298 86 64        STOML1:  STX   ADDEND
2963 E29A A9 00                 LDA   #0
2964 E29C 20 B6 E2              JSR   UMULTD                   ;ON RTS, A&Y=HI . X=LO.
2965 E29F 8A                    TXA   
2966 E2A0 65 94                 ADC   ARYPNT
2967 E2A2 85 83                 STA   VARPNT
2968 E2A4 98                    TYA   
2969 E2A5 65 95                 ADC   ARYPNT+1
2970 E2A7 85 84                 STA   VARPNT+1
2971 E2A9 A8                    TAY   
2972 E2AA A5 83                 LDA   VARPNT
2973 E2AC 60           DIMRTS:  RTS                            ;RETURN TO CALLER.
2974 E2AD                       EJECT 
2975 E2AD                       TITLE 'INTEGER ARITHMETIC ROUTINES.'
2976 E2AD              ;TWO BYTE UNSIGNED INTEGER MULTIPLY.
2977 E2AD              ;THIS IS FOR MULTIPLY DIMENSIONED ARRAYS.
2978 E2AD              ; X,Y=X,A=CURTOL*LOWTR,Y,Y+1.
2979 E2AD 84 5E        UMULT:   STY   INDEX
2980 E2AF B1 9B                 LDA   (LOWTR),Y
2981 E2B1 85 64                 STA   ADDEND                   ;LOW, THEN HIGH.
2982 E2B3 88                    DEY   
2983 E2B4 B1 9B                 LDA   (LOWTR),Y                ;PUT LOWTR,Y,Y+1 IN FASTER MEMORY.
2984 E2B6 85 65        UMULTD:  STA   ADDEND+1
2985 E2B8 A9 10                 LDA   #16
2986 E2BA 85 99                 STA   DECCNT
2987 E2BC A2 00                 LDX   #0                       ;CLR THE ACCS.
2988 E2BE A0 00                 LDY   #0                       ;RESULT INITIALLY ZERO.
2989 E2C0 8A           UMULTC:  TXA   
2990 E2C1 0A                    ASL   A                        ;MULTIPLY BY TWO.
2991 E2C2 AA                    TAX   
2992 E2C3 98                    TYA   
2993 E2C4 2A                    ROL   A
2994 E2C5 A8                    TAY   
2995 E2C6 B0 A4                 BCS   OMERR1                   ;TWO MUCH !
2996 E2C8 06 AD                 ASL   CURTOL
2997 E2CA 26 AE                 ROL   CURTOL+1
2998 E2CC 90 0B                 BCC   UMLCNT                   ;NOTHING IN THIS POSITION TO MULTIPLY.
2999 E2CE 18                    CLC   
3000 E2CF 8A                    TXA   
3001 E2D0 65 64                 ADC   ADDEND
3002 E2D2 AA                    TAX   
3003 E2D3 98                    TYA   
3004 E2D4 65 65                 ADC   ADDEND+1
3005 E2D6 A8                    TAY   
3006 E2D7 B0 93                 BCS   OMERR1                   ;MANJUST TOO MUCH !
3007 E2D9 C6 99        UMLCNT:  DEC   DECCNT                   ;DONE?
3008 E2DB D0 E3                 BNE   UMULTC                   ;KEEP IT UP.
3009 E2DD 60           UMLRTS:  RTS                            ;YES, ALL DONE.
3010 E2DE                       EJECT 
3011 E2DE                       TITLE 'FRE AND INT TO FLOATING ROUTINES.'
3012 E2DE A5 11        FRE:     LDA   VALTYP
3013 E2E0 F0 03                 BEQ   NOFREF
3014 E2E2 20 00 E6              JSR   FREFAC
3015 E2E5 20 84 E4     NOFREF:  JSR   GARBA2
3016 E2E8 38                    SEC   
3017 E2E9 A5 6F                 LDA   FRETOP                   ;WE WANT
3018 E2EB E5 6D                 SBC   STREND                   ;FRETOP-STREND.
3019 E2ED A8                    TAY   
3020 E2EE A5 70                 LDA   FRETOP+1
3021 E2F0 E5 6E                 SBC   STREND+1
3022 E2F2 A2 00        GIVAYF:  LDX   #0
3023 E2F4 86 11                 STX   VALTYP
3024 E2F6 85 9E                 STA   FACHO
3025 E2F8 84 9F                 STY   FACHO+1
3026 E2FA A2 90                 LDX   #144                     ;SET EXPONENT TO 216.
3027 E2FC 4C 9B EB              JMP   FLOATS                   ;TURN IT TO A FLOATING PNT #.
3028 E2FF A4 24        POS:     LDY   TRMPOS                   ;GET POSITION.
3029 E301 A9 00        SNGFLT:  LDA   #0
3030 E303 38                    SEC   
3031 E304 F0 EC                 BEQ   GIVAYF                   ;FLOAT IT.
3032 E306                       EJECT 
3033 E306                       TITLE 'SIMPLE-USER-DEFINED-FUNCTION CODE.'
3034 E306              ; NOTE ONLY SINGLE ARGUMENTS ARE ALLOWED TO FUNCTIONS
3035 E306              ; AND FUNCTIONS MUST BE OF THE SINGLE LINE FORM:
3036 E306              ; DEF FNA(X)=X2+X-2
3037 E306              ; NO STRINGS CAN BE INVOLVED WITH THESE FUNCTIONS.
3038 E306              ; IDEA: CREATE A SIMPLE VARIABLE ENTRY
3039 E306              ; WHOSE FIRST CHARACTER HAS THE 200 BIT SET.
3040 E306              ; THE VALUE WILL BE:
3041 E306              ; A TEXT PNTR TO THE FORMULA.
3042 E306              ; A PNTR TO THE ARGUMENT VARIABLE.
3043 E306              ; FUNCTIONAMES CAN BE LIKE 'FNA4'.
3044 E306              ; SUBROUTINE TO SEE IF WE ARE IN DIRECT MODE.
3045 E306              ; AND COMPLAIN IF SO.
3046 E306 A6 76        ERRDIR:  LDX   CURLIN+1                 ;DIR MODE HAS CURLIN=0,255
3047 E308 E8                    INX                            ;SO NOW, IS RESULT ZERO?
3048 E309 D0 A1                 BNE   DIMRTS                   ;YES.
3049 E30B A2 95                 LDX   #ERRID                   ;INPUT DIRECT ERROR CODE.
3050 E30D 2C                    DC B:44                        ;SKIP 2 OFFSET.
3051 E30E A2 E0        ERRGUF:  LDX   #ERRUF
3052 E310 4C 12 D4     ERRGO1:  JMP   ERROR
3053 E313 20 41 E3     DEF:     JSR   GETFNM                   ;GET A PNTR TO THE FUNCTION.
3054 E316 20 06 E3              JSR   ERRDIR
3055 E319 20 BB DE              JSR   CHKOPN                   ;MUST HAVE '('.
3056 E31C A9 80                 LDA   #128
3057 E31E 85 14                 STA   SUBFLG                   ;PROHIBIT SUBSCRIPTED VARIABLES.
3058 E320 20 E3 DF              JSR   PTRGET                   ;GET PNTR TO ARGUMENT.
3059 E323 20 6A DD              JSR   CHKNUM                   ;IS IT A NUMBER?
3060 E326 20 B8 DE              JSR   CHKCLS                   ;MUST HAVE ')'
3061 E329 A9 D0                 LDA   #EQULTK
3062 E32B 20 C0 DE              JSR   SYNCHR                   ;MUST HAVE '='.
3063 E32E 48                    PHA                            ;PUT CRAZY BYTE ON.
3064 E32F A5 84                 LDA   VARPNT+1
3065 E331 48                    PHA   
3066 E332 A5 83                 LDA   VARPNT
3067 E334 48                    PHA   
3068 E335 A5 B9                 LDA   TXTPTR+1
3069 E337 48                    PHA   
3070 E338 A5 B8                 LDA   TXTPTR
3071 E33A 48                    PHA   
3072 E33B 20 95 D9              JSR   DATA
3073 E33E 4C AF E3              JMP   DEFFIN
3074 E341              ; SUBROUTINE TO GET A PNTR TO A FUNCTION NAME.
3075 E341 A9 C2        GETFNM:  LDA   #FNTK
3076 E343 20 C0 DE              JSR   SYNCHR                   ;MUST START WITH FN.
3077 E346 09 80                 ORA   #128                     ;PUT FUNCTION BIT ON.
3078 E348 85 14                 STA   SUBFLG
3079 E34A 20 EA DF              JSR   PTRGT2                   ;GET POINTER TO FUNCTION OR CREATE ANEW.
3080 E34D 85 8A                 STA   DEFPNT
3081 E34F 84 8B                 STY   DEFPNT+1
3082 E351 4C 6A DD              JMP   CHKNUM                   ;MAKE SURE IT'S NOA STRING AND RETURN.
3083 E354 20 41 E3     FNDOER:  JSR   GETFNM                   ;GET THE FUNCTION'S NAME.
3084 E357 A5 8B                 LDA   DEFPNT+1
3085 E359 48                    PHA   
3086 E35A A5 8A                 LDA   DEFPNT
3087 E35C 48                    PHA   
3088 E35D 20 B2 DE              JSR   PARCHK                   ;EVALUATE PARAMETER.
3089 E360 20 6A DD              JSR   CHKNUM
3090 E363 68                    PLA   
3091 E364 85 8A                 STA   DEFPNT
3092 E366 68                    PLA   
3093 E367 85 8B                 STA   DEFPNT+1
3094 E369 A0 02                 LDY   #2
3095 E36B B1 8A                 LDA   (DEFPNT),Y               ;GET POINTER TO VARIABLE.
3096 E36D 85 83                 STA   VARPNT                   ;SAVE VARIABLE POINTER.
3097 E36F AA                    TAX   
3098 E370 C8                    INY   
3099 E371 B1 8A                 LDA   (DEFPNT),Y
3100 E373 F0 99                 BEQ   ERRGUF                   ;FUNCTION UNDEFINED?
3101 E375 85 84                 STA   VARPNT+1
3102 E377 C8                    INY                            ;SINCE DEF USES ONLY 4.
3103 E378 B1 83        DEFSTF:  LDA   (VARPNT),Y
3104 E37A 48                    PHA                            ;PUSH IT ALL ON STACK.
3105 E37B 88                    DEY                            ;SINCE WE ARE RECURSING MAYBE.
3106 E37C 10 FA                 BPL   DEFSTF
3107 E37E A4 84                 LDY   VARPNT+1
3108 E380 20 2B EB              JSR   MOVMF                    ;PUT CURRENT FAC INTO OUR ARG VARIABLE.
3109 E383 A5 B9                 LDA   TXTPTR+1
3110 E385 48                    PHA   
3111 E386 A5 B8                 LDA   TXTPTR
3112 E388 48                    PHA                            ;SAVE TEXT POINTER.
3113 E389 B1 8A                 LDA   (DEFPNT),Y               ;PNTR TO FUNCTION.
3114 E38B 85 B8                 STA   TXTPTR
3115 E38D C8                    INY   
3116 E38E B1 8A                 LDA   (DEFPNT),Y
3117 E390 85 B9                 STA   TXTPTR+1
3118 E392 A5 84                 LDA   VARPNT+1
3119 E394 48                    PHA   
3120 E395 A5 83                 LDA   VARPNT
3121 E397 48                    PHA                            ;SAVE VARIABLE POINTER.
3122 E398 20 67 DD              JSR   FRMNUM                   ;EVALUATE FORMULA AND CHECK NUMERIC.
3123 E39B 68                    PLA   
3124 E39C 85 8A                 STA   DEFPNT
3125 E39E 68                    PLA   
3126 E39F 85 8B                 STA   DEFPNT+1
3127 E3A1 20 B7 00              JSR   CHRGOT
3128 E3A4 F0 03                 BEQ   *+5
3129 E3A6 4C C9 DE              JMP   SNERR                    ;IT DIDN'T TERMINE. HUH?
3130 E3A9 68                    PLA   
3131 E3AA 85 B8                 STA   TXTPTR
3132 E3AC 68                    PLA   
3133 E3AD 85 B9                 STA   TXTPTR+1                 ;RESTORE TEXT PNTR.
3134 E3AF A0 00        DEFFIN:  LDY   #0
3135 E3B1 68                    PLA                            ;GET OLD ARG VALUE OFF STACK
3136 E3B2 91 8A                 STA   (DEFPNT),Y               ;AND PUT IT BACK IN VARIABLE.
3137 E3B4 68                    PLA   
3138 E3B5 C8                    INY   
3139 E3B6 91 8A                 STA   (DEFPNT),Y
3140 E3B8 68                    PLA   
3141 E3B9 C8                    INY   
3142 E3BA 91 8A                 STA   (DEFPNT),Y
3143 E3BC 68                    PLA   
3144 E3BD C8                    INY   
3145 E3BE 91 8A                 STA   (DEFPNT),Y
3146 E3C0 68                    PLA   
3147 E3C1 C8                    INY   
3148 E3C2 91 8A                 STA   (DEFPNT),Y
3149 E3C4 60           DEFRTS:  RTS   
3150 E3C5                       EJECT 
3151 E3C5                       TITLE 'STRING FUNCTIONS.'
3152 E3C5              ; THE STR$ FUNCTION TAKES A NUMBER AND GIVES A STRING
3153 E3C5              ; WITH THE CHARACTERS THE OUTPUT OF THE NUMBER
3154 E3C5              ; WOULD HAVE GIVEN.
3155 E3C5 20 6A DD     STRS:    JSR   CHKNUM                   ;ARG HAS TO BE NUMERIC.
3156 E3C8 A0 00                 LDY   #0
3157 E3CA 20 36 ED              JSR   FOUTC                    ;DO ITS OUTPUT.
3158 E3CD 68                    PLA   
3159 E3CE 68                    PLA   
3160 E3CF A9 FF        TIMSTR:  LDA   #LOFBUF
3161 E3D1 A0 00                 LDY   #>LOFBUF
3162 E3D3 F0 12                 BEQ   STRLIT                   ;SCAN IT AND TURN IT INTO A STRING.
3163 E3D5              ; 'STRINI' GET STRING SPACE FOR CREATION OF A STRING AND
3164 E3D5              ; CREATES A DESCRIPTOR FOR IT IN 'DSCTMP'.
3165 E3D5 A6 A0        STRINI:  LDX   FACMO
3166 E3D7 A4 A1                 LDY   FACMO+1                  ;GET FACMO TO STORE IN DSCPNT.
3167 E3D9 86 8C                 STX   DSCPNT
3168 E3DB 84 8D                 STY   DSCPNT+1                 ;RETAIN THE DESCRIPTOR POINTER.
3169 E3DD 20 52 E4     STRSPA:  JSR   GETSPA                   ;GET STRING SPACE.
3170 E3E0 86 9E                 STX   DSCTMP+1
3171 E3E2 84 9F                 STY   DSCTMP+1+1               ;SE LOCATION.
3172 E3E4 85 9D                 STA   DSCTMP                   ;SAVE LENGTH.
3173 E3E6 60                    RTS                            ;ALL DONE.
3174 E3E7              ; 'STRLT2' TAKES THE STRING LITERAL WHOSE FIRST CHARACTER
3175 E3E7              ; IS POINTED TO BY Y,A AND BUILDS A DESCRIPTOR FOR IT.
3176 E3E7              ; DESCRIPTOR IS INITIALLY BUILT IN 'DSCTMP', BUT 'PUTNEW'
3177 E3E7              ; TRANSFERS IT INTO A TEMPORARY AND LEAVES A POINTER
3178 E3E7              ; AT THE TEMPORARY IN FACMO&LO. THE CHARACTERS OTHER THAN
3179 E3E7              ; ZERO THAT TERMINATE STRING SHOULD BE SET UP IN 'CHARAC'
3180 E3E7              ; AND 'ENDCHR'. IF TERMINATOR IS QUOTE, THE QUOTE IS SAVED
3181 E3E7              ; OVER. LEING QUOTES SHOULD BE SKIPPED BEFORE JSR.
3182 E3E7              ; ON RETURN THE CHARACTER AFTER THE STRING LITERAL IS
3183 E3E7              ; POINTED TO BY STRNG2.
3184 E3E7 A2 22        STRLIT:  LDX   #34                      ;ASSUME STRING ENDS ON QUOTE.
3185 E3E9 86 0D                 STX   CHARAC
3186 E3EB 86 0E                 STX   ENDCHR
3187 E3ED 85 AB        STRLT2:  STA   STRNG1
3188 E3EF 84 AC                 STY   STRNG1+1                 ;SAVE POINTER TO STRING.
3189 E3F1 85 9E                 STA   DSCTMP+1
3190 E3F3 84 9F                 STY   DSCTMP+1+1               ;IN CASE NO STRCPY.
3191 E3F5 A0 FF                 LDY   #255                     ;INITIALIZE CHARACTER COUNT.
3192 E3F7 C8           STRGET:  INY   
3193 E3F8 B1 AB                 LDA   (STRNG1),Y               ;GET CHARACTER.
3194 E3FA F0 0C                 BEQ   STRFI1                   ;IF ZERO.
3195 E3FC C5 0D                 CMP   CHARAC                   ;THIS TERMINATOR?
3196 E3FE F0 04                 BEQ   STRFIN                   ;YES.
3197 E400 C5 0E                 CMP   ENDCHR
3198 E402 D0 F3                 BNE   STRGET                   ;LOOK FURTHER.
3199 E404 C9 22        STRFIN:  CMP   #34                      ;QUOTE?
3200 E406 F0 01                 BEQ   STRFI2
3201 E408 18           STRFI1:  CLC                            ;NO, BACK UP.
3202 E409 84 9D        STRFI2:  STY   DSCTMP                   ;RETAIN COUNT.
3203 E40B 98                    TYA   
3204 E40C 65 AB                 ADC   STRNG1                   ;WISHING TO SET TXTPTR.
3205 E40E 85 AD                 STA   STRNG2
3206 E410 A6 AC                 LDX   STRNG1+1
3207 E412 90 01                 BCC   STRST2
3208 E414 E8                    INX   
3209 E415 86 AE        STRST2:  STX   STRNG2+1
3210 E417 A5 AC                 LDA   STRNG1+1                 ;IF PAGE 0, COPY SINCE IT IS EITHER
3211 E419              ;A STRING CONSTANT IN BUF OR A STR$
3212 E419              ;RESULT IN LOFBUF
3213 E419 F0 04                 BEQ   STRCP
3214 E41B C9 02                 CMP   #2
3215 E41D D0 0B                 BNE   PUTNEW
3216 E41F 98           STRCP:   TYA   
3217 E420 20 D5 E3              JSR   STRINI
3218 E423 A6 AB                 LDX   STRNG1
3219 E425 A4 AC                 LDY   STRNG1+1
3220 E427 20 E2 E5              JSR   MOVSTR                   ;MOVE STRING. ;
3221 E42A              ; SOME STRING FUNCTION IS RETURNING A RESULT IN DSCTMP.
3222 E42A              ; SETUP A TEMP DESCRIPTOR WITH DSCTMP IN IT.
3223 E42A              ; PUT A POINTER TO THE DESCRIPTOR IN FACMO&LO AND FLAG THE
3224 E42A              ; RESULT AS TYPE STRING.
3225 E42A A6 52        PUTNEW:  LDX   TEMPPT                   ;POINTER TO FIRST FREE TEMP.
3226 E42C E0 5E                 CPX   #STRSIZ*NUMTMP+TEMPST
3227 E42E D0 05                 BNE   PUTNW1
3228 E430 A2 BF                 LDX   #ERRST                   ;STRING TEMPORARY ERROR.
3229 E432 4C 12 D4     ERRGO2:  JMP   ERROR                    ;GO TELL HIM.
3230 E435 A5 9D        PUTNW1:  LDA   DSCTMP
3231 E437 95 00                 STA   0,X
3232 E439 A5 9E                 LDA   DSCTMP+1
3233 E43B 95 01                 STA   1,X
3234 E43D A5 9F                 LDA   DSCTMP+2
3235 E43F 95 02                 STA   2,X
3236 E441 A0 00                 LDY   #0
3237 E443 86 A0                 STX   FACMO
3238 E445 84 A1                 STY   FACMO+1
3239 E447 88                    DEY   
3240 E448 84 11                 STY   VALTYP                   ;TYPE IS 'STRING'.
3241 E44A 86 53                 STX   LASTPT                   ;SET POINTER TO LAST-USED TEMP.
3242 E44C E8                    INX   
3243 E44D E8                    INX   
3244 E44E E8                    INX                            ;POINT FURTHER.
3245 E44F 86 52                 STX   TEMPPT                   ;SAVE POINTER TO NEXT TEMP IF ANY.
3246 E451 60                    RTS                            ;ALL DONE.
3247 E452              ; GETSPA - GET SPACE FOR CHARACTER STRING.
3248 E452              ; MAY FORCE GARBAGE COLLECTION.
3249 E452              ; # OF CHARACTERS (BYTES) IN ACCA.
3250 E452              ; RETURNS WITH POINTER IN Y,X. OTHERWISE (IF CAN'T GET
3251 E452              ; SPACE) BLOWS OFF TO 'OUT OF STRING SPACE' TYPE ERROR.
3252 E452              ; ALSO PRESERVES ACCA AND SETS FRESPC=Y,X=PNTR AT SPACE.
3253 E452 46 13        GETSPA:  LSR   GARBFL                   ;SIGNAL NO GARBAGE COLLECTION YET.
3254 E454 48           TRYAG2:  PHA                            ;SAVE FOR LATER.
3255 E455 49 FF                 EOR   #255
3256 E457 38                    SEC                            ;ADD ONE TO COMPLETE NEGATION
3257 E458 65 6F                 ADC   FRETOP
3258 E45A A4 70                 LDY   FRETOP+1
3259 E45C B0 01                 BCS   TRYAG3
3260 E45E 88                    DEY   
3261 E45F C4 6E        TRYAG3:  CPY   STREND+1                 ;COMPARE HIGH ORDERS.
3262 E461 90 11                 BCC   GARBAG                   ;MAKE ROOM FOR MORE.
3263 E463 D0 04                 BNE   STRFRE                   ;SAVE NEW FRETOP.
3264 E465 C5 6D                 CMP   STREND                   ;COMPARE LOW ORDERS.
3265 E467 90 0B                 BCC   GARBAG                   ;CLEAN UP.
3266 E469 85 6F        STRFRE:  STA   FRETOP
3267 E46B 84 70                 STY   FRETOP+1                 ;SAVE NEW FRETOP.
3268 E46D 85 71                 STA   FRESPC
3269 E46F 84 72                 STY   FRESPC+1                 ;PUT IT THERE OLD MAN.
3270 E471 AA                    TAX                            ;PRESERVE A IN X.
3271 E472 68                    PLA                            ;GET COUNT BACK IN ACCA.
3272 E473 60                    RTS                            ;ALL DONE.
3273 E474 A2 4D        GARBAG:  LDX   #ERROM                   ;'OUT OF STRING SPACE'
3274 E476 A5 13                 LDA   GARBFL
3275 E478 30 B8                 BMI   ERRGO2
3276 E47A 20 84 E4              JSR   GARBA2
3277 E47D A9 80                 LDA   #128
3278 E47F 85 13                 STA   GARBFL
3279 E481 68                    PLA                            ;GET BACK STRING LENGTH.
3280 E482 D0 D0                 BNE   TRYAG2                   ;ALWAYS BRANCHES.
3281 E484              GARBA2:  EQU   *                        ;START FROM TOP DOWN.
3282 E484 A6 73                 LDX   MEMSIZ
3283 E486 A5 74                 LDA   MEMSIZ+1
3284 E488 86 6F        FNDVAR:  STX   FRETOP                   ;LIKE SO.
3285 E48A 85 70                 STA   FRETOP+1
3286 E48C A0 00                 LDY   #0
3287 E48E 84 8B                 STY   GRBPNT+1
3288 E490 A5 6D                 LDA   STREND
3289 E492 A6 6E                 LDX   STREND+1
3290 E494 85 9B                 STA   GRBTOP
3291 E496 86 9C                 STX   GRBTOP+1
3292 E498 A9 55                 LDA   #TEMPST
3293 E49A A2 00                 LDX   #>TEMPST
3294 E49C 85 5E                 STA   INDEX1
3295 E49E 86 5F                 STX   INDEX1+1
3296 E4A0 C5 52        TVAR:    CMP   TEMPPT                   ;DONE WITH TEMPS?
3297 E4A2 F0 05                 BEQ   SVARS                    ;YEP.
3298 E4A4 20 23 E5              JSR   DVAR
3299 E4A7 F0 F7                 BEQ   TVAR                     ;LOOP.
3300 E4A9 A9 07        SVARS:   LDA   #6+1
3301 E4AB 85 8F                 STA   FOUR6
3302 E4AD A5 69                 LDA   VARTAB
3303 E4AF A6 6A                 LDX   VARTAB+1                 ;GET START OF SIMPLE VARIABLES.
3304 E4B1 85 5E                 STA   INDEX1
3305 E4B3 86 5F                 STX   INDEX1+1
3306 E4B5 E4 6C        SVAR:    CPX   ARYTAB+1                 ;DONE WITH SIMPLE VARIABLES?
3307 E4B7 D0 04                 BNE   SVARGO                   ;NO.
3308 E4B9 C5 6B                 CMP   ARYTAB
3309 E4BB F0 05                 BEQ   ARYVAR                   ;YEP.
3310 E4BD 20 19 E5     SVARGO:  JSR   DVARS                    ;DO IT , AGAIN.
3311 E4C0 F0 F3                 BEQ   SVAR                     ;LOOP.
3312 E4C2 85 94        ARYVAR:  STA   ARYPNT
3313 E4C4 86 95                 STX   ARYPNT+1                 ;SAVE FOR ADDITION.
3314 E4C6 A9 03                 LDA   #STRSIZ
3315 E4C8 85 8F                 STA   FOUR6
3316 E4CA A5 94        ARYVA2:  LDA   ARYPNT
3317 E4CC A6 95                 LDX   ARYPNT+1                 ;G THE POINTER TO VARIABLE.
3318 E4CE E4 6E        ARYVA3:  CPX   STREND+1                 ;DONE WITH ARRAYS?
3319 E4D0 D0 07                 BNE   ARYVGO                   ;NO.
3320 E4D2 C5 6D                 CMP   STREND
3321 E4D4 D0 03                 BNE   *+5
3322 E4D6 4C 62 E5              JMP   GRBPAS                   ;YES, GO FINISH UP.
3323 E4D9 85 5E        ARYVGO:  STA   INDEX1
3324 E4DB 86 5F                 STX   INDEX1+1
3325 E4DD A0 00                 LDY   #1-1
3326 E4DF B1 5E                 LDA   (INDEX1),Y
3327 E4E1 AA                    TAX   
3328 E4E2 C8                    INY   
3329 E4E3 B1 5E                 LDA   (INDEX1),Y
3330 E4E5 08                    PHP   
3331 E4E6 C8                    INY   
3332 E4E7 B1 5E                 LDA   (INDEX1),Y
3333 E4E9 65 94                 ADC   ARYPNT
3334 E4EB 85 94                 STA   ARYPNT                   ;FORM POINTER TO NEXT ARRAY VAR.
3335 E4ED C8                    INY   
3336 E4EE B1 5E                 LDA   (INDEX1),Y
3337 E4F0 65 95                 ADC   ARYPNT+1
3338 E4F2 85 95                 STA   ARYPNT+1
3339 E4F4 28                    PLP   
3340 E4F5 10 D3                 BPL   ARYVA2
3341 E4F7 8A                    TXA   
3342 E4F8 30 D0                 BMI   ARYVA2
3343 E4FA C8                    INY   
3344 E4FB B1 5E                 LDA   (INDEX1),Y
3345 E4FD A0 00                 LDY   #0                       ;RESET INDEX Y.
3346 E4FF 0A                    ASL   A
3347 E500 69 05                 ADC   #5                       ;CARRY IS OFF AND OFF AFTER ADD.
3348 E502 65 5E                 ADC   INDEX1
3349 E504 85 5E                 STA   INDEX1
3350 E506 90 02                 BCC   ARYGET
3351 E508 E6 5F                 INC   INDEX1+1
3352 E50A A6 5F        ARYGET:  LDX   INDEX1+1
3353 E50C E4 95        ARYSTR:  CPX   ARYPNT+1                 ;END OF THE ARRAY?
3354 E50E D0 04                 BNE   GOGO
3355 E510 C5 94                 CMP   ARYPNT
3356 E512 F0 BA                 BEQ   ARYVA3                   ;YES.
3357 E514 20 23 E5     GOGO:    JSR   DVAR
3358 E517 F0 F3                 BEQ   ARYSTR                   ;CYCLE.
3359 E519              DVARS:   EQU   *
3360 E519 B1 5E                 LDA   (INDEX1),Y
3361 E51B 30 35                 BMI   DVARTS
3362 E51D C8                    INY   
3363 E51E B1 5E                 LDA   (INDEX1),Y
3364 E520 10 30                 BPL   DVARTS
3365 E522 C8                    INY   
3366 E523 B1 5E        DVAR:    LDA   (INDEX1),Y               ;IS LENGTH=0?
3367 E525 F0 2B                 BEQ   DVARTS                   ;YES, RETURN.
3368 E527 C8                    INY   
3369 E528 B1 5E                 LDA   (INDEX1),Y               ;GET LOW(ADR).
3370 E52A AA                    TAX   
3371 E52B C8                    INY   
3372 E52C B1 5E                 LDA   (INDEX1),Y
3373 E52E C5 70                 CMP   FRETOP+1                 ;COMPARE HIGHS.
3374 E530 90 06                 BCC   DVAR2                    ;IF THIS STRING'S PNTR .GE. FRETOP
3375 E532 D0 1E                 BNE   DVARTS                   ;NO NEED TO MESS WITH IT FURTHER.
3376 E534 E4 6F                 CPX   FRETOP                   ;COMPARE LOWS.
3377 E536 B0 1A                 BCS   DVARTS
3378 E538 C5 9C        DVAR2:   CMP   GRBTOP+1
3379 E53A 90 16                 BCC   DVARTS                   ;IF THIS STRING IS BELOW PREVIOUS,
3380 E53C              ;FORGET IT.
3381 E53C D0 04                 BNE   DVAR3
3382 E53E E4 9B                 CPX   GRBTOP                   ;COMPARE LOW ORDERS.
3383 E540 90 10                 BCC   DVARTS                   ;X,A .LE. GRBTOP.
3384 E542 86 9B        DVAR3:   STX   GRBTOP
3385 E544 85 9C                 STA   GRBTOP+1
3386 E546 A5 5E                 LDA   INDEX1
3387 E548 A6 5F                 LDX   INDEX1+1
3388 E54A 85 8A                 STA   GRBPNT
3389 E54C 86 8B                 STX   GRBPNT+1
3390 E54E A5 8F                 LDA   FOUR6
3391 E550 85 91                 STA   SIZE
3392 E552 A5 8F        DVARTS:  LDA   FOUR6
3393 E554 18                    CLC   
3394 E555 65 5E                 ADC   INDEX1
3395 E557 85 5E                 STA   INDEX1
3396 E559 90 02                 BCC   GRBRTS
3397 E55B E6 5F                 INC   INDEX1+1
3398 E55D A6 5F        GRBRTS:  LDX   INDEX1+1
3399 E55F A0 00                 LDY   #0
3400 E561 60                    RTS                            ;DONE.
3401 E562              ; HERE WHEN MADE ONE COMPLETE PASS THRU STRING VARIABLES.
3402 E562 A6 8B        GRBPAS:  LDX   GRBPNT+1                 ;VARIABLE POINTER.
3403 E564 F0 F7                 BEQ   GRBRTS                   ;ALL DONE.
3404 E566 A5 91                 LDA   SIZE
3405 E568 29 04                 AND   #4                       ;LEAVES C OFF.
3406 E56A 4A                    LSR   A
3407 E56B A8                    TAY   
3408 E56C 85 91                 STA   SIZE
3409 E56E B1 8A                 LDA   (GRBPNT),Y
3410 E570              ;NOTE: GRBTOP=LOWTR SO NO NEED TO SET LOWTR.
3411 E570 65 9B                 ADC   LOWTR
3412 E572 85 96                 STA   HIGHTR
3413 E574 A5 9C                 LDA   LOWTR+1
3414 E576 69 00                 ADC   #0
3415 E578 85 97                 STA   HIGHTR+1
3416 E57A A5 6F                 LDA   FRETOP
3417 E57C A6 70                 LDX   FRETOP+1
3418 E57E 85 94                 STA   HIGHDS
3419 E580 86 95                 STX   HIGHDS+1                 ;WHERE IT ALL GOES.  JSR BLTUC
3420 E582 20 9A D3              JSR   BLTUC
3421 E585 A4 91                 LDY   SIZE
3422 E587 C8                    INY   
3423 E588 A5 94                 LDA   HIGHDS                   ;GET POSITION OF START OF RESULT.
3424 E58A 91 8A                 STA   (GRBPNT),Y
3425 E58C AA                    TAX   
3426 E58D E6 95                 INC   HIGHDS+1
3427 E58F A5 95                 LDA   HIGHDS+1
3428 E591 C8                    INY   
3429 E592 91 8A                 STA   (GRBPNT),Y               ;CHANGE ADDR OF STRING IN VAR.
3430 E594 4C 88 E4              JMP   FNDVAR                   ;GO TO FNDVAR WITH SOMETHING FOR
3431 E597              ;FRETOP.
3432 E597              ; THE FOLLOWING ROUTINE CONCATENATES TWO STRINGS.
3433 E597              ; THE FAC CONTAINS THE FIRST ONE AT THIS POINT.
3434 E597              ; TXTPTR POINTS TO THE + SIGN.
3435 E597 A5 A1        CAT:     LDA   FACLO                    ;PSH HIGH ORDER ONTO STACK.
3436 E599 48                    PHA   
3437 E59A A5 A0                 LDA   FACMO                    ;AND THE LOW.
3438 E59C 48                    PHA   
3439 E59D 20 60 DE              JSR   EVAL                     ;CAN COME BACK HERE SINCE
3440 E5A0              ;OPERATOR IS KNOWN.
3441 E5A0 20 6C DD              JSR   CHKSTR                   ;RESULT MUST BE STRING.
3442 E5A3 68                    PLA   
3443 E5A4 85 AB                 STA   STRNG1                   ;GET HIGH ORDER OF OLD DESC.
3444 E5A6 68                    PLA   
3445 E5A7 85 AC                 STA   STRNG1+1
3446 E5A9 A0 00                 LDY   #0
3447 E5AB B1 AB                 LDA   (STRNG1),Y               ;GET LENGTH OF OLD STRING.
3448 E5AD 18                    CLC   
3449 E5AE 71 A0                 ADC   (FACMO),Y
3450 E5B0 90 05                 BCC   SIZEOK                   ;RESULT IS LESS THAN 256.
3451 E5B2 A2 B0                 LDX   #ERRLS                   ;ERROR 'LONG STRING'.
3452 E5B4 4C 12 D4              JMP   ERROR
3453 E5B7 20 D5 E3     SIZEOK:  JSR   STRINI                   ;INITIALIZE STRING.
3454 E5BA 20 D4 E5              JSR   MOVINS                   ;MOVE IT.
3455 E5BD A5 8C                 LDA   DSCPNT
3456 E5BF A4 8D                 LDY   DSCPNT+1                 ;GET POINTER TO SECOND.
3457 E5C1 20 04 E6              JSR   FRETMP                   ;FREE IT.
3458 E5C4 20 E6 E5              JSR   MOVDO
3459 E5C7 A5 AB                 LDA   STRNG1
3460 E5C9 A4 AC                 LDY   STRNG1+1
3461 E5CB 20 04 E6              JSR   FRETMP
3462 E5CE 20 2A E4              JSR   PUTNEW
3463 E5D1 4C 95 DD              JMP   TSTOP                    ;'CAT' REENTERS FORM EVAL AT TSTOP.
3464 E5D4 A0 00        MOVINS:  LDY   #0                       ;GET ADDR OF STRING.
3465 E5D6 B1 AB                 LDA   (STRNG1),Y
3466 E5D8 48                    PHA   
3467 E5D9 C8                    INY   
3468 E5DA B1 AB                 LDA   (STRNG1),Y
3469 E5DC AA                    TAX   
3470 E5DD C8                    INY   
3471 E5DE B1 AB                 LDA   (STRNG1),Y
3472 E5E0 A8                    TAY   
3473 E5E1 68                    PLA   
3474 E5E2 86 5E        MOVSTR:  STX   INDEX
3475 E5E4 84 5F                 STY   INDEX+1
3476 E5E6 A8           MOVDO:   TAY   
3477 E5E7 F0 0A                 BEQ   MVDONE
3478 E5E9 48                    PHA   
3479 E5EA 88           MOVLP:   DEY   
3480 E5EB B1 5E                 LDA   (INDEX),Y
3481 E5ED 91 71                 STA   (FRESPC),Y
3482 E5EF 98           QMOVE:   TYA   
3483 E5F0 D0 F8                 BNE   MOVLP
3484 E5F2 68                    PLA   
3485 E5F3 18           MVDONE:  CLC   
3486 E5F4 65 71                 ADC   FRESPC
3487 E5F6 85 71                 STA   FRESPC
3488 E5F8 90 02                 BCC   MVSTRT
3489 E5FA E6 72                 INC   FRESPC+1
3490 E5FC 60           MVSTRT:  RTS   
3491 E5FD              ; 'FRETMP' IS PASS A STRING DESCRIPTOR PNTR IN Y,A.
3492 E5FD              ; A CHECK IS MADE TO SEE IF STRING DESCRIPTOR POINTS TO
3493 E5FD              ; TEMPORARY DESCRIPTOR ALLOCATED BY PUTNEW.
3494 E5FD              ; IF SO, THE TEMPORARY IS FREED UP BY UPDATING TEMPPT
3495 E5FD              ; IF A TEMP IS FREED UP, A FURTHER CHECK SEES IF STRING
3496 E5FD              ; THAT STRING TEMP PNT'D TO IS THE LOWEST PART OF STRING
3497 E5FD              ; IF SO, FRETOP IS UPDATED TO REFLECT THE FACT THAT
3498 E5FD              ; IS NO LONGER IN USE.
3499 E5FD              ; THE ADDR OF THE ACTUAL STRING IS RETURNED  Y,X AND
3500 E5FD              ; ITS LENGTH IN ACCA.
3501 E5FD 20 6C DD     FRESTR:  JSR   CHKSTR                   ;MAKE SURE ITS A STRING.
3502 E600 A5 A0        FREFAC:  LDA   FACMO
3503 E602 A4 A1                 LDY   FACMO+1                  ;FREE UP STR PNT'D TO BY FAC.
3504 E604 85 5E        FRETMP:  STA   INDEX
3505 E606 84 5F                 STY   INDEX+1                  ;GET LENGTH FOR LATER.
3506 E608 20 35 E6              JSR   FRETMS                   ;FREE UP THE TEMPORARY DESC.
3507 E60B 08                    PHP                            ;SAVE CODES.
3508 E60C A0 00                 LDY   #0                       ;PREP TO GET STUFF.
3509 E60E B1 5E                 LDA   (INDEX),Y                ;GET COUNT AND
3510 E610 48                    PHA                            ;SAVE IT.
3511 E611 C8                    INY   
3512 E612 B1 5E                 LDA   (INDEX),Y
3513 E614 AA                    TAX                            ;SAVE LOW ORDER.
3514 E615 C8                    INY   
3515 E616 B1 5E                 LDA   (INDEX),Y
3516 E618 A8                    TAY                            ;SAVE HIGH ORDER.
3517 E619 68                    PLA   
3518 E61A 28                    PLP                            ;RETURN STATUS.
3519 E61B D0 13                 BNE   FRETRT
3520 E61D C4 70                 CPY   FRETOP+1                 ;STRING IS LAST ONE IN?
3521 E61F D0 0F                 BNE   FRETRT
3522 E621 E4 6F                 CPX   FRETOP
3523 E623 D0 0B                 BNE   FRETRT
3524 E625 48                    PHA   
3525 E626 18                    CLC   
3526 E627 65 6F                 ADC   FRETOP
3527 E629 85 6F                 STA   FRETOP
3528 E62B 90 02                 BCC   FREPLA
3529 E62D E6 70                 INC   FRETOP+1
3530 E62F 68           FREPLA:  PLA                            ;GET COUNT BACK.
3531 E630 86 5E        FRETRT:  STX   INDEX
3532 E632 84 5F                 STY   INDEX+1                  ;SAVE FOR LATER USE.
3533 E634 60                    RTS   
3534 E635 C4 54        FRETMS:  CPY   LASTPT+1                 ;LAST ENTRY TO TEMP? 
3535 E637 D0 0C                 BNE   FRERTS
3536 E639 C5 53                 CMP   LASTPT
3537 E63B D0 08                 BNE   FRERTS
3538 E63D 85 52                 STA   TEMPPT
3539 E63F E9 03                 SBC   #STRSIZ                  ;POINT TO LAST ONE.
3540 E641 85 53                 STA   LASTPT                   ;UPDATE TEMP PNTR.
3541 E643 A0 00                 LDY   #0                       ;ALSO CLEARS ZFLG SO WE DO REST OF FRETMP.
3542 E645 60           FRERTS:  RTS                            ;ALL DONE.
3543 E646              ; CHR$(#) CREATES A STRING WHICH CONTAINS AS ITS ONLY
3544 E646              ; CHARACTER THE ASCII EQUIVALENT OF INTEGER ARGUMENT (#)
3545 E646              ; WHICH MUST BE .LT. 255.
3546 E646 20 FB E6     CHRS:    JSR   CONINT                   ;GET INTEGER IN RANGE.
3547 E649 8A                    TXA   
3548 E64A 48                    PHA   
3549 E64B A9 01                 LDA   #1                       ;ONE-CHARACTER STRING.
3550 E64D 20 DD E3              JSR   STRSPA                   ;GET SPACE FOR STRING.
3551 E650 68                    PLA   
3552 E651 A0 00                 LDY   #0
3553 E653 91 9E                 STA   (DSCTMP+1),Y
3554 E655 68                    PLA                            ;GET RID OF 'CHKNUM' RETURN ADDR.
3555 E656 68                    PLA   
3556 E657 4C 2A E4     RL$RET:  JMP   PUTNEW                   ;SETUP FAC TO POINT TO DESC.
3557 E65A              ; THE FOLLOWING IS THE LEFT$($,#) FUNCTION.
3558 E65A              ; IT TAKES THE LEMOST # CHARACTERS OF THE STRING.
3559 E65A              ; IF # .GT. THE LEN OF STRING, IT RETURNS THE WHOLE STRING
3560 E65A 20 B9 E6     LEFTS:   JSR   PREAM                    ;TEST PARAMETERS.
3561 E65D D1 8C                 CMP   (DSCPNT),Y
3562 E65F 98                    TYA   
3563 E660 90 04        RLEFT:   BCC   RLEFT1
3564 E662 B1 8C                 LDA   (DSCPNT),Y
3565 E664 AA                    TAX                            ;PUT LENGTH INTO X.
3566 E665 98                    TYA                            ;ZERO A THE OFFSET.
3567 E666 48           RLEFT1:  PHA                            ;SAVE OFFSET.
3568 E667 8A           RLEFT2:  TXA   
3569 E668 48           RLEFT3:  PHA                            ;SAVE LENGTH.
3570 E669 20 DD E3              JSR   STRSPA                   ;GET SPACE.
3571 E66C A5 8C                 LDA   DSCPNT
3572 E66E A4 8D                 LDY   DSCPNT+1
3573 E670 20 04 E6              JSR   FRETMP
3574 E673 68                    PLA   
3575 E674 A8                    TAY   
3576 E675 68                    PLA   
3577 E676 18                    CLC   
3578 E677 65 5E                 ADC   INDEX                    ;COMPUTE WHERE TO COPY.
3579 E679 85 5E                 STA   INDEX
3580 E67B 90 02                 BCC   PULMOR
3581 E67D E6 5F                 INC   INDEX+1
3582 E67F 98           PULMOR:  TYA   
3583 E680 20 E6 E5              JSR   MOVDO                    ;GO MOVE IT.
3584 E683 4C 2A E4              JMP   PUTNEW
3585 E686 20 B9 E6     RIGHTS:  JSR   PREAM
3586 E689 18                    CLC                            ;LENGTH DES'D-LENGTH-1.
3587 E68A F1 8C                 SBC   (DSCPNT),Y
3588 E68C 49 FF                 EOR   #255                     ;NEGATE.
3589 E68E 4C 60 E6              JMP   RLEFT
3590 E691              ; MID ($,#) RETURNS STRING WITH CHARS FROM # POSITION
3591 E691              ; ONWARD. IF # .GT. LEN ($) THEN RETURN NULL STRING.
3592 E691              ; MID ($,#,#) RETURNS STRING WITH CHARACTERS FROM
3593 E691              ; # POSITION FOR #2 CHARS. IF #2 GOES PAST END OF STRING
3594 E691              ; RETURN AS MUCH AS POSSIBLE.
3595 E691 A9 FF        MIDS:    LDA   #255                     ;DEFAULT.
3596 E693 85 A1                 STA   FACLO                    ;SAVE FOR LAT COMPARE.
3597 E695 20 B7 00              JSR   CHRGOT                   ;GET CURRENT CHARACTER.
3598 E698 C9 29                 CMP   #41                      ;IS IT A RIGHT PAREN )?
3599 E69A F0 06                 BEQ   MID2                     ;NO THIRD PARAM.
3600 E69C 20 BE DE              JSR   CHKCOM                   ;MUST HAVE COMMA.
3601 E69F 20 F8 E6              JSR   GETBYT                   ;GET THE LENGTH INTO 'FACLO'.
3602 E6A2 20 B9 E6     MID2:    JSR   PREAM                    ;CHECK IT OUT.
3603 E6A5 CA                    DEX                            ;COMPUTE OFFSET.
3604 E6A6 8A                    TXA   
3605 E6A7 48                    PHA                            ;PRSERVE AWHILE.
3606 E6A8 18                    CLC   
3607 E6A9 A2 00                 LDX   #0
3608 E6AB F1 8C                 SBC   (DSCPNT),Y               ;GET LENGTH OF WHAT'S LEFT.
3609 E6AD B0 B8                 BCS   RLEFT2                   ;GIVE NULL STRING.
3610 E6AF 49 FF                 EOR   #255                     ;IN SUB C WAS 0 SO JUST COMPLEMENT.
3611 E6B1 C5 A1                 CMP   FACLO                    ;GREATER THAN WHAT'S DESIRED?
3612 E6B3 90 B3                 BCC   RLEFT3                   ;NO,OPY THAT MUCH.
3613 E6B5 A5 A1                 LDA   FACLO                    ;GET LENGTH OF WHAT'S DESIRED.
3614 E6B7 B0 AF                 BCS   RLEFT3                   ;COPY IT.
3615 E6B9              ; USED BY RIGHT$, LEFT$, MID$ FOR PARAMETER CHECKING & SET
3616 E6B9 20 B8 DE     PREAM:   JSR   CHKCLS                   ;PARAM LIST SHOULD END.
3617 E6BC 68                    PLA                            ;GET THE RETURN ADDRESS INTO
3618 E6BD A8                    TAY                            ;JMPER+1,Y
3619 E6BE 68                    PLA   
3620 E6BF 85 91                 STA   JMPER+1
3621 E6C1 68                    PLA                            ;GET RID OF FINGO'S JSR RET ADDR.
3622 E6C2 68                    PLA   
3623 E6C3 68                    PLA                            ;GET LENGTH.
3624 E6C4 AA                    TAX   
3625 E6C5 68                    PLA   
3626 E6C6 85 8C                 STA   DSCPNT
3627 E6C8 68                    PLA   
3628 E6C9 85 8D                 STA   DSCPNT+1
3629 E6CB A5 91                 LDA   JMPER+1                  ;PUT RETURN ADDRESS BACK ON
3630 E6CD 48                    PHA   
3631 E6CE 98                    TYA   
3632 E6CF 48                    PHA   
3633 E6D0 A0 00                 LDY   #0
3634 E6D2 8A                    TXA   
3635 E6D3 F0 1D                 BEQ   GOFUC
3636 E6D5 60                    RTS   
3637 E6D6              ; THE FUNCTION LEN($) RETURNS THE LENGTH OF THE STRING
3638 E6D6              ; PASSED AS AN ARGUMENT.
3639 E6D6 20 DC E6     LEN:     JSR   LEN1
3640 E6D9 4C 01 E3              JMP   SNGFLT
3641 E6DC 20 FD E5     LEN1:    JSR   FRESTR                   ;FREE UP STRING.
3642 E6DF A2 00                 LDX   #0
3643 E6E1 86 11                 STX   VALTYP                   ;FORCE NUMERIC.
3644 E6E3 A8                    TAY                            ;SET CODES ON LENGTH.
3645 E6E4 60                    RTS                            ;DONE.
3646 E6E5              ; THE FOLLOWING IS THE ASC($) FUNCTION. IT RETURNS
3647 E6E5              ; AN INTEGER WHICH IS THE DECIMAL ASCII EQUIVALENT.
3648 E6E5 20 DC E6     ASC:     JSR   LEN1
3649 E6E8 F0 08                 BEQ   GOFUC                    ;NULL STRING, BAD ARG.
3650 E6EA A0 00                 LDY   #0
3651 E6EC B1 5E                 LDA   (INDEX1),Y               ;GET CHARACTER.
3652 E6EE A8                    TAY   
3653 E6EF 4C 01 E3              JMP   SNGFLT
3654 E6F2 4C 99 E1     GOFUC:   JMP   FCERR                    ;YES.
3655 E6F5 20 B1 00     GTBYTC:  JSR   CHRGET
3656 E6F8 20 67 DD     GETBYT:  JSR   FRMNUM                   ;READ FORMULA INTO FAC.
3657 E6FB 20 08 E1     CONINT:  JSR   POSINT                   ;CONVERT THE FAC TO A SINGLE BYTE INT
3658 E6FE A6 A0                 LDX   FACMO
3659 E700 D0 F0                 BNE   GOFUC                    ;RESULT MUST BE .LE. 255.
3660 E702 A6 A1                 LDX   FACLO
3661 E704 4C B7 00     CHRGO2:  JMP   CHRGOT                   ;SET CONDITION CODES ON TERMINATOR.
3662 E707              ; THE 'VAL' FUNCTION TAKES A STRING AND TURNS IT INTO
3663 E707              ; A NUMBER BY INTERPRETING THE ASCII DIGITS ETC.
3664 E707              ; EXCEPT FOR THE PROBLEM THAT TERMINATOR MUST BE SUPPLIED
3665 E707              ; BY REPLACING THE CHARACTER BEYOND STRING, VAL IS MELY
3666 E707              ; A CALL TO FLOATING POINT INPUT ('FIN').
3667 E707 20 DC E6     VAL:     JSR   LEN1                     ;DO SETUP. SET RESULT=NUMERIC.
3668 E70A D0 03                 BNE   *+5
3669 E70C 4C 4E E8              JMP   ZEROFC                   ;ZERO THE FAC ON A NULL STRING
3670 E70F A6 B8                 LDX   TXTPTR
3671 E711 A4 B9                 LDY   TXTPTR+1
3672 E713 86 AD                 STX   STRNG2
3673 E715 84 AE                 STY   STRNG2+1                 ;SAVE FOR LATER.
3674 E717 A6 5E                 LDX   INDEX1
3675 E719 86 B8                 STX   TXTPTR
3676 E71B 18                    CLC   
3677 E71C 65 5E                 ADC   INDEX1
3678 E71E 85 60                 STA   INDEX2
3679 E720 A6 5F                 LDX   INDEX1+1
3680 E722 86 B9                 STX   TXTPTR+1
3681 E724 90 01                 BCC   VAL2                     ;NO CARRY, NO INC.
3682 E726 E8                    INX   
3683 E727 86 61        VAL2:    STX   INDEX2+1
3684 E729 A0 00                 LDY   #0
3685 E72B B1 60                 LDA   (INDEX2),Y               ;PRESERVE CHARACTER.
3686 E72D 48                    PHA   
3687 E72E A9 00                 LDA   #0                       ;SET A TERMINATOR.
3688 E730 91 60                 STA   (INDEX2),Y
3689 E732 20 B7 00              JSR   CHRGOT                   ;GET CHARACTER PNT'D TO AND SET FLAGS.
3690 E735 20 4A EC              JSR   FIN
3691 E738 68                    PLA                            ;GET PRES'D CHARACTER.
3692 E739 A0 00                 LDY   #0
3693 E73B 91 60                 STA   (INDEX2),Y               ;STUFF IT BACK.
3694 E73D A6 AD        ST2TXT:  LDX   STRNG2
3695 E73F A4 AE                 LDY   STRNG2+1
3696 E741 86 B8                 STX   TXTPTR
3697 E743 84 B9                 STY   TXTPTR+1
3698 E745 60           VALRTS:  RTS                            ;ALL DONE WITH STRINGS.
3699 E746                       EJECT 
3700 E746                       TITLE 'PEEK, POKE, AND FNWAIT.'
3701 E746 20 67 DD     GETNUM:  JSR   FRMNUM                   ;GET ADDRESS.
3702 E749 20 52 E7              JSR   GETADR                   ;GET THAT LOCATION.
3703 E74C 20 BE DE     COMBYT:  JSR   CHKCOM                   ;CHECK FOR A COMMA.
3704 E74F 4C F8 E6              JMP   GETBYT                   ;GET SOMETHING TO STORE AND RETURN.
3705 E752 A5 9D        GETADR:  LDA   FACEXP                   ;EXAMINE EXPONENT.
3706 E754 C9 91                 CMP   #145
3707 E756 B0 9A                 BCS   GOFUC                    ;FUNCTION CALL ERROR.
3708 E758 20 F2 EB              JSR   QINT                     ;INTEGERIZE IT.
3709 E75B A5 A0                 LDA   FACMO
3710 E75D A4 A1                 LDY   FACMO+1
3711 E75F 84 50                 STY   POKER
3712 E761 85 51                 STA   POKER+1
3713 E763 60                    RTS                            ;IT'S DONE !.
3714 E764 A5 50        PEEK:    LDA   POKER                    ;CHEAP ASS FIX.
3715 E766 48                    PHA   
3716 E767 A5 51                 LDA   POKER+1
3717 E769 48                    PHA   
3718 E76A 20 52 E7              JSR   GETADR
3719 E76D A0 00                 LDY   #0
3720 E76F B1 50        GETCON:  LDA   (POKER),Y                ;GET THAT BYTE.
3721 E771 A8                    TAY   
3722 E772 68                    PLA   
3723 E773 85 51                 STA   POKER+1
3724 E775 68                    PLA   
3725 E776 85 50                 STA   POKER                    ;FOR POKE X,PEEK(KKK)
3726 E778 4C 01 E3     DOSGFL:  JMP   SNGFLT                   ;FLOAT IT.
3727 E77B 20 46 E7     POKE:    JSR   GETNUM
3728 E77E 8A                    TXA   
3729 E77F A0 00                 LDY   #0
3730 E781 91 50                 STA   (POKER),Y                ;STORE VALUE AWAY.
3731 E783 60                    RTS                            ;SCANNED  EVERYTHING.
3732 E784              ; THE WAIT LOCATION,MASK1,MASK2 STEMENT WAITS UNTIL CONT
3733 E784              ; OF LOCATION IS NONZERO WHEN XORED WITH MASK2
3734 E784              ; AND THEN ANDED WITH MASK1. IF MASK2 IS NOT PRESENT, IT
3735 E784              ; IS ASSUMED TO BE ZERO.
3736 E784 20 46 E7     FNWAIT:  JSR   GETNUM
3737 E787 86 85                 STX   ANDMSK
3738 E789 A2 00                 LDX   #0
3739 E78B 20 B7 00              JSR   CHRGOT
3740 E78E F0 03                 BEQ   STORDO
3741 E790 20 4C E7              JSR   COMBYT                   ;GET MASK2.
3742 E793 86 86        STORDO:  STX   EORMSK
3743 E795 A0 00                 LDY   #0
3744 E797 B1 50        WAITER:  LDA   (POKER),Y
3745 E799 45 86                 EOR   EORMSK
3746 E79B 25 85                 AND   ANDMSK
3747 E79D F0 F8                 BEQ   WAITER
3748 E79F 60           ZERRTS:  RTS                            ;GOT A NONZERO.
3749 E7A0                       EJECT 
3750 E7A0                       TITLE 'FLOATING POINT MATH CONFIG'
3751 E7A0              ;THROUGHOUT THE MATH PACKAGE.
3752 E7A0              ; THE FLTING POINT FORMAT IS AS FOLLOWS:
3753 E7A0              ; THE SIGN IS THE FIRST BIT OF THE MANTISSA.
3754 E7A0              ; THE MANTISSA IS 24 BITS LONG.
3755 E7A0              ; THE BINARY POINT IS TO THE LEFT OF THE MSB.
3756 E7A0              ; NUMBER = MANTISSA * 2  EXPONENT.
3757 E7A0              ; THE MANTISSA IS POSITIVE WITH A 1 ASSUMED TO BE WHERE
3758 E7A0              ; THE SIGN OF THE EXPONENT IS THE 1ST BIT OF THE EXPONENT.
3759 E7A0              ; THE EXPONENT IS STORED IN EXCESS 200, IE, WITH A BIAS OF
3760 E7A0              ; SO, THE EXPONENT IS A SIGNED 8-BIT NUMBER WITH 200 ADDED
3761 E7A0              ; AN EXPONENT OF ZERO MEANSHE NUMBER IS ZERO.
3762 E7A0              ; THE OTHER BYTES MAY NOT BE ASSUMED TO BE ZERO.
3763 E7A0              ; TO KEEP THE SAME NUMBER IN THE FAC WHILE SHIFTING,
3764 E7A0              ;  TO SHIFT RIGHT, EXP:=EXP+1
3765 E7A0              ;  TO SHIFT LEFT,  EXP:=EXP-1
3766 E7A0              ; IN MEMORY THE NUMBER LOOKS LIKE THIS:
3767 E7A0              ;  THE EXPONENT AS A SIGNED NUMBER +200
3768 E7A0              ;  THE SIGN BIT IN 7, BITS 2-8 OF MANTISSA IN BITS 6-0.
3769 E7A0              ;   (REMEMBER BIT 1 OF MANTISSA IS ALWAYS A ONE.)
3770 E7A0              ;  BITS 9-16 OF THE MANTISSA
3771 E7A0              ;  BITS 17-24 OF THE MANTISSA
3772 E7A0              ; ARITHMETIC ROUTINE CALLING CONVENTION
3773 E7A0              ; FOR ONE ARGUMENT FUNCTIONS:
3774 E7A0              ;  THE ARGUMENT IS IN THE FAC.
3775 E7A0              ;  THE RESULT IS LEFT IN THE FAC.
3776 E7A0              ; FOR TWO ARGUMENT OPERATIONS:
3777 E7A0              ;  THE 1ST ARGUMENT IS IN ARG (ARGEXP,HO,MO,LO AND ARGSGN)
3778 E7A0              ;  THE SECOND ARGUMENT IS IN THE FAC.
3779 E7A0              ;  THE RESULT IS LEFT IN THE FAC.
3780 E7A0              ; THE 'T' ENTRY POINTS TO THE 2-ARGUMENT OPERATIONS HAVE B
3781 E7A0              ; SETUP IN RESPECTIVE REGISTERS. BEFORE CALLING ARG MAY
3782 E7A0              ; POPPED OFF THE STACK AND INTO ARG, FOR EXAMPLE.
3783 E7A0              ; THE OTHER ENTRY POINTSSUMES Y,A POINTS TO THE ARGUMENT
3784 E7A0              ; SOMEWHERE IN MEMORY. IT IS UNPACKED INTO ARG BY 'CONUPK'
3785 E7A0              ; ON THE STACK, THE SGN IS PUSHED ON FIRST, THE LO,MO,HO &
3786 E7A0              ; NOTE ALL THINGS ARE KEPT UNPACKED IN ARG, FAC & ON THE S
3787 E7A0              ; IT IS ONLY WHEN SOMETHING IS STORED THAT IT IS PACKED
3788 E7A0              ; BYTES. UNPACKED FORMAT HAS A SGN BYTE REFLECTING THE S
3789 E7A0              ; NUMBER (POSITIVE=0, NEGATIVE=-1) A HO,MO & LO WITH THE H
3790 E7A0              ; OF THE HO TURNED ON. THE EXP IS THE SAMES STORED FORMAT.
3791 E7A0              ; THIS IS DONE FOR SPEED OF OPERATION.
3792 E7A0              ; %
3793 E7A0                       EJECT 
3794 E7A0                       TITLE 'FLOATING POINT ADD AND SUB'
3795 E7A0 A9 64        FADDH:   LDA   #FHALF
3796 E7A2 A0 EE                 LDY   #>FHALF                  ;ENTRY TO ADD 1/2.
3797 E7A4 4C BE E7              JMP   FADD                     ;UNPACK AND GO ADD UIT.
3798 E7A7 20 E3 E9     FSUB:    JSR   CONUPK                   ;UNPACK ARGUMENT INTO ARG.
3799 E7AA A5 A2        FSUBT:   LDA   FACSGN
3800 E7AC 49 FF                 EOR   #$FF                     ;COMPLEMENT IT.
3801 E7AE 85 A2                 STA   FACSGN
3802 E7B0 45 AA                 EOR   ARGSGN                   ;COMPLEMENT ARISGN.
3803 E7B2 85 AB                 STA   ARISGN
3804 E7B4 A5 9D                 LDA   FACEXP                   ;SET CODES ON FACEXP.
3805 E7B6 4C C1 E7              JMP   FADDT                    ;Y=ARGEXP..
3806 E7B9 20 F0 E8     FADD5:   JSR   SHIFTR                   ;DO A LONG SHIF
3807 E7BC 90 3C                 BCC   FADD4                    ;CONTINUE WITH ADDITION.
3808 E7BE 20 E3 E9     FADD:    JSR   CONUPK
3809 E7C1 D0 03        FADDT:   BNE   *+5
3810 E7C3 4C 53 EB              JMP   MOVFA                    ;IF FAC=0, RESULT IS IN ARG.
3811 E7C6 A6 AC                 LDX   FACOV
3812 E7C8 86 92                 STX   OLDOV
3813 E7CA A2 A5                 LDX   #ARGEXP                  ;DEFAULT IS SHIFT ARGUMENT.
3814 E7CC A5 A5                 LDA   ARGEXP                   ;IF ARG=0, FAC IS RESULT.
3815 E7CE A8           FADDC:   TAY                            ;ALSO COPY ACCA INTO ACCY.
3816 E7CF F0 CE                 BEQ   ZERRTS                   ;RETURN.
3817 E7D1 38                    SEC   
3818 E7D2 E5 9D                 SBC   FACEXP
3819 E7D4 F0 24                 BEQ   FADD4                    ;NO SHIFTING.
3820 E7D6 90 12                 BCC   FADDA                    ;BR IF ARGEXP.LT.FACEXP.
3821 E7D8 84 9D                 STY   FACEXP                   ;RESULTING EXPONENT.
3822 E7DA A4 AA                 LDY   ARGSGN                   ;SINCE ARG IS BIGGER, IT'S
3823 E7DC 84 A2                 STY   FACSGN                   ;SIGN IS SIGN OF RESU.
3824 E7DE 49 FF                 EOR   #$FF                     ;SHIFT A NEGATIVE NUMBER OF PLACES.
3825 E7E0 69 00                 ADC   #0                       ;COMPLETE NEGATION. W/ C=1.
3826 E7E2 A0 00                 LDY   #0                       ;ZERO OLDOV.
3827 E7E4 84 92                 STY   OLDOV
3828 E7E6 A2 9D                 LDX   #FAC                     ;SHIFT THE FAC INSTEAD.
3829 E7E8 D0 04                 BNE   FADD1
3830 E7EA A0 00        FADDA:   LDY   #0
3831 E7EC 84 AC                 STY   FACOV
3832 E7EE C9 F9        FADD1:   CMP   #$100-7                  ;FOR SPEED AND NECESSITY.  GETS
3833 E7F0              ;MOST LIKELY CASE TO SHIFTR FASTEST
3834 E7F0              ;AND ALLOWS SHIFTING OF NEG NUMS
3835 E7F0              ;BY 'QINT'.
3836 E7F0 30 C7                 BMI   FADD5                    ;SHIFT BIG.
3837 E7F2 A8                    TAY   
3838 E7F3 A5 AC                 LDA   FACOV                    ;SET FACOV.
3839 E7F5 56 01                 LSR   1,X                      ;GETS 0 IN MOST SIG BIT.
3840 E7F7 20 07 E9              JSR   ROLSHF                   ;DO THE ROLLING.
3841 E7FA 24 AB        FADD4:   BIT   ARISGN                   ;GET SULTING SIGN.
3842 E7FC 10 57                 BPL   FADD2                    ;IF POSITIVE, ADD.
3843 E7FE              ;CARRY IS CLEAR.
3844 E7FE A0 9D        FADD3:   LDY   #FACEXP
3845 E800 E0 A5                 CPX   #ARGEXP                  ;FAC IS BIGGER.
3846 E802 F0 02                 BEQ   SUBIT
3847 E804 A0 A5                 LDY   #ARGEXP                  ;ARG IS BIGGER.
3848 E806 38           SUBIT:   SEC   
3849 E807 49 FF                 EOR   #$FF
3850 E809 65 92                 ADC   OLDOV
3851 E80B 85 AC                 STA   FACOV
3852 E80D B9 04 00              LDA   |$3+1,Y
3853 E810 F5 04                 SBC    $3+1,X
3854 E812 85 A1                 STA   FACLO
3855 E814 B9 03 00              LDA   |$2+1,Y
3856 E817 F5 03                 SBC    $2+1,X
3857 E819 85 A0                 STA   FACMO
3858 E81B B9 02 00              LDA   |$2,Y
3859 E81E F5 02                 SBC    $2,X
3860 E820 85 9F                 STA   FACMOH
3861 E822 B9 01 00              LDA   |$1,Y
3862 E825 F5 01                 SBC    $1,X
3863 E827 85 9E                 STA   FACHO
3864 E829 B0 03        FADFLT:  BCS   NORMAL                   ;HERE IF SIGNS DIFFER. IF CARRY,
3865 E82B              ;FAC IS SET OK.
3866 E82B 20 9E E8              JSR   NEGFAC                   ;NEGATE FAC.
3867 E82E A0 00        NORMAL:  LDY   #0
3868 E830 98                    TYA   
3869 E831 18                    CLC   
3870 E832 A6 9E        NORM3:   LDX   FACHO
3871 E834 D0 4A                 BNE   NORM1
3872 E836 A6 9F                 LDX   FACHO+1                  ;SHIFT 8 BITS AT A TIME FOR SPEED.
3873 E838 86 9E                 STX   FACHO
3874 E83A A6 A0                 LDX   FACMOH+1
3875 E83C 86 9F                 STX   FACMOH
3876 E83E A6 A1                 LDX   FACMO+1
3877 E840 86 A0                 STX   FACMO
3878 E842 A6 AC                 LDX   FACOV
3879 E844 86 A1                 STX   FACLO
3880 E846 84 AC                 STY   FACOV
3881 E848 69 08                 ADC   #$08
3882 E84A C9 20                 CMP   #$18+$08
3883 E84C D0 E4                 BNE   NORM3
3884 E84E A9 00        ZEROFC:  LDA   #0                       ;NOT NEED BY NORMAL BUT BY OTHERS.
3885 E850 85 9D        ZEROF1:  STA   FACEXP                   ;NUMBER MUST BE ZERO.
3886 E852 85 A2        ZEROML:  STA   FACSGN                   ;MAKE SIGN POSITIVE.
3887 E854 60                    RTS                            ;ALL DONE.
3888 E855 65 92        FADD2:   ADC   OLDOV
3889 E857 85 AC                 STA   FACOV
3890 E859 A5 A1                 LDA   FACLO
3891 E85B 65 A9                 ADC   ARGLO
3892 E85D 85 A1                 STA   FACLO
3893 E85F A5 A0                 LDA   FACMO
3894 E861 65 A8                 ADC   ARGMO
3895 E863 85 A0                 STA   FACMO
3896 E865 A5 9F                 LDA   FACMOH
3897 E867 65 A7                 ADC   ARGMOH
3898 E869 85 9F                 STA   FACMOH
3899 E86B A5 9E                 LDA   FACHO
3900 E86D 65 A6                 ADC   ARGHO
3901 E86F 85 9E                 STA   FACHO
3902 E871 4C 8D E8              JMP   SQUEEZ                   ;GO ROUND IF SIGNS SAME.
3903 E874 69 01        NORM2:   ADC   #1                       ;DECREMENT SHIFT COUNT.
3904 E876 06 AC                 ASL   FACOV                    ;SHIFT ALL LEFT ONE BIT.
3905 E878 26 A1                 ROL   FACLO
3906 E87A 26 A0                 ROL   FACMO
3907 E87C 26 9F                 ROL   FACMOH
3908 E87E 26 9E                 ROL   FACHO
3909 E880 10 F2        NORM1:   BPL   NORM2                    ;IF MSB=0 SHIFT AGAIN.
3910 E882 38                    SEC   
3911 E883 E5 9D                 SBC   FACEXP
3912 E885 B0 C7                 BCS   ZEROFC
3913 E887 49 FF                 EOR   #$FF
3914 E889 69 01                 ADC   #1                       ;COMPLEMENT.
3915 E88B 85 9D                 STA   FACEXP
3916 E88D 90 0E        SQUEEZ:  BCC   RNDRTS                   ;BITS TO SHIFT?
3917 E88F E6 9D        RNDSHF:  INC   FACEXP
3918 E891 F0 42                 BEQ   OVERR
3919 E893 66 9E                 ROR   FACHO
3920 E895 66 9F                 ROR   FACMOH
3921 E897 66 A0                 ROR   FACMO
3922 E899 66 A1                 ROR   FACLO
3923 E89B 66 AC                 ROR   FACOV
3924 E89D 60           RNDRTS:  RTS                            ;ALL DONE ADDING.
3925 E89E A5 A2        NEGFAC:  LDA   FACSGN
3926 E8A0 49 FF                 EOR   #255
3927 E8A2 85 A2                 STA   FACSGN                   ;COMPLEMENT FAC  ENTIRELY.
3928 E8A4 A5 9E        NEGFCH:  LDA   FACHO
3929 E8A6 49 FF                 EOR   #255
3930 E8A8 85 9E                 STA   FACHO                    ;COMPLEMENT JUST THE NUMBER.
3931 E8AA A5 9F                 LDA   FACMOH
3932 E8AC 49 FF                 EOR   #255
3933 E8AE 85 9F                 STA   FACMOH
3934 E8B0 A5 A0                 LDA   FACMO
3935 E8B2 49 FF                 EOR   #255
3936 E8B4 85 A0                 STA   FACMO
3937 E8B6 A5 A1                 LDA   FACLO
3938 E8B8 49 FF                 EOR   #255
3939 E8BA 85 A1                 STA   FACLO
3940 E8BC A5 AC                 LDA   FACOV
3941 E8BE 49 FF                 EOR   #255
3942 E8C0 85 AC                 STA   FACOV
3943 E8C2 E6 AC                 INC   FACOV
3944 E8C4 D0 0E                 BNE   INCFRT
3945 E8C6 E6 A1        INCFAC:  INC   FACLO
3946 E8C8 D0 0A                 BNE   INCFRT
3947 E8CA E6 A0                 INC   FACMO
3948 E8CC D0 06                 BNE   INCFRT                   ;IF NO CARRY, RETURN.
3949 E8CE E6 9F                 INC   FACMOH
3950 E8D0 D0 02                 BNE   INCFRT
3951 E8D2 E6 9E                 INC   FACHO                    ;CARRY INCREMENT.
3952 E8D4 60           INCFRT:  RTS   
3953 E8D5 A2 45        OVERR:   LDX   #ERROV
3954 E8D7 4C 12 D4              JMP   ERROR                    ;TELL USER.
3955 E8DA              ; 'SHIFTR' SHIFTS X+1:X+3 -ACCA  BITS RIGHT.
3956 E8DA              ; SHIFTS BYTES TO START WITH IF POSSIBLE.
3957 E8DA A2 61        MULSHF:  LDX   #RESHO-1                 ;ENTRY POINT FOR MULTIPLIER.
3958 E8DC B4 04        SHFTR2:  LDY   3+1,X                    ;SHIFT BYTES FIRST.
3959 E8DE 84 AC                 STY   FACOV
3960 E8E0 B4 03                 LDY   3,X
3961 E8E2 94 04                 STY   4,X
3962 E8E4 B4 02                 LDY   2,X                      ;GET MO.
3963 E8E6 94 03                 STY   3,X                      ;STORE LO.
3964 E8E8 B4 01                 LDY   1,X                      ;GET HO.
3965 E8EA 94 02                 STY   2,X                      ;STORE MO.
3966 E8EC A4 A4                 LDY   BITS
3967 E8EE 94 01                 STY   1,X                      ;STORE HO.
3968 E8F0 69 08        SHIFTR:  ADC   #$08
3969 E8F2 30 E8                 BMI   SHFTR2
3970 E8F4 F0 E6                 BEQ   SHFTR2
3971 E8F6 E9 08                 SBC   #$08                     ;C CAN BE EITHER 1,0 AND IT WORKS.
3972 E8F8 A8                    TAY   
3973 E8F9 A5 AC                 LDA   FACOV
3974 E8FB B0 14                 BCS   SHFTRT                   ;EQUIV TO BEQ HERE.
3975 E8FD 16 01        SHFTR3:  ASL   1,X
3976 E8FF 90 02                 BCC   SHFTR4
3977 E901 F6 01                 INC   1,X
3978 E903 76 01        SHFTR4:  ROR   1,X
3979 E905 76 01                 ROR   1,X                      ;YES, TWO OF THEM.
3980 E907              ROLSHF:  EQU   *
3981 E907 76 02                 ROR   2,X
3982 E909 76 03                 ROR   3,X
3983 E90B 76 04                 ROR   4,X                      ;ONE MO TIME.
3984 E90D 6A                    ROR   A                        ;ROTATE ARGUMENT 1 BIT RIGHT.
3985 E90E C8           SHFTR7:  INY   
3986 E90F D0 EC                 BNE   SHFTR3                   ;$$$ ( MOST EXPENSIVE ! )
3987 E911 18           SHFTRT:  CLC                            ;CLEAR OUTPUT OF FACOV.
3988 E912 60                    RTS   
3989 E913                       EJECT 
3990 E913                       TITLE 'NATURAL LOG FUNCTION.'
3991 E913              ; CALCULATION IS BY:
3992 E913              ; LN(F*2N)=(N+LOG2(F))*LN(2)
3993 E913              ; AN APPXIMATION POLYNOMIAL IS USED TO CALCULATE LOG2(F).
3994 E913              ;  CONSTANTS USED BY LOG:
3995 E913 81           FONE:    DC B:$81                       ; 1.0
3996 E914 00                    DC B:$00
3997 E915 00                    DC B:$00
3998 E916 00                    DC B:$00
3999 E917 00                    DC B:$00
4000 E918 03           LOGCN2:  DC B:$03                       ;DEGREE-1
4001 E919 7F                    DC B:$7F                       ;.43425594188
4002 E91A 5E                    DC B:$5E
4003 E91B 56                    DC B:$56
4004 E91C CB                    DC B:$CB
4005 E91D 79                    DC B:$79
4006 E91E 80                    DC B:$80                       ; .57658454134
4007 E91F 13                    DC B:$13
4008 E920 9B                    DC B:$9B
4009 E921 0B                    DC B:$0B
4010 E922 64                    DC B:$64
4011 E923 80                    DC B:$80                       ; .96180075921
4012 E924 76                    DC B:$76
4013 E925 38                    DC B:$38
4014 E926 93                    DC B:$93
4015 E927 16                    DC B:$16
4016 E928 82                    DC B:$82
4017 E929 38                    DC B:$38
4018 E92A AA                    DC B:$AA
4019 E92B 3B                    DC B:$3B
4020 E92C 20                    DC B:$20
4021 E92D 80           SQR0_5:  DC B:$80                       ; S(0.5)
4022 E92E 35                    DC B:$35
4023 E92F 04                    DC B:$04
4024 E930 F3                    DC B:$F3
4025 E931 34                    DC B:$34
4026 E932 81           SQR2_0:  DC B:$81                       ; SQR(2.0)
4027 E933 35                    DC B:$35
4028 E934 04                    DC B:$04
4029 E935 F3                    DC B:$F3
4030 E936 34                    DC B:$34
4031 E937 80           NEGHLF:  DC B:$80                       ; -1/2
4032 E938 80                    DC B:$80
4033 E939 00                    DC B:$00
4034 E93A 00                    DC B:$00
4035 E93B 00                    DC B:$00
4036 E93C 80           LOG2:    DC B:$80                       ; LN(2)
4037 E93D 31                    DC B:$31
4038 E93E 72                    DC B:$72
4039 E93F 17                    DC B:$17
4040 E940 F8                    DC B:$F8
4041 E941 20 82 EB     LOG:     JSR   SIGN                     ;IS IT POSITIVE?
4042 E944 F0 02                 BEQ   LOGERR
4043 E946 10 03                 BPL   LOG1
4044 E948 4C 99 E1     LOGERR:  JMP   FCERR                    ;CAN'T TOLERATE NEG OR ZERO.
4045 E94B A5 9D        LOG1:    LDA   FACEXP                   ;GET EXPONENT INTO ACCA.
4046 E94D E9 7F                 SBC   #$7F                     ;REMOVE BIAS. (CARRY IS OFF)
4047 E94F 48                    PHA                            ;SE AWHILE.
4048 E950 A9 80                 LDA   #$80
4049 E952 85 9D                 STA   FACEXP                   ;RESULT IS FAC IN RANGE 0.5,1.
4050 E954 A9 2D                 LDA   #SQR0_5
4051 E956 A0 E9                 LDY   #>SQR0_5                 ;GET POINTER TO SQR(0.5).
4052 E958              ; CALCULATE (F-SQR(.5))/(F+SQR(.5))
4053 E958 20 BE E7              JSR   FADD                     ;ADD TO FAC.
4054 E95B A9 32                 LDA   #SQR2_0
4055 E95D A0 E9                 LDY   #>SQR2_0                 ;GET SQR(2.).
4056 E95F 20 66 EA              JSR   FDIV
4057 E962 A9 13                 LDA   #FONE
4058 E964 A0 E9                 LDY   #>FONE
4059 E966 20 A7 E7              JSR   FSUB
4060 E969 A9 18                 LDA   #LOGCN2
4061 E96B A0 E9                 LDY   #>LOGCN2
4062 E96D 20 5C EF              JSR   POLYX                    ;EVALUATE APPROXIMATION POLYNOMIAL.
4063 E970 A9 37                 LDA   #NEGHLF
4064 E972 A0 E9                 LDY   #>NEGHLF                 ;ADD IN LAST CONSTANT.
4065 E974 20 BE E7              JSR   FADD
4066 E977 68                    PLA                            ;GET EXPONENT BACK.
4067 E978 20 D5 EC              JSR   FINLOG                   ;ADD IT IN.
4068 E97B A9 3C        MULLN2:  LDA   #LOG2
4069 E97D A0 E9                 LDY   #>LOG2                   ;MULTIPLY RESULT BY LOG(2.0).
4070 E97F              ; JMP FMULT   ;MULTIPLY TOGETHER.
4071 E97F                       EJECT 
4072 E97F                       TITLE 'FLOATING MULT AND DIV'
4073 E97F              ;MULTIPLICATION  FAC:=ARG*FAC.
4074 E97F 20 E3 E9     FMULT:   JSR   CONUPK                   ;UNPACK THE CONSTANT INTO ARG FOR USE.
4075 E982 D0 03        FMULTT:  BNE   *+5
4076 E984 4C E2 E9              JMP   MULTRT                   ;IF FAC=0, RETURN. FAC IS SET.
4077 E987 20 0E EA              JSR   MULDIV                   ;FIX UP THE EXPONENTS.
4078 E98A A9 00                 LDA   #0                       ;TO CLEAR RESULT.
4079 E98C 85 62                 STA   RESHO
4080 E98E 85 63                 STA   RESMOH
4081 E990 85 64                 STA   RESMO
4082 E992 85 65                 STA   RESLO
4083 E994 A5 AC                 LDA   FACOV
4084 E996 20 B0 E9              JSR   MLTPLY
4085 E999 A5 A1                 LDA   FACLO                    ;MLTPLARG BY FACLO.
4086 E99B 20 B0 E9              JSR   MLTPLY
4087 E99E A5 A0                 LDA   FACMO                    ;MLTPLY ARG BY FACMO.
4088 E9A0 20 B0 E9              JSR   MLTPLY
4089 E9A3 A5 9F                 LDA   FACMOH
4090 E9A5 20 B0 E9              JSR   MLTPLY
4091 E9A8 A5 9E                 LDA   FACHO                    ;MLTPLY ARG BY FACHO.
4092 E9AA 20 B5 E9              JSR   MLTPL1
4093 E9AD 4C E6 EA              JMP   MOVFR                    ;MOVE RESULT INTO FAC,
4094 E9B0              ;NORMALIZE RESULT, AND RETURN.
4095 E9B0 D0 03        MLTPLY:  BNE   *+5
4096 E9B2 4C DA E8              JMP   MULSHF                   ;SHIFT RESULT RIGHT 1 BYTE.
4097 E9B5 4A           MLTPL1:  LSR   A
4098 E9B6 09 80                 ORA   #$80
4099 E9B8 A8           MLTPL2:  TAY   
4100 E9B9 90 19                 BCC   MLTPL3                   ;IT MULT BIT=0, JUST SHIFT.
4101 E9BB 18                    CLC   
4102 E9BC A5 65                 LDA   RESLO
4103 E9BE 65 A9                 ADC   ARGLO
4104 E9C0 85 65                 STA   RESLO
4105 E9C2 A5 64                 LDA   RESMO
4106 E9C4 65 A8                 ADC   ARGMO
4107 E9C6 85 64                 STA   RESMO
4108 E9C8 A5 63                 LDA   RESMOH
4109 E9CA 65 A7                 ADC   ARGMOH
4110 E9CC 85 63                 STA   RESMOH
4111 E9CE A5 62                 LDA   RESHO
4112 E9D0 65 A6                 ADC   ARGHO
4113 E9D2 85 62                 STA   RESHO
4114 E9D4 66 62        MLTPL3:  ROR   RESHO
4115 E9D6 66 63                 ROR   RESMOH
4116 E9D8 66 64                 ROR   RESMO
4117 E9DA 66 65                 ROR   RESLO
4118 E9DC 66 AC                 ROR   FACOV                    ;SAVE FOR ROUNDING.
4119 E9DE 98                    TYA   
4120 E9DF 4A                    LSR   A                        ;CLEAR MSB SO WE GET A CLOSER TO 0.
4121 E9E0 D0 D6                 BNE   MLTPL2                   ;SLOW AS A TURTLE !
4122 E9E2 60           MULTRT:  RTS   
4123 E9E3              ;ROUTINE TO UNPACK MEMORY INTO ARG.
4124 E9E3 85 5E        CONUPK:  STA   INDEX1
4125 E9E5 84 5F                 STY   INDEX1+1
4126 E9E7 A0 04                 LDY   #3+1
4127 E9E9 B1 5E                 LDA   (INDEX1),Y
4128 E9EB 85 A9                 STA   ARGLO
4129 E9ED 88                    DEY   
4130 E9EE B1 5E                 LDA   (INDEX1),Y
4131 E9F0 85 A8                 STA   ARGMO
4132 E9F2 88                    DEY   
4133 E9F3 B1 5E                 LDA   (INDEX1),Y
4134 E9F5 85 A7                 STA   ARGMOH
4135 E9F7 88                    DEY   
4136 E9F8 B1 5E                 LDA   (INDEX1),Y
4137 E9FA 85 AA                 STA   ARGSGN
4138 E9FC 45 A2                 EOR   FACSGN
4139 E9FE 85 AB                 STA   ARISGN
4140 EA00 A5 AA                 LDA   ARGSGN
4141 EA02 09 80                 ORA   #$80
4142 EA04 85 A6                 STA   ARGHO
4143 EA06 88                    DEY   
4144 EA07 B1 5E                 LDA   (INDEX1),Y
4145 EA09 85 A5                 STA   ARGEXP
4146 EA0B A5 9D                 LDA   FACEXP                   ;SET CODES OF FACEXP.
4147 EA0D 60                    RTS   
4148 EA0E              ;CHECK SPECIAL CASES AND ADD EXPONENTS FOR FMULT, FDIV.
4149 EA0E A5 A5        MULDIV:  LDA   ARGEXP                   ;EXP OF ARG=0?
4150 EA10 F0 1F        MLDEXP:  BEQ   ZEREMV                   ;SO WE GET ZERO EXPONENT.
4151 EA12 18                    CLC   
4152 EA13 65 9D                 ADC   FACEXP                   ;RESULT IS IN ACCA.
4153 EA15 90 04                 BCC   TRYOFF                   ;FIND C XOR N.
4154 EA17 30 1D                 BMI   GOOVER                   ;OVERFLOW IF BITS MATCH.
4155 EA19 18                    CLC   
4156 EA1A 2C                    DC B:44
4157 EA1B 10 14        TRYOFF:  BPL   ZEREMV                   ;UNDERFLOW.
4158 EA1D 69 80                 ADC   #$80                     ;ADD BIAS.
4159 EA1F 85 9D                 STA   FACEXP
4160 EA21 D0 03                 BNE   *+5
4161 EA23 4C 52 E8              JMP   ZEROML                   ;ZE THE REST OF IT.
4162 EA26 A5 AB                 LDA   ARISGN
4163 EA28 85 A2                 STA   FACSGN                   ;ARISGN IS RESULT'S SIGN.
4164 EA2A 60                    RTS                            ;DONE.
4165 EA2B A5 A2        MLDVEX:  LDA   FACSGN                   ;GET SIGN.
4166 EA2D 49 FF                 EOR   #$FF                     ;COMPLEMENT IT.
4167 EA2F 30 05                 BMI   GOOVER
4168 EA31 68           ZEREMV:  PLA                            ;GET ADDR OFF STACK.
4169 EA32 68                    PLA   
4170 EA33 4C 4E E8              JMP   ZEROFC                   ;UNDERFLOW.
4171 EA36 4C D5 E8     GOOVER:  JMP   OVERR                    ;OVERFLOW.
4172 EA39              ;MULTIPLY FAC BY 10.
4173 EA39 20 63 EB     MUL10:   JSR   MOVAF                    ;COPY FAC INTO ARG.
4174 EA3C AA                    TAX   
4175 EA3D F0 10                 BEQ   MUL10R                   ;IF FAC=0, GOT ANSWER.
4176 EA3F 18                    CLC   
4177 EA40 69 02                 ADC   #2                       ;AUGMENT EXP BY 2.
4178 EA42 B0 F2                 BCS   GOOVER                   ;OVERFLOW.
4179 EA44 A2 00        FINML6:  LDX   #0
4180 EA46 86 AB                 STX   ARISGN                   ;SIGNS ARE SAME.
4181 EA48 20 CE E7              JSR   FADDC                    ;ADD TOGETHER.
4182 EA4B E6 9D                 INC   FACEXP                   ;MULTIPLY BY TWO.
4183 EA4D F0 E7                 BEQ   GOOVER                   ;OVERFLOW.
4184 EA4F 60           MUL10R:  RTS   
4185 EA50              ; DIVIDE FAC BY 10.
4186 EA50 84           TEN_C:   DC B:$84
4187 EA51 20                    DC B:$20
4188 EA52 00                    DC B:$00
4189 EA53 00                    DC B:$00
4190 EA54 00                    DC B:$00
4191 EA55 20 63 EB     DIV10:   JSR   MOVAF                    ;MOVE FAC TO ARG.
4192 EA58 A9 50                 LDA   #TEN_C
4193 EA5A A0 EA                 LDY   #>TEN_C                  ;POINT TO CONSTANT OF 10.0
4194 EA5C A2 00                 LDX   #0                       ;SIGNS ARE BOTH POSITIVE.
4195 EA5E 86 AB        FDIVF:   STX   ARISGN
4196 EA60 20 F9 EA              JSR   MOVFM                    ;PUT IT INTO FAC.
4197 EA63 4C 69 EA              JMP   FDIVT                    ;SKIP OVER NEXT TWO BYTES.
4198 EA66 20 E3 E9     FDIV:    JSR   CONUPK                   ;UNPACK CONSTANT.
4199 EA69 F0 76        FDIVT:   BEQ   DV0ERR                   ;CAN'T DIVIDE BY ZERO !
4200 EA6B              ;(NOT ENOUGH ROOM TO STORE RESULT.)
4201 EA6B 20 72 EB              JSR   ROUND                    ;TAKE FACOV INTO ACCT IN FAC.
4202 EA6E A9 00                 LDA   #0                       ;NEGATE FACEXP.
4203 EA70 38                    SEC   
4204 EA71 E5 9D                 SBC   FACEXP
4205 EA73 85 9D                 STA   FACEXP
4206 EA75 20 0E EA              JSR   MULDIV                   ;FIX UP EXPONENTS.
4207 EA78 E6 9D                 INC   FACEXP                   ;SCALE IT RIGHT.
4208 EA7A F0 BA                 BEQ   GOOVER                   ;OVERFLOW.
4209 EA7C A2 FC                 LDX   #$100-3-1                ;SETUP PROCEDURE.
4210 EA7E A9 01                 LDA   #1
4211 EA80              DIVIDE:  EQU   *                        ;THIS IS THE BEST CODE IN THE WHOLE PILE
4212 EA80 A4 A6                 LDY   ARGHO                    ;SEE WHAT RELATION HOLDS.
4213 EA82 C4 9E                 CPY   FACHO
4214 EA84 D0 10                 BNE   SAVQUO                   ;C=0,1. N(C=0)=0.
4215 EA86 A4 A7                 LDY   ARGMOH
4216 EA88 C4 9F                 CPY   FACMOH
4217 EA8A D0 0A                 BNE   SAVQUO
4218 EA8C A4 A8                 LDY   ARGMO
4219 EA8E C4 A0                 CPY   FACMO
4220 EA90 D0 04                 BNE   SAVQUO
4221 EA92 A4 A9                 LDY   ARGLO
4222 EA94 C4 A1                 CPY   FACLO
4223 EA96 08           SAVQUO:  PHP   
4224 EA97 2A                    ROL   A                        ;SAVE RESULT.
4225 EA98 90 09                 BCC   QSHFT                    ;IF NOT DONE, CONTINUE.
4226 EA9A E8                    INX   
4227 EA9B 95 65                 STA   RESLO,X
4228 EA9D F0 32                 BEQ   LD100
4229 EA9F 10 34                 BPL   DIVNRM                   ;NOTE THIS REQ 1 MO RAM THEN NECESS.
4230 EAA1 A9 01                 LDA   #1
4231 EAA3 28           QSHFT:   PLP                            ;RETURN CONDITION CODES.
4232 EAA4 B0 0E                 BCS   DIVSUB                   ;FAC .LE. ARG.
4233 EAA6 06 A9        SHFARG:  ASL   ARGLO                    ;SHIFT ARG ONE PLACE LEFT.
4234 EAA8 26 A8                 ROL   ARGMO
4235 EAAA 26 A7                 ROL   ARGMOH
4236 EAAC 26 A6                 ROL   ARGHO
4237 EAAE B0 E6                 BCS   SAVQUO                   ;SAVE A RESULT OF ONE FOR THIS POSITION
4238 EAB0              ;AND DIVIDE.
4239 EAB0 30 CE                 BMI   DIVIDE                   ;IF MSB ON, GO DECIDE WHETHER TO SUB.
4240 EAB2 10 E2                 BPL   SAVQUO
4241 EAB4 A8           DIVSUB:  TAY                            ;NOTICE C MUST BE ON HERE.
4242 EAB5 A5 A9                 LDA   ARGLO
4243 EAB7 E5 A1                 SBC   FACLO
4244 EAB9 85 A9                 STA   ARGLO
4245 EABB A5 A8                 LDA   ARGMO
4246 EABD E5 A0                 SBC   FACMO
4247 EABF 85 A8                 STA   ARGMO
4248 EAC1 A5 A7                 LDA   ARGMOH
4249 EAC3 E5 9F                 SBC   FACMOH
4250 EAC5 85 A7                 STA   ARGMOH
4251 EAC7 A5 A6                 LDA   ARGHO
4252 EAC9 E5 9E                 SBC   FACHO
4253 EACB 85 A6                 STA   ARGHO
4254 EACD 98                    TYA   
4255 EACE 4C A6 EA              JMP   SHFARG
4256 EAD1 A9 40        LD100:   LDA   #$40                     ;ONLY WANT TWO MORE BITS.
4257 EAD3 D0 CE                 BNE   QSHFT                    ;ALWAYS BRANCHES.
4258 EAD5              DIVNRM:  EQU   *
4259 EAD5 0A                    ASL   A
4260 EAD6 0A                    ASL   A
4261 EAD7 0A                    ASL   A
4262 EAD8 0A                    ASL   A
4263 EAD9 0A                    ASL   A
4264 EADA 0A                    ASL   A                        ;GET LAST TWO BITS INTO MSB AND B6.
4265 EADB 85 AC                 STA   FACOV
4266 EADD 28                    PLP                            ;TO GET GARBAGE OFF STACK.
4267 EADE 4C E6 EA              JMP   MOVFR                    ;MOVE RESULT INTO FAC, THEN
4268 EAE1              ;NORMALIZE RESULTND RETURN.
4269 EAE1 A2 85        DV0ERR:  LDX   #ERRDV0
4270 EAE3 4C 12 D4              JMP   ERROR
4271 EAE6                       EJECT 
4272 EAE6                       TITLE 'FLOATING POINT MOVEMENT ROUTINES.'
4273 EAE6              ;MOVE RESULT TO FAC.
4274 EAE6 A5 62        MOVFR:   LDA   RESHO
4275 EAE8 85 9E                 STA   FACHO
4276 EAEA A5 63                 LDA   RESMOH
4277 EAEC 85 9F                 STA   FACMOH
4278 EAEE A5 64                 LDA   RESMO
4279 EAF0 85 A0                 STA   FACMO
4280 EAF2 A5 65                 LDA   RESLO                    ;MOVE LO AND SGN.
4281 EAF4 85 A1                 STA   FACLO
4282 EAF6 4C 2E E8              JMP   NORMAL                   ;ALL DONE.
4283 EAF9              ;MOVE MEMORY INTO FAC (UNPACKED).
4284 EAF9 85 5E        MOVFM:   STA   INDEX1
4285 EAFB 84 5F                 STY   INDEX1+1
4286 EAFD A0 04                 LDY   #3+1
4287 EAFF B1 5E                 LDA   (INDEX1),Y
4288 EB01 85 A1                 STA   FACLO
4289 EB03 88                    DEY   
4290 EB04 B1 5E                 LDA   (INDEX1),Y
4291 EB06 85 A0                 STA   FACMO
4292 EB08 88                    DEY   
4293 EB09 B1 5E                 LDA   (INDEX1),Y
4294 EB0B 85 9F                 STA   FACMOH
4295 EB0D 88                    DEY   
4296 EB0E B1 5E                 LDA   (INDEX1),Y
4297 EB10 85 A2                 STA   FACSGN
4298 EB12 09 80                 ORA   #$80
4299 EB14 85 9E                 STA   FACHO
4300 EB16 88                    DEY   
4301 EB17 B1 5E                 LDA   (INDEX1),Y
4302 EB19 85 9D                 STA   FACEXP                   ;LEAVE SWITCHES SET ON EXP.
4303 EB1B 84 AC                 STY   FACOV
4304 EB1D 60                    RTS   
4305 EB1E              ;MOVE NUMBER FROM FAC TO MEMORY.
4306 EB1E A2 98        MOV2F:   LDX   #TEMPF2
4307 EB20 2C                    DC B:44
4308 EB21 A2 93        MOV1F:   LDX   #TEMPF1
4309 EB23 A0 00        MOVML:   LDY   #0
4310 EB25 F0 04                 BEQ   MOVMF                    ;ALWAYS BRANCHES.
4311 EB27 A6 85        MOVVF:   LDX   FORPNT
4312 EB29 A4 86                 LDY   FORPNT+1
4313 EB2B 20 72 EB     MOVMF:   JSR   ROUND
4314 EB2E 86 5E                 STX   INDEX1
4315 EB30 84 5F                 STY   INDEX1+1
4316 EB32 A0 04                 LDY   #3+1
4317 EB34 A5 A1                 LDA   FACLO
4318 EB36 91 5E                 STA   (INDEX),Y
4319 EB38 88                    DEY   
4320 EB39 A5 A0                 LDA   FACMO
4321 EB3B 91 5E                 STA   (INDEX),Y
4322 EB3D 88                    DEY   
4323 EB3E A5 9F                 LDA   FACMOH
4324 EB40 91 5E                 STA   (INDEX),Y
4325 EB42 88                    DEY   
4326 EB43 A5 A2                 LDA   FACSGN                   ;INCLUDE SIGN IN HO.  ORA #$7F
4327 EB45 09 7F                 ORA   #$7F
4328 EB47 25 9E                 AND   FACHO
4329 EB49 91 5E                 STA   (INDEX),Y
4330 EB4B 88                    DEY   
4331 EB4C A5 9D                 LDA   FACEXP
4332 EB4E 91 5E                 STA   (INDEX),Y
4333 EB50 84 AC                 STY   FACOV                    ;ZERO IT SINCE ROUNDED.
4334 EB52 60                    RTS                            ;Y=0.
4335 EB53              ;MOVE ARG INTO FAC.
4336 EB53 A5 AA        MOVFA:   LDA   ARGSGN
4337 EB55 85 A2        MOVFA1:  STA   FACSGN
4338 EB57 A2 05                 LDX   #4+1
4339 EB59 B5 A4        MOVFAL:  LDA   ARGEXP-1,X
4340 EB5B 95 9C                 STA   FACEXP-1,X
4341 EB5D CA                    DEX   
4342 EB5E D0 F9                 BNE   MOVFAL
4343 EB60 86 AC                 STX   FACOV
4344 EB62 60                    RTS   
4345 EB63              ;MOVE FAC INTO ARG.
4346 EB63 20 72 EB     MOVAF:   JSR   ROUND
4347 EB66 A2 06        MOVEF:   LDX   #5+1
4348 EB68 B5 9C        MOVAFL:  LDA   FACEXP-1,X
4349 EB6A 95 A4                 STA   ARGEXP-1,X
4350 EB6C CA                    DEX   
4351 EB6D D0 F9                 BNE   MOVAFL
4352 EB6F 86 AC                 STX   FACOV                    ;ZERO IT SINCE ROUNDED.
4353 EB71 60           MOVRTS:  RTS   
4354 EB72 A5 9D        ROUND:   LDA   FACEXP                   ;ZO?
4355 EB74 F0 FB                 BEQ   MOVRTS                   ;YES. DONE ROUNDING.
4356 EB76 06 AC                 ASL   FACOV                    ;ROUND?
4357 EB78 90 F7                 BCC   MOVRTS                   ;NO. MSB OFF.
4358 EB7A 20 C6 E8     INCRND:  JSR   INCFAC                   ;YES, ADD ONE TO LSB(FAC).
4359 EB7D D0 F2                 BNE   MOVRTS                   ;NO CARRY MEANS DONE.
4360 EB7F 4C 8F E8              JMP   RNDSHF                   ;SQUEEZ MSB IN AND RTS.
4361 EB82              ;NOTE C=1 SINCE INCFAC DOESNT TOUCH C.
4362 EB82                       EJECT 
4363 EB82                       TITLE 'SIGN, SGN, FLOAT, NEG, ABS.'
4364 EB82              ;PUT SIGN OF FAC IN ACCA.
4365 EB82 A5 9D        SIGN:    LDA   FACEXP
4366 EB84 F0 09                 BEQ   SIGNRT                   ;IF NUMBER IS ZERO, SO IS RESULT.
4367 EB86 A5 A2        FCSIGN:  LDA   FACSGN
4368 EB88 2A           FCOMPS:  ROL   A
4369 EB89 A9 FF                 LDA   #$100-1                  ;ASSUME NEGATIVE.
4370 EB8B B0 02                 BCS   SIGNRT
4371 EB8D A9 01                 LDA   #1                       ;GET .
4372 EB8F 60           SIGNRT:  RTS   
4373 EB90              ;SGN FUNCTION.
4374 EB90 20 82 EB     SGN:     JSR   SIGN
4375 EB93              ;FLOAT THE SIGNED INTEGER IN ACCA.
4376 EB93 85 9E        FLOAT:   STA   FACHO                    ;PUT ACCA IN HIGH ORDER.
4377 EB95 A9 00                 LDA   #0
4378 EB97 85 9F                 STA   FACHO+1
4379 EB99 A2 88                 LDX   #$88                     ;GET THE EXPONENT.
4380 EB9B              ;FLOAT THE SIGNED NUMBER IN FAC.
4381 EB9B A5 9E        FLOATS:  LDA   FACHO
4382 EB9D 49 FF                 EOR   #$FF
4383 EB9F 2A                    ROL   A                        ;GET COMP OF SIGN IN CARRY.
4384 EBA0 A9 00        FLOATC:  LDA   #0                       ;ZERO ACCA BUT NOT CARRY.
4385 EBA2 85 A1                 STA   FACLO
4386 EBA4 85 A0                 STA   FACMO
4387 EBA6 86 9D        FLOATB:  STX   FACEXP
4388 EBA8 85 AC                 STA   FACOV
4389 EBAA 85 A2                 STA   FACSGN
4390 EBAC 4C 29 E8              JMP   FADFLT
4391 EBAF              ;ABSOLUTE VALUE OF FAC.
4392 EBAF 46 A2        ABS:     LSR   FACSGN
4393 EBB1 60                    RTS   
4394 EBB2                       EJECT 
4395 EBB2                       TITLE 'COMPARE TWO NUMBERS.'
4396 EBB2              ;A=1 IF ARG .LT. FAC.
4397 EBB2              ;A=0 IF ARG=FAC.
4398 EBB2              ;A=-1 IF ARG .GT. FAC.
4399 EBB2 85 60        FCOMP:   STA   INDEX2
4400 EBB4 84 61        FCOMPN:  STY   INDEX2+1
4401 EBB6 A0 00                 LDY   #0
4402 EBB8 B1 60                 LDA   (INDEX2),Y               ;HAS ARGEXP.
4403 EBBA C8                    INY                            ;BUMP PNTR UP.
4404 EBBB AA                    TAX                            ;SAVE A IN X AND RESET CODES.
4405 EBBC F0 C4                 BEQ   SIGN
4406 EBBE B1 60                 LDA   (INDEX2),Y
4407 EBC0 45 A2                 EOR   FACSGN                   ;SIGNS THE SAME.
4408 EBC2 30 C2                 BMI   FCSIGN                   ;SIGNS DIFFER SO RESULT IS
4409 EBC4              ;SIGN OF FAC AGAIN.
4410 EBC4 E4 9D        FOUTCP:  CPX   FACEXP
4411 EBC6 D0 21                 BNE   FCOMPC
4412 EBC8 B1 60                 LDA   (INDEX2),Y
4413 EBCA 09 80                 ORA   #$80
4414 EBCC C5 9E                 CMP   FACHO
4415 EBCE D0 19                 BNE   FCOMPC
4416 EBD0 C8                    INY   
4417 EBD1 B1 60                 LDA   (INDEX2),Y
4418 EBD3 C5 9F                 CMP   FACMOH
4419 EBD5 D0 12                 BNE   FCOMPC
4420 EBD7 C8                    INY   
4421 EBD8 B1 60                 LDA   (INDEX2),Y
4422 EBDA C5 A0                 CMP   FACMO
4423 EBDC D0 0B                 BNE   FCOMPC
4424 EBDE C8                    INY   
4425 EBDF A9 7F                 LDA   #$7F
4426 EBE1 C5 AC                 CMP   FACOV
4427 EBE3 B1 60                 LDA   (INDEX2),Y
4428 EBE5 E5 A1                 SBC   FACLO                    ;GET ZERO IF EQUAL.
4429 EBE7 F0 28                 BEQ   QINTRT
4430 EBE9 A5 A2        FCOMPC:  LDA   FACSGN
4431 EBEB 90 02                 BCC   FCOMPD
4432 EBED 49 FF                 EOR   #$FF
4433 EBEF 4C 88 EB     FCOMPD:  JMP   FCOMPS                   ;A PART OF SIGN SETS ACCA UP.
4434 EBF2                       EJECT 
4435 EBF2                       TITLE 'GREATEST INTEGER FUNCTION.'
4436 EBF2              ;QUICK GREATEST INTEGER FUNCTION.
4437 EBF2              ;LEAVES INT(FAC) IN FACHO&MO&LO SIGNED.
4438 EBF2              ;ASSUMES FAC .LT. 223 = 8388608
4439 EBF2 A5 9D        QINT:    LDA   FACEXP
4440 EBF4 F0 4A                 BEQ   CLRFAC                   ;IF ZERO, GOT IT.
4441 EBF6 38                    SEC   
4442 EBF7 E9 A0                 SBC   #$98+8                   ;GET NUMBER OF PLACES TO SHIFT.
4443 EBF9 24 A2                 BIT   FACSGN
4444 EBFB 10 09                 BPL   QISHFT
4445 EBFD AA                    TAX   
4446 EBFE A9 FF                 LDA   #$FF
4447 EC00 85 A4                 STA   BITS                     ;PUT 377 IN WHEN SHFTR SHIFTS BYTES.
4448 EC02 20 A4 E8              JSR   NEGFCH                   ;TRULY NEGATE QUANTITY IN FAC.
4449 EC05 8A                    TXA   
4450 EC06 A2 9D        QISHFT:  LDX   #FAC
4451 EC08 C9 F9                 CMP   #$100-7
4452 EC0A 10 06                 BPL   QINT1                    ;IF NUMBER OF PLACES .GE. 7
4453 EC0C              ;SHIFT 1 PLACE @ A TIME
4454 EC0C 20 F0 E8              JSR   SHIFTR                   ;START SHIFTN BYTS, THEN BITS
4455 EC0F 84 A4                 STY   BITS                     ;ZERO BITS; ADDER WANTS 0
4456 EC11 60           QINTRT:  RTS   
4457 EC12 A8           QINT1:   TAY                            ;CNT IN CTR
4458 EC13 A5 A2                 LDA   FACSGN
4459 EC15 29 80                 AND   #$80                     ;GET SIGN BIT.
4460 EC17 46 9E                 LSR   FACHO                    ;SAVE FIR SHIFTED BYTE.
4461 EC19 05 9E                 ORA   FACHO
4462 EC1B 85 9E                 STA   FACHO
4463 EC1D 20 07 E9              JSR   ROLSHF                   ;SHIFT THE REST.
4464 EC20 84 A4                 STY   BITS                     ;ZERO BITS.
4465 EC22 60                    RTS   
4466 EC23              ;GREATEST INTEGER FUNCTION.
4467 EC23 A5 9D        INT:     LDA   FACEXP
4468 EC25 C9 A0                 CMP   #$98+8
4469 EC27 B0 20                 BCS   INTRTS                   ;FORGET IT.
4470 EC29 20 F2 EB              JSR   QINT
4471 EC2C 84 AC                 STY   FACOV                    ;CLR OVERFLOW BYTE.
4472 EC2E A5 A2                 LDA   FACSGN
4473 EC30 84 A2                 STY   FACSGN                   ;MAKE FAC POSITIVE
4474 EC32 49 80                 EOR   #$80                     ;GET COMPLEMENT OF SIGN IN CARRY.
4475 EC34 2A                    ROL   A
4476 EC35 A9 A0                 LDA   #$98+8
4477 EC37 85 9D                 STA   FACEXP
4478 EC39 A5 A1                 LDA   FACLO
4479 EC3B 85 0D                 STA   INTEGR
4480 EC3D 4C 29 E8              JMP   FADFLT
4481 EC40 85 9E        CLRFAC:  STA   FACHO                    ;MAKE IT REALLY ZERO.
4482 EC42 85 9F                 STA   FACMOH
4483 EC44 85 A0                 STA   FACMO
4484 EC46 85 A1                 STA   FACLO
4485 EC48 A8                    TAY   
4486 EC49 60           INTRTS:  RTS   
4487 EC4A                       EJECT 
4488 EC4A                       TITLE 'FLOATING POINT INPUT ROUTINE.'
4489 EC4A              ;NUMBER INPUT IS LEFT IN FAC.
4490 EC4A              ;AT ENTRY TXTPTR POINTS TO THE 1ST CHARACTER IN A TEXT BUF
4491 EC4A              ;THE FIRST CHARACTER IS ALSO IN ACCA. FIN PACKS THE DIGITS
4492 EC4A              ;INTO THE FAC AS AN INTEGER AND KEEPS TRACK OF WHERE THE
4493 EC4A              ;DECIMAL POINT IS. DPTFLG TELL WHETHER A DP HAS BEEN
4494 EC4A              ;SEEN. DECCNT IS THE NUMBER OF DIGITS AFTER THE DP.
4495 EC4A              ;AT THE END DECCNT AND THE EXPONENT ARE USED TO
4496 EC4A              ;DETERMINE HOW MANY TIMES TO MULTIPLY ORIVIDE BY TEN
4497 EC4A              ;TO GET THE CORRECT NUMBER.
4498 EC4A A0 00        FIN:     LDY   #0                       ;ZERO FACSGN&SGNFLG.
4499 EC4C A2 0A                 LDX   #$09+1                   ;ZERO EXP AND HO (AND MOH).
4500 EC4E 94 99        FINZLP:  STY   DECCNT,X                 ;ZERO MO AND LO.
4501 EC50 CA                    DEX                            ;ZERO TENEXP AND EXPSGN
4502 EC51 10 FB                 BPL   FINZLP                   ;ZERO DECCNT, DPTFLG.
4503 EC53 90 0F                 BCC   FINDGQ                   ;FLAGS STILL SET FROM CHRGET.
4504 EC55 C9 2D                 CMP   #$2D                     ;A '-' SIGN?
4505 EC57 D0 04                 BNE   QPLUS                    ;NO, TRY +
4506 EC59 86 A3                 STX   SGNFLG                   ;IT'S NEGATIVE. (X=377).
4507 EC5B F0 04                 BEQ   FINC                     ;ALWAYS GO
4508 EC5D C9 2B        QPLUS:   CMP   #$2B                     ;PLUS SIGN?
4509 EC5F D0 05                 BNE   FIN1                     ;YES, SKIP IT.
4510 EC61 20 B1 00     FINC:    JSR   CHRGET
4511 EC64 90 5B        FINDGQ:  BCC   FINDIG
4512 EC66 C9 2E        FIN1:    CMP   #'.'                     ;THE DP?
4513 EC68 F0 2E                 BEQ   FINDP
4514 EC6A C9 45                 CMP   #'E'                     ;EXPONENT FOLLOWS.
4515 EC6C D0 30                 BNE   FINE                     ;NO.
4516 EC6E              ;HERE TO CHECK FOR SIGN OF EXP.
4517 EC6E 20 B1 00              JSR   CHRGET                   ;YES. GET ANOTHER.
4518 EC71 90 17                 BCC   FNEDG1                   ;IT IS A DIGIT. (EASIER THAN
4519 EC73              ;BACKING UP POINTER.)
4520 EC73 C9 C9                 CMP   #MINUTK                  ;MINUS?
4521 EC75 F0 0E                 BEQ   FINEC1                   ;NEGATE.
4522 EC77 C9 2D                 CMP   #$2D                     ;MINUS SIGN?
4523 EC79 F0 0A                 BEQ   FINEC1
4524 EC7B C9 C8                 CMP   #PLUSTK                  ;PLUS?
4525 EC7D F0 08                 BEQ   FINEC
4526 EC7F C9 2B                 CMP   #$2B                     ;PLUS SIGN?
4527 EC81 F0 04                 BEQ   FINEC
4528 EC83 D0 07                 BNE   FINEC2
4529 EC85 66 9C        FINEC1:  ROR   EXPSGN                   ;TURN IT ON.
4530 EC87 20 B1 00     FINEC:   JSR   CHRGET                   ;GET ANOTHER.
4531 EC8A 90 5C        FNEDG1:  BCC   FINEDG                   ;IT IS A DIGIT.
4532 EC8C 24 9C        FINEC2:  BIT   EXPSGN
4533 EC8E 10 0E                 BPL   FINE
4534 EC90 A9 00                 LDA   #0
4535 EC92 38                    SEC   
4536 EC93 E5 9A                 SBC   TENEXP
4537 EC95 4C A0 EC              JMP   FINE1
4538 EC98 66 9B        FINDP:   ROR   DPTFLG
4539 EC9A 24 9B                 BIT   DPTFLG
4540 EC9C 50 C3                 BVC   FINC
4541 EC9E A5 9A        FINE:    LDA   TENEXP
4542 ECA0 38           FINE1:   SEC   
4543 ECA1 E5 99                 SBC   DECCNT                   ;# OF PLACES TO SHIFT
4544 ECA3 85 9A                 STA   TENEXP
4545 ECA5 F0 12                 BEQ   FINQNG                   ;NEGATE?
4546 ECA7 10 09                 BPL   FINMUL                   ;POSITIVE SO MULTIPLY.
4547 ECA9 20 55 EA     FINDIV:  JSR   DIV10
4548 ECAC E6 9A                 INC   TENEXP                   ;DONE?
4549 ECAE D0 F9                 BNE   FINDIV                   ;NO.
4550 ECB0 F0 07                 BEQ   FINQNG                   ;YES.
4551 ECB2 20 39 EA     FINMUL:  JSR   MUL10
4552 ECB5 C6 9A                 DEC   TENEXP                   ;DONE?
4553 ECB7 D0 F9                 BNE   FINMUL                   ;NO
4554 ECB9 A5 A3        FINQNG:  LDA   SGNFLG
4555 ECBB 30 01                 BMI   NEGXQS                   ;IF POSITE, RETURN.
4556 ECBD 60                    RTS   
4557 ECBE 4C D0 EE     NEGXQS:  JMP   NEGOP                    ;ELSE, NEG AND RTN
4558 ECC1 48           FINDIG:  PHA   
4559 ECC2 24 9B                 BIT   DPTFLG
4560 ECC4 10 02                 BPL   FINDG1
4561 ECC6 E6 99                 INC   DECCNT
4562 ECC8 20 39 EA     FINDG1:  JSR   MUL10
4563 ECCB 68                    PLA                            ;GET IT BACK.
4564 ECCC 38                    SEC   
4565 ECCD E9 30                 SBC   #'0'
4566 ECCF 20 D5 EC              JSR   FINLOG                   ;ADD IT IN.
4567 ECD2 4C 61 EC              JMP   FINC
4568 ECD5 48           FINLOG:  PHA   
4569 ECD6 20 63 EB              JSR   MOVAF                    ;SAVE FAC FOR LATER.
4570 ECD9 68                    PLA   
4571 ECDA 20 93 EB              JSR   FLOAT                    ;FLOAT THE A REG
4572 ECDD A5 AA                 LDA   ARGSGN
4573 ECDF 45 A2                 EOR   FACSGN
4574 ECE1 85 AB                 STA   ARISGN                   ;RESULTANT SIGN.
4575 ECE3 A6 9D                 LDX   FACEXP                   ;SET SIGNS ON THING TO ADD.
4576 ECE5 4C C1 E7              JMP   FADDT                    ;ADD  AND RETURN
4577 ECE8              ;HERE PACK IN THE NEXDIGIT OF THE EXPONENT.
4578 ECE8              ;MULTIPLY THE OLD EXP BY 10 AND ADD IN THE NEXT
4579 ECE8              ;DIGIT. NOTE: EXP OVERFLOW IS NOT CHECKED FOR.
4580 ECE8 A5 9A        FINEDG:  LDA   TENEXP                   ;GET EXP SO FAR.
4581 ECEA C9 0A                 CMP   #$0A                     ;WILL RESULT BE .GE. 100?
4582 ECEC 90 09                 BCC   MLEX10
4583 ECEE A9 64                 LDA   #$64                     ;GET 100.
4584 ECF0 24 9C                 BIT   EXPSGN
4585 ECF2 30 11                 BMI   MLEXMI                   ;IF NEG EXP, NO CHK FOR OVERR.
4586 ECF4 4C D5 E8              JMP   OVERR
4587 ECF7 0A           MLEX10:  ASL   A                        ;MULT BY 2 TWICE
4588 ECF8 0A                    ASL   A
4589 ECF9 18                    CLC                            ;POSSIBLE SHIFT OUT OF HIGH.
4590 ECFA 65 9A                 ADC   TENEXP                   ;LIKE MULTIPLYING BY FIVE.
4591 ECFC 0A                    ASL   A                        ;AND NOW BY TEN.
4592 ECFD 18                    CLC   
4593 ECFE A0 00                 LDY   #0
4594 ED00 71 B8                 ADC   (TXTPTR),Y
4595 ED02 38                    SEC   
4596 ED03 E9 30                 SBC   #'0'
4597 ED05 85 9A        MLEXMI:  STA   TENEXP                   ;SAVE RESULT.
4598 ED07 4C 87 EC              JMP   FINEC
4599 ED0A                       EJECT 
4600 ED0A                       TITLE 'FLOATING POINT OUTPUT ROUTINE.'
4601 ED0A 9B           N_0999:  DC B:$9B                       ; 99999999.9499
4602 ED0B 3E                    DC B:$3E
4603 ED0C BC                    DC B:$BC
4604 ED0D 1F                    DC B:$1F
4605 ED0E FD                    DC B:$FD
4606 ED0F 9E           N_9999:  DC B:$9E                       ; 999999999.499
4607 ED10 6E                    DC B:$6E
4608 ED11 6B                    DC B:$6B
4609 ED12 27                    DC B:$27
4610 ED13 FD                    DC B:$FD
4611 ED14 9E           N_MIL:   DC B:$9E                       ; 109
4612 ED15 6E                    DC B:$6E
4613 ED16 6B                    DC B:$6B
4614 ED17 28                    DC B:$28
4615 ED18 00                    DC B:$00
4616 ED19              ;ENTRY TO LINPRT.
4617 ED19 A9 58        INPRT:   LDA   #INTXT
4618 ED1B A0 D3                 LDY   #>INTXT
4619 ED1D 20 31 ED              JSR   STROU2
4620 ED20 A5 76                 LDA   CURLIN+1
4621 ED22 A6 75                 LDX   CURLIN
4622 ED24 85 9E        LINPRT:  STA   FACHO
4623 ED26 86 9F                 STX   FACHO+1
4624 ED28 A2 90                 LDX   #$90                     ;EXPONENT OF 16.
4625 ED2A 38                    SEC                            ;NUMBER IS POSITIVE.
4626 ED2B 20 A0 EB              JSR   FLOATC
4627 ED2E 20 34 ED              JSR   FOUT
4628 ED31 4C 3A DB     STROU2:  JMP   STROUT                   ;PRINT AND RETURN.
4629 ED34 A0 01        FOUT:    LDY   #1
4630 ED36 A9 2D        FOUTC:   LDA   #$2D                     ;PRINT NULL IF PLUS
4631 ED38 88                    DEY                            ;NEG SIGN IF NEGATIVE
4632 ED39 24 A2                 BIT   FACSGN
4633 ED3B 10 04                 BPL   FOUT1_1
4634 ED3D C8                    INY   
4635 ED3E 99 FF 00     FOUT1:   STA   |FBUFFR-1,Y              ;STA THE CHR
4636 ED41 85 A2        FOUT1_1: STA   FACSGN                   ;MAKE FAC POS FOR QINT.
4637 ED43 84 AD                 STY   FBUFPT                   ;SAVE FOR LATER.
4638 ED45 C8                    INY   
4639 ED46 A9 30                 LDA   #'0'                     ;GET ZERO TO TYPE IF FAC=0.
4640 ED48 A6 9D                 LDX   FACEXP
4641 ED4A D0 03                 BNE   *+5
4642 ED4C 4C 57 EE              JMP   FOUT19
4643 ED4F A9 00                 LDA   #0
4644 ED51 E0 80                 CPX   #$80                     ;IS NUMBER .LT. 1.0 ?
4645 ED53 F0 02                 BEQ   FOUT37                   ;NO.
4646 ED55 B0 09                 BCS   FOUT7
4647 ED57 A9 14        FOUT37:  LDA   #N_MIL
4648 ED59 A0 ED                 LDY   #>N_MIL                  ;MULTIPLY BY 106.
4649 ED5B 20 7F E9              JSR   FMULT
4650 ED5E A9 F7                 LDA   #$100-6-3
4651 ED60 85 99        FOUT7:   STA   DECCNT                   ;SAVE COUNT OR ZERO IT.
4652 ED62 A9 0F        FOUT4:   LDA   #N_9999
4653 ED64 A0 ED                 LDY   #>N_9999
4654 ED66 20 B2 EB              JSR   FCOMP                    ;IS NUMBER .GT. 999999.499 ?
4655 ED69              ;OR 999999999.499?
4656 ED69 F0 1E                 BEQ   BIGGES
4657 ED6B 10 12                 BPL   FOUT9                    ;YES. MAKE IT SMALLER.
4658 ED6D A9 0A        FOUT3:   LDA   #N_0999
4659 ED6F A0 ED                 LDY   #>N_0999
4660 ED71 20 B2 EB              JSR   FCOMP                    ;IS NUMBER .GT. 99999.9499 ?
4661 ED74              ; OR 99999999.9499?
4662 ED74 F0 02                 BEQ   FOUT38
4663 ED76 10 0E                 BPL   FOUT5                    ;YES. DONE MULTIPLYING.
4664 ED78 20 39 EA     FOUT38:  JSR   MUL10                    ;MAKE IT BIGGER.
4665 ED7B C6 99                 DEC   DECCNT
4666 ED7D D0 EE                 BNE   FOUT3                    ;SEE IF THAT DOES IT.
4667 ED7F              ;THIS ALWAYS GOES.
4668 ED7F 20 55 EA     FOUT9:   JSR   DIV10                    ;MAKE IT SMALLER.
4669 ED82 E6 99                 INC   DECCNT
4670 ED84 D0 DC                 BNE   FOUT4                    ;SEE IF THAT DOES IT.
4671 ED86              ;THIS ALWAYS GOES.
4672 ED86 20 A0 E7     FOUT5:   JSR   FADDH                    ;ADD A HALF TO ROUND UP.
4673 ED89 20 F2 EB     BIGGES:  JSR   QINT
4674 ED8C A2 01                 LDX   #1                       ;DECIMAL POINT COUNT.
4675 ED8E A5 99                 LDA   DECCNT
4676 ED90 18                    CLC   
4677 ED91 69 0A                 ADC   #3*1+7                   ;SHOULD # PRINT IN E FORM?
4678 ED93              ;IE, IS NUMBER .LT. .01 ?
4679 ED93 30 09                 BMI   FOUTPI                   ;YES.
4680 ED95 C9 0B                 CMP   #3*1+$08                 ;IS IT .GT. 999999 (999999999)?
4681 ED97 B0 06                 BCS   FOUT6                    ;YES. USE E NOTATION.
4682 ED99 69 FF                 ADC   #$100-1                  ;# OF PLACES BR DEC PT
4683 ED9B AA                    TAX                            ;PUT INTO ACCX.
4684 ED9C A9 02                 LDA   #2                       ;NO E NOTATION.
4685 ED9E 38           FOUTPI:  SEC   
4686 ED9F E9 02        FOUT6:   SBC   #2                       ;ADD 5 TO ORIG EXP
4687 EDA1 85 9A                 STA   TENEXP                   ;THAT IS THE EXPONENT TO PRINT.
4688 EDA3 86 99                 STX   DECCNT                   ;# OF DEC PLACS
4689 EDA5 8A                    TXA   
4690 EDA6 F0 02                 BEQ   FOUT39
4691 EDA8 10 13                 BPL   FOUT8                    ;SOME PLACES BEFORE DEC PNT.
4692 EDAA A4 AD        FOUT39:  LDY   FBUFPT                   ;PTR TO OUTPUT
4693 EDAC A9 2E                 LDA   #'.'                     ;PUT IN '.'
4694 EDAE C8                    INY   
4695 EDAF 99 FF 00              STA   |FBUFFR-1,Y
4696 EDB2 8A                    TXA   
4697 EDB3 F0 06                 BEQ   FOUT16
4698 EDB5 A9 30                 LDA   #'0'                     ;GET THE ENSUING ZERO.
4699 EDB7 C8                    INY   
4700 EDB8 99 FF 00              STA   |FBUFFR-1,Y
4701 EDBB 84 AD        FOUT16:  STY   FBUFPT                   ;SAVE FOLATER.
4702 EDBD A0 00        FOUT8:   LDY   #0
4703 EDBF A2 80        FOUTIM:  LDX   #$80                     ;FIRST PASS THRU, ACCX HAS MSB SET.
4704 EDC1 A5 A1        FOUT2:   LDA   FACLO
4705 EDC3 18                    CLC   
4706 EDC4 79 6C EE              ADC   FOUTBL+2+1,Y
4707 EDC7 85 A1                 STA   FACLO
4708 EDC9 A5 A0                 LDA   FACMO
4709 EDCB 79 6B EE              ADC   FOUTBL+1+1,Y
4710 EDCE 85 A0                 STA   FACMO
4711 EDD0 A5 9F                 LDA   FACMOH
4712 EDD2 79 6A EE              ADC   FOUTBL+1,Y
4713 EDD5 85 9F                 STA   FACMOH
4714 EDD7 A5 9E                 LDA   FACHO
4715 EDD9 79 69 EE              ADC   FOUTBL,Y
4716 EDDC 85 9E                 STA   FACHO
4717 EDDE E8                    INX                            ;IT WAS DONE YET ANOTHER TIME.
4718 EDDF B0 04                 BCS   FOUT41
4719 EDE1 10 DE                 BPL   FOUT2
4720 EDE3 30 02                 BMI   FOUT40
4721 EDE5 30 DA        FOUT41:  BMI   FOUT2
4722 EDE7 8A           FOUT40:  TXA   
4723 EDE8 90 04                 BCC   FOUTYP                   ;CAN USE ACCA AS IS.
4724 EDEA 49 FF                 EOR   #$FF                     ;FIND 11.-A.
4725 EDEC 69 0A                 ADC   #$0A                     ;C IS STILL ON TO COMPLETE NEGAON.
4726 EDEE              ;AND WILL ALWAYS BE ON AFTER.
4727 EDEE 69 2F        FOUTYP:  ADC   #'0'-1                   ;GET A CHARACTER TO PRINT.
4728 EDF0 C8                    INY   
4729 EDF1 C8                    INY   
4730 EDF2 C8                    INY   
4731 EDF3 C8                    INY                            ;BUMP POINTER UP.
4732 EDF4 84 83                 STY   FDECPT
4733 EDF6 A4 AD                 LDY   FBUFPT
4734 EDF8 C8                    INY                            ;POINT TO PLACE TO STORE OUTPUT.
4735 EDF9 AA                    TAX   
4736 EDFA 29 7F                 AND   #$7F                     ;GET RID OF MSB.
4737 EDFC 99 FF 00              STA   |FBUFFR-1,Y
4738 EDFF C6 99                 DEC   DECCNT
4739 EE01 D0 06                 BNE   STXBUF                   ;NOT TIME FOR DP YET.
4740 EE03 A9 2E                 LDA   #'.'
4741 EE05 C8                    INY   
4742 EE06 99 FF 00              STA   |FBUFFR-1,Y              ;STORE DP.
4743 EE09 84 AD        STXBUF:  STY   FBUFPT                   ;STORE PNTR FOR LATER.
4744 EE0B A4 83                 LDY   FDECPT
4745 EE0D 8A           FOUTCM:  TXA                            ;COMPLEMENT ACCX
4746 EE0E 49 FF                 EOR   #$FF                     ;COMPLEMENT ACCA.
4747 EE10 29 80                 AND   #$80                     ;SAVONLY MSB.
4748 EE12 AA                    TAX   
4749 EE13 C0 24                 CPY   #FDCEND-FOUTBL
4750 EE15 D0 AA                 BNE   FOUT2                    ;CONTINUE WITH OUTPUT.
4751 EE17 A4 AD        FOULDY:  LDY   FBUFPT                   ;GET BACK OUTPUT PNTR.
4752 EE19 B9 FF 00     FOUT11:  LDA   |FBUFFR-1,Y              ;REMOVE TRAIL 0'S
4753 EE1C 88                    DEY   
4754 EE1D C9 30                 CMP   #'0'
4755 EE1F F0 F8                 BEQ   FOUT11
4756 EE21 C9 2E                 CMP   #'.'
4757 EE23 F0 01                 BEQ   FOUT12                   ;RUN INTO DP. STOP.
4758 EE25 C8                    INY                            ;SOMETHING ELSE. SAVE IT.
4759 EE26 A9 2B        FOUT12:  LDA   #$2B
4760 EE28 A6 9A                 LDX   TENEXP
4761 EE2A F0 2E                 BEQ   FOUT17                   ;NO EXPONENT TO OUTPUT.
4762 EE2C 10 08                 BPL   FOUT14
4763 EE2E A9 00                 LDA   #0
4764 EE30 38                    SEC   
4765 EE31 E5 9A                 SBC   TENEXP
4766 EE33 AA                    TAX   
4767 EE34 A9 2D                 LDA   #$2D                     ;EXPONENT IS NEGATIVE.
4768 EE36 99 01 01     FOUT14:  STA   FBUFFR-1+2,Y             ;STORE SIGN OF EXP
4769 EE39 A9 45                 LDA   #'E'
4770 EE3B 99 00 01              STA   FBUFFR-1+1,Y             ;STORE THE 'E' CHARACTER.
4771 EE3E 8A                    TXA   
4772 EE3F A2 2F                 LDX   #'0'-1
4773 EE41 38                    SEC   
4774 EE42 E8           FOUT15:  INX                            ;MOVE CLOSER TO OUTPUT VALUE.
4775 EE43 E9 0A                 SBC   #$0A                     ;SUBTRACT 10.
4776 EE45 B0 FB                 BCS   FOUT15                   ;NOT NEGATIVE YET.
4777 EE47 69 3A                 ADC   #'0'+$0A                 ;2ND OUTPUT CHR
4778 EE49 99 03 01              STA   FBUFFR-1+4,Y             ;STORE HIGH DIGIT.
4779 EE4C 8A                    TXA   
4780 EE4D 99 02 01              STA   FBUFFR-1+3,Y             ;STORE  LOW DIGIT.
4781 EE50 A9 00                 LDA   #0                       ;PUT IN TERMINATOR.
4782 EE52 99 04 01              STA   FBUFFR-1+5,Y
4783 EE55 F0 08                 BEQ   FOUT20                   ;RETURN. (ALWAYS  GO)
4784 EE57 99 FF 00     FOUT19:  STA   |FBUFFR-1,Y              ;STOR CHAR
4785 EE5A A9 00        FOUT17:  LDA   #0                       ;A TERMINATOR.
4786 EE5C 99 00 01              STA   FBUFFR-1+1,Y
4787 EE5F A9 00        FOUT20:  LDA   #<FBUFFR
4788 EE61 A0 01                 LDY   #>FBUFFR
4789 EE63 60           FPWRRT:  RTS                            ;ALL DONE.
4790 EE64 80           FHALF:   DC B:$80                       ;1/2
4791 EE65 00                    DC B:$00
4792 EE66 00                    DC B:$00
4793 EE67 00                    DC B:$00
4794 EE68 00                    DC B:$00
4795 EE69              ;POWER OF TEN TABLE
4796 EE69 FA           FOUTBL:  DC B:$FA                       ;-100,000,000
4797 EE6A 0A                    DC B:$0A
4798 EE6B 1F                    DC B:$1F
4799 EE6C 00                    DC B:$00
4800 EE6D 00                    DC B:$00                       ;10,000,000
4801 EE6E 98                    DC B:$98
4802 EE6F 96                    DC B:$96
4803 EE70 80                    DC B:$80
4804 EE71 FF                    DC B:$FF                       ;-1,000,000
4805 EE72 F0                    DC B:$F0
4806 EE73 BD                    DC B:$BD
4807 EE74 C0                    DC B:$C0
4808 EE75 00                    DC B:$00                       ;100,000
4809 EE76 01                    DC B:$01
4810 EE77 86                    DC B:$86
4811 EE78 A0                    DC B:$A0
4812 EE79 FF                    DC B:$FF                       ;-10,000
4813 EE7A FF                    DC B:$FF
4814 EE7B D8                    DC B:$D8
4815 EE7C F0                    DC B:$F0
4816 EE7D 00                    DC B:$00                       ;00
4817 EE7E 00                    DC B:$00
4818 EE7F 03                    DC B:$03
4819 EE80 E8                    DC B:$E8
4820 EE81 FF                    DC B:$FF                       ;-100
4821 EE82 FF                    DC B:$FF
4822 EE83 FF                    DC B:$FF
4823 EE84 9C                    DC B:$9C
4824 EE85 00                    DC B:$00                       ;10
4825 EE86 00                    DC B:$00
4826 EE87 00                    DC B:$00
4827 EE88 0A                    DC B:$0A
4828 EE89 FF                    DC B:$FF                       ;-1
4829 EE8A FF                    DC B:$FF
4830 EE8B FF                    DC B:$FF
4831 EE8C FF                    DC B:$FF
4832 EE8D              FDCEND:  EQU   *
4833 EE8D                       EJECT 
4834 EE8D                       TITLE 'EXP AND SQUARE ROOT'
4835 EE8D              ;SQUARE ROOT FUNCTION --- SQR(A)
4836 EE8D              ;USE SQR(X)=X.5
4837 EE8D 20 63 EB     SQR:     JSR   MOVAF                    ;MOVE FAC INTO ARG.
4838 EE90 A9 64                 LDA   #FHALF
4839 EE92 A0 EE                 LDY   #>FHALF
4840 EE94 20 F9 EA              JSR   MOVFM                    ;PUT MEMORY INTO FAC.
4841 EE97              ;LAST THING FETCHED IS FACEXP. INTO ACCX.
4842 EE97              ; JMP FPWRT   ;FALL INTO FPW.
4843 EE97              ;EXPONENTIATION ---  XY.
4844 EE97              ;N.B.  00=1
4845 EE97              ;FIRST CHECK IF Y=0. IF SO, THE RESULT IS 1.
4846 EE97              ;NEXT CHECK IF X=0. IF SO THE RESULT IS 0.
4847 EE97              ;THEN CHECK IF X.GT.0. IF NOT CHECK THAT Y IS AN INTEGER.
4848 EE97              ;IF SO, NEGATE X, SO THAT LOG DOESN'T GIVE FCERR.
4849 EE97              ;IF X IS NEGATIVE AND Y IS ODD, NEGATE THE RESULT
4850 EE97              ;RETURNED BY EXP.
4851 EE97              ;TO COMPUTE THE RESULT USE XY=EXP((Y*LOG(X)).
4852 EE97 F0 70        FPWRT:   BEQ   EXP                      ;IF FAC=0, JUST EXPONENTIATE THAT.
4853 EE99 A5 A5                 LDA   ARGEXP                   ;IS X=0?
4854 EE9B D0 03                 BNE   FPWRT1
4855 EE9D 4C 50 E8              JMP   ZEROF1                   ;ZERO FAC.
4856 EEA0 A2 8A        FPWRT1:  LDX   #TEMPF3
4857 EEA2 A0 00                 LDY   #>TEMPF3                 ;SAVE FOR LATER IN A TEMP.
4858 EEA4 20 2B EB              JSR   MOVMF
4859 EEA7              ;Y=0 ALREADY. GOOD IN CASE NO ONE CALLS INT.
4860 EEA7 A5 AA                 LDA   ARGSGN
4861 EEA9 10 0F                 BPL   FPWR1                    ;NO PROBLEMS IF X.GT.0.
4862 EEAB 20 23 EC              JSR   INT                      ;INTEGERIZE THE FAC.
4863 EEAE A9 8A                 LDA   #TEMPF3
4864 EEB0 A0 00                 LDY   #>TEMPF3                 ;GET ADDR OF COMPERAND.
4865 EEB2 20 B2 EB              JSR   FCOMP                    ;EQUAL?
4866 EEB5 D0 03                 BNE   FPWR1                    ;LEAVE X NEG. LOG WILL BLOW HIM OUT.
4867 EEB7              ;A=-1 AND Y IS IRRELEVANT.
4868 EEB7 98                    TYA                            ;NEGATE X. MAKE POSITIVE.
4869 EEB8 A4 0D                 LDY   INTEGR                   ;GET EVENNESS.
4870 EEBA 20 55 EB     FPWR1:   JSR   MOVFA1                   ;ALTERNATE ENTRY POINT.
4871 EEBD 98                    TYA   
4872 EEBE 48                    PHA                            ;SAVE EVENNESS FOR TER.
4873 EEBF 20 41 E9              JSR   LOG                      ;FIND LOG.
4874 EEC2 A9 8A                 LDA   #TEMPF3
4875 EEC4 A0 00                 LDY   #>TEMPF3                 ;MULTIPLY FAC TIMES LOG(X).
4876 EEC6 20 7F E9              JSR   FMULT
4877 EEC9 20 09 EF              JSR   EXP                      ;EXPONENTIATE THE FAC.
4878 EECC 68                    PLA   
4879 EECD 4A                    LSR   A                        ;IS IT EVEN?
4880 EECE 90 0A                 BCC   NEGRTS                   ;YES. OR X.GT.0.
4881 EED0              ;NEGATE THE NUMBER IN FAC.
4882 EED0 A5 9D        NEGOP:   LDA   FACEXP
4883 EED2 F0 06                 BEQ   NEGRTS
4884 EED4 A5 A2                 LDA   FACSGN
4885 EED6 49 FF                 EOR   #255
4886 EED8 85 A2                 STA   FACSGN
4887 EEDA 60           NEGRTS:  RTS   
4888 EEDB                       EJECT 
4889 EEDB                       TITLE 'EXPONENTIATION FUNCTION.'
4890 EEDB              ;FIRST SAVE THE ORIGINAL ARGUMENT AND MULTIPLY THE FAC BY
4891 EEDB              ;LOG2(E). THE RESULT IS USED TO DETERMINE IF OVERFLOW
4892 EEDB              ;WILL OCCUR SINCE EXP)=2(X*LOG2(E)) WHERE
4893 EEDB              ;LOG2(E)=LOG(E) BASE 2. THEN SAVE THE INTEGER PART OF
4894 EEDB              ;THIS TO SCALE THE ANSWER AT THE END. SINCE
4895 EEDB              ;2Y=2INT(Y)*2(Y-INT(Y)) AND 2INT(Y) IS EASY TO COMPUTE.
4896 EEDB              ;NOW COMPUTE 2(X*LOG2(E)-INT(X*LOG2(E)) BY
4897 EEDB              ;P(LN(2)*(INT(X*LOG2(E))+1)-X) WHERE P IS AN APPROXIMATION
4898 EEDB              ;POLYNOMIAL. THE RESULT IS THEN SCALED BY THE POWER OF 2
4899 EEDB              ;PREVIOUSLY SAVED.
4900 EEDB 81           LOGEB2:  DC B:$81                       ;LOG(E) BASE 2.
4901 EEDC 38                    DC B:$38
4902 EEDD AA                    DC B:$AA
4903 EEDE 3B 29                 DC B:$3B,$29
4904 EEE0 07           EXPCON:  DC B:7                         ;DEGREE-1
4905 EEE1 71                    DC B:$71                       ; .0000214987636
4906 EEE2 34                    DC B:$34
4907 EEE3 58                    DC B:$58
4908 EEE4 3E                    DC B:$3E
4909 EEE5 56                    DC B:$56
4910 EEE6 74                    DC B:$74                       ; .00014352314036
4911 EEE7 16                    DC B:$16
4912 EEE8 7E                    DC B:$7E
4913 EEE9 B3                    DC B:$B3
4914 EEEA 1B                    DC B:$1B
4915 EEEB 77                    DC B:$77                       ; .0013422634824
4916 EEEC 2F                    DC B:$2F
4917 EEED EE                    DC B:$EE
4918 EEEE E3                    DC B:$E3
4919 EEEF 85                    DC B:$85
4920 EEF0 7A                    DC B:$7A                       ; .0096140170119
4921 EEF1 1D                    DC B:$1D
4922 EEF2 84                    DC B:$84
4923 EEF3 1C                    DC B:$1C
4924 EEF4 2A                    DC B:$2A
4925 EEF5 7C                    DC B:$7C                       ; .055505126860
4926 EEF6 63                    DC B:$63
4927 EEF7 59                    DC B:$59
4928 EEF8 58                    DC B:$58
4929 EEF9 0A                    DC B:$0A
4930 EEFA 7E                    DC B:$7E                       ; .24022638462
4931 EEFB 75                    DC B:$75
4932 EEFC FD                    DC B:$FD
4933 EEFD E7                    DC B:$E7
4934 EEFE C6                    DC B:$C6
4935 EEFF 80                    DC B:$80                       ; .69314718608
4936 EF00 31                    DC B:$31
4937 EF01 72                    DC B:$72
4938 EF02 18                    DC B:$18
4939 EF03 10                    DC B:$10
4940 EF04 81                    DC B:$81                       ; 1.0
4941 EF05 00                    DC B:$00
4942 EF06 00                    DC B:$00
4943 EF07 00                    DC B:$00
4944 EF08 00                    DC B:$00
4945 EF09              EXP:     EQU   *
4946 EF09 A9 DB                 LDA   #LOGEB2
4947 EF0B A0 EE                 LDY   #>LOGEB2                 ;MULTIPLY BY LOG(E) BASE 2.
4948 EF0D 20 7F E9              JSR   FMULT
4949 EF10 A5 AC                 LDA   FACOV
4950 EF12 69 50                 ADC   #$50
4951 EF14 90 03                 BCC   STOLD
4952 EF16 20 7A EB              JSR   INCRND
4953 EF19 85 92        STOLD:   STA   OLDOV
4954 EF1B 20 66 EB              JSR   MOVEF                    ;TO SAVE IN ARG WITHOUT ROUND.
4955 EF1E A5 9D                 LDA   FACEXP
4956 EF20 C9 88                 CMP   #$88                     ;IF ABS(FAC) .GE. 128, TOO BIG.
4957 EF22 90 03                 BCC   EXP1
4958 EF24 20 2B EA     GOMLDV:  JSR   MLDVEX                   ;OVERFLOW OR OVERFLOW.
4959 EF27 20 23 EC     EXP1:    JSR   INT
4960 EF2A A5 0D                 LDA   INTEGR                   ;GET LOW PART.
4961 EF2C 18                    CLC   
4962 EF2D 69 81                 ADC   #$81
4963 EF2F F0 F3                 BEQ   GOMLDV                   ;OVERFLOW OR OVERFLOW !!
4964 EF31 38                    SEC   
4965 EF32 E9 01                 SBC   #1                       ;SUBTRACT 1.
4966 EF34 48                    PHA                            ;SAVE A WHILE.
4967 EF35 A2 05                 LDX   #4+1                     ;PREP TO SWAP FAC AND ARG.
4968 EF37 B5 A5        SWAPLP:  LDA   ARGEXP,X
4969 EF39 B4 9D                 LDY   FACEXP,X
4970 EF3B 95 9D                 STA   FACEXP,X
4971 EF3D 94 A5                 STY   ARGEXP,X
4972 EF3F CA                    DEX   
4973 EF40 10 F5                 BPL   SWAPLP
4974 EF42 A5 92                 LDA   OLDOV
4975 EF44 85 AC                 STA   FACOV
4976 EF46 20 AA E7              JSR   FSUBT
4977 EF49 20 D0 EE              JSR   NEGOP                    ;NEGATE FAC.
4978 EF4C A9 E0                 LDA   #EXPCON
4979 EF4E A0 EE                 LDY   #>EXPCON
4980 EF50 20 72 EF              JSR   POLY
4981 EF53 A9 00                 LDA   #0
4982 EF55 85 AB                 STA   ARISGN                   ;MULTIPLY BY POSITIVE 1.0.
4983 EF57 68                    PLA                            ;GET SCALE FACTOR.
4984 EF58 20 10 EA              JSR   MLDEXP                   ;MODIFY FACEXP AND CHECK FOR OVERFLOW.
4985 EF5B 60                    RTS                            ;HAS TO DO JSR DUE TO PULAS IN MULDIV.
4986 EF5C                       EJECT 
4987 EF5C                       TITLE 'POLY EVAL & RANDOM NUMBER GEN'
4988 EF5C              ;EVALUATE P(X2)*X
4989 EF5C              ;POINTER TO DEGREE IS IN Y,A.
4990 EF5C              ;THE CONSTANTS FOLLOW THE DEGREE.
4991 EF5C              ;FOR X=FAC, COMPUTE:
4992 EF5C              ; C0*X+C1*X3+C2*X5+C3*X7+...+C(N)*X(2*N+1)
4993 EF5C 85 AD        POLYX:   STA   POLYPT
4994 EF5E 84 AE                 STY   POLYPT+1                 ;RETAIN POLYNOMIAL POINTER FOR LATER.
4995 EF60 20 21 EB              JSR   MOV1F                    ;SAVE FAC IN FACTMP.
4996 EF63 A9 93                 LDA   #TEMPF1
4997 EF65 20 7F E9              JSR   FMULT                    ;COMPUTE X2.
4998 EF68 20 76 EF              JSR   POLY1                    ;COMPUTE P(X2).
4999 EF6B A9 93                 LDA   #TEMPF1
5000 EF6D A0 00                 LDY   #>TEMPF1
5001 EF6F 4C 7F E9              JMP   FMULT                    ;MULTIPLY BY FAC AGAIN.
5002 EF72              ;POLYNOMIAL EVALUATOR.
5003 EF72              ;POINTER TDEGREE IS IN Y,A.
5004 EF72              ;COMPUTE:
5005 EF72              ; C0+C1*X+C2*X2+C3*X3+C4*X4+...+C(N-1)*X(N-1)+C(N)*XN.
5006 EF72 85 AD        POLY:    STA   POLYPT
5007 EF74 84 AE                 STY   POLYPT+1
5008 EF76 20 1E EB     POLY1:   JSR   MOV2F                    ;SAVE FAC.
5009 EF79 B1 AD                 LDA   (POLYPT),Y
5010 EF7B 85 A3                 STA   DEGREE
5011 EF7D A4 AD                 LDY   POLYPT
5012 EF7F C8                    INY   
5013 EF80 98                    TYA   
5014 EF81 D0 02                 BNE   POLY3
5015 EF83 E6 AE                 INC   POLYPT+1
5016 EF85 85 AD        POLY3:   STA   POLYPT
5017 EF87 A4 AE                 LDY   POLYPT+1
5018 EF89 20 7F E9     POLY2:   JSR   FMULT
5019 EF8C A5 AD                 LDA   POLYPT
5020 EF8E A4 AE                 LDY   POLYPT+1                 ;GET CURRENT POINTER.
5021 EF90 18                    CLC   
5022 EF91 69 05                 ADC   #4+1
5023 EF93 90 01                 BCC   POLY4
5024 EF95 C8                    INY   
5025 EF96 85 AD        POLY4:   STA   POLYPT
5026 EF98 84 AE                 STY   POLYPT+1
5027 EF9A 20 BE E7              JSR   FADD                     ;ADD IN CONSTANT.
5028 EF9D A9 98                 LDA   #TEMPF2
5029 EF9F A0 00                 LDY   #>TEMPF2                 ;MULTIY THE ORIGINAL FAC.
5030 EFA1 C6 A3                 DEC   DEGREE                   ;DONE?
5031 EFA3 D0 E4                 BNE   POLY2
5032 EFA5 60           RANDRT:  RTS                            ;YES.
5033 EFA6              ;PSUEDO-RANDOM NUMBER GENERATOR.
5034 EFA6              ;IF ARG=0, THE LAST RANDOM NUMBER GENERATED IS RETURNED.
5035 EFA6              ;IF ARG .LT. 0, A NEW SEQUENCE OF RANDOM NUMBERS IS
5036 EFA6              ;STARTED USING THE ARGUMENT.
5037 EFA6              ;   TO FORM THE NEXT RANDOM NUMBER IN THE SEQUENCE,
5038 EFA6              ;MULTIPLY THE PREVIOUS RANDOM NUMBER BY A RANDOM CONSTANT
5039 EFA6              ;AND ADD IN ANOTHER RANDOM CONSTANT. THE THEN HO
5040 EFA6              ;AND LO BYTES ARE SWITCHED, THE EXPONENT IS PUT WHERE
5041 EFA6              ;IT WILL BE SHIFTED IN BY RMAL, & THE EXPONENT IN THE FAC
5042 EFA6              ;IS SET TO 200 SO THE RESULT WILL BE LESS THAN 1. THIS
5043 EFA6              ;IS THEN NORMALIZED AND SAVED FOR THE NEXT TIME.
5044 EFA6              ;THE HO AND LOW BYTES WERE SWITCHED SO THERE WILL BE A
5045 EFA6              ;RANDOM CHANCE OF GETTING A NUMBER LESS THAN OR GREATER
5046 EFA6              ;THAN .5 .
5047 EFA6 98           RMUL_C:  DC B:$98
5048 EFA7 35                    DC B:$35
5049 EFA8 44                    DC B:$44
5050 EFA9 7A                    DC B:$7A
5051 EFAA 68           RADD_C:  DC B:$68
5052 EFAB 28                    DC B:$28
5053 EFAC B1                    DC B:$B1
5054 EFAD 46                    DC B:$46
5055 EFAE 20 82 EB     RND:     JSR   SIGN                     ;GET SIGN INTO ACCX.
5056 EFB1 AA                    TAX                            ;GET INTO ACCX, SINCE 'MOVFM' USES ACCX.
5057 EFB2 30 18                 BMI   RND1                     ;START NEW SEQUENCE  NEGATIVE.
5058 EFB4 A9 C9        QSETNR:  LDA   #RNDX
5059 EFB6 A0 00                 LDY   #>RNDX                   ;GET LAST ONE INTO FAC.
5060 EFB8 20 F9 EA              JSR   MOVFM
5061 EFBB 8A                    TXA                            ;FAC WAS ZERO?
5062 EFBC F0 E7                 BEQ   RANDRT                   ;RESTORE LAST ONE.
5063 EFBE A9 A6                 LDA   #RMUL_C
5064 EFC0 A0 EF                 LDY   #>RMUL_C                 ;MULTIPLY BY RANDOM CONSTANT.
5065 EFC2 20 7F E9              JSR   FMULT
5066 EFC5 A9 AA                 LDA   #RADD_C
5067 EFC7 A0 EF                 LDY   #>RADD_C
5068 EFC9 20 BE E7              JSR   FADD                     ;ADD RANDOM CONSTANT.
5069 EFCC A6 A1        RND1:    LDX   FACLO
5070 EFCE A5 9E                 LDA   FACHO
5071 EFD0 85 A1                 STA   FACLO
5072 EFD2 86 9E                 STX   FACHO                    ;REVERSE HO AND LO.
5073 EFD4 A9 00        STRNEX:  LDA   #$00
5074 EFD6 85 A2                 STA   FACSGN                   ;MAKE NUMBER POSITIVE.
5075 EFD8 A5 9D                 LDA   FACEXP                   ;PUT EXP WHERE IT WILL
5076 EFDA 85 AC                 STA   FACOV                    ;BE SHIFTED IN BY NORMAL.
5077 EFDC A9 80                 LDA   #$80
5078 EFDE 85 9D                 STA   FACEXP                   ;MAKE RESULT BETWEEN 0 AND 1.
5079 EFE0 20 2E E8              JSR   NORMAL                   ;NORMALIZE.
5080 EFE3 A2 C9                 LDX   #RNDX
5081 EFE5 A0 00                 LDY   #>RNDX
5082 EFE7 4C 2B EB     GMOVMF:  JMP   MOVMF                    ;PUT NEW ONE INTO MEMORY.
5083 EFEA                       EJECT 
5084 EFEA                       TITLE 'SINE, COSINE & TANGENT'
5085 EFEA              ;COSINE FUNCTION.
5086 EFEA              ;USE COS(X)=SIN(X+PI/2)
5087 EFEA A9 66        COS:     LDA   #PI2
5088 EFEC A0 F0                 LDY   #>PI2                    ;PNTR TO PI/2.
5089 EFEE 20 BE E7              JSR   FADD                     ;ADD IT IN.
5090 EFF1              ;FALL INTO SIN.
5091 EFF1              ;SINE FUNCTION.
5092 EFF1              ;USE IDENTITIES TO GET FAC IN QUADRANTS I OR IV.
5093 EFF1              ;THE FAC IS DIVIDED BY 2*PI & THE INTEGER PART IS IGNORED
5094 EFF1              ;BECAUSE SIN(X+PI)=SIN(X). THEN ARGUMENT CAN BE COMPARED
5095 EFF1              ;WITH PI/2 BY COMPARING THE RESULT OF THE DIVISION
5096 EFF1              ;WITH PI/2/(2*PI)=1/4.
5097 EFF1              ;IDENTITIES ARE THEN USED TO GET THE RESULT IN QUADRANTS
5098 EFF1              ;I OR IV. AN APPROXIMATION POLYNOMIAL IS THEN USED TO
5099 EFF1              ;COMPUTE SIN(X).
5100 EFF1 20 63 EB     SIN:     JSR   MOVAF
5101 EFF4 A9 6B                 LDA   #TWOPI
5102 EFF6 A0 F0                 LDY   #>TWOPI                  ;GET PNTR TO DIVISOR.
5103 EFF8 A6 AA                 LDX   ARGSGN                   ;GET SIGN OF RESULT.
5104 EFFA 20 5E EA              JSR   FDIVF
5105 EFFD 20 63 EB              JSR   MOVAF                    ;GET RESULT INTO ARG.
5106 F000 20 23 EC              JSR   INT                      ;INTEGERIZE FAC.
5107 F003 A9 00                 LDA   #0
5108 F005 85 AB                 STA   ARISGN                   ;ALWAYS HAVE THE SAME SIGN.
5109 F007 20 AA E7              JSR   FSUBT                    ;KEEP ONLY THE FRACTIONAL PART.
5110 F00A A9 70                 LDA   #FR4
5111 F00C A0 F0                 LDY   #>FR4                    ;GET PNTR TO 1/4.
5112 F00E 20 A7 E7              JSR   FSUB                     ;COMPUTE 1/4-FAC.
5113 F011 A5 A2                 LDA   FACSGN                   ;SAVE SIGN FOR LATER.
5114 F013 48                    PHA   
5115 F014 10 0D                 BPL   SIN1                     ;FIRST QUADRANT.
5116 F016 20 A0 E7              JSR   FADDH                    ;ADD 1/2 TO FAC.
5117 F019 A5 A2                 LDA   FACSGN                   ;SIGN IS NEGATIVE?
5118 F01B 30 09                 BMI   SIN2
5119 F01D A5 16                 LDA   TANSGN
5120 F01F 49 FF                 EOR   #255
5121 F021 85 16                 STA   TANSGN                   ;QUADRANTS II AND III COME HERE.
5122 F023 20 D0 EE     SIN1:    JSR   NEGOP                    ;IF POSITIVE, NEGATE IT.
5123 F026 A9 70        SIN2:    LDA   #FR4
5124 F028 A0 F0                 LDY   #>FR4                    ;POINTER TO 1/4.
5125 F02A 20 BE E7              JSR   FADD                     ;ADD IT IN.
5126 F02D 68                    PLA                            ;GET ORIGINAL QUADRANT.
5127 F02E 10 03                 BPL   SIN3
5128 F030 20 D0 EE              JSR   NEGOP                    ;IF NEGATIVE, NEGATE RESULT.
5129 F033 A9 75        SIN3:    LDA   #SINCON
5130 F035 A0 F0                 LDY   #>SINCON
5131 F037 4C 5C EF     GPOLYX:  JMP   POLYX                    ;DO APPROXIMATION POLYNOMIAL.
5132 F03A              ;TANGENT FUNCTION.
5133 F03A 20 21 EB     TAN:     JSR   MOV1F                    ;MOVE FAC INTO TEMPORARY.
5134 F03D A9 00                 LDA   #0
5135 F03F 85 16                 STA   TANSGN                   ;REMEMBER WHETHER TO NEGATE.
5136 F041 20 F1 EF              JSR   SIN                      ;COMPUTE THE SIN.
5137 F044 A2 8A                 LDX   #TEMPF3
5138 F046 A0 00                 LDY   #>TEMPF3
5139 F048 20 E7 EF              JSR   GMOVMF                   ;PUT SIGN INTO OTHER TEMP.
5140 F04B A9 93                 LDA   #TEMPF1
5141 F04D A0 00                 LDY   #>TEMPF1
5142 F04F 20 F9 EA              JSR   MOVFM                    ;PUT THIS MEMORY LOC INTO FAC.
5143 F052 A9 00                 LDA   #0
5144 F054 85 A2                 STA   FACSGN                   ;START OFF POSITIVE.
5145 F056 A5 16                 LDA   TANSGN
5146 F058 20 62 F0              JSR   COSC                     ;COMPUTE COSINE.
5147 F05B A9 8A                 LDA   #TEMPF3
5148 F05D A0 00                 LDY   #>TEMPF3                 ;ADDRESS OF SINE VALUE.
5149 F05F 4C 66 EA     GFDIV:   JMP   FDIV                     ;DIVIDE SINE BY COSINE AND RETURN.
5150 F062 48           COSC:    PHA   
5151 F063 4C 23 F0              JMP   SIN1
5152 F066 81           PI2:     DC B:$81                       ;PI/2
5153 F067 49                    DC B:$49
5154 F068 0F                    DC B:$0F
5155 F069 DA                    DC B:$DA
5156 F06A A2                    DC B:$A2
5157 F06B 83           TWOPI:   DC B:$83                       ;2*PI.
5158 F06C 49                    DC B:$49
5159 F06D 0F                    DC B:$0F
5160 F06E DA                    DC B:$DA
5161 F06F A2                    DC B:$A2
5162 F070 7F           FR4:     DC B:$7F                       ;1/4
5163 F071 00                    DC B:$00
5164 F072 00                    DC B:$00
5165 F073 00                    DC B:$00
5166 F074 00                    DC B:$00
5167 F075 05           SINCON:  DC B:5                         ;DEGREE-1.
5168 F076 84                    DC B:$84                       ; -14.381383816
5169 F077 E6                    DC B:$E6
5170 F078 1A                    DC B:$1A
5171 F079 2D                    DC B:$2D
5172 F07A 1B                    DC B:$1B
5173 F07B 86                    DC B:$86                       ; 42.07777095
5174 F07C 28                    DC B:$28
5175 F07D 07                    DC B:$07
5176 F07E FB                    DC B:$FB
5177 F07F F8                    DC B:$F8
5178 F080 87                    DC B:$87                       ; -76.704133676
5179 F081 99                    DC B:$99
5180 F082 68                    DC B:$68
5181 F083 89                    DC B:$89
5182 F084 01                    DC B:$01
5183 F085 87                    DC B:$87                       ; 81.605223690
5184 F086 23                    DC B:$23
5185 F087 35                    DC B:$35
5186 F088 DF                    DC B:$DF
5187 F089 E1                    DC B:$E1
5188 F08A 86                    DC B:$86                       ; -41.34170209
5189 F08B A5                    DC B:$A5
5190 F08C 5D                    DC B:$5D
5191 F08D E7                    DC B:$E7
5192 F08E 28                    DC B:$28
5193 F08F 83                    DC B:$83                       ; 6.2831853070
5194 F090 49                    DC B:$49
5195 F091 0F                    DC B:$0F
5196 F092 DA                    DC B:$DA
5197 F093 A2                    DC B:$A2
5198 F094 A6                    DC B:$A6
5199 F095 D3                    DC B:$D3
5200 F096 C1                    DC B:$C1
5201 F097 C8                    DC B:$C8
5202 F098 D4                    DC B:$D4
5203 F099 C8                    DC B:$C8
5204 F09A D5                    DC B:$D5
5205 F09B C4                    DC B:$C4
5206 F09C CE                    DC B:$CE
5207 F09D CA                    DC B:$CA
5208 F09E                       EJECT 
5209 F09E                       TITLE 'ARCTANGENT FUNCTION.'
5210 F09E              ;USE IDENTITIES TO GET ARG BETWEEN 0 AND 1 AND THEN USE AN
5211 F09E              ;APPROXIMATION POLYNOMIAL TO COMPUTE ARCTAN(X).
5212 F09E A5 A2        ATN:     LDA   FACSGN                   ;WHAT IS SIGN?
5213 F0A0 48                    PHA                            ;(MEANWHILE SAVE FOR LATER.)
5214 F0A1 10 03                 BPL   ATN1
5215 F0A3 20 D0 EE              JSR   NEGOP                    ;IF NEGATIVE, NEGATE FAC.
5216 F0A6              ;USE ARCTAN(X)=-ARCTAN(-X) .
5217 F0A6 A5 9D        ATN1:    LDA   FACEXP
5218 F0A8 48                    PHA                            ;SAVE THIS TOO FOR LATER.
5219 F0A9 C9 81                 CMP   #$81                     ;SEE IF FAC .GE. 1.0 .
5220 F0AB 90 07                 BCC   ATN2                     ;IT IS LESS THAN 1.
5221 F0AD A9 13                 LDA   #FONE
5222 F0AF A0 E9                 LDY   #>FONE                   ;GET PNTR TO 1.0 .
5223 F0B1 20 66 EA              JSR   FDIV                     ;COMPUTE RECROCAL.
5224 F0B4              ;USE ARCTAN(X)=PI/2-ARCTAN(1/X) .
5225 F0B4 A9 CE        ATN2:    LDA   #ATNCON
5226 F0B6 A0 F0                 LDY   #>ATNCON                 ;PNTR TO ARCTAN CONSTANTS.
5227 F0B8 20 5C EF              JSR   POLYX
5228 F0BB 68                    PLA   
5229 F0BC C9 81                 CMP   #$81                     ;WAS ORIGINAL ARGUMENT .LT. 1 ?
5230 F0BE 90 07                 BCC   ATN3                     ;YES.
5231 F0C0 A9 66                 LDA   #PI2
5232 F0C2 A0 F0                 LDY   #>PI2
5233 F0C4 20 A7 E7              JSR   FSUB                     ;SUBTRACT ARCTAGN FROM PI/2.
5234 F0C7 68           ATN3:    PLA                            ;WAS ORIGINAL ARGUMENT POSITIVE?
5235 F0C8 10 03                 BPL   ATN4                     ;YES.
5236 F0CA 4C D0 EE              JMP   NEGOP                    ;IF NEGATIVE, NEGATE RESULT.
5237 F0CD 60           ATN4:    RTS                            ;ALL DONE.
5238 F0CE 0B           ATNCON:  DC B:$0B                       ;DEGREE-1.
5239 F0CF 76                    DC B:$76                       ; -.0006847939119
5240 F0D0 B3                    DC B:$B3
5241 F0D1 83                    DC B:$83
5242 F0D2 BD                    DC B:$BD
5243 F0D3 D3                    DC B:$D3
5244 F0D4 79                    DC B:$79                       ; .004850942156
5245 F0D5 1E                    DC B:$1E
5246 F0D6 F4                    DC B:$F4
5247 F0D7 A6                    DC B:$A6
5248 F0D8 F5                    DC B:$F5
5249 F0D9 7B                    DC B:$7B                       ; -.01611170184
5250 F0DA 83                    DC B:$83
5251 F0DB FC                    DC B:$FC
5252 F0DC B0                    DC B:$B0
5253 F0DD 10                    DC B:$10
5254 F0DE 7C                    DC B:$7C                       ; .03420963805
5255 F0DF 0C                    DC B:$0C
5256 F0E0 1F                    DC B:$1F
5257 F0E1 67                    DC B:$67
5258 F0E2 CA                    DC B:$CA
5259 F0E3 7C                    DC B:$7C                       ; .-.05427913276
5260 F0E4 DE                    DC B:$DE
5261 F0E5 53                    DC B:$53
5262 F0E6 CB                    DC B:$CB
5263 F0E7 C1                    DC B:$C1
5264 F0E8 7D                    DC B:$7D                       ; .07245719654
5265 F0E9 14                    DC B:$14
5266 F0EA 64                    DC B:$64
5267 F0EB 70                    DC B:$70
5268 F0EC 4C                    DC B:$4C
5269 F0ED 7D                    DC B:$7D                       ; -.08980239538
5270 F0EE B7                    DC B:$B7
5271 F0EF EA                    DC B:$EA
5272 F0F0 51                    DC B:$51
5273 F0F1 7A                    DC B:$7A
5274 F0F2 7D                    DC B:$7D                       ; .1109324134
5275 F0F3 63                    DC B:$63
5276 F0F4 30                    DC B:$30
5277 F0F5 88                    DC B:$88
5278 F0F6 7E                    DC B:$7E
5279 F0F7 7E                    DC B:$7E                       ; -.1428398077
5280 F0F8 92                    DC B:$92
5281 F0F9 44                    DC B:$44
5282 F0FA 99                    DC B:$99
5283 F0FB 3A                    DC B:$3A
5284 F0FC 7E                    DC B:$7E                       ; .1999991205
5285 F0FD 4C                    DC B:$4C
5286 F0FE CC                    DC B:$CC
5287 F0FF 91                    DC B:$91
5288 F100 C7                    DC B:$C7
5289 F101 7F                    DC B:$7F                       ; -.3333333157
5290 F102 AA                    DC B:$AA
5291 F103 AA                    DC B:$AA
5292 F104 AA                    DC B:$AA
5293 F105 13                    DC B:$13
5294 F106 81                    DC B:$81                       ; 1.000000000
5295 F107 00                    DC B:$00
5296 F108 00                    DC B:$00
5297 F109 00                    DC B:$00
5298 F10A 00                    DC B:$00
5299 F10B                       EJECT 
5300 F10B                       TITLE 'SYSTEM INITIALIZATION CODE.'
5301 F10B              ; THIS INITIALIZES THE BASIC INTERPRETER FOR THE M6502
5302 F10B              ; LOCATED WHERE IT WIL BE WIPED OUT IN RAM IF CODE IS ALIN 
5303 F10B              ;SO ZEROING AT TXTTAB DOESN'T PREVENT
5304 F10B              ;RESTARTING INIT
5305 F10B E6 B8        INITAT:  INC   CHRGET+7                 ;INCREMENT THE WHOLE TXTPTR.
5306 F10D D0 02                 BNE   CHSGOT
5307 F10F E6 B9                 INC   CHRGET+8
5308 F111 AD 60 EA     CHSGOT:  LDA   60000                    ;A LOAD WITH AN EXT ADDR.
5309 F114 C9 3A                 CMP   #':'                     ;IS IT A ':'?
5310 F116 B0 0A                 BCS   CHSRTS                   ;IT IS .GE. ':'
5311 F118 C9 20                 CMP   #' '                     ;SKIP SPACES.
5312 F11A F0 EF                 BEQ   INITAT
5313 F11C 38                    SEC   
5314 F11D E9 30                 SBC   #'0'                     ;ALL CHARS .GT. '9' HAVE RET'D SO
5315 F11F 38                    SEC   
5316 F120 E9 D0                 SBC   #$100-'0'                ;SEE IF NUMERIC.
5317 F122              ;TURN CARRY ON IF NUMERIC.
5318 F122              ;ALSO, SETZ IF NULL.
5319 F122 60           CHSRTS:  RTS                            ;RETURN TO CALLER.
5320 F123 80                    DC B:128                       ;LOADED  FROM ROM.
5321 F124 4F                    DC B:79                        ;THE INITIAL RANDOM NUMBER.
5322 F125 C7                    DC B:199
5323 F126 52                    DC B:82
5324 F127 58                    DC B:88
5325 F128 A2 FF        INIT:    LDX   #255                     ;MAKE IT LOOK DIRECT IN CASE OF
5326 F12A 86 76                 STX   CURLIN+1                 ;ERROR MESSAGE.
5327 F12C A2 FB                 LDX   #STKEND-256
5328 F12E 9A                    TXS   
5329 F12F A9 28                 LDA   #<INIT
5330 F131 A0 F1                 LDY   #>INIT                   ;ALLOW RESTART.
5331 F133 85 01                 STA   START+1
5332 F135 84 02                 STY   START+1+1
5333 F137 85 04                 STA   RDYJSR+1
5334 F139 84 05                 STY   RDYJSR+1+1               ;RTS HERE ON ERRORS.
5335 F13B 20 73 F2              JSR   SETNORM                  ;FOR NORMAL VIDEO
5336 F13E A9 4C                 LDA   #76                      ; A JUMP INSTRUCTION
5337 F140 85 00                 STA   START
5338 F142 85 03                 STA   RDYJSR
5339 F144 85 90                 STA   JMPER
5340 F146 85 0A                 STA   USRPOK
5341 F148 A9 99                 LDA   #<FCERR
5342 F14A A0 E1                 LDY   #>FCERR
5343 F14C 85 0B                 STA   USRPOK+1
5344 F14E 84 0C                 STY   USRPOK+1+1
5345 F150              ;INTO THE PROGRAM
5346 F150 A2 1C                 LDX   #RNDX+4-CHRGET
5347 F152 BD 0A F1     MOVCHG:  LDA   INITAT-1,X
5348 F155 95 B0                 STA   CHRGET-1,X               ;MOVE TO RAM.
5349 F157 86 F1                 STX   SPDBYT                   ;FOR FULL SPEED PRINTING
5350 F159 CA                    DEX   
5351 F15A D0 F6                 BNE   MOVCHG
5352 F15C 86 F2                 STX   TRFLAG                   ;TRACE OFF MODE.
5353 F15E 8A                    TXA                            ;SET CONST IN RAM.
5354 F15F 85 A4                 STA   BITS
5355 F161 85 54                 STA   LASTPT+1
5356 F163 48                    PHA                            ;PUT ZERO AT THE END OF THE STACK
5357 F164              ;SO FNDFOR WILL STOP
5358 F164 A9 03                 LDA   #STRSIZ
5359 F166 85 8F                 STA   FOUR6
5360 F168 20 FB DA              JSR   CRDO                     ;TYPE A CR.
5361 F16B A9 01                 LDA   #1
5362 F16D 8D FD 01              STA   BUF-3                    ;SET PRE-BUF BYTES NON-ZERO FOR CHEAD
5363 F170 8D FC 01              STA   BUF-4
5364 F173 A2 55                 LDX   #TEMPST
5365 F175 86 52                 STX   TEMPPT                   ;SET UP STRING TEMPORARIES.
5366 F177 A9 00                 LDA   #<RAMLOC
5367 F179 A0 08                 LDY   #RAMLOC/256
5368 F17B 85 50                 STA   LINNUM
5369 F17D 84 51                 STY   LINNUM+1
5370 F17F A0 00                 LDY   #0
5371 F181 E6 51        LOOPMM:  INC   LINNUM+1
5372 F183 B1 50        LOOPM1:  LDA   (LINNUM),Y
5373 F185 49 FF                 EOR   #$FF
5374 F187 91 50                 STA   (LINNUM),Y
5375 F189 D1 50                 CMP   (LINNUM),Y
5376 F18B D0 08                 BNE   USEDEC
5377 F18D 49 FF                 EOR   #$FF
5378 F18F 91 50                 STA   (LINNUM),Y
5379 F191 D1 50                 CMP   (LINNUM),Y
5380 F193 F0 EC                 BEQ   LOOPMM
5381 F195 A4 50        USEDEC:  LDY   LINNUM
5382 F197 A5 51                 LDA   LINNUM+1                 ;GET SIZE OF MEMORY INPUT.
5383 F199              USEDEF:  EQU   *                        ;HIGHEST ADDRESS.
5384 F199 29 F0                 AND   #$F0
5385 F19B 84 73                 STY   MEMSIZ
5386 F19D 85 74                 STA   MEMSIZ+1                 ;THIS IS THE SIZE OF MEMORY.
5387 F19F 84 6F                 STY   FRETOP
5388 F1A1 85 70                 STA   FRETOP+1                 ;TOP OF STRINGS TOO.
5389 F1A3              ASKAGN:  EQU   *
5390 F1A3 A2 00                 LDX   #<RAMLOC
5391 F1A5 A0 08                 LDY   #RAMLOC/256
5392 F1A7 86 67        FINILOW: STX   TXTTAB
5393 F1A9 84 68                 STY   TXTTAB+1
5394 F1AB A0 00                 LDY   #0
5395 F1AD 84 D6                 STY   RNONLY
5396 F1AF 98                    TYA   
5397 F1B0 91 67                 STA   (TXTTAB),Y               ;SET UP TEXT TABLE.
5398 F1B2 E6 67                 INC   TXTTAB
5399 F1B4 D0 02                 BNE   QROOM
5400 F1B6 E6 68                 INC   TXTTAB+1
5401 F1B8 A5 67        QROOM:   LDA   TXTTAB
5402 F1BA A4 68                 LDY   TXTTAB+1                 ;PREPARE TO USE 'REASON'.
5403 F1BC 20 E3 D3              JSR   REASON
5404 F1BF 20 4B D6              JSR   SCRTCH                   ;SET UP EVERYTHING ELSE.
5405 F1C2 A9 3A                 LDA   #<STROUT
5406 F1C4 A0 DB                 LDY   #>STROUT
5407 F1C6 85 04                 STA   RDYJSR+1
5408 F1C8 84 05                 STY   RDYJSR+1+1
5409 F1CA A9 3C                 LDA   #<READY
5410 F1CC A0 D4                 LDY   #>READY
5411 F1CE 85 01                 STA   START+1
5412 F1D0 84 02                 STY   START+1+1
5413 F1D2 6C                    DC B:$6C                       ;JMP (INDIRECT)
5414 F1D3 01 00                 DC W:START+1
5415 F1D5                       EJECT 
5416 F1D5                       TITLE 'APPLESOFT EXTENSIONS'
5417 F1D5 20 67 DD     CALL:    JSR   FRMNUM
5418 F1D8 20 52 E7              JSR   GETADR
5419 F1DB 6C                    DC B:$6C                       ;JMP (INDIRECT)
5420 F1DC 50 00                 DC W:POKER
5421 F1DE              SETTXT   EQU   $FB39
5422 F1DE              INPORT   EQU   $FE8B
5423 F1DE              OUTPORT  EQU   $FE95
5424 F1DE 20 F8 E6     INNUMB:  JSR   GETBYT                   ;GET PORT NUMBR
5425 F1E1 8A                    TXA                            ;INTO A
5426 F1E2 4C 8B FE              JMP   INPORT
5427 F1E5 20 F8 E6     PRNUMB:  JSR   GETBYT
5428 F1E8 8A                    TXA   
5429 F1E9 4C 95 FE              JMP   OUTPORT
5430 F1EC              XMAX     EQU   $50
5431 F1EC 20 F8 E6     PLOTFNS: JSR   GETBYT
5432 F1EF E0 50                 CPX   #XMAX
5433 F1F1 B0 13                 BCS   TOOBIG
5434 F1F3 86 F0                 STX   FIRST
5435 F1F5 A9 2C                 LDA   #$2C                     ;ARGS MUST BE SEPERATED BY COMMA
5436 F1F7 20 C0 DE              JSR   SYNCHR
5437 F1FA 20 F8 E6              JSR   GETBYT                   ;GET SECOND ARG
5438 F1FD E0 30                 CPX   #48                      ;48 is correct for Cortland
5439 F1FF B0 05                 BCS   TOOBIG                   ;BRANCH IF ILLEGAL PLOT 
5440 F201 86 2C                 STX   H2
5441 F203 86 2D                 STX   V2                       ;BOTH ARGS
5442 F205 60                    RTS   
5443 F206 4C 99 E1     TOOBIG:  JMP   FCERR
5444 F209 20 EC F1     ATFNS:   JSR   PLOTFNS
5445 F20C              ATFNS2   EQU   *                        ;Cortland HLIN return entry point
5446 F20C E4 F0                 CPX   FIRST                    ;ARGS IN RIGHT ORDER?
5447 F20E B0 08                 BCS   RGHTORD
5448 F210 A5 F0                 LDA   FIRST
5449 F212 85 2C                 STA   H2
5450 F214 85 2D                 STA   V2
5451 F216 86 F0                 STX   FIRST
5452 F218 A9 C5        RGHTORD: LDA   #ATTKN
5453 F21A 20 C0 DE              JSR   SYNCHR
5454 F21D 20 F8 E6              JSR   GETBYT
5455 F220 E0 50                 CPX   #XMAX                    ;LAST COORD OK?
5456 F222 B0 E2                 BCS   TOOBIG
5457 F224 60                    RTS   
5458 F225 20 EC F1     PLOT:    JSR   PLOTFNS
5459 F228 A4 F0                 LDY   FIRST                    ;Y-REG=X-COORDINATE
5460 F22A 20 75 F7              JSR   XBOUND
5461 F22D 8A                    TXA                            ;ACC=Y-COORD
5462 F22E 4C 9F F3              JMP   PLOTDO
5463 F231 00                    DC B:$00                       ;Was BRK
5464 F232              HLIN:    EQU   *
5465 F232              SPATFNS  EQU   $F8D9                    ;Patches to fix ATFNS for HLIN
5466 F232 20 D9 F8              JSR   SPATFNS
5467 F235 A4 2C                 LDY   H2                       ;THIRD ARG IN ACC
5468 F237 20 75 F7              JSR   XBOUND
5469 F23A E0 30                 CPX   #48
5470 F23C B0 C8                 BCS   TOOBIG
5471 F23E 4C 96 F7              JMP   HLINE
5472 F241 20 09 F2     VLIN     JSR   ATFNS
5473 F244 8A                    TXA   
5474 F245 A8                    TAY   
5475 F246 20 75 F7              JSR   XBOUND
5476 F249 A5 F0                 LDA   FIRST
5477 F24B 4C 83 F7              JMP   VLINXX
5478 F24E 00                    DC B:$00                       ;Was BRK
5479 F24F 20 F8 E6     COLORE:  JSR   GETBYT
5480 F252 8A                    TXA                            ;COLOR TO A-REG.
5481 F253 4C 64 F8              JMP   SETCOL
5482 F256              SETCOL:  EQU   $F864
5483 F256 20 F8 E6     VTAB     JSR   GETBYT
5484 F259 CA                    DEX   
5485 F25A 8A                    TXA                            ;PREPARE FOR TABV SUBR.
5486 F25B C9 18                 CMP   #$18                     ;OFF OF SCREEN?
5487 F25D B0 A7                 BCS   TOOBIG
5488 F25F 4C 5B FB              JMP   TABV
5489 F262              TABV     EQU   $FB5B
5490 F262 20 F8 E6     SETSPD:  JSR   GETBYT
5491 F265 8A                    TXA                            ;FOR OUTPUT SPEED
5492 F266 49 FF                 EOR   #$FF
5493 F268 AA                    TAX   
5494 F269 E8                    INX   
5495 F26A 86 F1                 STX   SPDBYT
5496 F26C 60                    RTS   
5497 F26D 38           SETTRACE: SEC   
5498 F26E 90                    DC B:$90                       ;was BCC	SETTRACE : ORG *-1
5499 F26F 18           TRACEOFF: CLC                           ;ADJUST TRFLAG FOR TRACE.
5500 F270 66 F2                 ROR   TRFLAG
5501 F272 60                    RTS                            ;BACK TO CALLER.
5502 F273              *
5503 F273 A9 FF        SETNORM: LDA   #$FF
5504 F275 D0 02                 BNE   SETTYPE
5505 F277 A9 3F        INVERSE: LDA   #$3F
5506 F279 A2 00        SETTYPE: LDX   #$00
5507 F27B 85 32        SETMODE: STA   INVFLG
5508 F27D 86 F3                 STX   ORMASK
5509 F27F 60                    RTS   
5510 F280 A9 7F        FLASH:   LDA   #$7F
5511 F282 A2 40                 LDX   #$40
5512 F284 D0 F5                 BNE   SETMODE                  ;ALWAYS TAKEN
5513 F286              *
5514 F286 20 67 DD     HIMEMSET: JSR   FRMNUM                  ;GET ARG FOR HIMEM:
5515 F289 20 52 E7              JSR   GETADR
5516 F28C A5 50                 LDA   POKER                    ;PROGRAM OVERFLOW?
5517 F28E C5 6D                 CMP   STREND
5518 F290 A5 51                 LDA   POKER+1
5519 F292 E5 6E                 SBC   STREND+1
5520 F294 B0 03                 BCS   DOSET
5521 F296 4C 10 D4     MEMFULL: JMP   OMERR
5522 F299 A5 50        DOSET:   LDA   POKER
5523 F29B 85 73                 STA   MEMSIZ
5524 F29D 85 6F                 STA   FRETOP
5525 F29F A5 51                 LDA   POKER+1
5526 F2A1 85 74                 STA   MEMSIZ+1
5527 F2A3 85 70                 STA   FRETOP+1
5528 F2A5 60                    RTS   
5529 F2A6 20 67 DD     LOMEMSET: JSR   FRMNUM
5530 F2A9 20 52 E7              JSR   GETADR
5531 F2AC A5 50                 LDA   POKER
5532 F2AE C5 73                 CMP   MEMSIZ
5533 F2B0 A5 51                 LDA   POKER+1
5534 F2B2 E5 74                 SBC   MEMSIZ+1
5535 F2B4 B0 E0                 BCS   MEMFULL
5536 F2B6 A5 50                 LDA   POKER
5537 F2B8 C5 69                 CMP   VARTAB
5538 F2BA A5 51                 LDA   POKER+1
5539 F2BC E5 6A                 SBC   VARTAB+1
5540 F2BE 90 D6                 BCC   MEMFULL
5541 F2C0 A5 50                 LDA   POKER
5542 F2C2 85 69                 STA   VARTAB
5543 F2C4 A5 51                 LDA   POKER+1
5544 F2C6 85 6A                 STA   VARTAB+1
5545 F2C8 4C 6C D6              JMP   CLEARC
5546 F2CB A9 AB        ONERR:   LDA   #GOTOTK                  ;ON ERR GOTO?
5547 F2CD 20 C0 DE              JSR   SYNCHR                   ;IF NOT, BLOW HIM UP
5548 F2D0 A5 B8                 LDA   TXTPTR                   ;SAVE FOR ERRHNDL
5549 F2D2 85 F4                 STA   ERRTO
5550 F2D4 A5 B9                 LDA   TXTPTR+1
5551 F2D6 85 F5                 STA   ERRTO+1
5552 F2D8 38                    SEC                            ;ROTATE IN.
5553 F2D9 66 D8                 ROR   ERRFLG
5554 F2DB A5 75                 LDA   CURLIN                   ;ALL INFO FOR 'GOTO' COMMAND
5555 F2DD 85 F6                 STA   ERRTO+2
5556 F2DF A5 76                 LDA   CURLIN+1
5557 F2E1 85 F7                 STA   ERRTO+3
5558 F2E3 20 A6 D9              JSR   REMN                     ;SKIP REST OF LINE.
5559 F2E6 4C 98 D9              JMP   ADDON                    ;FINISH.
5560 F2E9 86 DE        HNDLERR: STX   ERRNUM
5561 F2EB A6 F8                 LDX   REMSTK                   ;PRESERVE STACK POINTER
5562 F2ED 86 DF                 STX   ERRSTK                   ;FOR 'RESUME' STATEMENT
5563 F2EF A5 75                 LDA   CURLIN                   ;FOR RESUME
5564 F2F1 85 DA                 STA   ERRLIN
5565 F2F3 A5 76                 LDA   CURLIN+1
5566 F2F5 85 DB                 STA   ERRLIN+1
5567 F2F7 A5 79                 LDA   OLDTXT
5568 F2F9 85 DC                 STA   ERRPOS
5569 F2FB A5 7A                 LDA   OLDTXT+1
5570 F2FD 85 DD                 STA   ERRPOS+1
5571 F2FF              * ALL USER INFO NOW THERE.
5572 F2FF A5 F4                 LDA   ERRTO
5573 F301 85 B8                 STA   TXTPTR
5574 F303 A5 F5                 LDA   ERRTO+1
5575 F305 85 B9                 STA   TXTPTR+1
5576 F307 A5 F6                 LDA   ERRTO+2
5577 F309 85 75                 STA   CURLIN
5578 F30B A5 F7                 LDA   ERRTO+3
5579 F30D 85 76                 STA   CURLIN+1
5580 F30F 20 B7 00              JSR   CHRGOT                   ;FOR STATUS
5581 F312 20 3E D9              JSR   GOTO                     ;NOW DISPATCH, THEN
5582 F315 4C D2 D7              JMP   NEWSTT                   ;BACK TO NEWSTT.
5583 F318 A5 DA        RESUME:  LDA   ERRLIN
5584 F31A 85 75                 STA   CURLIN
5585 F31C A5 DB                 LDA   ERRLIN+1
5586 F31E 85 76                 STA   CURLIN+1
5587 F320 A5 DC                 LDA   ERRPOS
5588 F322 85 B8                 STA   TXTPTR
5589 F324 A5 DD                 LDA   ERRPOS+1
5590 F326 85 B9                 STA   TXTPTR+1
5591 F328 A6 DF                 LDX   ERRSTK                   ;RESTORE STACK POINTER.
5592 F32A 9A                    TXS                            ;FOR REST OF BASIC.
5593 F32B 4C D2 D7              JMP   NEWSTT                   ;BACK TO TRY AGAIN.....
5594 F32E 4C C9 DE     BLOWEM:  JMP   SNERR
5595 F331 B0 FB        DELETE:  BCS   BLOWEM                   ;IF NOT A DIGIT.
5596 F333 A6 AF                 LDX   PRGEND                   ;FOR LOMEM:
5597 F335 86 69                 STX   VARTAB
5598 F337 A6 B0                 LDX   PRGEND+1
5599 F339 86 6A                 STX   VARTAB+1
5600 F33B 20 0C DA              JSR   LINGET                   ;READ THE LINE NUMBER INTO LINNUM.
5601 F33E 20 1A D6              JSR   FNDLIN
5602 F341 A5 9B                 LDA   LOWTR                    ;PREPARE FOR MOVE.
5603 F343 85 60                 STA   INDEX2
5604 F345 A5 9C                 LDA   LOWTR+1
5605 F347 85 61                 STA   INDEX2+1
5606 F349 A9 2C                 LDA   #$2C
5607 F34B 20 C0 DE              JSR   SYNCHR
5608 F34E 20 0C DA              JSR   LINGET                   ;MUST HAVE TWO ARGS.
5609 F351 E6 50                 INC   LINNUM                   ;INCLUSIVE DELETE.
5610 F353 D0 02                 BNE   *+4
5611 F355 E6 51                 INC   LINNUM+1
5612 F357 20 1A D6              JSR   FNDLIN                   ;GET THIS LINE.
5613 F35A              ;CHECK FOR BACKWARDS DELETE
5614 F35A A5 9B                 LDA   LOWTR                    ;IS LOWTR>=INDEX2
5615 F35C C5 60                 CMP   INDEX2                   ;IF SO ;DO NOTHING
5616 F35E A5 9C                 LDA   LOWTR+1
5617 F360 E5 61                 SBC   INDEX2+1
5618 F362 B0 01                 BCS   *+3
5619 F364 60                    RTS   
5620 F365              ;NOW MOVE: (INDEX1)<(LOWTR).(VARTAB)M
5621 F365 A0 00                 LDY   #0
5622 F367 B1 9B        MOVEDEL: LDA   (LOWTR),Y                ;TRANSFER A BYTE.
5623 F369 91 60                 STA   (INDEX2),Y
5624 F36B E6 9B                 INC   LOWTR                    ;NEXT LOCATIONS...
5625 F36D D0 02                 BNE   *+4
5626 F36F E6 9C                 INC   LOWTR+1
5627 F371 E6 60                 INC   INDEX2
5628 F373 D0 02                 BNE   *+4
5629 F375 E6 61                 INC   INDEX2+1
5630 F377 A5 69                 LDA   VARTAB
5631 F379 C5 9B                 CMP   LOWTR                    ;DONE WITH MOVE?
5632 F37B A5 6A                 LDA   VARTAB+1
5633 F37D E5 9C                 SBC   LOWTR+1
5634 F37F B0 E6                 BCS   MOVEDEL                  ;IF LESS THAN OR EQUAL, CONT.
5635 F381 A6 61                 LDX   INDEX2+1
5636 F383 A4 60                 LDY   INDEX2
5637 F385 D0 01                 BNE   *+3
5638 F387 CA                    DEX   
5639 F388 88                    DEY   
5640 F389 86 6A                 STX   VARTAB+1                 ;END OF PROGRAM
5641 F38B 84 69                 STY   VARTAB
5642 F38D 4C F2 D4              JMP   FINI                     ;FINISH IT OFF.
5643 F390              LORES:   EQU   $C056
5644 F390 AD 56 C0     MSETGR:  LDA   LORES
5645 F393 AD 53 C0              LDA   MIXSET
5646 F396 4C EC D8              JMP   SETGR                    ;NOW INTO LOW-RESOLUTION
5647 F399 AD 54 C0     MSETTXT: LDA   LOPAGE
5648 F39C 4C 39 FB              JMP   SETTXT
5649 F39F 4A           PLOTDO   LSR   A
5650 F3A0 08                    PHP                            ;THIS STUFF STOLEN FROM MONITOR GR ROUTINES
5651 F3A1 20 47 F8              JSR   GBASCALC
5652 F3A4 28                    PLP   
5653 F3A5 A9 0F                 LDA   #$F
5654 F3A7 90 02                 BCC   RTMASK
5655 F3A9 69 E0                 ADC   #$E0                     ;FORMS $F0 WITH CARRY CLEAR
5656 F3AB 85 2E        RTMASK   STA   MASK
5657 F3AD 5A           PLOT1    PHY                            ;OTHER ROUTINES ENTER HERE 
5658 F3AE 20 BB F7              JSR   VIDSETY                  ;TEST FOR DOUBLE GR, SET Y 
5659 F3B1 90 0A                 BCC   PLOT3                    ;BRANCH IF REG GR 
5660 F3B3 DA                    PHX                            ;SAVE X ON TOP OF STACK 
5661 F3B4 A5 30                 LDA   COLOR                    ;MUST MUCK WITH COLORS IN ALT BANK 
5662 F3B6 AA                    TAX                            ;SAVE IN X FOR LATER COLOR RESTORE 
5663 F3B7 4A                    LSR   A
5664 F3B8 8A                    TXA                            ;ROTATE 8 BITS RIGHT
5665 F3B9 6A                    ROR   A
5666 F3BA 38                    SEC                            ;RESET CARRY FOR ALT PAGE INDICATOR
5667 F3BB 85 30                 STA   COLOR
5668 F3BD              PLOT3    EQU   *
5669 F3BD 20 0E F8              JSR   ROMPLOT                  ;GO PLOT THE DOT 
5670 F3C0 90 07                 BCC   PLOT4                    ;BRANCH IF NOT SPECIAL HANDLED
5671 F3C2 AD 54 C0              LDA   $C054
5672 F3C5 86 30                 STX   COLOR                    ;RESTORE UNTRANSLATED COLOR
5673 F3C7 FA                    PLX                            ;RESTORE ORIGINAL X
5674 F3C8 18                    CLC                            ;PLOT ALWAYS RETURNS CARRY CLEAR.
5675 F3C9 7A           PLOT4    PLY                            ;RESTORE ORIGINAL Y
5676 F3CA 60                    RTS   
5677 F3CB              VIDSTATE EQU   *
5678 F3CB              GETAN3STATUS EQU   $F93A                ;Let Cortland monitor get AN3
5679 F3CB 20 3A F9              JSR   GETAN3STATUS             ;Get AN3 status in bit 7
5680 F3CE 49 80                 EOR   #$80
5681 F3D0 2D 18 C0              AND   $C018                    ;80-STORE MUST ALSO BE ENABLED 
5682 F3D3 2D 1F C0              AND   $C01F
5683 F3D6 0A                    ASL   A                        ;RETURN IN CARRY
5684 F3D7 60                    RTS   
5685 F3D8              *
5686 F3D8              FILL_SIZE02 EQU   APPLESOFT+$23D8-*
5687 F3D8
5688 F3D8              ;TITLE "APPLE II HI-RES GRAPHICS ROUTINES"
5689 F3D8              **************************
5690 F3D8              *                        *
5691 F3D8              * APPLE-II HI-RESOLUTION * 
5692 F3D8              *  GRAPHICS SUBROUTINES  * 
5693 F3D8              *                        * 
5694 F3D8              *    BY WOZ   9/13/77    * 
5695 F3D8              *                        *
5696 F3D8              *  ALL RIGHTS RESERVED   *
5697 F3D8              *                        * 
5698 F3D8              **************************
5699 F3D8                       EJECT 
5700 F3D8                       TITLE 'HI-RES EQUATES'
5701 F3D8              SHAPEL   EQU   $1A                      ;POINTER TO
5702 F3D8              SHAPEH   EQU   $1B                      ;SHAPE LIST 
5703 F3D8              HCOLOR1  EQU   $1C                      ;RUNNING COLOR MASK
5704 F3D8              COUNTH   EQU   $1D
5705 F3D8              HBASL    EQU   $26                      ;BASE ADR FOR CURRENT
5706 F3D8              HBASH    EQU   $27                      ;HI-RES PLOT LINE. A
5707 F3D8              HMASK    EQU   $30
5708 F3D8              A1L      EQU   $3C                      ;MONITOR A1.
5709 F3D8              A1H      EQU   $3D
5710 F3D8              A2L      EQU   $3E                      ;MONITOR A2.
5711 F3D8              A2H      EQU   $3F
5712 F3D8              LOMEML   EQU   $4A                      ;BASIC 'START OF VARS'.
5713 F3D8              LOMEMH   EQU   $4B
5714 F3D8              DXL      EQU   $D0                      ;DELTA-X FOR HLIN, SHAPE.
5715 F3D8              DXH      EQU   $D1
5716 F3D8              SHAPEX   EQU   $D1                      ;SHAPE TEMP.
5717 F3D8              DY       EQU   $D2                      ;DELTA-Y FOR HLIN, SHAPE.
5718 F3D8              QDRNT    EQU   $D3                      ;ROT QUADRANT (SHAPE).
5719 F3D8              EL       EQU   $D4                      ;ERROR FOR HLIN.
5720 F3D8              EH       EQU   $D5
5721 F3D8              X0L      EQU   $E0                      ;PRIOR X-COORD SAVE
5722 F3D8              X0H      EQU   $E1                      ;AFTER HLIN OR HPLOT.
5723 F3D8              Y0       EQU   $E2                      ;HLIN, HPLOT Y-COORD SAVE.
5724 F3D8              HCOLOR   EQU   $E4                      ;COLOR FOR HPLOT, HPOSN
5725 F3D8              HNDX     EQU   $E5                      ;HORIZ OFFSET SAVE.
5726 F3D8              HPAG     EQU   $E6                      ;HI-RES PAGE ($20 NORMAL)
5727 F3D8              SCALE    EQU   $E7                      ;SCALE FOR SHAPE, MOVE.
5728 F3D8              SHAPXL   EQU   $E8                      ;START OF
5729 F3D8              SHAPXH   EQU   $E9                      ;SHAPE TABLE.
5730 F3D8              COLLSN   EQU   $EA                      ;COLLISION COUNT.
5731 F3D8              ROTBYT   EQU   $F9                      ;HOLD ROTATION FACTOR >>>UNDOCUMENTED ZPG BYTE<<<
5732 F3D8              SHSTRT   EQU   $C00                     ;START OF SHAPE TABLE.
5733 F3D8              HIRES    EQU   $C057                    ;SWITCH TO HI-RES VIDEO
5734 F3D8              MIXSET   EQU   $C053                    ;SELECT TEXT/GRAPHICS 
5735 F3D8              TXTCLR   EQU   $C050                    ;SELECT GRAPHICS MODE.
5736 F3D8              ACADR    EQU   $F11E                    ;2-BYTE TAPE READ SETUP.
5737 F3D8              LOPAGE   EQU   $C054                    ;FOR PRIMARY PAGE.
5738 F3D8              HIPAGE   EQU   $C055                    ;FOR SECONDARY PAGE.
5739 F3D8              FULSET   EQU   $C052                    ;WHOLE SCREEN GRAPHICS
5740 F3D8                       EJECT 
5741 F3D8                       TITLE 'HIGH RESOLUTION GRAPHICS INITS'
5742 F3D8              *
5743 F3D8              * MICROSOFT VERSION
5744 F3D8              *
5745 F3D8 2C 55 C0     SETHRH:  BIT   HIPAGE                   ;DISPLAY SECOND PAGE.
5746 F3DB 2C 52 C0              BIT   FULSET
5747 F3DE A9 40                 LDA   #$40
5748 F3E0 D0 08                 BNE   SET                      ;ALWAYS TAKEN.
5749 F3E2 A9 20        SETHRL   LDA   #$20                     ;INIT FOR $2000-3FFF
5750 F3E4 2C 54 C0              BIT   LOPAGE
5751 F3E7 2C 53 C0              BIT   MIXSET
5752 F3EA 85 E6        SET:     STA   HPAG                     ;HI-RES SCREEN MEMORY.
5753 F3EC AD 57 C0              LDA   HIRES                    ;SET HIRES DISPLAY MODE
5754 F3EF AD 50 C0              LDA   TXTCLR                   ;SET GRAPHICS DISPLAY
5755 F3F2 A9 00        HCLR     LDA   #$0
5756 F3F4 85 1C        BKGNDO   STA   HCOLOR1                  ;SET FOR BLACK BKGND.
5757 F3F6 A5 E6        BKGND    LDA   HPAG
5758 F3F8 85 1B                 STA   SHAPEH                   ;INIT HI-RES SCREEN MEM
5759 F3FA A0 00                 LDY   #$0                      ;FOR CURRENT PAGE, NORMALLY
5760 F3FC 84 1A                 STY   SHAPEL                   ;$2000-3FFF OR $4000-5FFF
5761 F3FE A5 1C        BKGND1   LDA   HCOLOR1
5762 F400 91 1A                 STA   (SHAPEL),Y
5763 F402 20 7E F4              JSR   CSHFT2                   ;(SHAPEL,H) WILL SPECIFY
5764 F405 C8                    INY                            ;32 SEPARATE PAGES.
5765 F406 D0 F6                 BNE   BKGND1                   ;THROUGHOUT THE INIT.
5766 F408 E6 1B                 INC   SHAPEH
5767 F40A A5 1B                 LDA   SHAPEH
5768 F40C 29 1F                 AND   #$1F                     ;TEST FOR DONE.
5769 F40E D0 EE                 BNE   BKGND1
5770 F410 60                    RTS   
5771 F411                       EJECT 
5772 F411                       TITLE 'HI-RES POSITION AND PLOT'
5773 F411 85 E2        HPOSN    STA   Y0                       ;ENTER WITH Y IN A-REG,
5774 F413 86 E0                 STX   X0L                      ;XL IN X-REG,
5775 F415 84 E1                 STY   X0H                      ;AND XH IN Y-REG.
5776 F417 48                    PHA   
5777 F418 29 C0                 AND   #$C0
5778 F41A 85 26                 STA   HBASL                    ;FOR Y-COORD = OOABCDEF. 
5779 F41C 4A                    LSR   A                        ;CALCULATES BASE ADDRESS.
5780 F41D 4A                    LSR   A                        ;IN HBASL, HBASH FOR
5781 F41E 05 26                 ORA   HBASL                    ;ACCESSING SCREEN MEM
5782 F420 85 26                 STA   HBASL                    ;VIA (HBASL),Y ADDRESSING MODE
5783 F422 68                    PLA   
5784 F423 85 27                 STA   HBASH
5785 F425 0A                    ASL   A                        ;CALCULATES
5786 F426 0A                    ASL   A                        ;HBASH = PPPFGHCD,
5787 F427 0A                    ASL   A                        ;HBASL = EABAB000
5788 F428 26 27                 ROL   HBASH
5789 F42A 0A                    ASL   A                        ;WHERE PPP=001 FOR $2000.3FFF
5790 F42B 26 27                 ROL   HBASH                    ;SCREEN MEM RANGE AND
5791 F42D 0A                    ASL   A                        ;PPP=010 FOR $4000-7FFF
5792 F42E 66 26                 ROR   HBASL                    ;(GIVEN Y-COORD=ABCDEFGH)
5793 F430 A5 27                 LDA   HBASH
5794 F432 29 1F                 AND   #$1F
5795 F434 05 E6                 ORA   HPAG
5796 F436 85 27                 STA   HBASH
5797 F438 8A                    TXA                            ;DIVIDE X0 BY 7 FOR
5798 F439 C0 00                 CPY   #$0                      ;INDEX FROM BASE ADR
5799 F43B F0 05                 BEQ   HPOSN2                   ;(QUOTIENT) AND BIT
5800 F43D A0 23                 LDY   #$23                     ;WITHIN SCREEN MEM B
5801 F43F 69 04                 ADC   #$4                      ;(MASK SPEC'D BY REMAINDER) 
5802 F441 C8           HPOSN1   INY   
5803 F442 E9 07        HPOSN2   SBC   #$7                      ;SUBTRACT OUT SEVENS.
5804 F444 B0 FB                 BCS   HPOSN1
5805 F446 84 E5                 STY   HNDX                     ;WORKS FOR XO FROM
5806 F448 AA                    TAX                            ;0 TO 279, LOW-ORDER
5807 F449 BD B9 F4              LDA   MSKTBL-$F9,X             ;BYTE IN X-REG,
5808 F44C 85 30                 STA   HMASK                    ;HIGH IN Y-REG ON ENTRY
5809 F44E 98                    TYA   
5810 F44F 4A                    LSR   A                        ;IF ON ODD BYTE (CARRY
5811 F450 A5 E4                 LDA   HCOLOR                   ;THEN ROTATE HCOLOR
5812 F452 85 1C        HPOSN3   STA   HCOLOR1                  ;BIT FOR 180 DEGREE
5813 F454 B0 28                 BCS   CSHFT2                   ;PRIOR TO COPYING TO
5814 F456 60                    RTS   
5815 F457 20 11 F4     HPLOT    JSR   HPOSN
5816 F45A A5 1C        HPLOT1   LDA   HCOLOR1                  ;CALC BIT POSN IN HBAS
5817 F45C 51 26                 EOR   (HBASL),Y                ;HNDX, AND HMASK FROM
5818 F45E 25 30                 AND   HMASK                    ;Y-COORD IN A-REG,
5819 F460 51 26                 EOR   (HBASL),Y                ;X-COORD IN X,Y-REGS.
5820 F462 91 26                 STA   (HBASL),Y                ;FOR ANY 'L' BITS OF H
5821 F464 60                    RTS                            ;SUBSTITUTE CORRESPONDING 
5822 F465              * BIT OF HCOLOR1.
5823 F465                       EJECT 
5824 F465                       TITLE 'HI-RES GRAPHICS L,R,U,D SUBRS'
5825 F465 10 23        LFTRT    BPL   RIGHT                    ;USE SIGN FOR LFT/RT S
5826 F467 A5 30        LEFT     LDA   HMASK
5827 F469 4A                    LSR   A                        ;SHIFT LOW-ORDER
5828 F46A B0 05                 BCS   LEFT1                    ;7 BITS OF HMASK
5829 F46C 49 C0                 EOR   #$C0                     ;ONE BIT TO LSB.
5830 F46E 85 30        LR1      STA   HMASK
5831 F470 60                    RTS   
5832 F471 88           LEFT1    DEY                            ;DECR HORIZ INDEX.
5833 F472 10 02                 BPL   LEFT2
5834 F474 A0 27                 LDY   #$27                     ;WRAP AROUND SCREEN.
5835 F476 A9 C0        LEFT2    LDA   #$C0                     ;NEW HMASK, RIGHTMOST
5836 F478 85 30        NEWNDX   STA   HMASK                    ;DOT OF BYTE.
5837 F47A 84 E5                 STY   HNDX                     ;UPDATE HORIZ INDEX.
5838 F47C A5 1C        CSHIFT   LDA   HCOLOR1
5839 F47E 0A           CSHFT2   ASL   A                        ;ROTATE LOW-ORDER
5840 F47F C9 C0                 CMP   #$C0                     ;7 BITS OF HCOLOR1
5841 F481 10 06                 BPL   RTS1                     ;ONE BIT POSN.
5842 F483 A5 1C                 LDA   HCOLOR1
5843 F485 49 7F                 EOR   #$7F                     ;ZXYXYXYX -> ZYXYXYXY
5844 F487 85 1C                 STA   HCOLOR1
5845 F489 60           RTS1     RTS   
5846 F48A A5 30        RIGHT    LDA   HMASK
5847 F48C 0A                    ASL   A                        ;SHIFT LOW-ORDER
5848 F48D 49 80                 EOR   #$80                     ;7 BITS OF HMASK
5849 F48F 30 DD                 BMI   LR1                      ;ONE BIT TO MSB.
5850 F491 A9 81                 LDA   #$81
5851 F493 C8                    INY                            ;NEXT BYTE.
5852 F494 C0 28                 CPY   #$28
5853 F496 90 E0                 BCC   NEWNDX
5854 F498 A0 00                 LDY   #$0                      ;WRAP AROUND SCREEN IF
5855 F49A B0 DC                 BCS   NEWNDX                   ;ALWAYS TAKEN.
5856 F49C                       EJECT 
5857 F49C                       TITLE 'L,R,U,D, SUBROUTINES.'
5858 F49C 18           LRUDX1   CLC                            ;NO 90 DEG ROT (X-OR).
5859 F49D A5 D1        LRUDX2   LDA   SHAPEX
5860 F49F 29 04                 AND   #$4                      ;IF B2=0 THEN NO PLOT.
5861 F4A1 F0 25                 BEQ   LRUD4
5862 F4A3 A9 7F                 LDA   #$7F                     ;FOR EX-OR INTO SCREEN
5863 F4A5 25 30                 AND   HMASK
5864 F4A7 31 26                 AND   (HBASL),Y                ;SCREEN BIT SET?
5865 F4A9 D0 19                 BNE   LRUD3
5866 F4AB E6 EA                 INC   COLLSN
5867 F4AD A9 7F                 LDA   #$7F
5868 F4AF 25 30                 AND   HMASK
5869 F4B1 10 11                 BPL   LRUD3                    ;ALWAYS TAKEN.
5870 F4B3 18           LRUD1    CLC                            ;NO 90 DEG ROT.
5871 F4B4 A5 D1        LRUD2    LDA   SHAPEX
5872 F4B6 29 04                 AND   #$4                      ;IF B2=0 THEN NO PLOT.
5873 F4B8 F0 0E                 BEQ   LRUD4
5874 F4BA B1 26                 LDA   (HBASL),Y
5875 F4BC 45 1C                 EOR   HCOLOR1                  ;SET HI-RES SCREEN BIT
5876 F4BE 25 30                 AND   HMASK                    ;TO CORRESPONDING HC
5877 F4C0 D0 02                 BNE   LRUD3                    ;IF BIT OF SCREEN CHAN
5878 F4C2 E6 EA                 INC   COLLSN                   ;THEN INCR COLLSN DE
5879 F4C4 51 26        LRUD3    EOR   (HBASL),Y
5880 F4C6 91 26                 STA   (HBASL),Y
5881 F4C8 A5 D1        LRUD4    LDA   SHAPEX                   ;ADD QDRNT TO
5882 F4CA 65 D3                 ADC   QDRNT                    ;SPECIFIED VECTOR
5883 F4CC 29 03                 AND   #$3                      ;AND MOVE LFT, RT,
5884 F4CE              EQ3      EQU   *-1                      ;UP, OR DWN BASED
5885 F4CE C9 02                 CMP   #$2                      ;ON SIGN AND CARRY.
5886 F4D0 6A                    ROR   A
5887 F4D1 B0 92        LRUD     BCS   LFTRT
5888 F4D3 30 30        UPDWN    BMI   DOWN4                    ;SIGN FOR UP/DWN SELECT
5889 F4D5 18           UP       CLC   
5890 F4D6 A5 27                 LDA   HBASH                    ;CALC BASE ADDRESS
5891 F4D8 2C B9 F5              BIT   EQ1C                     ;(ADR OF LEFTMOST BYTE)
5892 F4DB D0 22                 BNE   UP4                      ;FOR NEXT LINE UP
5893 F4DD 06 26                 ASL   HBASL                    ;IN (HBASL, HBASH)
5894 F4DF B0 1A                 BCS   UP2                      ;WITH 192-LINE WRAPA
5895 F4E1 2C CD F4              BIT   EQ3
5896 F4E4 F0 05                 BEQ   UP1
5897 F4E6 69 1F                 ADC   #$1F                     ;**** BIT MAP ****
5898 F4E8 38                    SEC   
5899 F4E9 B0 12                 BCS   UP3                      ;FOR ROW = ABCDEFGH,
5900 F4EB 69 23        UP1      ADC   #$23
5901 F4ED 48                    PHA   
5902 F4EE A5 26                 LDA   HBASL                    ;HBASL = EABABOOO
5903 F4F0 69 B0                 ADC   #$B0                     ;HBASH = PPPFGHCD
5904 F4F2 B0 02                 BCS   UP5
5905 F4F4 69 F0                 ADC   #$F0                     ;WHERE PPP=001 FOR PRIMARY
5906 F4F6 85 26        UP5      STA   HBASL                    ;HI-RES PAGE ($2000-
5907 F4F8 68                    PLA   
5908 F4F9 B0 02                 BCS   UP3
5909 F4FB 69 1F        UP2      ADC   #$1F
5910 F4FD 66 26        UP3      ROR   HBASL
5911 F4FF 69 FC        UP4      ADC   #$FC
5912 F501 85 27        UPDWN1   STA   HBASH
5913 F503 60                    RTS   
5914 F504 18           DOWN     CLC   
5915 F505 A5 27        DOWN4    LDA   HBASH
5916 F507 69 04                 ADC   #$4                      ;CALC BASE ADR FOR NEX
5917 F509              EQ4      EQU   *-1                      ;DOWN TO (HBASL,HBAS
5918 F509 2C B9 F5              BIT   EQ1C
5919 F50C D0 F3                 BNE   UPDWN1
5920 F50E 06 26                 ASL   HBASL                    ;WITH 192-LINE WRAPA
5921 F510 90 18                 BCC   DOWN1
5922 F512 69 E0                 ADC   #$E0
5923 F514 18                    CLC   
5924 F515 2C 08 F5              BIT   EQ4
5925 F518 F0 12                 BEQ   DOWN2
5926 F51A A5 26                 LDA   HBASL
5927 F51C 69 50                 ADC   #$50
5928 F51E 49 F0                 EOR   #$F0
5929 F520 F0 02                 BEQ   DOWN3
5930 F522 49 F0                 EOR   #$F0
5931 F524 85 26        DOWN3    STA   HBASL
5932 F526 A5 E6                 LDA   HPAG
5933 F528 90 02                 BCC   DOWN2
5934 F52A 69 E0        DOWN1    ADC   #$E0
5935 F52C 66 26        DOWN2    ROR   HBASL
5936 F52E 90 D1                 BCC   UPDWN1
5937 F530                       EJECT 
5938 F530                       TITLE 'HI-RES GRAPHICS LINE DRAW SUBRS'
5939 F530 48           HLINRL   PHA   
5940 F531 A9 00                 LDA   #$0                      ;SET (X0L,X0H) AND
5941 F533 85 E0                 STA   X0L                      ;Y0 TO ZERO FOR
5942 F535 85 E1                 STA   X0H                      ;REL LINE DRAW
5943 F537 85 E2                 STA   Y0                       ;(DX, DY).
5944 F539 68                    PLA   
5945 F53A 48           HILIN    PHA                            ;ON ENTRY
5946 F53B 38                    SEC                            ;XL: A-REG
5947 F53C E5 E0                 SBC   X0L                      ;XH; X-REG
5948 F53E 48                    PHA                            ;Y: Y-REG
5949 F53F 8A                    TXA   
5950 F540 E5 E1                 SBC   X0H
5951 F542 85 D3                 STA   QDRNT                    ;CALC ABS(X-XO)
5952 F544 B0 0A                 BCS   HLIN2                    ;IN (DXL,DXH)
5953 F546 68                    PLA   
5954 F547 49 FF                 EOR   #$FF                     ;X DIR TO SIGN BIT
5955 F549 69 01                 ADC   #$1                      ;OF QDRNT.
5956 F54B 48                    PHA                            ;0=RIGHT (DX POS)
5957 F54C A9 00                 LDA   #$0                      ;1=LEFT (DX NEG)
5958 F54E E5 D3                 SBC   QDRNT
5959 F550 85 D1        HLIN2    STA   DXH
5960 F552 85 D5                 STA   EH                       ;INIT (EL,EH) TO
5961 F554 68                    PLA                            ;ABS(X-X0)
5962 F555 85 D0                 STA   DXL
5963 F557 85 D4                 STA   EL
5964 F559 68                    PLA   
5965 F55A 85 E0                 STA   X0L
5966 F55C 86 E1                 STX   X0H
5967 F55E 98                    TYA   
5968 F55F 18                    CLC   
5969 F560 E5 E2                 SBC   Y0                       ;CALC -ABS(Y-O)-1
5970 F562 90 04                 BCC   HLIN3                    ;IN DY.
5971 F564 49 FF                 EOR   #$FF
5972 F566 69 FE                 ADC   #$FE
5973 F568 85 D2        HLIN3    STA   DY                       ;ROTATE Y DIR INTO
5974 F56A 84 E2                 STY   Y0                       ;QDRNT SIGN BIT
5975 F56C 66 D3                 ROR   QDRNT                    ;(0=UP, 1=DOWN)
5976 F56E 38                    SEC   
5977 F56F E5 D0                 SBC   DXL                      ;INIT (COUNTL, COUNTH).
5978 F571 AA                    TAX                            ;TO -(DELTX+DELTY+1)
5979 F572 A9 FF                 LDA   #$FF
5980 F574 E5 D1                 SBC   DXH
5981 F576 85 1D                 STA   COUNTH
5982 F578 A4 E5                 LDY   HNDX                     ;HORIZ INDEX
5983 F57A B0 05                 BCS   MOVEX2                   ;ALWAYS TAKEN.
5984 F57C 0A           MOVEX    ASL   A                        ;MOVE IN X-DIR. USE
5985 F57D 20 65 F4              JSR   LFTRT                    ;QDRNT B6 FOR LFT/RT
5986 F580 38                    SEC   
5987 F581 A5 D4        MOVEX2   LDA   EL                       ;ASSUME CARRY SET.
5988 F583 65 D2                 ADC   DY                       ;(EL,EH)-DELTY TO (EL,
5989 F585 85 D4                 STA   EL                       ;NOTE: DY IS (-DELTY)-1
5990 F587 A5 D5                 LDA   EH                       ;CARRY CLR IF (EL,EH)
5991 F589 E9 00                 SBC   #$0                      ;GOES NEG.
5992 F58B 85 D5        HCOUNT   STA   EH
5993 F58D B1 26                 LDA   (HBASL),Y                ;SCREEN BYTE.
5994 F58F 45 1C                 EOR   HCOLOR1                  ;PLOT DOT OF HCOLOR1.
5995 F591 25 30                 AND   HMASK                    ;CURRENT BIT MASK.
5996 F593 51 26                 EOR   (HBASL),Y
5997 F595 91 26                 STA   (HBASL),Y
5998 F597 E8                    INX                            ;DONE (DELTX+DELTY)
5999 F598 D0 04                 BNE   HLIN4                    ;DOTS?
6000 F59A E6 1D                 INC   COUNTH
6001 F59C F0 62                 BEQ   RTS2                     ;YES, RETURN.
6002 F59E A5 D3        HLIN4    LDA   QDRNT                    ;FOR DIRECTION TEST
6003 F5A0 B0 DA                 BCS   MOVEX                    ;IF CAR SET, (EL, EH) P
6004 F5A2 20 D3 F4              JSR   UPDWN                    ;IF CLR, NEG, MOVE Y
6005 F5A5 18                    CLC   
6006 F5A6 A5 D4                 LDA   EL                       ;(EL,EH)+DELTX
6007 F5A8 65 D0                 ADC   DXL                      ;TO (EL,EH).
6008 F5AA 85 D4                 STA   EL
6009 F5AC A5 D5                 LDA   EH                       ;CAR SET IF (EL,EH) GO
6010 F5AE 65 D1                 ADC   DXH
6011 F5B0 50 D9                 BVC   HCOUNT                   ;ALWAYS TAKEN.
6012 F5B2 81           MSKTBL   DC B:$81                       ;LEFTMOST BIT OF BYTE.
6013 F5B3 82 84 88              DC B:$82,$84,$88
6014 F5B6 90 A0                 DC B:$90,$A0
6015 F5B8 C0                    DC B:$C0                       ;RIGHTMOST BIT OF BYTE.
6016 F5B9 1C           EQ1C     DC B:$1C
6017 F5BA FF FE FA F4  COSTABL  DC B:$FF,$FE,$FA,$F4
6018 F5BE EC E1 D4 C5           DC B:$EC,$E1,$D4,$C5
6019 F5C2 B4                    DC B:$B4
6020 F5C3 A1 8D 78 61           DC B:$A1,$8D,$78,$61
6021 F5C7 49 31 18 FF           DC B:$49,$31,$18,$FF
6022 F5CB                       EJECT 
6023 F5CB                       TITLE 'HI-RES GRAPHICS COORD RESTORE'
6024 F5CB A5 26        HFIND    LDA   HBASL
6025 F5CD 0A                    ASL   A                        ;CONVERTS BASE ADR
6026 F5CE A5 27                 LDA   HBASH                    ;TO Y-COORD.
6027 F5D0 29 03                 AND   #$3
6028 F5D2 2A                    ROL   A                        ;FOR HBASL = EABABOOO
6029 F5D3 05 26                 ORA   HBASL                    ;HBASH = PPPFGHCD
6030 F5D5 0A                    ASL   A
6031 F5D6 0A                    ASL   A                        ;GENERATE
6032 F5D7 0A                    ASL   A                        ;Y-COORD = ABCDEFGH
6033 F5D8 85 E2                 STA   Y0
6034 F5DA A5 27                 LDA   HBASH                    ;(PPP=SCREEN PAFE,
6035 F5DC 4A                    LSR   A                        ;NORMALLY 001 FOR
6036 F5DD 4A                    LSR   A                        ;$2000-$3FFF
6037 F5DE 29 07                 AND   #$7                      ;HI-RES SCREEN)
6038 F5E0 05 E2                 ORA   Y0
6039 F5E2 85 E2                 STA   Y0                       ;CONVERTS HNDX (INDEX
6040 F5E4 A5 E5                 LDA   HNDX                     ;FROM BASE ADR)
6041 F5E6 0A                    ASL   A                        ;AND HMASK (BIT
6042 F5E7 65 E5                 ADC   HNDX                     ;MASK) TO X-COORD
6043 F5E9 0A                    ASL   A                        ;IN (XOL,XOH)
6044 F5EA AA                    TAX                            ;(RANGE $0-$133)
6045 F5EB CA                    DEX   
6046 F5EC A5 30                 LDA   HMASK
6047 F5EE 29 7F                 AND   #$7F
6048 F5F0 E8           HFIND1   INX   
6049 F5F1 4A                    LSR   A
6050 F5F2 D0 FC                 BNE   HFIND1
6051 F5F4 85 E1                 STA   X0H
6052 F5F6 8A                    TXA   
6053 F5F7 18                    CLC                            ;CALC HNDX*7 +
6054 F5F8 65 E5                 ADC   HNDX                     ;LOG (BASE 2) HMASK.
6055 F5FA 90 02                 BCC   HFIND2
6056 F5FC E6 E1                 INC   X0H
6057 F5FE 85 E0        HFIND2   STA   X0L
6058 F600 60           RTS2     RTS   
6059 F601                       EJECT 
6060 F601                       TITLE 'HI-RES GRAPHICS SHAPE DRAW SUBR'
6061 F601              *
6062 F601              * SHAPE DRAW
6063 F601              * R = O TO 63
6064 F601              * SCALE FACTOR USED (1=NORMAL)
6065 F601              *
6066 F601 86 1A        DRAW     STX   SHAPEL                   ;DRAW DEFINITION
6067 F603 84 1B                 STY   SHAPEH                   ;POINTER.
6068 F605 AA           DRAW1    TAX   
6069 F606 4A                    LSR   A                        ;ROT ($0-$3F)
6070 F607 4A                    LSR   A
6071 F608 4A                    LSR   A                        ;QDRNT 0=UP, 1=RT,
6072 F609 4A                    LSR   A                        ;2=DWN, 3=LFT.
6073 F60A 85 D3                 STA   QDRNT
6074 F60C 8A                    TXA   
6075 F60D 29 0F                 AND   #$F
6076 F60F AA                    TAX   
6077 F610 BC BA F5              LDY   COSTABL,X                ;SAVE COS AND SIN
6078 F613 84 D0                 STY   DXL                      ;VALS IN DXL AND DY.
6079 F615 49 0F                 EOR   #$F
6080 F617 AA                    TAX   
6081 F618 BC BB F5              LDY   COSTABL+1,X
6082 F61B C8                    INY   
6083 F61C 84 D2                 STY   DY
6084 F61E A4 E5        DRAW2    LDY   HNDX                     ;BYTE INDEX FROM
6085 F620 A2 00                 LDX   #$0                      ;HI-RES BASE ADR.
6086 F622 86 EA                 STX   COLLSN                   ;CLEAR COLLISION COUNT.
6087 F624 A1 1A                 LDA   (SHAPEL,X)               ;1ST SHAPE DEF BYTE.
6088 F626 85 D1        DRAW3    STA   SHAPEX
6089 F628 A2 80                 LDX   #$80
6090 F62A 86 D4                 STX   EL                       ;EL,EH FOR FRACTIONAL
6091 F62C 86 D5                 STX   EH                       ;L,R,U,D VECTORS.
6092 F62E A6 E7                 LDX   SCALE                    ;SCALE FACTOR.
6093 F630 A5 D4        DRAW4    LDA   EL
6094 F632 38                    SEC                            ;IF FRAC COS OVFL
6095 F633 65 D0                 ADC   DXL                      ;THEN MOVE IN
6096 F635 85 D4                 STA   EL                       ;SPECIFIED VECTOR
6097 F637 90 04                 BCC   DRAW5                    ;DIRECTION.
6098 F639 20 B3 F4              JSR   LRUD1
6099 F63C 18                    CLC   
6100 F63D A5 D5        DRAW5    LDA   EH                       ;IF FRAC SIN OVFL
6101 F63F 65 D2                 ADC   DY                       ;THEN MOVE IN
6102 F641 85 D5                 STA   EH                       ;SPECIFIED VECTOR
6103 F643 90 03                 BCC   DRAW6                    ;DIRECTION +90 DEG.
6104 F645 20 B4 F4              JSR   LRUD2
6105 F648 CA           DRAW6    DEX                            ;LOOP ON SCALE
6106 F649 D0 E5                 BNE   DRAW4                    ;FACTOR.
6107 F64B A5 D1                 LDA   SHAPEX
6108 F64D 4A                    LSR   A                        ;NEXT 3-BIT VECTOR
6109 F64E 4A                    LSR   A                        ;OF SHAPE DEF.
6110 F64F 4A                    LSR   A
6111 F650 D0 D4                 BNE   DRAW3                    ;NOT DONE THIS BYTE.
6112 F652 E6 1A                 INC   SHAPEL
6113 F654 D0 02                 BNE   DRAW7                    ;NEXT BYTE OF
6114 F656 E6 1B                 INC   SHAPEH                   ;SHAPE DEFINITION.
6115 F658 A1 1A        DRAW7    LDA   (SHAPEL,X)
6116 F65A D0 CA                 BNE   DRAW3                    ;DONE IF ZERO.
6117 F65C 60                    RTS   
6118 F65D                       EJECT 
6119 F65D                       TITLE 'HI-RES GRAPHICS SHAPE EX-OR SUBR'
6120 F65D              *
6121 F65D              * EX-OR SHAPE INTO SCREEN. 
6122 F65D              *
6123 F65D              * ROT = 0 TO 3 (QUADRANT ONLY)
6124 F65D              * SCALE IS USED
6125 F65D              *
6126 F65D 86 1A        XDRAW    STX   SHAPEL                   ;SHAPE DEFINITION
6127 F65F 84 1B                 STY   SHAPEH                   ;POINTER.
6128 F661 AA           XDRAW1   TAX   
6129 F662 4A                    LSR   A                        ;ROT ($0-$3F)
6130 F663 4A                    LSR   A
6131 F664 4A                    LSR   A                        ;QDRNT 0=UP, 1=RT,
6132 F665 4A                    LSR   A                        ;2=DWN, 3=LFT.
6133 F666 85 D3                 STA   QDRNT
6134 F668 8A                    TXA   
6135 F669 29 0F                 AND   #$F
6136 F66B AA                    TAX   
6137 F66C BC BA F5              LDY   COSTABL,X                ;SAVE COS AND SIN
6138 F66F 84 D0                 STY   DXL                      ;VALS IN DXL AND DY,
6139 F671 49 0F                 EOR   #$F
6140 F673 AA                    TAX   
6141 F674 BC BB F5              LDY   COSTABL+1,X
6142 F677 C8                    INY   
6143 F678 84 D2                 STY   DY
6144 F67A A4 E5        XDRAW2   LDY   HNDX                     ;INDEX FROM HI-RES
6145 F67C A2 00                 LDX   #$0                      ;BASE ADR.
6146 F67E 86 EA                 STX   COLLSN                   ;CLEAR COLLISION DETECT
6147 F680 A1 1A                 LDA   (SHAPEL,X)               ;1ST SHAPE DEF BYTE.
6148 F682 85 D1        XDRAW3   STA   SHAPEX
6149 F684 A2 80                 LDX   #$80
6150 F686 86 D4                 STX   EL                       ;EL,EH FOR FRACTIONAL 
6151 F688 86 D5                 STX   EH                       ;L,R,U,D, VECTORS.
6152 F68A A6 E7                 LDX   SCALE                    ;SCALE FACTOR.
6153 F68C A5 D4        XDRAW4   LDA   EL
6154 F68E 38                    SEC                            ;IF FRAC COS OVFL
6155 F68F 65 D0                 ADC   DXL                      ;THEN MOVE IN
6156 F691 85 D4                 STA   EL                       ;SPECIFIED VECTOR
6157 F693 90 04                 BCC   XDRAW5                   ;DIRECTION
6158 F695 20 9C F4              JSR   LRUDX1
6159 F698 18                    CLC   
6160 F699 A5 D5        XDRAW5   LDA   EH                       ;IF FRAC SIN OVFL
6161 F69B 65 D2                 ADC   DY                       ;THEN MOVE IN
6162 F69D 85 D5                 STA   EH                       ;SPECIFIED VECTOR
6163 F69F 90 03                 BCC   XDRAW6                   ;DIRECTION +90 DEG.
6164 F6A1 20 9D F4              JSR   LRUDX2
6165 F6A4 CA           XDRAW6   DEX                            ;LOOP ON SCALE
6166 F6A5 D0 E5                 BNE   XDRAW4                   ;FACTOR.
6167 F6A7 A5 D1                 LDA   SHAPEX
6168 F6A9 4A                    LSR   A                        ;NEXT 3-BIT VECTOR
6169 F6AA 4A                    LSR   A                        ;OF SHAPE DEF.
6170 F6AB 4A                    LSR   A
6171 F6AC D0 D4                 BNE   XDRAW3
6172 F6AE E6 1A                 INC   SHAPEL
6173 F6B0 D0 02                 BNE   XDRAW7                   ;NEXT BYTE OF
6174 F6B2 E6 1B                 INC   SHAPEH                   ;SHAPE DEF.
6175 F6B4 A1 1A        XDRAW7   LDA   (SHAPEL,X)
6176 F6B6 D0 CA                 BNE   XDRAW3                   ;DONE IF ZERO.
6177 F6B8 60                    RTS   
6178 F6B9 20 67 DD     HFNS:    JSR   FRMNUM                   ;GET X-ARG
6179 F6BC 20 52 E7              JSR   GETADR
6180 F6BF A4 51                 LDY   POKER+1
6181 F6C1 A6 50                 LDX   POKER
6182 F6C3 C0 01                 CPY   #1                       ;X<280
6183 F6C5 90 06                 BCC   HOK                      ;IF LESS THAN 256, FINE
6184 F6C7 D0 1D                 BNE   HTOOBIG
6185 F6C9 E0 18                 CPX   #24
6186 F6CB B0 19                 BCS   HTOOBIG
6187 F6CD 8A           HOK:     TXA                            ;SAVE COORDS.
6188 F6CE 48                    PHA   
6189 F6CF 98                    TYA   
6190 F6D0 48                    PHA   
6191 F6D1 A9 2C                 LDA   #$2C                     ;COMMA MUST SEPERATE ARGS.
6192 F6D3 20 C0 DE              JSR   SYNCHR
6193 F6D6 20 F8 E6              JSR   GETBYT                   ;GET Y-ARG.
6194 F6D9 E0 C0                 CPX   #192
6195 F6DB B0 09                 BCS   HTOOBIG
6196 F6DD 86 9D                 STX   FAC                      ;ALL REGS. CORRECT
6197 F6DF 68                    PLA   
6198 F6E0 A8                    TAY   
6199 F6E1 68                    PLA   
6200 F6E2 AA                    TAX   
6201 F6E3 A5 9D                 LDA   FAC
6202 F6E5 60                    RTS   
6203 F6E6 4C 06 F2     HTOOBIG: JMP   TOOBIG                   ;ERROR.
6204 F6E9 20 F8 E6     SETHCOL: JSR   GETBYT
6205 F6EC E0 08                 CPX   #8                       ;COLOR=0 TO 7
6206 F6EE B0 F6                 BCS   HTOOBIG                  ;BLOW UP!
6207 F6F0 BD F6 F6              LDA   COLRTAB,X
6208 F6F3 85 E4                 STA   HCOLOR
6209 F6F5 60           MINERTS: RTS   
6210 F6F6 00 2A 55 7F  COLRTAB: DC B:0,42,85,127
6211 F6FA 80 AA D5 FF           DC B:128,170,213,255
6212 F6FE C9 C1        LINE:    CMP   #TOTK                    ;LINE TO X,Y?
6213 F700 F0 0D                 BEQ   LINETO
6214 F702 20 B9 F6              JSR   HFNS
6215 F705 20 57 F4              JSR   HPLOT
6216 F708 20 B7 00     LINEAGAIN: JSR   CHRGOT                 ;IS IT FOR A LINE?
6217 F70B C9 C1                 CMP   #TOTK
6218 F70D D0 E6                 BNE   MINERTS
6219 F70F 20 C0 DE     LINETO:  JSR   SYNCHR
6220 F712 20 B9 F6              JSR   HFNS
6221 F715 84 9D                 STY   FAC                      ;REARRANGE REGISTERS FOR LINE DRAW
6222 F717 A8                    TAY   
6223 F718 8A                    TXA   
6224 F719 A6 9D                 LDX   FAC
6225 F71B 20 3A F5              JSR   HILIN                    ;GO THROUGH WOZ'S ROUTINE
6226 F71E 4C 08 F7              JMP   LINEAGAIN                ;CHECK FOR AN EXTRA 'TO'
6227 F721 20 F8 E6     SETROT:  JSR   GETBYT                   ;SET HI-RES ROTATION
6228 F724 86 F9                 STX   ROTBYT
6229 F726 60                    RTS   
6230 F727 20 F8 E6     SETSCALE: JSR   GETBYT
6231 F72A 86 E7                 STX   SCALE
6232 F72C 60           SCALRTS: RTS   
6233 F72D 20 F8 E6     PREDRAW: JSR   GETBYT                   ;GET SHAPE# INTO X
6234 F730 A5 E8                 LDA   SHAPXL                   ;PRSERVE SHAPE POINTER
6235 F732 85 1A                 STA   SHAPEL
6236 F734 A5 E9                 LDA   SHAPXH
6237 F736 85 1B                 STA   SHAPEH
6238 F738 8A                    TXA                            ;ACC=SHAPE NUMBER
6239 F739 A2 00                 LDX   #0                       ;ZERO INDEX
6240 F73B C1 1A                 CMP   (SHAPEL,X)
6241 F73D F0 02                 BEQ   DRAWOK
6242 F73F              XBND3    EQU   *
6243 F73F B0 A5                 BCS   HTOOBIG
6244 F741 0A           DRAWOK:  ASL   A                        ;SHAPE # *2
6245 F742 90 03                 BCC   PREDRAW2                 ;IF OVEFLOW
6246 F744 E6 1B                 INC   SHAPEH
6247 F746 18                    CLC   
6248 F747 A8           PREDRAW2: TAY                           ;INDX INTO TABLE
6249 F748 B1 1A                 LDA   (SHAPEL),Y
6250 F74A 65 1A                 ADC   SHAPEL                   ;RELATIVE TABLE.
6251 F74C AA                    TAX                            ;PRESERVE
6252 F74D C8                    INY                            ;ADD 2-BYTE INDEX TO SHAPE
6253 F74E B1 1A                 LDA   (SHAPEL),Y               ;START ADDRESS
6254 F750 65 E9                 ADC   SHAPXH
6255 F752 85 1B                 STA   SHAPEH
6256 F754 86 1A                 STX   SHAPEL
6257 F756 20 B7 00              JSR   CHRGOT                   ;OPTIONALLY FOLLOWED BY X,Y ARGS.
6258 F759 C9 C5                 CMP   #ATTKN                   ;IS IT THERE?
6259 F75B D0 09                 BNE   SHFINI                   ;IF NOT, FINISH UP.
6260 F75D 20 C0 DE              JSR   SYNCHR
6261 F760 20 B9 F6              JSR   HFNS
6262 F763 20 11 F4              JSR   HPOSN                    ;POSITION TO X,Y
6263 F766 A5 F9        SHFINI:  LDA   ROTBYT
6264 F768 60                    RTS   
6265 F769 20 2D F7     DODRAW:  JSR   PREDRAW                  ;SET UP,
6266 F76C 4C 05 F6              JMP   DRAW1                    ;THEN DRAW IT.
6267 F76F 20 2D F7     DOXDRAW: JSR   PREDRAW
6268 F772 4C 61 F6              JMP   XDRAW1
6269 F775 20 CB F3     XBOUND   JSR   VIDSTATE                 ;DETERMINE IF DOUBLE GR
6270 F778 B0 04                 BCS   XBND2
6271 F77A C0 28                 CPY   #40
6272 F77C B0 C1                 BCS   XBND3
6273 F77E              * IF LESS THAN 40 THEN SURELY LESS THAN 80 
6274 F77E C0 50        XBND2    CPY   #80
6275 F780 B0 BD                 BCS   XBND3
6276 F782 60                    RTS   
6277 F783 48           VLINXX   PHA   
6278 F784 A5 2D                 LDA   V2
6279 F786 C9 30                 CMP   #48
6280 F788 68                    PLA   
6281 F789 B0 B4                 BCS   XBND3
6282 F78B 48           VLINE    PHA   
6283 F78C 20 9F F3              JSR   PLOTDO
6284 F78F 68                    PLA   
6285 F790 C5 2D                 CMP   V2
6286 F792 1A                    INC   A
6287 F793 90 F6                 BCC   VLINE
6288 F795 60           RTSQQ    RTS   
6289 F796              *
6290 F796 8A           HLINE    TXA   
6291 F797 A4 F0                 LDY   FIRST
6292 F799 20 9F F3              JSR   PLOTDO
6293 F79C C4 2C        HLINE1   CPY   H2
6294 F79E B0 F5                 BCS   RTSQQ                    ;BRANCH IF DONE WITH PLOT
6295 F7A0 C8                    INY   
6296 F7A1 20 AD F3              JSR   PLOT1
6297 F7A4 80 F6                 BRA   HLINE1                   ;BRANCH ALWAYS TAKEN
6298 F7A6              RDSCRN   EQU   *
6299 F7A6 48                    PHA   
6300 F7A7 20 BB F7              JSR   VIDSETY                  ;ADJUST Y AS NECESSARY, CARRY SET=PG2GR 
6301 F7AA 68                    PLA   
6302 F7AB 08                    PHP   
6303 F7AC 20 71 F8              JSR   $F871                    ;ROM RDSCRN
6304 F7AF 28                    PLP   
6305 F7B0 90 08                 BCC   RDSCRN41
6306 F7B2 8D 54 C0              STA   $C054
6307 F7B5 C9 08                 CMP   #8
6308 F7B7 0A                    ASL   A                        ;EFFECTIVE 4 BIT ROTATE LEFT 
6309 F7B8 29 0F                 AND   #$F                      ; FOR ALT MEM COLORS
6310 F7BA              RDSCRN41 EQU   *
6311 F7BA 60                    RTS   
6312 F7BB              *
6313 F7BB 20 CB F3     VIDSETY  JSR   VIDSTATE                 ;TEST 40/80 GRAFIX
6314 F7BE 90 0A                 BCC   XQXRTS
6315 F7C0 98                    TYA   
6316 F7C1 49 01                 EOR   #1
6317 F7C3 4A                    LSR   A
6318 F7C4 A8                    TAY   
6319 F7C5 90 03                 BCC   XQXRTS
6320 F7C7 AD 55 C0              LDA   $C055
6321 F7CA 60           XQXRTS   RTS   
6322 F7CB              *
6323 F7CB 8A           TABER2   TXA                            ;CALC SPACES TO NEXT COMMA
6324 F7CC 2C 1F C0              BIT   $C01F                    ; TAB POSITION IN EITHER 40 OR 80 COLUMNS
6325 F7CF 30 12                 BMI   TABER3
6326 F7D1 2C                    DC B:$2C                       ;SKIP THE NEXT 2 BYTES
6327 F7D2 85 24        HTAB3    STA   $24
6328 F7D4 38                    SEC   
6329 F7D5 8A                    TXA   
6330 F7D6 E5 24                 SBC   $24
6331 F7D8 60           HTDONE   RTS   
6332 F7D9 A9 40        GETARYPT LDA   #$40
6333 F7DB 85 14                 STA   SUBFLG
6334 F7DD 20 E3 DF              JSR   PTRGET
6335 F7E0 64 14                 STZ   SUBFLG
6336 F7E2 60                    RTS   
6337 F7E3              *
6338 F7E3 ED 7B 05     TABER3   SBC   $57B
6339 F7E6 60                    RTS   
6340 F7E7              *
6341 F7E7 20 F8 E6     HTAB:    JSR   GETBYT                   ;GET ARG OF STATEMENT
6342 F7EA CA                    DEX   
6343 F7EB A9 28        HTAB1:   LDA   #40
6344 F7ED C5 21                 CMP   $21
6345 F7EF B0 02                 BCS   HTAB2
6346 F7F1 A5 21                 LDA   $21
6347 F7F3 20 D2 F7     HTAB2:   JSR   HTAB3
6348 F7F6 86 24                 STX   $24
6349 F7F8 90 DE                 BCC   HTDONE
6350 F7FA AA                    TAX   
6351 F7FB 20 FB DA              JSR   CRDO
6352 F7FE 80 EB                 BRA   HTAB1
6353 F800
6354 F800
6355 F800
6356 F800
6357 F800                       ENDP 
6358 F800                       END   
6359 F800
